/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ZKReplicationStorageBase;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZKReplicationPeerStorage
extends ZKReplicationStorageBase
implements ReplicationPeerStorage {
    public static final String PEERS_ZNODE = "zookeeper.znode.replication.peers";
    public static final String PEERS_ZNODE_DEFAULT = "peers";
    public static final String PEERS_STATE_ZNODE = "zookeeper.znode.replication.peers.state";
    public static final String PEERS_STATE_ZNODE_DEFAULT = "peer-state";
    public static final byte[] ENABLED_ZNODE_BYTES = ZKReplicationPeerStorage.toByteArray(ReplicationProtos.ReplicationState.State.ENABLED);
    public static final byte[] DISABLED_ZNODE_BYTES = ZKReplicationPeerStorage.toByteArray(ReplicationProtos.ReplicationState.State.DISABLED);
    private final String peerStateNodeName;
    private final String peersZNode;

    public ZKReplicationPeerStorage(ZKWatcher zookeeper, Configuration conf) {
        super(zookeeper, conf);
        this.peerStateNodeName = conf.get(PEERS_STATE_ZNODE, PEERS_STATE_ZNODE_DEFAULT);
        String peersZNodeName = conf.get(PEERS_ZNODE, PEERS_ZNODE_DEFAULT);
        this.peersZNode = ZNodePaths.joinZNode(this.replicationZNode, peersZNodeName);
    }

    @VisibleForTesting
    public String getPeerStateNode(String peerId) {
        return ZNodePaths.joinZNode(this.getPeerNode(peerId), this.peerStateNodeName);
    }

    @VisibleForTesting
    public String getPeerNode(String peerId) {
        return ZNodePaths.joinZNode(this.peersZNode, peerId);
    }

    @Override
    public void addPeer(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) throws ReplicationException {
        try {
            ZKUtil.createWithParents(this.zookeeper, this.peersZNode);
            ZKUtil.multiOrSequential(this.zookeeper, Arrays.asList(ZKUtil.ZKUtilOp.createAndFailSilent(this.getPeerNode(peerId), ReplicationPeerConfigUtil.toByteArray(peerConfig)), ZKUtil.ZKUtilOp.createAndFailSilent(this.getPeerStateNode(peerId), enabled ? ENABLED_ZNODE_BYTES : DISABLED_ZNODE_BYTES)), false);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Could not add peer with id=" + peerId + ", peerConfif=>" + peerConfig + ", state=" + (enabled ? "ENABLED" : "DISABLED"), e);
        }
    }

    @Override
    public void removePeer(String peerId) throws ReplicationException {
        try {
            ZKUtil.deleteNodeRecursively(this.zookeeper, this.getPeerNode(peerId));
        }
        catch (KeeperException e) {
            throw new ReplicationException("Could not remove peer with id=" + peerId, e);
        }
    }

    @Override
    public void setPeerState(String peerId, boolean enabled) throws ReplicationException {
        byte[] stateBytes = enabled ? ENABLED_ZNODE_BYTES : DISABLED_ZNODE_BYTES;
        try {
            ZKUtil.setData(this.zookeeper, this.getPeerStateNode(peerId), stateBytes);
        }
        catch (KeeperException e) {
            throw new ReplicationException("Unable to change state of the peer with id=" + peerId, e);
        }
    }

    @Override
    public void updatePeerConfig(String peerId, ReplicationPeerConfig peerConfig) throws ReplicationException {
        try {
            ZKUtil.setData(this.zookeeper, this.getPeerNode(peerId), ReplicationPeerConfigUtil.toByteArray(peerConfig));
        }
        catch (KeeperException e) {
            throw new ReplicationException("There was a problem trying to save changes to the replication peer " + peerId, e);
        }
    }

    @Override
    public List<String> listPeerIds() throws ReplicationException {
        try {
            List<String> children = ZKUtil.listChildrenNoWatch(this.zookeeper, this.peersZNode);
            return children != null ? children : Collections.emptyList();
        }
        catch (KeeperException e) {
            throw new ReplicationException("Cannot get the list of peers", e);
        }
    }

    @Override
    public boolean isPeerEnabled(String peerId) throws ReplicationException {
        try {
            return Arrays.equals(ENABLED_ZNODE_BYTES, ZKUtil.getData(this.zookeeper, this.getPeerStateNode(peerId)));
        }
        catch (InterruptedException | KeeperException e) {
            throw new ReplicationException("Unable to get status of the peer with id=" + peerId, e);
        }
    }

    @Override
    public ReplicationPeerConfig getPeerConfig(String peerId) throws ReplicationException {
        byte[] data;
        try {
            data = ZKUtil.getData(this.zookeeper, this.getPeerNode(peerId));
        }
        catch (InterruptedException | KeeperException e) {
            throw new ReplicationException("Error getting configuration for peer with id=" + peerId, e);
        }
        if (data == null || data.length == 0) {
            throw new ReplicationException("Replication peer config data shouldn't be empty, peerId=" + peerId);
        }
        try {
            return ReplicationPeerConfigUtil.parsePeerFrom(data);
        }
        catch (DeserializationException e) {
            throw new ReplicationException("Failed to parse replication peer config for peer with id=" + peerId, e);
        }
    }
}

