/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.slowlog;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.slowlog.DisruptorExceptionHandler;
import org.apache.hadoop.hbase.regionserver.slowlog.LogEventHandler;
import org.apache.hadoop.hbase.regionserver.slowlog.RingBufferEnvelope;
import org.apache.hadoop.hbase.regionserver.slowlog.RpcLogDetails;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.BlockingWaitStrategy;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.RingBuffer;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.WaitStrategy;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.dsl.Disruptor;
import org.apache.hadoop.hbase.shaded.com.lmax.disruptor.dsl.ProducerType;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SlowLogRecorder {
    private final Disruptor<RingBufferEnvelope> disruptor;
    private final LogEventHandler logEventHandler;
    private final int eventCount;
    private final boolean isOnlineLogProviderEnabled;
    private static final String SLOW_LOG_RING_BUFFER_SIZE = "hbase.regionserver.slowlog.ringbuffer.size";

    public SlowLogRecorder(Configuration conf) {
        this.isOnlineLogProviderEnabled = conf.getBoolean("hbase.regionserver.slowlog.buffer.enabled", false);
        if (!this.isOnlineLogProviderEnabled) {
            this.disruptor = null;
            this.logEventHandler = null;
            this.eventCount = 0;
            return;
        }
        this.eventCount = conf.getInt(SLOW_LOG_RING_BUFFER_SIZE, 256);
        String hostingThreadName = Thread.currentThread().getName();
        this.disruptor = new Disruptor<RingBufferEnvelope>(RingBufferEnvelope::new, this.getEventCount(), Threads.newDaemonThreadFactory(hostingThreadName + ".slowlog.append"), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.setDefaultExceptionHandler(new DisruptorExceptionHandler());
        boolean isSlowLogTableEnabled = conf.getBoolean("hbase.regionserver.slowlog.systable.enabled", false);
        this.logEventHandler = new LogEventHandler(this.eventCount, isSlowLogTableEnabled, conf);
        this.disruptor.handleEventsWith(this.logEventHandler);
        this.disruptor.start();
    }

    private int getEventCount() {
        Preconditions.checkArgument(this.eventCount >= 0, "hbase.regionserver.slowlog.ringbuffer.size must be > 0");
        int floor = Integer.highestOneBit(this.eventCount);
        if (floor == this.eventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    public List<TooSlowLog.SlowLogPayload> getSlowLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        return this.isOnlineLogProviderEnabled ? this.logEventHandler.getSlowLogPayloads(request) : Collections.emptyList();
    }

    public List<TooSlowLog.SlowLogPayload> getLargeLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        return this.isOnlineLogProviderEnabled ? this.logEventHandler.getLargeLogPayloads(request) : Collections.emptyList();
    }

    public boolean clearSlowLogPayloads() {
        if (!this.isOnlineLogProviderEnabled) {
            return true;
        }
        return this.logEventHandler.clearSlowLogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSlowLogPayload(RpcLogDetails rpcLogDetails) {
        if (!this.isOnlineLogProviderEnabled) {
            return;
        }
        RingBuffer<RingBufferEnvelope> ringBuffer = this.disruptor.getRingBuffer();
        long seqId = ringBuffer.next();
        try {
            ringBuffer.get(seqId).load(rpcLogDetails);
        }
        finally {
            ringBuffer.publish(seqId);
        }
    }

    public void addAllLogsToSysTable() {
        if (this.logEventHandler != null) {
            this.logEventHandler.addAllLogsToSysTable();
        }
    }
}

