/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.ByteBufferChunkKeyValue;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.NoTagByteBufferChunkKeyValue;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MemStoreLABImpl
implements MemStoreLAB {
    static final Logger LOG = LoggerFactory.getLogger(MemStoreLABImpl.class);
    private AtomicReference<Chunk> currChunk = new AtomicReference();
    private ReentrantLock lock = new ReentrantLock();
    @VisibleForTesting
    Set<Integer> chunks = new ConcurrentSkipListSet<Integer>();
    private final int dataChunkSize;
    private final int maxAlloc;
    private final ChunkCreator chunkCreator;
    private final CompactingMemStore.IndexType idxType;
    private volatile boolean closed = false;
    private AtomicBoolean reclaimed = new AtomicBoolean(false);
    private final AtomicInteger openScannerCount = new AtomicInteger();

    public MemStoreLABImpl() {
        this(new Configuration());
    }

    public MemStoreLABImpl(Configuration conf) {
        this.dataChunkSize = conf.getInt("hbase.hregion.memstore.mslab.chunksize", 0x200000);
        this.maxAlloc = conf.getInt("hbase.hregion.memstore.mslab.max.allocation", 262144);
        this.chunkCreator = ChunkCreator.getInstance();
        Preconditions.checkArgument(this.maxAlloc <= this.dataChunkSize, "hbase.hregion.memstore.mslab.max.allocation must be less than hbase.hregion.memstore.mslab.chunksize");
        this.idxType = CompactingMemStore.IndexType.CHUNK_MAP;
    }

    @Override
    public Cell copyCellInto(Cell cell) {
        return cell instanceof ByteBufferExtendedCell ? this.copyBBECellInto((ByteBufferExtendedCell)cell, this.maxAlloc) : this.copyCellInto(cell, this.maxAlloc);
    }

    @Override
    public Cell forceCopyOfBigCellInto(Cell cell) {
        int size = Segment.getCellLength(cell);
        Preconditions.checkArgument((size += 4) >= 0, "negative size");
        if (size <= this.dataChunkSize) {
            return this.copyCellInto(cell, this.dataChunkSize);
        }
        Chunk c = this.getNewExternalChunk(size);
        int allocOffset = c.alloc(size);
        return MemStoreLABImpl.copyToChunkCell(cell, c.getData(), allocOffset, size);
    }

    private Cell copyBBECellInto(ByteBufferExtendedCell cell, int maxAlloc) {
        int size = cell.getSerializedSize();
        Preconditions.checkArgument(size >= 0, "negative size");
        if (size > maxAlloc) {
            return null;
        }
        Chunk c = null;
        int allocOffset = 0;
        while (true) {
            if ((c = this.getOrMakeChunk()) == null) {
                continue;
            }
            allocOffset = c.alloc(size);
            if (allocOffset != -1) break;
            this.tryRetireChunk(c);
        }
        return MemStoreLABImpl.copyBBECToChunkCell(cell, c.getData(), allocOffset, size);
    }

    private Cell copyCellInto(Cell cell, int maxAlloc) {
        int size = Segment.getCellLength(cell);
        Preconditions.checkArgument(size >= 0, "negative size");
        if (size > maxAlloc) {
            return null;
        }
        Chunk c = null;
        int allocOffset = 0;
        while (true) {
            if ((c = this.getOrMakeChunk()) == null) {
                continue;
            }
            allocOffset = c.alloc(size);
            if (allocOffset != -1) break;
            this.tryRetireChunk(c);
        }
        return MemStoreLABImpl.copyToChunkCell(cell, c.getData(), allocOffset, size);
    }

    private static Cell copyToChunkCell(Cell cell, ByteBuffer buf, int offset, int len) {
        int tagsLen = cell.getTagsLength();
        if (cell instanceof ExtendedCell) {
            ((ExtendedCell)cell).write(buf, offset);
        } else {
            KeyValueUtil.appendTo(cell, buf, offset, true);
        }
        return MemStoreLABImpl.createChunkCell(buf, offset, len, tagsLen, cell.getSequenceId());
    }

    private static Cell copyBBECToChunkCell(ByteBufferExtendedCell cell, ByteBuffer buf, int offset, int len) {
        int tagsLen = cell.getTagsLength();
        cell.write(buf, offset);
        return MemStoreLABImpl.createChunkCell(buf, offset, len, tagsLen, cell.getSequenceId());
    }

    private static Cell createChunkCell(ByteBuffer buf, int offset, int len, int tagsLen, long sequenceId) {
        if (tagsLen == 0) {
            return new NoTagByteBufferChunkKeyValue(buf, offset, len, sequenceId);
        }
        return new ByteBufferChunkKeyValue(buf, offset, len, sequenceId);
    }

    @Override
    public void close() {
        this.closed = true;
        int count = this.openScannerCount.get();
        if (count == 0) {
            this.recycleChunks();
        }
    }

    @VisibleForTesting
    int getOpenScannerCount() {
        return this.openScannerCount.get();
    }

    @Override
    public void incScannerCount() {
        this.openScannerCount.incrementAndGet();
    }

    @Override
    public void decScannerCount() {
        int count = this.openScannerCount.decrementAndGet();
        if (this.closed && count == 0) {
            this.recycleChunks();
        }
    }

    private void recycleChunks() {
        if (this.reclaimed.compareAndSet(false, true)) {
            this.chunkCreator.putbackChunks(this.chunks);
        }
    }

    private void tryRetireChunk(Chunk c) {
        this.currChunk.compareAndSet(c, null);
    }

    private Chunk getOrMakeChunk() {
        Chunk c = this.currChunk.get();
        if (c != null) {
            return c;
        }
        if (this.lock.tryLock()) {
            try {
                c = this.currChunk.get();
                if (c != null) {
                    Chunk chunk = c;
                    return chunk;
                }
                c = this.chunkCreator.getChunk(this.idxType);
                if (c != null) {
                    this.currChunk.set(c);
                    this.chunks.add(c.getId());
                    Chunk chunk = c;
                    return chunk;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    @Override
    public Chunk getNewExternalChunk(ChunkCreator.ChunkType chunkType) {
        switch (chunkType) {
            case INDEX_CHUNK: 
            case DATA_CHUNK: {
                Chunk c = this.chunkCreator.getChunk(chunkType);
                this.chunks.add(c.getId());
                return c;
            }
        }
        return null;
    }

    @Override
    public Chunk getNewExternalChunk(int size) {
        int allocSize = size + 4;
        if (allocSize <= ChunkCreator.getInstance().getChunkSize()) {
            return this.getNewExternalChunk(ChunkCreator.ChunkType.DATA_CHUNK);
        }
        Chunk c = this.chunkCreator.getJumboChunk(size);
        this.chunks.add(c.getId());
        return c;
    }

    @Override
    public boolean isOnHeap() {
        return !this.isOffHeap();
    }

    @Override
    public boolean isOffHeap() {
        return this.chunkCreator.isOffheap();
    }

    @VisibleForTesting
    Chunk getCurrentChunk() {
        return this.currChunk.get();
    }

    @VisibleForTesting
    BlockingQueue<Chunk> getPooledChunks() {
        LinkedBlockingQueue<Chunk> pooledChunks = new LinkedBlockingQueue<Chunk>();
        for (Integer id : this.chunks) {
            Chunk chunk = this.chunkCreator.getChunk(id);
            if (chunk == null || !chunk.isFromPool()) continue;
            pooledChunks.add(chunk);
        }
        return pooledChunks;
    }

    @VisibleForTesting
    Integer getNumOfChunksReturnedToPool() {
        int i = 0;
        for (Integer id : this.chunks) {
            if (!this.chunkCreator.isChunkInPool(id)) continue;
            ++i;
        }
        return i;
    }
}

