/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanOptions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CustomizedScanInfoBuilder
implements ScanOptions {
    private final ScanInfo scanInfo;
    private Integer maxVersions;
    private Long ttl;
    private KeepDeletedCells keepDeletedCells = null;
    private Integer minVersions;
    private final Scan scan;

    public CustomizedScanInfoBuilder(ScanInfo scanInfo) {
        this.scanInfo = scanInfo;
        this.scan = new Scan();
    }

    public CustomizedScanInfoBuilder(ScanInfo scanInfo, Scan scan) {
        this.scanInfo = scanInfo;
        try {
            this.scan = new Scan(scan);
        }
        catch (IOException e) {
            throw new AssertionError("Scan should not throw IOException", e);
        }
    }

    @Override
    public int getMaxVersions() {
        return this.maxVersions != null ? this.maxVersions.intValue() : this.scanInfo.getMaxVersions();
    }

    @Override
    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    @Override
    public long getTTL() {
        return this.ttl != null ? this.ttl.longValue() : this.scanInfo.getTtl();
    }

    @Override
    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    public ScanInfo build() {
        if (this.maxVersions == null && this.ttl == null && this.keepDeletedCells == null) {
            return this.scanInfo;
        }
        return this.scanInfo.customize(this.getMaxVersions(), this.getTTL(), this.getKeepDeletedCells(), this.getMinVersions());
    }

    public String toString() {
        return "ScanOptions [maxVersions=" + this.getMaxVersions() + ", TTL=" + this.getTTL() + ", KeepDeletedCells=" + (Object)((Object)this.getKeepDeletedCells()) + ", MinVersions=" + this.getMinVersions() + "]";
    }

    @Override
    public void setKeepDeletedCells(KeepDeletedCells keepDeletedCells) {
        this.keepDeletedCells = keepDeletedCells;
    }

    @Override
    public KeepDeletedCells getKeepDeletedCells() {
        return this.keepDeletedCells != null ? this.keepDeletedCells : this.scanInfo.getKeepDeletedCells();
    }

    @Override
    public int getMinVersions() {
        return this.minVersions != null ? this.minVersions.intValue() : this.scanInfo.getMinVersions();
    }

    @Override
    public void setMinVersions(int minVersions) {
        this.minVersions = minVersions;
    }

    @Override
    public Scan getScan() {
        try {
            return new Scan(this.scan);
        }
        catch (IOException e) {
            throw new AssertionError("Scan should not throw IOException anymore", e);
        }
    }
}

