/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultMobStoreFlusher
extends DefaultStoreFlusher {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMobStoreFlusher.class);
    private final Object flushLock = new Object();
    private long mobCellValueSizeThreshold = 0L;
    private Path targetPath;
    private HMobStore mobStore;

    public DefaultMobStoreFlusher(Configuration conf, HStore store) throws IOException {
        super(conf, store);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobCellValueSizeThreshold = store.getColumnFamilyDescriptor().getMobThreshold();
        this.targetPath = MobUtils.getMobFamilyPath(conf, store.getTableName(), store.getColumnFamilyName());
        if (!this.store.getFileSystem().exists(this.targetPath)) {
            this.store.getFileSystem().mkdirs(this.targetPath);
        }
        this.mobStore = (HMobStore)store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushId, MonitoredTask status, ThroughputController throughputController, FlushLifeCycleTracker tracker) throws IOException {
        StoreFileWriter writer;
        ArrayList<Path> result = new ArrayList<Path>();
        long cellsCount = snapshot.getCellsCount();
        if (cellsCount == 0L) {
            return result;
        }
        long smallestReadPoint = this.store.getSmallestReadPoint();
        try (InternalScanner scanner = this.createScanner(snapshot.getScanners(), smallestReadPoint, tracker);){
            Object object = this.flushLock;
            synchronized (object) {
                status.setStatus("Flushing " + this.store + ": creating writer");
                writer = this.store.createWriterInTmp(cellsCount, this.store.getColumnFamilyDescriptor().getCompressionType(), false, true, true, false);
                IOException e = null;
                try {
                    this.performMobFlush(snapshot, cacheFlushId, scanner, writer, status, throughputController);
                }
                catch (IOException ioe) {
                    e = ioe;
                    throw ioe;
                }
                finally {
                    if (e != null) {
                        writer.close();
                    } else {
                        this.finalizeWriter(writer, cacheFlushId, status);
                    }
                }
            }
        }
        LOG.info("Mob store is flushed, sequenceid=" + cacheFlushId + ", memsize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)snapshot.getDataSize(), (String)"", (int)1) + ", hasBloomFilter=" + writer.hasGeneralBloom() + ", into tmp file " + writer.getPath());
        result.add(writer.getPath());
        return result;
    }

    protected void performMobFlush(MemStoreSnapshot snapshot, long cacheFlushId, InternalScanner scanner, StoreFileWriter writer, MonitoredTask status, ThroughputController throughputController) throws IOException {
        boolean control;
        StoreFileWriter mobFileWriter = null;
        int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        long mobCount = 0L;
        long mobSize = 0L;
        long time = snapshot.getTimeRangeTracker().getMax();
        mobFileWriter = this.mobStore.createWriterInTmp(new Date(time), snapshot.getCellsCount(), this.store.getColumnFamilyDescriptor().getCompressionType(), this.store.getRegionInfo().getStartKey(), false);
        byte[] fileName = Bytes.toBytes(mobFileWriter.getPath().getName());
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(compactionKVMax).build();
        ArrayList<Cell> cells = new ArrayList<Cell>();
        String flushName = ThroughputControlUtil.getNameForThrottling(this.store, "flush");
        boolean bl = control = throughputController != null && !this.store.getRegionInfo().getTable().isSystemTable();
        if (control) {
            throughputController.start(flushName);
        }
        IOException ioe = null;
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(cells, scannerContext);
                if (cells.isEmpty()) continue;
                for (Cell c : cells) {
                    if ((long)c.getValueLength() <= this.mobCellValueSizeThreshold || MobUtils.isMobReferenceCell(c) || c.getTypeByte() != KeyValue.Type.Put.getCode()) {
                        writer.append(c);
                    } else {
                        mobFileWriter.append(c);
                        mobSize += (long)c.getValueLength();
                        ++mobCount;
                        Cell reference = MobUtils.createMobRefCell(c, fileName, this.mobStore.getRefCellTags());
                        writer.append(reference);
                    }
                    if (!control) continue;
                    throughputController.control(flushName, c.getSerializedSize());
                }
                cells.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            ioe = new InterruptedIOException("Interrupted while control throughput of flushing " + flushName);
            throw ioe;
        }
        catch (IOException e) {
            ioe = e;
            throw e;
        }
        finally {
            if (control) {
                throughputController.finish(flushName);
            }
            if (ioe != null) {
                mobFileWriter.close();
            }
        }
        if (mobCount > 0L) {
            status.setStatus("Flushing mob file " + this.store + ": appending metadata");
            mobFileWriter.appendMetadata(cacheFlushId, false, mobCount);
            status.setStatus("Flushing mob file " + this.store + ": closing flushed file");
            mobFileWriter.close();
            this.mobStore.commitFile(mobFileWriter.getPath(), this.targetPath);
            this.mobStore.updateMobFlushCount();
            this.mobStore.updateMobFlushedCellsCount(mobCount);
            this.mobStore.updateMobFlushedCellsSize(mobSize);
        } else {
            try {
                status.setStatus("Flushing mob file " + this.store + ": no mob cells, closing flushed file");
                mobFileWriter.close();
                this.store.getFileSystem().delete(mobFileWriter.getPath(), true);
            }
            catch (IOException e) {
                LOG.error("Failed to delete the temp mob file", (Throwable)e);
            }
        }
    }
}

