/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionsRecoveryChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(RegionsRecoveryChore.class);
    private static final String REGIONS_RECOVERY_CHORE_NAME = "RegionsRecoveryChore";
    private static final String ERROR_REOPEN_REIONS_MSG = "Error reopening regions with high storeRefCount. ";
    private final HMaster hMaster;
    private final int storeFileRefCountThreshold;
    private static final PerClientRandomNonceGenerator NONCE_GENERATOR = PerClientRandomNonceGenerator.get();

    RegionsRecoveryChore(Stoppable stopper, Configuration configuration, HMaster hMaster) {
        super(REGIONS_RECOVERY_CHORE_NAME, stopper, configuration.getInt("hbase.master.regions.recovery.check.interval", 1200000));
        this.hMaster = hMaster;
        this.storeFileRefCountThreshold = configuration.getInt("hbase.regions.recovery.store.file.ref.count", -1);
    }

    @Override
    protected void chore() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting up Regions Recovery chore for reopening regions based on storeFileRefCount...");
        }
        try {
            if (this.storeFileRefCountThreshold > 0) {
                ClusterMetrics clusterMetrics = this.hMaster.getClusterMetrics();
                Map<ServerName, ServerMetrics> serverMetricsMap = clusterMetrics.getLiveServerMetrics();
                Map<TableName, List<byte[]>> tableToReopenRegionsMap = this.getTableToRegionsByRefCount(serverMetricsMap);
                if (MapUtils.isNotEmpty(tableToReopenRegionsMap)) {
                    tableToReopenRegionsMap.forEach((tableName, regionNames) -> {
                        try {
                            LOG.warn("Reopening regions due to high storeFileRefCount. TableName: {} , noOfRegions: {}", tableName, (Object)regionNames.size());
                            this.hMaster.reopenRegions((TableName)tableName, (List<byte[]>)regionNames, NONCE_GENERATOR.getNonceGroup(), NONCE_GENERATOR.newNonce());
                        }
                        catch (IOException e) {
                            LOG.error("{} tableName: {}, regionNames: {}", new Object[]{ERROR_REOPEN_REIONS_MSG, tableName, regionNames, e});
                        }
                    });
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Reopening regions with very high storeFileRefCount is disabled. Provide threshold value > 0 for {} to enable it.", (Object)"hbase.regions.recovery.store.file.ref.count");
            }
        }
        catch (Exception e) {
            LOG.error("Error while reopening regions based on storeRefCount threshold", (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exiting Regions Recovery chore for reopening regions based on storeFileRefCount...");
        }
    }

    private Map<TableName, List<byte[]>> getTableToRegionsByRefCount(Map<ServerName, ServerMetrics> serverMetricsMap) {
        HashMap<TableName, List<byte[]>> tableToReopenRegionsMap = new HashMap<TableName, List<byte[]>>();
        for (ServerMetrics serverMetrics : serverMetricsMap.values()) {
            Map<byte[], RegionMetrics> regionMetricsMap = serverMetrics.getRegionMetrics();
            for (RegionMetrics regionMetrics : regionMetricsMap.values()) {
                int maxCompactedStoreFileRefCount = regionMetrics.getMaxCompactedStoreFileRefCount();
                if (maxCompactedStoreFileRefCount <= this.storeFileRefCountThreshold) continue;
                byte[] regionName = regionMetrics.getRegionName();
                this.prepareTableToReopenRegionsMap(tableToReopenRegionsMap, regionName, maxCompactedStoreFileRefCount);
            }
        }
        return tableToReopenRegionsMap;
    }

    private void prepareTableToReopenRegionsMap(Map<TableName, List<byte[]>> tableToReopenRegionsMap, byte[] regionName, int regionStoreRefCount) {
        RegionInfo regionInfo = this.hMaster.getAssignmentManager().getRegionInfo(regionName);
        TableName tableName = regionInfo.getTable();
        if (TableName.isMetaTableName(tableName)) {
            return;
        }
        LOG.warn("Region {} for Table {} has high storeFileRefCount {}, considering it for reopen..", new Object[]{regionInfo.getRegionNameAsString(), tableName, regionStoreRefCount});
        tableToReopenRegionsMap.putIfAbsent(tableName, new ArrayList());
        tableToReopenRegionsMap.get(tableName).add(regionName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 31;
    }
}

