/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZNodeClearer;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ActiveMasterManager
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMasterManager.class);
    final AtomicBoolean clusterHasActiveMaster = new AtomicBoolean(false);
    final AtomicBoolean clusterShutDown = new AtomicBoolean(false);
    int infoPort;
    final ServerName sn;
    final Server master;
    volatile ServerName activeMasterServerName;

    ActiveMasterManager(ZKWatcher watcher, ServerName sn, Server master) {
        super(watcher);
        watcher.registerListener(this);
        this.sn = sn;
        this.master = master;
    }

    public void setInfoPort(int infoPort) {
        this.infoPort = infoPort;
    }

    @Override
    public void nodeCreated(String path) {
        this.handle(path);
    }

    @Override
    public void nodeDeleted(String path) {
        if (path.equals(this.watcher.getZNodePaths().clusterStateZNode) && !this.master.isStopped()) {
            this.clusterShutDown.set(true);
        }
        this.handle(path);
    }

    void handle(String path) {
        if (path.equals(this.watcher.getZNodePaths().masterAddressZNode) && !this.master.isStopped()) {
            this.handleMasterNodeChange();
        }
    }

    private void fetchAndSetActiveMasterServerName() {
        LOG.debug("Attempting to fetch active master sn from zk");
        try {
            this.activeMasterServerName = MasterAddressTracker.getMasterAddress(this.watcher);
        }
        catch (IOException | KeeperException e) {
            LOG.error("Error fetching active master information", (Throwable)e);
        }
    }

    public Optional<ServerName> getActiveMasterServerName() {
        if (!this.clusterHasActiveMaster.get()) {
            return Optional.empty();
        }
        if (this.activeMasterServerName == null) {
            this.fetchAndSetActiveMasterServerName();
        }
        return Optional.ofNullable(this.activeMasterServerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMasterNodeChange() {
        try {
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.watcher.getZNodePaths().masterAddressZNode)) {
                    LOG.trace("A master is now available");
                    this.clusterHasActiveMaster.set(true);
                } else {
                    LOG.debug("No master available. Notifying waiting threads");
                    this.clusterHasActiveMaster.set(false);
                    this.clusterHasActiveMaster.notifyAll();
                }
                this.activeMasterServerName = null;
            }
        }
        catch (KeeperException ke) {
            this.master.abort("Received an unexpected KeeperException, aborting", ke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean blockUntilBecomingActiveMaster(int checkInterval, MonitoredTask startupStatus) {
        String backupZNode = ZNodePaths.joinZNode(this.watcher.getZNodePaths().backupMasterAddressesZNode, this.sn.toString());
        while (!this.master.isAborted() && !this.master.isStopped()) {
            startupStatus.setStatus("Trying to register in ZK as active master");
            try {
                String msg;
                if (MasterAddressTracker.setMasterAddress(this.watcher, this.watcher.getZNodePaths().masterAddressZNode, this.sn, this.infoPort)) {
                    if (ZKUtil.checkExists(this.watcher, backupZNode) != -1) {
                        LOG.info("Deleting ZNode for " + backupZNode + " from backup master directory");
                        ZKUtil.deleteNodeFailSilent(this.watcher, backupZNode);
                    }
                    ZNodeClearer.writeMyEphemeralNodeOnDisk(this.sn.toString());
                    startupStatus.setStatus("Successfully registered as active master.");
                    this.clusterHasActiveMaster.set(true);
                    this.activeMasterServerName = this.sn;
                    LOG.info("Registered as active master=" + this.sn);
                    return true;
                }
                this.activeMasterServerName = null;
                this.clusterHasActiveMaster.set(true);
                byte[] bytes = ZKUtil.getDataAndWatch(this.watcher, this.watcher.getZNodePaths().masterAddressZNode);
                if (bytes == null) {
                    msg = "A master was detected, but went down before its address could be read.  Attempting to become the next active master";
                } else {
                    ServerName currentMaster;
                    try {
                        currentMaster = ProtobufUtil.parseServerNameFrom(bytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn("Failed parse", (Throwable)e);
                        continue;
                    }
                    if (ServerName.isSameAddress(currentMaster, this.sn)) {
                        msg = "Current master has this master's address, " + currentMaster + "; master was restarted? Deleting node.";
                        ZKUtil.deleteNode(this.watcher, this.watcher.getZNodePaths().masterAddressZNode);
                        ZNodeClearer.deleteMyEphemeralNodeOnDisk();
                    } else {
                        msg = "Another master is the active master, " + currentMaster + "; waiting to become the next active master";
                    }
                }
                LOG.info(msg);
                startupStatus.setStatus(msg);
            }
            catch (KeeperException ke) {
                this.master.abort("Received an unexpected KeeperException, aborting", ke);
                return false;
            }
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                while (this.clusterHasActiveMaster.get() && !this.master.isStopped()) {
                    try {
                        this.clusterHasActiveMaster.wait(checkInterval);
                    }
                    catch (InterruptedException e) {
                        LOG.debug("Interrupted waiting for master to die", (Throwable)e);
                    }
                }
                if (this.clusterShutDown.get()) {
                    this.master.stop("Cluster went down before this master became active");
                }
            }
        }
        return false;
    }

    boolean hasActiveMaster() {
        try {
            if (ZKUtil.checkExists(this.watcher, this.watcher.getZNodePaths().masterAddressZNode) >= 0) {
                return true;
            }
        }
        catch (KeeperException ke) {
            LOG.info("Received an unexpected KeeperException when checking isActiveMaster : " + ke);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            AtomicBoolean atomicBoolean = this.clusterHasActiveMaster;
            synchronized (atomicBoolean) {
                this.clusterHasActiveMaster.notifyAll();
            }
            ServerName activeMaster = null;
            try {
                activeMaster = MasterAddressTracker.getMasterAddress(this.watcher);
            }
            catch (IOException e) {
                LOG.warn("Failed get of master address: " + e.toString());
            }
            if (activeMaster != null && activeMaster.equals(this.sn)) {
                ZKUtil.deleteNode(this.watcher, this.watcher.getZNodePaths().masterAddressZNode);
                ZNodeClearer.deleteMyEphemeralNodeOnDisk();
            }
        }
        catch (KeeperException e) {
            LOG.debug(this.watcher.prefix("Failed delete of our master address node; " + e.getMessage()));
        }
    }
}

