/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.concurrent.ForkJoinPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.FirstLevelBlockCache;
import org.apache.hadoop.hbase.io.hfile.InclusiveCombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.IndexOnlyLruBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.TinyLfuBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class BlockCacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)BlockCacheFactory.class.getName());
    public static final String BLOCKCACHE_POLICY_KEY = "hfile.block.cache.policy";
    public static final String BLOCKCACHE_POLICY_DEFAULT = "LRU";
    public static final String BUCKET_CACHE_PERSISTENT_PATH_KEY = "hbase.bucketcache.persistent.path";
    public static final String BUCKET_CACHE_WRITER_THREADS_KEY = "hbase.bucketcache.writer.threads";
    public static final String BUCKET_CACHE_WRITER_QUEUE_KEY = "hbase.bucketcache.writer.queuelength";
    public static final String BUCKET_CACHE_BUCKETS_KEY = "hbase.bucketcache.bucket.sizes";
    public static final int DEFAULT_BUCKET_CACHE_WRITER_THREADS = 3;
    public static final int DEFAULT_BUCKET_CACHE_WRITER_QUEUE = 64;
    public static final String BLOCKCACHE_BLOCKSIZE_KEY = "hbase.blockcache.minblocksize";
    private static final String EXTERNAL_BLOCKCACHE_KEY = "hbase.blockcache.use.external";
    private static final boolean EXTERNAL_BLOCKCACHE_DEFAULT = false;
    private static final String EXTERNAL_BLOCKCACHE_CLASS_KEY = "hbase.blockcache.external.class";
    @Deprecated
    static final String DEPRECATED_BLOCKCACHE_BLOCKSIZE_KEY = "hbase.offheapcache.minblocksize";

    private BlockCacheFactory() {
    }

    public static BlockCache createBlockCache(Configuration conf) {
        FirstLevelBlockCache l1Cache;
        if (conf.get(DEPRECATED_BLOCKCACHE_BLOCKSIZE_KEY) != null) {
            LOG.warn("The config key {} is deprecated now, instead please use {}. In future release we will remove the deprecated config.", (Object)DEPRECATED_BLOCKCACHE_BLOCKSIZE_KEY, (Object)BLOCKCACHE_BLOCKSIZE_KEY);
        }
        if ((l1Cache = BlockCacheFactory.createFirstLevelCache(conf)) == null) {
            return null;
        }
        boolean useExternal = conf.getBoolean(EXTERNAL_BLOCKCACHE_KEY, false);
        if (useExternal) {
            BlockCache l2CacheInstance = BlockCacheFactory.createExternalBlockcache(conf);
            return l2CacheInstance == null ? l1Cache : new InclusiveCombinedBlockCache(l1Cache, l2CacheInstance);
        }
        BucketCache bucketCache = BlockCacheFactory.createBucketCache(conf);
        if (!conf.getBoolean("hbase.bucketcache.combinedcache.enabled", true)) {
            LOG.warn("From HBase 2.0 onwards only combined mode of LRU cache and bucket cache is available");
        }
        return bucketCache == null ? l1Cache : new CombinedBlockCache(l1Cache, bucketCache);
    }

    private static FirstLevelBlockCache createFirstLevelCache(Configuration c) {
        long cacheSize = MemorySizeUtil.getOnHeapCacheSize(c);
        if (cacheSize < 0L) {
            return null;
        }
        String policy = c.get(BLOCKCACHE_POLICY_KEY, BLOCKCACHE_POLICY_DEFAULT);
        int blockSize = c.getInt(BLOCKCACHE_BLOCKSIZE_KEY, 65536);
        LOG.info("Allocating BlockCache size=" + StringUtils.byteDesc((long)cacheSize) + ", blockSize=" + StringUtils.byteDesc((long)blockSize));
        if (policy.equalsIgnoreCase(BLOCKCACHE_POLICY_DEFAULT)) {
            return new LruBlockCache(cacheSize, blockSize, true, c);
        }
        if (policy.equalsIgnoreCase("IndexOnlyLRU")) {
            return new IndexOnlyLruBlockCache(cacheSize, blockSize, true, c);
        }
        if (policy.equalsIgnoreCase("TinyLFU")) {
            return new TinyLfuBlockCache(cacheSize, (long)blockSize, ForkJoinPool.commonPool(), c);
        }
        throw new IllegalArgumentException("Unknown policy: " + policy);
    }

    private static BlockCache createExternalBlockcache(Configuration c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to use External l2 cache");
        }
        Class klass = null;
        try {
            klass = ExternalBlockCaches.valueOf((String)c.get((String)EXTERNAL_BLOCKCACHE_CLASS_KEY, (String)"memcache")).clazz;
        }
        catch (IllegalArgumentException exception) {
            try {
                klass = c.getClass(EXTERNAL_BLOCKCACHE_CLASS_KEY, Class.forName("org.apache.hadoop.hbase.io.hfile.MemcachedBlockCache"));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        try {
            LOG.info("Creating external block cache of type: " + klass);
            return (BlockCache)ReflectionUtils.newInstance(klass, c);
        }
        catch (Exception e) {
            LOG.warn("Error creating external block cache", (Throwable)e);
            return null;
        }
    }

    private static BucketCache createBucketCache(Configuration c) {
        String bucketCacheIOEngineName = c.get("hbase.bucketcache.ioengine", null);
        if (bucketCacheIOEngineName == null || bucketCacheIOEngineName.length() <= 0) {
            return null;
        }
        int blockSize = c.getInt(BLOCKCACHE_BLOCKSIZE_KEY, 65536);
        long bucketCacheSize = MemorySizeUtil.getBucketCacheSize(c);
        if (bucketCacheSize <= 0L) {
            throw new IllegalStateException("bucketCacheSize <= 0; Check hbase.bucketcache.size setting and/or server java heap size");
        }
        if (c.get("hbase.bucketcache.percentage.in.combinedcache") != null) {
            LOG.warn("Configuration 'hbase.bucketcache.percentage.in.combinedcache' is no longer respected. See comments in http://hbase.apache.org/book.html#_changes_of_note");
        }
        int writerThreads = c.getInt(BUCKET_CACHE_WRITER_THREADS_KEY, 3);
        int writerQueueLen = c.getInt(BUCKET_CACHE_WRITER_QUEUE_KEY, 64);
        String persistentPath = c.get(BUCKET_CACHE_PERSISTENT_PATH_KEY);
        String[] configuredBucketSizes = c.getStrings(BUCKET_CACHE_BUCKETS_KEY);
        int[] bucketSizes = null;
        if (configuredBucketSizes != null) {
            bucketSizes = new int[configuredBucketSizes.length];
            for (int i = 0; i < configuredBucketSizes.length; ++i) {
                int bucketSize = Integer.parseInt(configuredBucketSizes[i].trim());
                if (bucketSize % 256 != 0) {
                    throw new IllegalArgumentException("Illegal value: " + bucketSize + " configured for '" + BUCKET_CACHE_BUCKETS_KEY + "'. All bucket sizes to be multiples of 256");
                }
                bucketSizes[i] = bucketSize;
            }
        }
        BucketCache bucketCache = null;
        try {
            int ioErrorsTolerationDuration = c.getInt("hbase.bucketcache.ioengine.errors.tolerated.duration", 60000);
            bucketCache = new BucketCache(bucketCacheIOEngineName, bucketCacheSize, blockSize, bucketSizes, writerThreads, writerQueueLen, persistentPath, ioErrorsTolerationDuration, c);
        }
        catch (IOException ioex) {
            LOG.error("Can't instantiate bucket cache", (Throwable)ioex);
            throw new RuntimeException(ioex);
        }
        return bucketCache;
    }

    static {
        Configuration.addDeprecation((String)DEPRECATED_BLOCKCACHE_BLOCKSIZE_KEY, (String)BLOCKCACHE_BLOCKSIZE_KEY);
    }

    private static enum ExternalBlockCaches {
        memcached("org.apache.hadoop.hbase.io.hfile.MemcachedBlockCache");

        Class<? extends BlockCache> clazz;

        private ExternalBlockCaches(String clazzName) {
            try {
                this.clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException cnef) {
                this.clazz = null;
            }
        }

        private ExternalBlockCaches(Class<? extends BlockCache> clazz) {
            this.clazz = clazz;
        }
    }
}

