/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.locking;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.locking.EntityLock;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class LockServiceClient {
    private final LockServiceProtos.LockService.BlockingInterface stub;
    private final Configuration conf;
    private final NonceGenerator ng;

    public LockServiceClient(Configuration conf, LockServiceProtos.LockService.BlockingInterface stub, NonceGenerator ng) {
        this.conf = conf;
        this.stub = stub;
        this.ng = ng;
    }

    public EntityLock tableLock(TableName tableName, boolean exclusive, String description, Abortable abort) {
        LockServiceProtos.LockRequest lockRequest = LockServiceClient.buildLockRequest(exclusive ? LockServiceProtos.LockType.EXCLUSIVE : LockServiceProtos.LockType.SHARED, tableName.getNameAsString(), null, null, description, this.ng.getNonceGroup(), this.ng.newNonce());
        return new EntityLock(this.conf, this.stub, lockRequest, abort);
    }

    public EntityLock namespaceLock(String namespace, String description, Abortable abort) {
        LockServiceProtos.LockRequest lockRequest = LockServiceClient.buildLockRequest(LockServiceProtos.LockType.EXCLUSIVE, namespace, null, null, description, this.ng.getNonceGroup(), this.ng.newNonce());
        return new EntityLock(this.conf, this.stub, lockRequest, abort);
    }

    public EntityLock regionLock(List<RegionInfo> regionInfos, String description, Abortable abort) {
        LockServiceProtos.LockRequest lockRequest = LockServiceClient.buildLockRequest(LockServiceProtos.LockType.EXCLUSIVE, null, null, regionInfos, description, this.ng.getNonceGroup(), this.ng.newNonce());
        return new EntityLock(this.conf, this.stub, lockRequest, abort);
    }

    @VisibleForTesting
    public static LockServiceProtos.LockRequest buildLockRequest(LockServiceProtos.LockType type, String namespace, TableName tableName, List<RegionInfo> regionInfos, String description, long nonceGroup, long nonce) {
        LockServiceProtos.LockRequest.Builder builder = LockServiceProtos.LockRequest.newBuilder().setLockType(type).setNonceGroup(nonceGroup).setNonce(nonce);
        if (regionInfos != null) {
            for (RegionInfo hri : regionInfos) {
                builder.addRegionInfo(ProtobufUtil.toRegionInfo(hri));
            }
        } else if (namespace != null) {
            builder.setNamespace(namespace);
        } else if (tableName != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        }
        return builder.setDescription(description).build();
    }
}

