/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.net.BoundSocketMaker;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleKdcServerUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(SimpleKdcServerUtil.class);

    private SimpleKdcServerUtil() {
    }

    public static SimpleKdcServer getRunningSimpleKdcServer(File testDir, Supplier<Integer> randomPortGenerator) throws KrbException, IOException {
        return SimpleKdcServerUtil.getRunningSimpleKdcServer(testDir, randomPortGenerator, false);
    }

    @VisibleForTesting
    static SimpleKdcServer getRunningSimpleKdcServer(File testDir, Supplier<Integer> randomPortGenerator, boolean portClash) throws KrbException, IOException {
        File kdcDir = new File(testDir, SimpleKdcServer.class.getSimpleName());
        Preconditions.checkArgument((boolean)kdcDir.mkdirs(), (Object)("Failed create of " + kdcDir));
        String hostName = InetAddress.getLoopbackAddress().getHostName();
        BoundSocketMaker bsm = portClash ? new BoundSocketMaker(randomPortGenerator) : null;
        int retries = 10;
        for (int i = 0; i < 10; ++i) {
            SimpleKdcServer kdc = new SimpleKdcServer();
            kdc.setWorkDir(kdcDir);
            kdc.setKdcHost(hostName);
            kdc.setAllowTcp(true);
            kdc.setAllowUdp(false);
            int kdcPort = bsm != null ? bsm.getPort() : randomPortGenerator.get().intValue();
            try {
                kdc.setKdcTcpPort(kdcPort);
                LOG.info("Starting KDC server at {}:{}", (Object)hostName, (Object)kdcPort);
                kdc.init();
                kdc.start();
                SimpleKdcServer simpleKdcServer = kdc;
                return simpleKdcServer;
            }
            catch (KrbException ke) {
                if (kdc != null) {
                    kdc.stop();
                }
                if (ke.getCause() != null && ke.getCause() instanceof BindException) {
                    LOG.info("Clashed using port {}; getting a new random port", (Object)kdcPort);
                    continue;
                }
                throw ke;
            }
            finally {
                if (bsm != null) {
                    bsm.close();
                    bsm = null;
                }
            }
        }
        throw new KrbException("Failed create of SimpleKdcServer after 10 attempts");
    }
}

