/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.KerberosAuthException;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.PlatformName;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class UserGroupInformation {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(UserGroupInformation.class);
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static boolean shouldRenewImmediatelyForTests = false;
    static final String HADOOP_USER_NAME = "HADOOP_USER_NAME";
    static final String HADOOP_PROXY_USER = "HADOOP_PROXY_USER";
    static UgiMetrics metrics = UgiMetrics.create();
    private static AuthenticationMethod authenticationMethod;
    private static Groups groups;
    private static long kerberosMinSecondsBeforeRelogin;
    private static Configuration conf;
    public static final String HADOOP_TOKEN_FILE_LOCATION = "HADOOP_TOKEN_FILE_LOCATION";
    private static UserGroupInformation loginUser;
    private static String keytabPrincipal;
    private static String keytabFile;
    private final Subject subject;
    private final User user;
    private final boolean isKeytab;
    private final boolean isKrbTkt;
    private static String OS_LOGIN_MODULE_NAME;
    private static Class<? extends Principal> OS_PRINCIPAL_CLASS;
    private static final boolean windows;
    private static final boolean is64Bit;
    private static final boolean aix;

    @VisibleForTesting
    public static void setShouldRenewImmediatelyForTests(boolean immediate) {
        shouldRenewImmediatelyForTests = immediate;
    }

    public static void reattachMetrics() {
        UgiMetrics.reattach();
    }

    public static boolean isInitialized() {
        return conf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInitialized() {
        if (UserGroupInformation.isInitialized()) return;
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        synchronized (UserGroupInformation.class) {
            if (UserGroupInformation.isInitialized()) return;
            UserGroupInformation.initialize(new Configuration(), false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static synchronized void initialize(Configuration conf, boolean overrideNameRules) {
        int[] intervals;
        authenticationMethod = SecurityUtil.getAuthenticationMethod(conf);
        if (overrideNameRules || !HadoopKerberosName.hasRulesBeenSet()) {
            try {
                HadoopKerberosName.setConfiguration(conf);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Problem with Kerberos auth_to_local name configuration", ioe);
            }
        }
        try {
            kerberosMinSecondsBeforeRelogin = 1000L * conf.getLong("hadoop.kerberos.min.seconds.before.relogin", 60L);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.kerberos.min.seconds.before.relogin of " + conf.get("hadoop.kerberos.min.seconds.before.relogin"));
        }
        if (!(groups instanceof TestingGroups)) {
            groups = Groups.getUserToGroupsMappingService(conf);
        }
        UserGroupInformation.conf = conf;
        if (UserGroupInformation.metrics.getGroupsQuantiles == null && (intervals = conf.getInts("hadoop.user.group.metrics.percentiles.intervals")) != null && intervals.length > 0) {
            int length = intervals.length;
            MutableQuantiles[] getGroupsQuantiles = new MutableQuantiles[length];
            for (int i = 0; i < length; ++i) {
                getGroupsQuantiles[i] = UserGroupInformation.metrics.registry.newQuantiles("getGroups" + intervals[i] + "s", "Get groups", "ops", "latency", intervals[i]);
            }
            UserGroupInformation.metrics.getGroupsQuantiles = getGroupsQuantiles;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void setConfiguration(Configuration conf) {
        UserGroupInformation.initialize(conf, true);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void reset() {
        authenticationMethod = null;
        conf = null;
        groups = null;
        UserGroupInformation.setLoginUser(null);
        HadoopKerberosName.setRules(null);
    }

    public static boolean isSecurityEnabled() {
        return !UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.SIMPLE);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    private static boolean isAuthenticationMethodEnabled(AuthenticationMethod method) {
        UserGroupInformation.ensureInitialized();
        return authenticationMethod == method;
    }

    private static String getOSLoginModuleName() {
        if (PlatformName.IBM_JAVA) {
            if (windows) {
                return is64Bit ? "com.ibm.security.auth.module.Win64LoginModule" : "com.ibm.security.auth.module.NTLoginModule";
            }
            if (aix) {
                return is64Bit ? "com.ibm.security.auth.module.AIX64LoginModule" : "com.ibm.security.auth.module.AIXLoginModule";
            }
            return "com.ibm.security.auth.module.LinuxLoginModule";
        }
        return windows ? "com.sun.security.auth.module.NTLoginModule" : "com.sun.security.auth.module.UnixLoginModule";
    }

    private static Class<? extends Principal> getOsPrincipalClass() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        try {
            String principalClass = null;
            principalClass = PlatformName.IBM_JAVA ? (is64Bit ? "com.ibm.security.auth.UsernamePrincipal" : (windows ? "com.ibm.security.auth.NTUserPrincipal" : (aix ? "com.ibm.security.auth.AIXPrincipal" : "com.ibm.security.auth.LinuxPrincipal"))) : (windows ? "com.sun.security.auth.NTUserPrincipal" : "com.sun.security.auth.UnixPrincipal");
            return cl.loadClass(principalClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to find JAAS classes:" + e.getMessage());
            return null;
        }
    }

    private static String prependFileAuthority(String keytabPath) {
        return keytabPath.startsWith("file://") ? keytabPath : "file://" + keytabPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoginContext newLoginContext(String appName, Subject subject, javax.security.auth.login.Configuration loginConf) throws LoginException {
        Thread t = Thread.currentThread();
        ClassLoader oldCCL = t.getContextClassLoader();
        t.setContextClassLoader(HadoopLoginModule.class.getClassLoader());
        try {
            LoginContext loginContext = new LoginContext(appName, subject, null, loginConf);
            return loginContext;
        }
        finally {
            t.setContextClassLoader(oldCCL);
        }
    }

    private LoginContext getLogin() {
        return this.user.getLogin();
    }

    private void setLogin(LoginContext login) {
        this.user.setLogin(login);
    }

    UserGroupInformation(Subject subject) {
        this(subject, false);
    }

    private UserGroupInformation(Subject subject, boolean externalKeyTab) {
        this.subject = subject;
        this.user = subject.getPrincipals(User.class).iterator().next();
        this.isKeytab = externalKeyTab ? false : KerberosUtil.hasKerberosKeyTab((Subject)subject);
        this.isKrbTkt = KerberosUtil.hasKerberosTicket((Subject)subject);
    }

    public boolean hasKerberosCredentials() {
        return this.isKeytab || this.isKrbTkt;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized UserGroupInformation getCurrentUser() throws IOException {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        if (subject == null || subject.getPrincipals(User.class).isEmpty()) {
            return UserGroupInformation.getLoginUser();
        }
        return new UserGroupInformation(subject);
    }

    public static UserGroupInformation getBestUGI(String ticketCachePath, String user) throws IOException {
        if (ticketCachePath != null) {
            return UserGroupInformation.getUGIFromTicketCache(ticketCachePath, user);
        }
        if (user == null) {
            return UserGroupInformation.getCurrentUser();
        }
        return UserGroupInformation.createRemoteUser(user);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation getUGIFromTicketCache(String ticketCache, String user) throws IOException {
        if (!UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.KERBEROS)) {
            return UserGroupInformation.getBestUGI(null, user);
        }
        try {
            HashMap<String, String> krbOptions = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                krbOptions.put("useDefaultCcache", "true");
                System.setProperty("KRB5CCNAME", ticketCache);
            } else {
                krbOptions.put("doNotPrompt", "true");
                krbOptions.put("useTicketCache", "true");
                krbOptions.put("useKeyTab", "false");
                krbOptions.put("ticketCache", ticketCache);
            }
            krbOptions.put("renewTGT", "false");
            krbOptions.putAll(HadoopConfiguration.BASIC_JAAS_OPTIONS);
            AppConfigurationEntry ace = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, krbOptions);
            DynamicConfiguration dynConf = new DynamicConfiguration(new AppConfigurationEntry[]{ace});
            LoginContext login = UserGroupInformation.newLoginContext("hadoop-user-kerberos", null, dynConf);
            login.login();
            Subject loginSubject = login.getSubject();
            Set<Principal> loginPrincipals = loginSubject.getPrincipals();
            if (loginPrincipals.isEmpty()) {
                throw new RuntimeException("No login principals found!");
            }
            if (loginPrincipals.size() != 1) {
                LOG.warn("found more than one principal in the ticket cache file " + ticketCache);
            }
            User ugiUser = new User(loginPrincipals.iterator().next().getName(), AuthenticationMethod.KERBEROS, login);
            loginSubject.getPrincipals().add(ugiUser);
            UserGroupInformation ugi = new UserGroupInformation(loginSubject);
            ugi.setLogin(login);
            ugi.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
            return ugi;
        }
        catch (LoginException le) {
            KerberosAuthException kae = new KerberosAuthException("failure to login:", le);
            kae.setUser(user);
            kae.setTicketCacheFile(ticketCache);
            throw kae;
        }
    }

    public static UserGroupInformation getUGIFromSubject(Subject subject) throws IOException {
        if (subject == null) {
            throw new KerberosAuthException("Subject must not be null");
        }
        if (subject.getPrincipals(KerberosPrincipal.class).isEmpty()) {
            throw new KerberosAuthException("Provided Subject must contain a KerberosPrincipal");
        }
        KerberosPrincipal principal = subject.getPrincipals(KerberosPrincipal.class).iterator().next();
        User ugiUser = new User(principal.getName(), AuthenticationMethod.KERBEROS, null);
        subject.getPrincipals().add(ugiUser);
        UserGroupInformation ugi = new UserGroupInformation(subject);
        ugi.setLogin(null);
        ugi.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
        return ugi;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized UserGroupInformation getLoginUser() throws IOException {
        if (loginUser == null) {
            UserGroupInformation.loginUserFromSubject(null);
        }
        return loginUser;
    }

    public static String trimLoginMethod(String userName) {
        int spaceIndex = userName.indexOf(32);
        if (spaceIndex >= 0) {
            userName = userName.substring(0, spaceIndex);
        }
        return userName;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized void loginUserFromSubject(Subject subject) throws IOException {
        UserGroupInformation.ensureInitialized();
        try {
            String fileLocation;
            if (subject == null) {
                subject = new Subject();
            }
            LoginContext login = UserGroupInformation.newLoginContext(authenticationMethod.getLoginAppName(), subject, new HadoopConfiguration());
            login.login();
            LOG.debug("Assuming keytab is managed externally since logged in from subject.");
            UserGroupInformation realUser = new UserGroupInformation(subject, true);
            realUser.setLogin(login);
            realUser.setAuthenticationMethod(authenticationMethod);
            String proxyUser = System.getenv(HADOOP_PROXY_USER);
            if (proxyUser == null) {
                proxyUser = System.getProperty(HADOOP_PROXY_USER);
            }
            loginUser = proxyUser == null ? realUser : UserGroupInformation.createProxyUser(proxyUser, realUser);
            String tokenFileLocation = System.getProperty("hadoop.token.files");
            if (tokenFileLocation == null) {
                tokenFileLocation = conf.get("hadoop.token.files");
            }
            if (tokenFileLocation != null) {
                for (String tokenFileName : StringUtils.getTrimmedStrings(tokenFileLocation)) {
                    if (tokenFileName.length() <= 0) continue;
                    File tokenFile = new File(tokenFileName);
                    if (tokenFile.exists() && tokenFile.isFile()) {
                        Credentials cred = Credentials.readTokenStorageFile(tokenFile, conf);
                        loginUser.addCredentials(cred);
                        continue;
                    }
                    LOG.info("tokenFile(" + tokenFileName + ") does not exist");
                }
            }
            if ((fileLocation = System.getenv(HADOOP_TOKEN_FILE_LOCATION)) != null) {
                File source = new File(fileLocation);
                LOG.debug("Reading credentials from location set in {}: {}", (Object)HADOOP_TOKEN_FILE_LOCATION, (Object)source.getCanonicalPath());
                if (!source.isFile()) {
                    throw new FileNotFoundException("Source file " + source.getCanonicalPath() + " from " + HADOOP_TOKEN_FILE_LOCATION + " not found");
                }
                Credentials cred = Credentials.readTokenStorageFile(source, conf);
                LOG.debug("Loaded {} tokens", (Object)cred.numberOfTokens());
                loginUser.addCredentials(cred);
            }
            loginUser.spawnAutoRenewalThreadForUserCreds();
        }
        catch (LoginException le) {
            LOG.debug("failure to login", (Throwable)le);
            throw new KerberosAuthException("failure to login:", le);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("UGI loginUser:" + loginUser);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public static synchronized void setLoginUser(UserGroupInformation ugi) {
        loginUser = ugi;
    }

    public boolean isFromKeytab() {
        return this.isKeytab;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!SecurityUtil.isOriginalTGT(ticket)) continue;
            return ticket;
        }
        return null;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    private void spawnAutoRenewalThreadForUserCreds() {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || this.isKeytab) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                String cmd = conf.get("hadoop.kerberos.kinit.command", "kinit");
                KerberosTicket tgt = UserGroupInformation.this.getTGT();
                if (tgt == null) {
                    return;
                }
                long nextRefresh = UserGroupInformation.this.getRefreshTime(tgt);
                RetryPolicy rp = null;
                while (true) {
                    try {
                        while (true) {
                            long now = Time.now();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Current time is " + now);
                                LOG.debug("Next refresh is " + nextRefresh);
                            }
                            if (now < nextRefresh) {
                                Thread.sleep(nextRefresh - now);
                            }
                            Shell.execCommand(cmd, "-R");
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("renewed ticket");
                            }
                            UserGroupInformation.this.reloginFromTicketCache();
                            tgt = UserGroupInformation.this.getTGT();
                            if (tgt == null) {
                                LOG.warn("No TGT after renewal. Aborting renew thread for " + UserGroupInformation.this.getUserName());
                                return;
                            }
                            nextRefresh = Math.max(UserGroupInformation.this.getRefreshTime(tgt), now + kerberosMinSecondsBeforeRelogin);
                            metrics.renewalFailures.set(0);
                            rp = null;
                        }
                    }
                    catch (InterruptedException ie) {
                        LOG.warn("Terminating renewal thread");
                        return;
                    }
                    catch (IOException ie) {
                        metrics.renewalFailuresTotal.incr();
                        long tgtEndTime = tgt.getEndTime().getTime();
                        LOG.warn("Exception encountered while running the renewal command for {}. (TGT end time:{}, renewalFailures: {},renewalFailuresTotal: {})", new Object[]{UserGroupInformation.this.getUserName(), tgtEndTime, metrics.renewalFailures, metrics.renewalFailuresTotal, ie});
                        long now = Time.now();
                        if (rp == null) {
                            rp = RetryPolicies.exponentialBackoffRetry(62, kerberosMinSecondsBeforeRelogin, TimeUnit.MILLISECONDS);
                        }
                        try {
                            nextRefresh = UserGroupInformation.getNextTgtRenewalTime(tgtEndTime, now, rp);
                        }
                        catch (Exception e) {
                            LOG.error("Exception when calculating next tgt renewal time", (Throwable)e);
                            return;
                        }
                        metrics.renewalFailures.incr();
                        if (now <= nextRefresh) continue;
                        LOG.error("TGT is expired. Aborting renew thread for {}.", (Object)UserGroupInformation.this.getUserName());
                        return;
                    }
                    break;
                }
            }
        });
        t.setDaemon(true);
        t.setName("TGT Renewer for " + this.getUserName());
        t.start();
    }

    @VisibleForTesting
    static long getNextTgtRenewalTime(long tgtEndTime, long now, RetryPolicy rp) throws Exception {
        long lastRetryTime = tgtEndTime - kerberosMinSecondsBeforeRelogin;
        RetryPolicy.RetryAction ra = rp.shouldRetry(null, metrics.renewalFailures.value(), 0, false);
        return Math.min(lastRetryTime, now + ra.delayMillis);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized void loginUserFromKeytab(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        keytabFile = path;
        keytabPrincipal = user;
        Subject subject = new Subject();
        long start = 0L;
        try {
            LoginContext login = UserGroupInformation.newLoginContext("hadoop-keytab-kerberos", subject, new HadoopConfiguration());
            start = Time.now();
            login.login();
            UserGroupInformation.metrics.loginSuccess.add(Time.now() - start);
            loginUser = new UserGroupInformation(subject);
            loginUser.setLogin(login);
            loginUser.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.add(Time.now() - start);
            }
            KerberosAuthException kae = new KerberosAuthException("Login failure", le);
            kae.setUser(user);
            kae.setKeytabFile(path);
            throw kae;
        }
        LOG.info("Login successful for user " + keytabPrincipal + " using keytab file " + keytabFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void logoutUserFromKeytab() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null || keytabFile == null) {
            throw new KerberosAuthException("loginUserFromKeyTab must be done first");
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initiating logout for " + this.getUserName());
            }
            Class<UserGroupInformation> clazz = UserGroupInformation.class;
            synchronized (UserGroupInformation.class) {
                login.logout();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (LoginException le) {
            KerberosAuthException kae = new KerberosAuthException("Logout failure", le);
            kae.setUser(this.user.toString());
            kae.setKeytabFile(keytabFile);
            throw kae;
        }
        {
            LOG.info("Logout successful for user " + keytabPrincipal + " using keytab file " + keytabFile);
            return;
        }
    }

    public synchronized void checkTGTAndReloginFromKeytab() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKeytab) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt != null && !shouldRenewImmediatelyForTests && Time.now() < this.getRefreshTime(tgt)) {
            return;
        }
        this.reloginFromKeytab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixKerberosTicketOrder() {
        Set<Object> creds;
        Set<Object> set = creds = this.getSubject().getPrivateCredentials();
        synchronized (set) {
            Iterator<Object> iter = creds.iterator();
            while (iter.hasNext()) {
                Object cred = iter.next();
                if (!(cred instanceof KerberosTicket)) continue;
                KerberosTicket ticket = (KerberosTicket)cred;
                if (ticket.isDestroyed() || ticket.getServer() == null) {
                    LOG.warn("Ticket is already destroyed, remove it.");
                    iter.remove();
                    continue;
                }
                if (!ticket.getServer().getName().startsWith("krbtgt")) {
                    LOG.warn("The first kerberos ticket is not TGT(the server principal is {}), remove and destroy it.", (Object)ticket.getServer());
                    iter.remove();
                    try {
                        ticket.destroy();
                    }
                    catch (DestroyFailedException e) {
                        LOG.warn("destroy ticket failed", (Throwable)e);
                    }
                    continue;
                }
                return;
            }
        }
        LOG.warn("Warning, no kerberos ticket found while attempting to renew ticket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public synchronized void reloginFromKeytab() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKeytab) {
            return;
        }
        long now = Time.now();
        if (!shouldRenewImmediatelyForTests && !this.hasSufficientTimeElapsed(now)) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt != null && !shouldRenewImmediatelyForTests && now < this.getRefreshTime(tgt)) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null || keytabFile == null) {
            throw new KerberosAuthException("loginUserFromKeyTab must be done first");
        }
        long start = 0L;
        this.user.setLastLogin(now);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initiating logout for " + this.getUserName());
            }
            Class<UserGroupInformation> clazz = UserGroupInformation.class;
            synchronized (UserGroupInformation.class) {
                login.logout();
                login = UserGroupInformation.newLoginContext("hadoop-keytab-kerberos", this.getSubject(), new HadoopConfiguration());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Initiating re-login for " + keytabPrincipal);
                }
                start = Time.now();
                login.login();
                this.fixKerberosTicketOrder();
                UserGroupInformation.metrics.loginSuccess.add(Time.now() - start);
                this.setLogin(login);
                // ** MonitorExit[var7_5] (shouldn't be in output)
            }
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.add(Time.now() - start);
            }
            KerberosAuthException kae = new KerberosAuthException("Login failure", le);
            kae.setPrincipal(keytabPrincipal);
            kae.setKeytabFile(keytabFile);
            throw kae;
        }
        {
            return;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public synchronized void reloginFromTicketCache() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKrbTkt) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null) {
            throw new KerberosAuthException("login must be done first");
        }
        long now = Time.now();
        if (!this.hasSufficientTimeElapsed(now)) {
            return;
        }
        this.user.setLastLogin(now);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initiating logout for " + this.getUserName());
            }
            login.logout();
            login = UserGroupInformation.newLoginContext("hadoop-user-kerberos", this.getSubject(), new HadoopConfiguration());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initiating re-login for " + this.getUserName());
            }
            login.login();
            this.fixKerberosTicketOrder();
            this.setLogin(login);
        }
        catch (LoginException le) {
            KerberosAuthException kae = new KerberosAuthException("Login failure", le);
            kae.setUser(this.getUserName());
            throw kae;
        }
    }

    public static synchronized UserGroupInformation loginUserFromKeytabAndReturnUGI(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return UserGroupInformation.getCurrentUser();
        }
        String oldKeytabFile = null;
        String oldKeytabPrincipal = null;
        long start = 0L;
        try {
            oldKeytabFile = keytabFile;
            oldKeytabPrincipal = keytabPrincipal;
            keytabFile = path;
            keytabPrincipal = user;
            Subject subject = new Subject();
            LoginContext login = UserGroupInformation.newLoginContext("hadoop-keytab-kerberos", subject, new HadoopConfiguration());
            start = Time.now();
            login.login();
            UserGroupInformation.metrics.loginSuccess.add(Time.now() - start);
            UserGroupInformation newLoginUser = new UserGroupInformation(subject);
            newLoginUser.setLogin(login);
            newLoginUser.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
            UserGroupInformation userGroupInformation = newLoginUser;
            return userGroupInformation;
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.add(Time.now() - start);
            }
            KerberosAuthException kae = new KerberosAuthException("Login failure", le);
            kae.setUser(user);
            kae.setKeytabFile(path);
            throw kae;
        }
        finally {
            if (oldKeytabFile != null) {
                keytabFile = oldKeytabFile;
            }
            if (oldKeytabPrincipal != null) {
                keytabPrincipal = oldKeytabPrincipal;
            }
        }
    }

    private boolean hasSufficientTimeElapsed(long now) {
        if (now - this.user.getLastLogin() < kerberosMinSecondsBeforeRelogin) {
            LOG.warn("Not attempting to re-login since the last re-login was attempted less than " + kerberosMinSecondsBeforeRelogin / 1000L + " seconds before. Last Login=" + this.user.getLastLogin());
            return false;
        }
        return true;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized boolean isLoginKeytabBased() throws IOException {
        return UserGroupInformation.getLoginUser().isKeytab;
    }

    public static boolean isLoginTicketBased() throws IOException {
        return UserGroupInformation.getLoginUser().isKrbTkt;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createRemoteUser(String user) {
        return UserGroupInformation.createRemoteUser(user, SaslRpcServer.AuthMethod.SIMPLE);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createRemoteUser(String user, SaslRpcServer.AuthMethod authMethod) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Null user");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new User(user));
        UserGroupInformation result = new UserGroupInformation(subject);
        result.setAuthenticationMethod(authMethod);
        return result;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createProxyUser(String user, UserGroupInformation realUser) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Null user");
        }
        if (realUser == null) {
            throw new IllegalArgumentException("Null real user");
        }
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new User(user));
        principals.add(new RealUser(realUser));
        UserGroupInformation result = new UserGroupInformation(subject);
        result.setAuthenticationMethod(AuthenticationMethod.PROXY);
        return result;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public UserGroupInformation getRealUser() {
        Iterator<RealUser> i$ = this.subject.getPrincipals(RealUser.class).iterator();
        if (i$.hasNext()) {
            RealUser p = i$.next();
            return p.getRealUser();
        }
        return null;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createUserForTesting(String user, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups(groups);
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public static UserGroupInformation createProxyUserForTesting(String user, UserGroupInformation realUser, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser(user, realUser);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups(groups);
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public String getShortUserName() {
        return this.user.getShortName();
    }

    public String getPrimaryGroupName() throws IOException {
        List<String> groups = this.getGroups();
        if (groups.isEmpty()) {
            throw new IOException("There is no primary group for UGI " + this);
        }
        return groups.get(0);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public String getUserName() {
        return this.user.getName();
    }

    public synchronized boolean addTokenIdentifier(TokenIdentifier tokenId) {
        return this.subject.getPublicCredentials().add(tokenId);
    }

    public synchronized Set<TokenIdentifier> getTokenIdentifiers() {
        return this.subject.getPublicCredentials(TokenIdentifier.class);
    }

    public boolean addToken(Token<? extends TokenIdentifier> token) {
        return token != null ? this.addToken(token.getService(), token) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToken(Text alias, Token<? extends TokenIdentifier> token) {
        Subject subject = this.subject;
        synchronized (subject) {
            this.getCredentialsInternal().addToken(alias, token);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Token<? extends TokenIdentifier>> getTokens() {
        Subject subject = this.subject;
        synchronized (subject) {
            return Collections.unmodifiableCollection(new ArrayList<Token<? extends TokenIdentifier>>(this.getCredentialsInternal().getAllTokens()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials() {
        Subject subject = this.subject;
        synchronized (subject) {
            Credentials creds = new Credentials(this.getCredentialsInternal());
            Iterator<Token<? extends TokenIdentifier>> iter = creds.getAllTokens().iterator();
            while (iter.hasNext()) {
                if (!iter.next().isPrivate()) continue;
                iter.remove();
            }
            return creds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCredentials(Credentials credentials) {
        Subject subject = this.subject;
        synchronized (subject) {
            this.getCredentialsInternal().addAll(credentials);
        }
    }

    private synchronized Credentials getCredentialsInternal() {
        Credentials credentials;
        Set<Credentials> credentialsSet = this.subject.getPrivateCredentials(Credentials.class);
        if (!credentialsSet.isEmpty()) {
            credentials = credentialsSet.iterator().next();
        } else {
            credentials = new Credentials();
            this.subject.getPrivateCredentials().add(credentials);
        }
        return credentials;
    }

    public String[] getGroupNames() {
        List<String> groups = this.getGroups();
        return groups.toArray(new String[groups.size()]);
    }

    public List<String> getGroups() {
        UserGroupInformation.ensureInitialized();
        try {
            return groups.getGroups(this.getShortUserName());
        }
        catch (IOException ie) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to get groups for user " + this.getShortUserName() + " by " + ie);
                LOG.trace("TRACE", (Throwable)ie);
            }
            return Collections.emptyList();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUserName());
        sb.append(" (auth:" + (Object)((Object)this.getAuthenticationMethod()) + ")");
        if (this.getRealUser() != null) {
            sb.append(" via ").append(this.getRealUser().toString());
        }
        return sb.toString();
    }

    public synchronized void setAuthenticationMethod(AuthenticationMethod authMethod) {
        this.user.setAuthenticationMethod(authMethod);
    }

    public void setAuthenticationMethod(SaslRpcServer.AuthMethod authMethod) {
        this.user.setAuthenticationMethod(AuthenticationMethod.valueOf(authMethod));
    }

    public synchronized AuthenticationMethod getAuthenticationMethod() {
        return this.user.getAuthenticationMethod();
    }

    public synchronized AuthenticationMethod getRealAuthenticationMethod() {
        UserGroupInformation ugi = this.getRealUser();
        if (ugi == null) {
            ugi = this;
        }
        return ugi.getAuthenticationMethod();
    }

    public static AuthenticationMethod getRealAuthenticationMethod(UserGroupInformation ugi) {
        AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.subject == ((UserGroupInformation)o).subject;
    }

    public int hashCode() {
        return System.identityHashCode(this.subject);
    }

    protected Subject getSubject() {
        return this.subject;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public <T> T doAs(PrivilegedAction<T> action) {
        this.logPrivilegedAction(this.subject, action);
        return Subject.doAs(this.subject, action);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        try {
            this.logPrivilegedAction(this.subject, action);
            return Subject.doAs(this.subject, action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (LOG.isDebugEnabled()) {
                LOG.debug("PrivilegedActionException as:" + this + " cause:" + cause);
            }
            if (cause == null) {
                throw new RuntimeException("PrivilegedActionException with no underlying cause. UGI [" + this + "]" + ": " + pae, pae);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    private void logPrivilegedAction(Subject subject, Object action) {
        if (LOG.isDebugEnabled()) {
            String where = new Throwable().getStackTrace()[2].toString();
            LOG.debug("PrivilegedAction as:" + this + " from:" + where);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "KMS"})
    @InterfaceStability.Unstable
    public static void logUserInfo(Logger log, String caption, UserGroupInformation ugi) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(caption + " UGI: " + ugi);
            for (Token<? extends TokenIdentifier> token : ugi.getTokens()) {
                log.debug("+token:" + token);
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "KMS"})
    @InterfaceStability.Unstable
    public static void logAllUserInfo(Logger log, UserGroupInformation ugi) throws IOException {
        if (log.isDebugEnabled()) {
            UserGroupInformation.logUserInfo(log, "Current", ugi.getCurrentUser());
            if (ugi.getRealUser() != null) {
                UserGroupInformation.logUserInfo(log, "Real", ugi.getRealUser());
            }
            UserGroupInformation.logUserInfo(log, "Login", ugi.getLoginUser());
        }
    }

    public static void logAllUserInfo(UserGroupInformation ugi) throws IOException {
        UserGroupInformation.logAllUserInfo(LOG, ugi);
    }

    private void print() throws IOException {
        System.out.println("User: " + this.getUserName());
        System.out.print("Group Ids: ");
        System.out.println();
        String[] groups = this.getGroupNames();
        System.out.print("Groups: ");
        for (int i = 0; i < groups.length; ++i) {
            System.out.print(groups[i] + " ");
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Getting UGI for current user");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.print();
        System.out.println("UGI: " + ugi);
        System.out.println("Auth method " + (Object)((Object)ugi.user.getAuthenticationMethod()));
        System.out.println("Keytab " + ugi.isKeytab);
        System.out.println("============================================================");
        if (args.length == 2) {
            System.out.println("Getting UGI from keytab....");
            UserGroupInformation.loginUserFromKeytab(args[0], args[1]);
            UserGroupInformation.getCurrentUser().print();
            System.out.println("Keytab: " + ugi);
            System.out.println("Auth method " + (Object)((Object)UserGroupInformation.loginUser.user.getAuthenticationMethod()));
            System.out.println("Keytab " + UserGroupInformation.loginUser.isKeytab);
        }
    }

    static {
        loginUser = null;
        keytabPrincipal = null;
        keytabFile = null;
        windows = System.getProperty("os.name").startsWith("Windows");
        is64Bit = System.getProperty("os.arch").contains("64") || System.getProperty("os.arch").contains("s390x");
        aix = System.getProperty("os.name").equals("AIX");
        OS_LOGIN_MODULE_NAME = UserGroupInformation.getOSLoginModuleName();
        OS_PRINCIPAL_CLASS = UserGroupInformation.getOsPrincipalClass();
    }

    private static class TestingGroups
    extends Groups {
        private final Map<String, List<String>> userToGroupsMapping = new HashMap<String, List<String>>();
        private Groups underlyingImplementation;

        private TestingGroups(Groups underlyingImplementation) {
            super(new Configuration());
            this.underlyingImplementation = underlyingImplementation;
        }

        @Override
        public List<String> getGroups(String user) throws IOException {
            List<String> result = this.userToGroupsMapping.get(user);
            if (result == null) {
                result = this.underlyingImplementation.getGroups(user);
            }
            return result;
        }

        private void setUserGroups(String user, String[] groups) {
            this.userToGroupsMapping.put(user, Arrays.asList(groups));
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum AuthenticationMethod {
        SIMPLE(SaslRpcServer.AuthMethod.SIMPLE, "hadoop-simple"),
        KERBEROS(SaslRpcServer.AuthMethod.KERBEROS, "hadoop-user-kerberos"),
        TOKEN(SaslRpcServer.AuthMethod.TOKEN),
        CERTIFICATE(null),
        KERBEROS_SSL(null),
        PROXY(null);

        private final SaslRpcServer.AuthMethod authMethod;
        private final String loginAppName;

        private AuthenticationMethod(SaslRpcServer.AuthMethod authMethod) {
            this(authMethod, null);
        }

        private AuthenticationMethod(SaslRpcServer.AuthMethod authMethod, String loginAppName) {
            this.authMethod = authMethod;
            this.loginAppName = loginAppName;
        }

        public SaslRpcServer.AuthMethod getAuthMethod() {
            return this.authMethod;
        }

        String getLoginAppName() {
            if (this.loginAppName == null) {
                throw new UnsupportedOperationException((Object)((Object)this) + " login authentication is not supported");
            }
            return this.loginAppName;
        }

        public static AuthenticationMethod valueOf(SaslRpcServer.AuthMethod authMethod) {
            for (AuthenticationMethod value : AuthenticationMethod.values()) {
                if (value.getAuthMethod() != authMethod) continue;
                return value;
            }
            throw new IllegalArgumentException("no authentication method for " + (Object)((Object)authMethod));
        }
    }

    private static class DynamicConfiguration
    extends javax.security.auth.login.Configuration {
        private AppConfigurationEntry[] ace;

        DynamicConfiguration(AppConfigurationEntry[] ace) {
            this.ace = ace;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            return this.ace;
        }
    }

    private static class HadoopConfiguration
    extends javax.security.auth.login.Configuration {
        private static final String SIMPLE_CONFIG_NAME = "hadoop-simple";
        private static final String USER_KERBEROS_CONFIG_NAME = "hadoop-user-kerberos";
        private static final String KEYTAB_KERBEROS_CONFIG_NAME = "hadoop-keytab-kerberos";
        private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
        private static final AppConfigurationEntry OS_SPECIFIC_LOGIN;
        private static final AppConfigurationEntry HADOOP_LOGIN;
        private static final Map<String, String> USER_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry USER_KERBEROS_LOGIN;
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry KEYTAB_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] SIMPLE_CONF;
        private static final AppConfigurationEntry[] USER_KERBEROS_CONF;
        private static final AppConfigurationEntry[] KEYTAB_KERBEROS_CONF;

        private HadoopConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (SIMPLE_CONFIG_NAME.equals(appName)) {
                return SIMPLE_CONF;
            }
            if (USER_KERBEROS_CONFIG_NAME.equals(appName)) {
                return USER_KERBEROS_CONF;
            }
            if (KEYTAB_KERBEROS_CONFIG_NAME.equals(appName)) {
                if (PlatformName.IBM_JAVA) {
                    KEYTAB_KERBEROS_OPTIONS.put("useKeytab", UserGroupInformation.prependFileAuthority(keytabFile));
                } else {
                    KEYTAB_KERBEROS_OPTIONS.put("keyTab", keytabFile);
                }
                KEYTAB_KERBEROS_OPTIONS.put("principal", keytabPrincipal);
                return KEYTAB_KERBEROS_CONF;
            }
            return null;
        }

        static {
            String jaasEnvVar = System.getenv("HADOOP_JAAS_DEBUG");
            if (jaasEnvVar != null && "true".equalsIgnoreCase(jaasEnvVar)) {
                BASIC_JAAS_OPTIONS.put("debug", "true");
            }
            OS_SPECIFIC_LOGIN = new AppConfigurationEntry(OS_LOGIN_MODULE_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, BASIC_JAAS_OPTIONS);
            HADOOP_LOGIN = new AppConfigurationEntry(HadoopLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, BASIC_JAAS_OPTIONS);
            USER_KERBEROS_OPTIONS = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                USER_KERBEROS_OPTIONS.put("useDefaultCcache", "true");
            } else {
                USER_KERBEROS_OPTIONS.put("doNotPrompt", "true");
                USER_KERBEROS_OPTIONS.put("useTicketCache", "true");
            }
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                if (PlatformName.IBM_JAVA) {
                    System.setProperty("KRB5CCNAME", ticketCache);
                } else {
                    USER_KERBEROS_OPTIONS.put("ticketCache", ticketCache);
                }
            }
            USER_KERBEROS_OPTIONS.put("renewTGT", "true");
            USER_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            USER_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, USER_KERBEROS_OPTIONS);
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                KEYTAB_KERBEROS_OPTIONS.put("credsType", "both");
            } else {
                KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
                KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
                KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
            }
            KEYTAB_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
            KEYTAB_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KEYTAB_KERBEROS_OPTIONS);
            SIMPLE_CONF = new AppConfigurationEntry[]{OS_SPECIFIC_LOGIN, HADOOP_LOGIN};
            USER_KERBEROS_CONF = new AppConfigurationEntry[]{OS_SPECIFIC_LOGIN, USER_KERBEROS_LOGIN, HADOOP_LOGIN};
            KEYTAB_KERBEROS_CONF = new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN, HADOOP_LOGIN};
        }
    }

    private static class RealUser
    implements Principal {
        private final UserGroupInformation realUser;

        RealUser(UserGroupInformation realUser) {
            this.realUser = realUser;
        }

        @Override
        public String getName() {
            return this.realUser.getUserName();
        }

        public UserGroupInformation getRealUser() {
            return this.realUser;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.realUser.equals(((RealUser)o).realUser);
        }

        @Override
        public int hashCode() {
            return this.realUser.hashCode();
        }

        @Override
        public String toString() {
            return this.realUser.toString();
        }
    }

    @InterfaceAudience.Private
    public static class HadoopLoginModule
    implements LoginModule {
        private Subject subject;

        @Override
        public boolean abort() throws LoginException {
            return true;
        }

        private <T extends Principal> T getCanonicalUser(Class<T> cls) {
            Iterator<T> i$ = this.subject.getPrincipals(cls).iterator();
            if (i$.hasNext()) {
                Principal user = (Principal)i$.next();
                return (T)user;
            }
            return null;
        }

        @Override
        public boolean commit() throws LoginException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("hadoop login commit");
            }
            if (!this.subject.getPrincipals(User.class).isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("using existing subject:" + this.subject.getPrincipals());
                }
                return true;
            }
            Principal user = null;
            if (UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.KERBEROS)) {
                user = this.getCanonicalUser(KerberosPrincipal.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("using kerberos user:" + user);
                }
            }
            if (!UserGroupInformation.isSecurityEnabled() && user == null) {
                String envUser = System.getenv(UserGroupInformation.HADOOP_USER_NAME);
                if (envUser == null) {
                    envUser = System.getProperty(UserGroupInformation.HADOOP_USER_NAME);
                }
                Principal principal = user = envUser == null ? null : new User(envUser);
            }
            if (user == null) {
                user = this.getCanonicalUser(OS_PRINCIPAL_CLASS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("using local user:" + user);
                }
            }
            if (user != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using user: \"" + user + "\" with name " + user.getName());
                }
                User userEntry = null;
                try {
                    userEntry = new User(user.getName());
                }
                catch (Exception e) {
                    throw (LoginException)new LoginException(e.toString()).initCause(e);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("User entry: \"" + userEntry.toString() + "\"");
                }
                this.subject.getPrincipals().add(userEntry);
                return true;
            }
            LOG.error("Can't find user in " + this.subject);
            throw new LoginException("Can't find user name");
        }

        @Override
        public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
            this.subject = subject;
        }

        @Override
        public boolean login() throws LoginException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("hadoop login");
            }
            return true;
        }

        @Override
        public boolean logout() throws LoginException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("hadoop logout");
            }
            return true;
        }
    }

    @Metrics(about="User and group related metrics", context="ugi")
    static class UgiMetrics {
        final MetricsRegistry registry = new MetricsRegistry("UgiMetrics");
        @Metric(value={"Rate of successful kerberos logins and latency (milliseconds)"})
        MutableRate loginSuccess;
        @Metric(value={"Rate of failed kerberos logins and latency (milliseconds)"})
        MutableRate loginFailure;
        @Metric(value={"GetGroups"})
        MutableRate getGroups;
        MutableQuantiles[] getGroupsQuantiles;
        @Metric(value={"Renewal failures since startup"})
        private MutableGaugeLong renewalFailuresTotal;
        @Metric(value={"Renewal failures since last successful login"})
        private MutableGaugeInt renewalFailures;

        UgiMetrics() {
        }

        static UgiMetrics create() {
            return DefaultMetricsSystem.instance().register(new UgiMetrics());
        }

        static void reattach() {
            metrics = UgiMetrics.create();
        }

        void addGetGroups(long latency) {
            this.getGroups.add(latency);
            if (this.getGroupsQuantiles != null) {
                for (MutableQuantiles q : this.getGroupsQuantiles) {
                    q.add(latency);
                }
            }
        }

        MutableGaugeInt getRenewalFailures() {
            return this.renewalFailures;
        }
    }
}

