/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSGroupAdminServer
implements RSGroupAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupAdminServer.class);
    public static final String KEEP_ONE_SERVER_IN_DEFAULT_ERROR_MESSAGE = "should keep at least one server in 'default' RSGroup.";
    private MasterServices master;
    private final RSGroupInfoManager rsGroupInfoManager;

    public RSGroupAdminServer(MasterServices master, RSGroupInfoManager rsGroupInfoManager) {
        this.master = master;
        this.rsGroupInfoManager = rsGroupInfoManager;
    }

    @Override
    public RSGroupInfo getRSGroupInfo(String groupName) throws IOException {
        return this.rsGroupInfoManager.getRSGroup(groupName);
    }

    @Override
    public RSGroupInfo getRSGroupInfoOfTable(TableName tableName) throws IOException {
        String groupName = this.rsGroupInfoManager.getRSGroupOfTable(tableName);
        return groupName == null ? null : this.rsGroupInfoManager.getRSGroup(groupName);
    }

    private void checkOnlineServersOnly(Set<Address> servers) throws ConstraintException {
        HashSet<Address> onlineServers = new HashSet<Address>();
        for (ServerName server : this.master.getServerManager().getOnlineServers().keySet()) {
            onlineServers.add(server.getAddress());
        }
        for (Address address : servers) {
            if (onlineServers.contains(address)) continue;
            throw new ConstraintException("Server " + address + " is not an online server in 'default' RSGroup.");
        }
    }

    private RSGroupInfo getAndCheckRSGroupInfo(String name) throws IOException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ConstraintException("RSGroup cannot be null.");
        }
        RSGroupInfo rsGroupInfo = this.getRSGroupInfo(name);
        if (rsGroupInfo == null) {
            throw new ConstraintException("RSGroup does not exist: " + name);
        }
        return rsGroupInfo;
    }

    private List<RegionInfo> getRegions(Address server) {
        LinkedList<RegionInfo> regions = new LinkedList<RegionInfo>();
        for (Map.Entry el : this.master.getAssignmentManager().getRegionStates().getRegionAssignments().entrySet()) {
            if (el.getValue() == null || !((ServerName)el.getValue()).getAddress().equals((Object)server)) continue;
            this.addRegion(regions, (RegionInfo)el.getKey());
        }
        for (RegionStateNode state : this.master.getAssignmentManager().getRegionsInTransition()) {
            if (state.getRegionLocation() == null || !state.getRegionLocation().getAddress().equals((Object)server)) continue;
            this.addRegion(regions, state.getRegionInfo());
        }
        return regions;
    }

    private void addRegion(LinkedList<RegionInfo> regions, RegionInfo hri) {
        if (hri.isMetaRegion()) {
            regions.addLast(hri);
        } else {
            regions.addFirst(hri);
        }
    }

    private void checkServersAndTables(Set<Address> servers, Set<TableName> tables, String targetGroupName) throws IOException {
        String tmpGroup;
        Address firstServer = servers.iterator().next();
        RSGroupInfo tmpSrcGrp = this.rsGroupInfoManager.getRSGroupOfServer(firstServer);
        if (tmpSrcGrp == null) {
            throw new ConstraintException("Server " + firstServer + " is either offline or it does not exist.");
        }
        RSGroupInfo srcGrp = new RSGroupInfo(tmpSrcGrp);
        this.checkOnlineServersOnly(servers);
        for (Address server : servers) {
            tmpGroup = this.rsGroupInfoManager.getRSGroupOfServer(server).getName();
            if (tmpGroup.equals(srcGrp.getName())) continue;
            throw new ConstraintException("Move server request should only come from one source RSGroup. Expecting only " + srcGrp.getName() + " but contains " + tmpGroup);
        }
        for (TableName table : tables) {
            tmpGroup = this.rsGroupInfoManager.getRSGroupOfTable(table);
            if (tmpGroup.equals(srcGrp.getName())) continue;
            throw new ConstraintException("Move table request should only come from one source RSGroup. Expecting only " + srcGrp.getName() + " but contains " + tmpGroup);
        }
        if (srcGrp.getServers().size() <= servers.size() && srcGrp.getTables().size() > tables.size()) {
            throw new ConstraintException("Cannot leave a RSGroup " + srcGrp.getName() + " that contains tables without servers to host them.");
        }
    }

    private void moveServerRegionsFromGroup(Set<Address> servers, String targetGroupName) throws IOException {
        boolean hasRegionsToMove;
        int retry = 0;
        RSGroupInfo targetGrp = this.getRSGroupInfo(targetGroupName);
        HashSet<Address> allSevers = new HashSet<Address>(servers);
        do {
            hasRegionsToMove = false;
            Iterator iter = allSevers.iterator();
            while (iter.hasNext()) {
                Address rs = (Address)iter.next();
                for (RegionInfo region : this.getRegions(rs)) {
                    if (targetGrp.containsTable(region.getTable())) continue;
                    LOG.info("Moving server region {}, which do not belong to RSGroup {}", (Object)region.getShortNameToLog(), (Object)targetGroupName);
                    try {
                        this.master.getAssignmentManager().move(region);
                    }
                    catch (IOException ioe) {
                        LOG.error("Move region {} from group failed, will retry, current retry time is {}", new Object[]{region.getShortNameToLog(), retry, ioe});
                    }
                    if (this.master.getAssignmentManager().getRegionStates().getRegionState(region).isFailedOpen()) continue;
                    hasRegionsToMove = true;
                }
                if (hasRegionsToMove) continue;
                LOG.info("Server {} has no more regions to move for RSGroup", (Object)rs.getHostname());
                iter.remove();
            }
            ++retry;
            try {
                this.rsGroupInfoManager.wait(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Sleep interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        } while (hasRegionsToMove && retry <= 50);
    }

    private void moveTableRegionsToGroup(Set<TableName> tables, String targetGroupName) throws IOException {
        boolean hasRegionsToMove;
        int retry = 0;
        RSGroupInfo targetGrp = this.getRSGroupInfo(targetGroupName);
        HashSet<TableName> allTables = new HashSet<TableName>(tables);
        do {
            hasRegionsToMove = false;
            Iterator iter = allTables.iterator();
            while (iter.hasNext()) {
                TableName table = (TableName)iter.next();
                if (this.master.getAssignmentManager().isTableDisabled(table)) {
                    LOG.debug("Skipping move regions because the table {} is disabled", (Object)table);
                    continue;
                }
                LOG.info("Moving region(s) for table {} to RSGroup {}", (Object)table, (Object)targetGroupName);
                for (RegionInfo region : this.master.getAssignmentManager().getRegionStates().getRegionsOfTable(table)) {
                    ServerName sn = this.master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(region);
                    if (targetGrp.containsServer(sn.getAddress())) continue;
                    LOG.info("Moving region {} to RSGroup {}", (Object)region.getShortNameToLog(), (Object)targetGroupName);
                    try {
                        this.master.getAssignmentManager().move(region);
                    }
                    catch (IOException ioe) {
                        LOG.error("Move region {} to group failed, will retry, current retry time is {}", new Object[]{region.getShortNameToLog(), retry, ioe});
                    }
                    hasRegionsToMove = true;
                }
                if (hasRegionsToMove) continue;
                LOG.info("Table {} has no more regions to move for RSGroup {}", (Object)table.getNameAsString(), (Object)targetGroupName);
                iter.remove();
            }
            ++retry;
            try {
                this.rsGroupInfoManager.wait(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Sleep interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        } while (hasRegionsToMove && retry <= 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="Ignoring complaint because don't know what it is complaining about")
    public void moveServers(Set<Address> servers, String targetGroupName) throws IOException {
        if (servers == null) {
            throw new ConstraintException("The list of servers to move cannot be null.");
        }
        if (servers.isEmpty()) {
            return;
        }
        this.getAndCheckRSGroupInfo(targetGroupName);
        RSGroupInfoManager rSGroupInfoManager = this.rsGroupInfoManager;
        synchronized (rSGroupInfoManager) {
            Address firstServer = servers.iterator().next();
            RSGroupInfo srcGrp = this.rsGroupInfoManager.getRSGroupOfServer(firstServer);
            if (srcGrp == null) {
                throw new ConstraintException("Server " + firstServer + " is either offline or it does not exist.");
            }
            if ("default".equals(srcGrp.getName())) {
                if (srcGrp.getServers().size() <= servers.size()) {
                    throw new ConstraintException(KEEP_ONE_SERVER_IN_DEFAULT_ERROR_MESSAGE);
                }
                this.checkOnlineServersOnly(servers);
            }
            for (Address server : servers) {
                String tmpGroup = this.rsGroupInfoManager.getRSGroupOfServer(server).getName();
                if (tmpGroup.equals(srcGrp.getName())) continue;
                throw new ConstraintException("Move server request should only come from one source RSGroup. Expecting only " + srcGrp.getName() + " but contains " + tmpGroup);
            }
            if (srcGrp.getServers().size() <= servers.size() && srcGrp.getTables().size() > 0) {
                throw new ConstraintException("Cannot leave a RSGroup " + srcGrp.getName() + " that contains tables without servers to host them.");
            }
            Set<Address> movedServers = this.rsGroupInfoManager.moveServers(servers, srcGrp.getName(), targetGroupName);
            this.moveServerRegionsFromGroup(movedServers, targetGroupName);
            LOG.info("Move servers done: {} => {}", (Object)srcGrp.getName(), (Object)targetGroupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTables(Set<TableName> tables, String targetGroup) throws IOException {
        if (tables == null) {
            throw new ConstraintException("The list of tables cannot be null.");
        }
        if (tables.size() < 1) {
            LOG.debug("moveTables() passed an empty set. Ignoring.");
            return;
        }
        RSGroupInfoManager rSGroupInfoManager = this.rsGroupInfoManager;
        synchronized (rSGroupInfoManager) {
            if (targetGroup != null) {
                RSGroupInfo destGroup = this.rsGroupInfoManager.getRSGroup(targetGroup);
                if (destGroup == null) {
                    throw new ConstraintException("Target " + targetGroup + " RSGroup does not exist.");
                }
                if (destGroup.getServers().size() < 1) {
                    throw new ConstraintException("Target RSGroup must have at least one server.");
                }
            }
            this.rsGroupInfoManager.moveTables(tables, targetGroup);
            if (targetGroup != null) {
                this.moveTableRegionsToGroup(tables, targetGroup);
            }
        }
    }

    @Override
    public void addRSGroup(String name) throws IOException {
        this.rsGroupInfoManager.addRSGroup(new RSGroupInfo(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRSGroup(String name) throws IOException {
        RSGroupInfoManager rSGroupInfoManager = this.rsGroupInfoManager;
        synchronized (rSGroupInfoManager) {
            RSGroupInfo rsGroupInfo = this.rsGroupInfoManager.getRSGroup(name);
            if (rsGroupInfo == null) {
                throw new ConstraintException("RSGroup " + name + " does not exist");
            }
            int tableCount = rsGroupInfo.getTables().size();
            if (tableCount > 0) {
                throw new ConstraintException("RSGroup " + name + " has " + tableCount + " tables; you must remove these tables from the rsgroup before the rsgroup can be removed.");
            }
            int serverCount = rsGroupInfo.getServers().size();
            if (serverCount > 0) {
                throw new ConstraintException("RSGroup " + name + " has " + serverCount + " servers; you must remove these servers from the RSGroup beforethe RSGroup can be removed.");
            }
            for (NamespaceDescriptor ns : this.master.getClusterSchema().getNamespaces()) {
                String nsGroup = ns.getConfigurationValue("hbase.rsgroup.name");
                if (nsGroup == null || !nsGroup.equals(name)) continue;
                throw new ConstraintException("RSGroup " + name + " is referenced by namespace: " + ns.getName());
            }
            this.rsGroupInfoManager.removeRSGroup(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean balanceRSGroup(String groupName) throws IOException {
        LoadBalancer balancer;
        ServerManager serverManager = this.master.getServerManager();
        LoadBalancer loadBalancer = balancer = this.master.getLoadBalancer();
        synchronized (loadBalancer) {
            boolean balancerRan;
            if (!((HMaster)this.master).isBalancerOn()) {
                return false;
            }
            if (this.getRSGroupInfo(groupName) == null) {
                throw new ConstraintException("RSGroup does not exist: " + groupName);
            }
            Map<String, RegionState> groupRIT = this.rsGroupGetRegionsInTransition(groupName);
            if (groupRIT.size() > 0) {
                LOG.debug("Not running balancer because {} region(s) in transition: {}", (Object)groupRIT.size(), (Object)StringUtils.abbreviate((String)this.master.getAssignmentManager().getRegionStates().getRegionsInTransition().toString(), (int)256));
                return false;
            }
            if (serverManager.areDeadServersInProgress()) {
                LOG.debug("Not running balancer because processing dead regionserver(s): {}", (Object)serverManager.getDeadServers());
                return false;
            }
            Map<TableName, Map<ServerName, List<RegionInfo>>> assignmentsByTable = this.getRSGroupAssignmentsByTable(this.master.getTableStateManager(), groupName);
            List plans = balancer.balanceCluster(assignmentsByTable);
            boolean bl = balancerRan = !plans.isEmpty();
            if (balancerRan) {
                LOG.info("RSGroup balance {} starting with plan count: {}", (Object)groupName, (Object)plans.size());
                this.master.executeRegionPlansWithThrottling(plans);
                LOG.info("RSGroup balance " + groupName + " completed");
            }
            return balancerRan;
        }
    }

    @Override
    public List<RSGroupInfo> listRSGroups() throws IOException {
        return this.rsGroupInfoManager.listRSGroups();
    }

    @Override
    public RSGroupInfo getRSGroupOfServer(Address hostPort) throws IOException {
        return this.rsGroupInfoManager.getRSGroupOfServer(hostPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveServersAndTables(Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
        if (servers == null || servers.isEmpty()) {
            throw new ConstraintException("The list of servers to move cannot be null or empty.");
        }
        if (tables == null || tables.isEmpty()) {
            throw new ConstraintException("The list of tables to move cannot be null or empty.");
        }
        this.getAndCheckRSGroupInfo(targetGroup);
        RSGroupInfoManager rSGroupInfoManager = this.rsGroupInfoManager;
        synchronized (rSGroupInfoManager) {
            this.checkServersAndTables(servers, tables, targetGroup);
            String srcGroup = this.getRSGroupOfServer(servers.iterator().next()).getName();
            this.rsGroupInfoManager.moveServersAndTables(servers, tables, srcGroup, targetGroup);
            this.moveServerRegionsFromGroup(servers, targetGroup);
            this.moveTableRegionsToGroup(tables, targetGroup);
        }
        LOG.info("Move servers and tables done. Severs: {}, Tables: {} => {}", new Object[]{servers, tables, targetGroup});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServers(Set<Address> servers) throws IOException {
        if (servers == null || servers.isEmpty()) {
            throw new ConstraintException("The set of servers to remove cannot be null or empty.");
        }
        RSGroupInfoManager rSGroupInfoManager = this.rsGroupInfoManager;
        synchronized (rSGroupInfoManager) {
            this.checkForDeadOrOnlineServers(servers);
            this.rsGroupInfoManager.removeServers(servers);
            LOG.info("Remove decommissioned servers {} from RSGroup done", servers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameRSGroup(String oldName, String newName) throws IOException {
        RSGroupInfoManager rSGroupInfoManager = this.rsGroupInfoManager;
        synchronized (rSGroupInfoManager) {
            this.rsGroupInfoManager.renameRSGroup(oldName, newName);
        }
    }

    private Map<String, RegionState> rsGroupGetRegionsInTransition(String groupName) throws IOException {
        TreeMap rit = Maps.newTreeMap();
        AssignmentManager am = this.master.getAssignmentManager();
        for (TableName tableName : this.getRSGroupInfo(groupName).getTables()) {
            for (RegionInfo regionInfo : am.getRegionStates().getRegionsOfTable(tableName)) {
                RegionState state = am.getRegionStates().getRegionTransitionState(regionInfo);
                if (state == null) continue;
                rit.put(regionInfo.getEncodedName(), state);
            }
        }
        return rit;
    }

    @VisibleForTesting
    Map<TableName, Map<ServerName, List<RegionInfo>>> getRSGroupAssignmentsByTable(TableStateManager tableStateManager, String groupName) throws IOException {
        HashMap result = Maps.newHashMap();
        RSGroupInfo rsGroupInfo = this.getRSGroupInfo(groupName);
        HashMap assignments = Maps.newHashMap();
        for (Map.Entry entry : this.master.getAssignmentManager().getRegionStates().getRegionAssignments().entrySet()) {
            TableName currTable = ((RegionInfo)entry.getKey()).getTable();
            ServerName currServer = (ServerName)entry.getValue();
            RegionInfo currRegion = (RegionInfo)entry.getKey();
            if (!rsGroupInfo.getTables().contains(currTable) || tableStateManager.isTableState(currTable, new TableState.State[]{TableState.State.DISABLED, TableState.State.DISABLING}) || currRegion.isSplitParent()) continue;
            assignments.putIfAbsent(currTable, new HashMap());
            ((Map)assignments.get(currTable)).putIfAbsent(currServer, new ArrayList());
            ((List)((Map)assignments.get(currTable)).get(currServer)).add(currRegion);
        }
        HashMap serverMap = Maps.newHashMap();
        for (ServerName serverName : this.master.getServerManager().getOnlineServers().keySet()) {
            if (!rsGroupInfo.getServers().contains(serverName.getAddress())) continue;
            serverMap.put(serverName, Collections.emptyList());
        }
        for (TableName tableName : rsGroupInfo.getTables()) {
            if (!assignments.containsKey(tableName)) continue;
            result.put(tableName, new HashMap());
            ((Map)result.get(tableName)).putAll(serverMap);
            ((Map)result.get(tableName)).putAll((Map)assignments.get(tableName));
            LOG.debug("Adding assignments for {}: {}", (Object)tableName, assignments.get(tableName));
        }
        return result;
    }

    private void checkForDeadOrOnlineServers(Set<Address> servers) throws ConstraintException {
        HashSet<Address> onlineServers = new HashSet<Address>();
        List drainingServers = this.master.getServerManager().getDrainingServersList();
        for (ServerName server : this.master.getServerManager().getOnlineServers().keySet()) {
            if (drainingServers.contains(server)) continue;
            onlineServers.add(server.getAddress());
        }
        HashSet<Address> deadServers = new HashSet<Address>();
        for (ServerName server : this.master.getServerManager().getDeadServers().copyServerNames()) {
            deadServers.add(server.getAddress());
        }
        for (Address address : servers) {
            if (onlineServers.contains(address)) {
                throw new ConstraintException("Server " + address + " is an online server, not allowed to remove.");
            }
            if (!deadServers.contains(address)) continue;
            throw new ConstraintException("Server " + address + " is on the dead servers list, Maybe it will come back again, not allowed to remove.");
        }
    }
}

