/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface Table
extends Closeable {
    public TableName getName();

    public Configuration getConfiguration();

    @Deprecated
    default public HTableDescriptor getTableDescriptor() throws IOException {
        TableDescriptor descriptor = this.getDescriptor();
        if (descriptor instanceof HTableDescriptor) {
            return (HTableDescriptor)descriptor;
        }
        return new HTableDescriptor(descriptor);
    }

    public TableDescriptor getDescriptor() throws IOException;

    public RegionLocator getRegionLocator() throws IOException;

    default public boolean exists(Get get) throws IOException {
        return this.exists(Collections.singletonList(get))[0];
    }

    default public boolean[] exists(List<Get> gets) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public boolean[] existsAll(List<Get> gets) throws IOException {
        return this.exists(gets);
    }

    default public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public Result get(Get get) throws IOException {
        return this.get(Collections.singletonList(get))[0];
    }

    default public Result[] get(List<Get> gets) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public ResultScanner getScanner(Scan scan) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public ResultScanner getScanner(byte[] family) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public void put(Put put) throws IOException {
        this.put(Collections.singletonList(put));
    }

    default public void put(List<Put> puts) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.checkAndPut(row, family, qualifier, CompareOperator.EQUAL, value, put);
    }

    @Deprecated
    default public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        RowMutations mutations = new RowMutations(put.getRow(), 1);
        mutations.add(put);
        return this.checkAndMutate(row, family, qualifier, compareOp, value, mutations);
    }

    @Deprecated
    default public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put) throws IOException {
        RowMutations mutations = new RowMutations(put.getRow(), 1);
        mutations.add(put);
        return this.checkAndMutate(row, family, qualifier, op, value, mutations);
    }

    default public void delete(Delete delete) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public void delete(List<Delete> deletes) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndDelete(row, family, qualifier, CompareOperator.EQUAL, value, delete);
    }

    @Deprecated
    default public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        RowMutations mutations = new RowMutations(delete.getRow(), 1);
        mutations.add(delete);
        return this.checkAndMutate(row, family, qualifier, compareOp, value, mutations);
    }

    @Deprecated
    default public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
        RowMutations mutations = new RowMutations(delete.getRow(), 1);
        mutations.add(delete);
        return this.checkAndMutate(row, family, qualifier, op, value, mutations);
    }

    default public CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        throw new NotImplementedException("Add an implementation!");
    }

    default public CheckAndMutateWithFilterBuilder checkAndMutate(byte[] row, Filter filter) {
        throw new NotImplementedException("Add an implementation!");
    }

    default public void mutateRow(RowMutations rm) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public Result append(Append append) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public Result increment(Increment increment) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        Increment increment = new Increment(row).addColumn(family, qualifier, amount);
        Cell cell = this.increment(increment).getColumnLatestCell(family, qualifier);
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    default public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        Increment increment = new Increment(row).addColumn(family, qualifier, amount).setDurability(durability);
        Cell cell = this.increment(increment).getColumnLatestCell(family, qualifier);
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    @Override
    default public void close() throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public CoprocessorRpcChannel coprocessorService(byte[] row) {
        throw new NotImplementedException("Add an implementation!");
    }

    default public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        throw new NotImplementedException("Add an implementation!");
    }

    default public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new NotImplementedException("Add an implementation!");
    }

    default public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        throw new NotImplementedException("Add an implementation!");
    }

    default public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutation) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations mutation) throws IOException {
        throw new NotImplementedException("Add an implementation!");
    }

    default public long getRpcTimeout(TimeUnit unit) {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public int getRpcTimeout() {
        return (int)this.getRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Deprecated
    default public void setRpcTimeout(int rpcTimeout) {
        this.setReadRpcTimeout(rpcTimeout);
        this.setWriteRpcTimeout(rpcTimeout);
    }

    default public long getReadRpcTimeout(TimeUnit unit) {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public int getReadRpcTimeout() {
        return (int)this.getReadRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Deprecated
    default public void setReadRpcTimeout(int readRpcTimeout) {
        throw new NotImplementedException("Add an implementation!");
    }

    default public long getWriteRpcTimeout(TimeUnit unit) {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public int getWriteRpcTimeout() {
        return (int)this.getWriteRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Deprecated
    default public void setWriteRpcTimeout(int writeRpcTimeout) {
        throw new NotImplementedException("Add an implementation!");
    }

    default public long getOperationTimeout(TimeUnit unit) {
        throw new NotImplementedException("Add an implementation!");
    }

    @Deprecated
    default public int getOperationTimeout() {
        return (int)this.getOperationTimeout(TimeUnit.MILLISECONDS);
    }

    @Deprecated
    default public void setOperationTimeout(int operationTimeout) {
        throw new NotImplementedException("Add an implementation!");
    }

    public static interface CheckAndMutateWithFilterBuilder {
        public CheckAndMutateWithFilterBuilder timeRange(TimeRange var1);

        public boolean thenPut(Put var1) throws IOException;

        public boolean thenDelete(Delete var1) throws IOException;

        public boolean thenMutate(RowMutations var1) throws IOException;
    }

    public static interface CheckAndMutateBuilder {
        public CheckAndMutateBuilder qualifier(byte[] var1);

        public CheckAndMutateBuilder timeRange(TimeRange var1);

        public CheckAndMutateBuilder ifNotExists();

        default public CheckAndMutateBuilder ifEquals(byte[] value) {
            return this.ifMatches(CompareOperator.EQUAL, value);
        }

        public CheckAndMutateBuilder ifMatches(CompareOperator var1, byte[] var2);

        public boolean thenPut(Put var1) throws IOException;

        public boolean thenDelete(Delete var1) throws IOException;

        public boolean thenMutate(RowMutations var1) throws IOException;
    }
}

