/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.TestWALProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStressWALProcedureStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStressWALProcedureStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWALProcedureStore.class);
    private static final int PROCEDURE_STORE_SLOTS = 8;
    private WALProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    private void setupConfiguration(Configuration conf) {
        conf.setBoolean("hbase.procedure.store.wal.use.hsync", false);
        conf.setInt("hbase.procedure.store.wal.periodic.roll.msec", 5000);
        conf.setInt("hbase.procedure.store.wal.roll.threshold", 131072);
    }

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.setupConfiguration(this.htu.getConfiguration());
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.logDir);
        this.procStore.start(8);
        this.procStore.recoverLease();
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.procStore.load((ProcedureStore.ProcedureLoader)loader);
        Assert.assertEquals((long)0L, (long)loader.getMaxProcId());
        Assert.assertEquals((long)0L, (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @After
    public void tearDown() throws IOException {
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test
    public void testInsertUpdateDelete() throws Exception {
        int i;
        long LAST_PROC_ID = 19999L;
        Thread[] thread = new Thread[8];
        final AtomicLong procCounter = new AtomicLong(Math.round(Math.random() * 100.0));
        for (i = 0; i < thread.length; ++i) {
            thread[i] = new Thread(){

                @Override
                public void run() {
                    ProcedureTestingUtility.TestProcedure proc;
                    Random rand = new Random();
                    do {
                        long procId = procCounter.addAndGet(1 + rand.nextInt(3));
                        proc = new ProcedureTestingUtility.TestProcedure(procId);
                        TestStressWALProcedureStore.this.procStore.insert((Procedure)proc, null);
                        int nupdates = rand.nextInt(10);
                        for (int i = 0; i <= nupdates; ++i) {
                            try {
                                Thread.sleep(0L, rand.nextInt(15));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            TestStressWALProcedureStore.this.procStore.update((Procedure)proc);
                        }
                        TestStressWALProcedureStore.this.procStore.delete(proc.getProcId());
                    } while (proc.getProcId() < 19999L);
                }
            };
            thread[i].start();
        }
        for (i = 0; i < thread.length; ++i) {
            thread[i].join();
        }
        this.procStore.getStoreTracker().dump();
        Assert.assertTrue((procCounter.get() >= 19999L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.procStore.getStoreTracker().isEmpty());
        Assert.assertEquals((long)1L, (long)this.procStore.getActiveLogs().size());
    }

    @Ignore
    @Test
    public void testEntrySizeLimit() throws Exception {
        int NITEMS = 20;
        for (int i = 1; i <= 20; ++i) {
            byte[] data = new byte[256 << i];
            LOG.info(String.format("Writing %s", StringUtils.humanSize((double)data.length)));
            ProcedureTestingUtility.TestProcedure proc = new ProcedureTestingUtility.TestProcedure(i, 0L, data);
            this.procStore.insert((Procedure)proc, null);
        }
        ProcedureTestingUtility.storeRestartAndAssert((ProcedureStore)this.procStore, 20L, 20L, 0, 0);
    }
}

