#
# Autogenerated by Thrift Compiler (0.9.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface:
  def exists(self, table, get):
    """
    Test for the existence of columns in the table, as specified in the TGet.

    @return true if the specified TGet matches one or more keys, false if not

    Parameters:
     - table: the table to check on
     - get: the TGet to check for
    """
    pass

  def get(self, table, get):
    """
    Method for getting data from a row.

    If the row cannot be found an empty Result is returned.
    This can be checked by the empty field of the TResult

    @return the result

    Parameters:
     - table: the table to get from
     - get: the TGet to fetch
    """
    pass

  def getMultiple(self, table, gets):
    """
    Method for getting multiple rows.

    If a row cannot be found there will be a null
    value in the result list for that TGet at the
    same position.

    So the Results are in the same order as the TGets.

    Parameters:
     - table: the table to get from
     - gets: a list of TGets to fetch, the Result list
    will have the Results at corresponding positions
    or null if there was an error
    """
    pass

  def put(self, table, put):
    """
    Commit a TPut to a table.

    Parameters:
     - table: the table to put data in
     - put: the TPut to put
    """
    pass

  def checkAndPut(self, table, row, family, qualifier, value, put):
    """
    Atomically checks if a row/family/qualifier value matches the expected
    value. If it does, it adds the TPut.

    @return true if the new put was executed, false otherwise

    Parameters:
     - table: to check in and put to
     - row: row to check
     - family: column family to check
     - qualifier: column qualifier to check
     - value: the expected value, if not provided the
    check is for the non-existence of the
    column in question
     - put: the TPut to put if the check succeeds
    """
    pass

  def putMultiple(self, table, puts):
    """
    Commit a List of Puts to the table.

    Parameters:
     - table: the table to put data in
     - puts: a list of TPuts to commit
    """
    pass

  def deleteSingle(self, table, deleteSingle):
    """
    Deletes as specified by the TDelete.

    Note: "delete" is a reserved keyword and cannot be used in Thrift
    thus the inconsistent naming scheme from the other functions.

    Parameters:
     - table: the table to delete from
     - deleteSingle: the TDelete to delete
    """
    pass

  def deleteMultiple(self, table, deletes):
    """
    Bulk commit a List of TDeletes to the table.

    Throws a TIOError if any of the deletes fail.

    Always returns an empty list for backwards compatibility.

    Parameters:
     - table: the table to delete from
     - deletes: list of TDeletes to delete
    """
    pass

  def checkAndDelete(self, table, row, family, qualifier, value, deleteSingle):
    """
    Atomically checks if a row/family/qualifier value matches the expected
    value. If it does, it adds the delete.

    @return true if the new delete was executed, false otherwise

    Parameters:
     - table: to check in and delete from
     - row: row to check
     - family: column family to check
     - qualifier: column qualifier to check
     - value: the expected value, if not provided the
    check is for the non-existence of the
    column in question
     - deleteSingle: the TDelete to execute if the check succeeds
    """
    pass

  def increment(self, table, increment):
    """
    Parameters:
     - table: the table to increment the value on
     - increment: the TIncrement to increment
    """
    pass

  def openScanner(self, table, scan):
    """
    Get a Scanner for the provided TScan object.

    @return Scanner Id to be used with other scanner procedures

    Parameters:
     - table: the table to get the Scanner for
     - scan: the scan object to get a Scanner for
    """
    pass

  def getScannerRows(self, scannerId, numRows):
    """
    Grabs multiple rows from a Scanner.

    @return Between zero and numRows TResults

    Parameters:
     - scannerId: the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
     - numRows: number of rows to return
    """
    pass

  def closeScanner(self, scannerId):
    """
    Closes the scanner. Should be called if you need to close
    the Scanner before all results are read.

    Exhausted scanners are closed automatically.

    Parameters:
     - scannerId: the Id of the Scanner to close *
    """
    pass


class Client(Iface):
  def __init__(self, iprot, oprot=None):
    self._iprot = self._oprot = iprot
    if oprot is not None:
      self._oprot = oprot
    self._seqid = 0

  def exists(self, table, get):
    """
    Test for the existence of columns in the table, as specified in the TGet.

    @return true if the specified TGet matches one or more keys, false if not

    Parameters:
     - table: the table to check on
     - get: the TGet to check for
    """
    self.send_exists(table, get)
    return self.recv_exists()

  def send_exists(self, table, get):
    self._oprot.writeMessageBegin('exists', TMessageType.CALL, self._seqid)
    args = exists_args()
    args.table = table
    args.get = get
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_exists(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = exists_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "exists failed: unknown result");

  def get(self, table, get):
    """
    Method for getting data from a row.

    If the row cannot be found an empty Result is returned.
    This can be checked by the empty field of the TResult

    @return the result

    Parameters:
     - table: the table to get from
     - get: the TGet to fetch
    """
    self.send_get(table, get)
    return self.recv_get()

  def send_get(self, table, get):
    self._oprot.writeMessageBegin('get', TMessageType.CALL, self._seqid)
    args = get_args()
    args.table = table
    args.get = get
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get failed: unknown result");

  def getMultiple(self, table, gets):
    """
    Method for getting multiple rows.

    If a row cannot be found there will be a null
    value in the result list for that TGet at the
    same position.

    So the Results are in the same order as the TGets.

    Parameters:
     - table: the table to get from
     - gets: a list of TGets to fetch, the Result list
    will have the Results at corresponding positions
    or null if there was an error
    """
    self.send_getMultiple(table, gets)
    return self.recv_getMultiple()

  def send_getMultiple(self, table, gets):
    self._oprot.writeMessageBegin('getMultiple', TMessageType.CALL, self._seqid)
    args = getMultiple_args()
    args.table = table
    args.gets = gets
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getMultiple(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getMultiple_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getMultiple failed: unknown result");

  def put(self, table, put):
    """
    Commit a TPut to a table.

    Parameters:
     - table: the table to put data in
     - put: the TPut to put
    """
    self.send_put(table, put)
    self.recv_put()

  def send_put(self, table, put):
    self._oprot.writeMessageBegin('put', TMessageType.CALL, self._seqid)
    args = put_args()
    args.table = table
    args.put = put
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_put(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = put_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def checkAndPut(self, table, row, family, qualifier, value, put):
    """
    Atomically checks if a row/family/qualifier value matches the expected
    value. If it does, it adds the TPut.

    @return true if the new put was executed, false otherwise

    Parameters:
     - table: to check in and put to
     - row: row to check
     - family: column family to check
     - qualifier: column qualifier to check
     - value: the expected value, if not provided the
    check is for the non-existence of the
    column in question
     - put: the TPut to put if the check succeeds
    """
    self.send_checkAndPut(table, row, family, qualifier, value, put)
    return self.recv_checkAndPut()

  def send_checkAndPut(self, table, row, family, qualifier, value, put):
    self._oprot.writeMessageBegin('checkAndPut', TMessageType.CALL, self._seqid)
    args = checkAndPut_args()
    args.table = table
    args.row = row
    args.family = family
    args.qualifier = qualifier
    args.value = value
    args.put = put
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_checkAndPut(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = checkAndPut_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "checkAndPut failed: unknown result");

  def putMultiple(self, table, puts):
    """
    Commit a List of Puts to the table.

    Parameters:
     - table: the table to put data in
     - puts: a list of TPuts to commit
    """
    self.send_putMultiple(table, puts)
    self.recv_putMultiple()

  def send_putMultiple(self, table, puts):
    self._oprot.writeMessageBegin('putMultiple', TMessageType.CALL, self._seqid)
    args = putMultiple_args()
    args.table = table
    args.puts = puts
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_putMultiple(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = putMultiple_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteSingle(self, table, deleteSingle):
    """
    Deletes as specified by the TDelete.

    Note: "delete" is a reserved keyword and cannot be used in Thrift
    thus the inconsistent naming scheme from the other functions.

    Parameters:
     - table: the table to delete from
     - deleteSingle: the TDelete to delete
    """
    self.send_deleteSingle(table, deleteSingle)
    self.recv_deleteSingle()

  def send_deleteSingle(self, table, deleteSingle):
    self._oprot.writeMessageBegin('deleteSingle', TMessageType.CALL, self._seqid)
    args = deleteSingle_args()
    args.table = table
    args.deleteSingle = deleteSingle
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteSingle(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteSingle_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteMultiple(self, table, deletes):
    """
    Bulk commit a List of TDeletes to the table.

    Throws a TIOError if any of the deletes fail.

    Always returns an empty list for backwards compatibility.

    Parameters:
     - table: the table to delete from
     - deletes: list of TDeletes to delete
    """
    self.send_deleteMultiple(table, deletes)
    return self.recv_deleteMultiple()

  def send_deleteMultiple(self, table, deletes):
    self._oprot.writeMessageBegin('deleteMultiple', TMessageType.CALL, self._seqid)
    args = deleteMultiple_args()
    args.table = table
    args.deletes = deletes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteMultiple(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteMultiple_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "deleteMultiple failed: unknown result");

  def checkAndDelete(self, table, row, family, qualifier, value, deleteSingle):
    """
    Atomically checks if a row/family/qualifier value matches the expected
    value. If it does, it adds the delete.

    @return true if the new delete was executed, false otherwise

    Parameters:
     - table: to check in and delete from
     - row: row to check
     - family: column family to check
     - qualifier: column qualifier to check
     - value: the expected value, if not provided the
    check is for the non-existence of the
    column in question
     - deleteSingle: the TDelete to execute if the check succeeds
    """
    self.send_checkAndDelete(table, row, family, qualifier, value, deleteSingle)
    return self.recv_checkAndDelete()

  def send_checkAndDelete(self, table, row, family, qualifier, value, deleteSingle):
    self._oprot.writeMessageBegin('checkAndDelete', TMessageType.CALL, self._seqid)
    args = checkAndDelete_args()
    args.table = table
    args.row = row
    args.family = family
    args.qualifier = qualifier
    args.value = value
    args.deleteSingle = deleteSingle
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_checkAndDelete(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = checkAndDelete_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "checkAndDelete failed: unknown result");

  def increment(self, table, increment):
    """
    Parameters:
     - table: the table to increment the value on
     - increment: the TIncrement to increment
    """
    self.send_increment(table, increment)
    return self.recv_increment()

  def send_increment(self, table, increment):
    self._oprot.writeMessageBegin('increment', TMessageType.CALL, self._seqid)
    args = increment_args()
    args.table = table
    args.increment = increment
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_increment(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = increment_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "increment failed: unknown result");

  def openScanner(self, table, scan):
    """
    Get a Scanner for the provided TScan object.

    @return Scanner Id to be used with other scanner procedures

    Parameters:
     - table: the table to get the Scanner for
     - scan: the scan object to get a Scanner for
    """
    self.send_openScanner(table, scan)
    return self.recv_openScanner()

  def send_openScanner(self, table, scan):
    self._oprot.writeMessageBegin('openScanner', TMessageType.CALL, self._seqid)
    args = openScanner_args()
    args.table = table
    args.scan = scan
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_openScanner(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = openScanner_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "openScanner failed: unknown result");

  def getScannerRows(self, scannerId, numRows):
    """
    Grabs multiple rows from a Scanner.

    @return Between zero and numRows TResults

    Parameters:
     - scannerId: the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
     - numRows: number of rows to return
    """
    self.send_getScannerRows(scannerId, numRows)
    return self.recv_getScannerRows()

  def send_getScannerRows(self, scannerId, numRows):
    self._oprot.writeMessageBegin('getScannerRows', TMessageType.CALL, self._seqid)
    args = getScannerRows_args()
    args.scannerId = scannerId
    args.numRows = numRows
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getScannerRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getScannerRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getScannerRows failed: unknown result");

  def closeScanner(self, scannerId):
    """
    Closes the scanner. Should be called if you need to close
    the Scanner before all results are read.

    Exhausted scanners are closed automatically.

    Parameters:
     - scannerId: the Id of the Scanner to close *
    """
    self.send_closeScanner(scannerId)
    self.recv_closeScanner()

  def send_closeScanner(self, scannerId):
    self._oprot.writeMessageBegin('closeScanner', TMessageType.CALL, self._seqid)
    args = closeScanner_args()
    args.scannerId = scannerId
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_closeScanner(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = closeScanner_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return


class Processor(Iface, TProcessor):
  def __init__(self, handler):
    self._handler = handler
    self._processMap = {}
    self._processMap["exists"] = Processor.process_exists
    self._processMap["get"] = Processor.process_get
    self._processMap["getMultiple"] = Processor.process_getMultiple
    self._processMap["put"] = Processor.process_put
    self._processMap["checkAndPut"] = Processor.process_checkAndPut
    self._processMap["putMultiple"] = Processor.process_putMultiple
    self._processMap["deleteSingle"] = Processor.process_deleteSingle
    self._processMap["deleteMultiple"] = Processor.process_deleteMultiple
    self._processMap["checkAndDelete"] = Processor.process_checkAndDelete
    self._processMap["increment"] = Processor.process_increment
    self._processMap["openScanner"] = Processor.process_openScanner
    self._processMap["getScannerRows"] = Processor.process_getScannerRows
    self._processMap["closeScanner"] = Processor.process_closeScanner

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_exists(self, seqid, iprot, oprot):
    args = exists_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = exists_result()
    try:
      result.success = self._handler.exists(args.table, args.get)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("exists", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get(self, seqid, iprot, oprot):
    args = get_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_result()
    try:
      result.success = self._handler.get(args.table, args.get)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("get", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getMultiple(self, seqid, iprot, oprot):
    args = getMultiple_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getMultiple_result()
    try:
      result.success = self._handler.getMultiple(args.table, args.gets)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("getMultiple", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_put(self, seqid, iprot, oprot):
    args = put_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = put_result()
    try:
      self._handler.put(args.table, args.put)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("put", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_checkAndPut(self, seqid, iprot, oprot):
    args = checkAndPut_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = checkAndPut_result()
    try:
      result.success = self._handler.checkAndPut(args.table, args.row, args.family, args.qualifier, args.value, args.put)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("checkAndPut", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_putMultiple(self, seqid, iprot, oprot):
    args = putMultiple_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = putMultiple_result()
    try:
      self._handler.putMultiple(args.table, args.puts)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("putMultiple", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteSingle(self, seqid, iprot, oprot):
    args = deleteSingle_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteSingle_result()
    try:
      self._handler.deleteSingle(args.table, args.deleteSingle)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteSingle", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteMultiple(self, seqid, iprot, oprot):
    args = deleteMultiple_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteMultiple_result()
    try:
      result.success = self._handler.deleteMultiple(args.table, args.deletes)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteMultiple", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_checkAndDelete(self, seqid, iprot, oprot):
    args = checkAndDelete_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = checkAndDelete_result()
    try:
      result.success = self._handler.checkAndDelete(args.table, args.row, args.family, args.qualifier, args.value, args.deleteSingle)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("checkAndDelete", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_increment(self, seqid, iprot, oprot):
    args = increment_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = increment_result()
    try:
      result.success = self._handler.increment(args.table, args.increment)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("increment", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_openScanner(self, seqid, iprot, oprot):
    args = openScanner_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = openScanner_result()
    try:
      result.success = self._handler.openScanner(args.table, args.scan)
    except TIOError as io:
      result.io = io
    oprot.writeMessageBegin("openScanner", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getScannerRows(self, seqid, iprot, oprot):
    args = getScannerRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getScannerRows_result()
    try:
      result.success = self._handler.getScannerRows(args.scannerId, args.numRows)
    except TIOError as io:
      result.io = io
    except TIllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("getScannerRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_closeScanner(self, seqid, iprot, oprot):
    args = closeScanner_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = closeScanner_result()
    try:
      self._handler.closeScanner(args.scannerId)
    except TIOError as io:
      result.io = io
    except TIllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("closeScanner", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class exists_args:
  """
  Attributes:
   - table: the table to check on
   - get: the TGet to check for
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.STRUCT, 'get', (TGet, TGet.thrift_spec), None, ), # 2
  )

  def __init__(self, table=None, get=None,):
    self.table = table
    self.get = get

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.get = TGet()
          self.get.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('exists_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.get is not None:
      oprot.writeFieldBegin('get', TType.STRUCT, 2)
      self.get.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.get is None:
      raise TProtocol.TProtocolException(message='Required field get is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class exists_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('exists_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_args:
  """
  Attributes:
   - table: the table to get from
   - get: the TGet to fetch
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.STRUCT, 'get', (TGet, TGet.thrift_spec), None, ), # 2
  )

  def __init__(self, table=None, get=None,):
    self.table = table
    self.get = get

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.get = TGet()
          self.get.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.get is not None:
      oprot.writeFieldBegin('get', TType.STRUCT, 2)
      self.get.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.get is None:
      raise TProtocol.TProtocolException(message='Required field get is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (TResult, TResult.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = TResult()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getMultiple_args:
  """
  Attributes:
   - table: the table to get from
   - gets: a list of TGets to fetch, the Result list
  will have the Results at corresponding positions
  or null if there was an error
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.LIST, 'gets', (TType.STRUCT,(TGet, TGet.thrift_spec)), None, ), # 2
  )

  def __init__(self, table=None, gets=None,):
    self.table = table
    self.gets = gets

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.gets = []
          (_etype45, _size42) = iprot.readListBegin()
          for _i46 in xrange(_size42):
            _elem47 = TGet()
            _elem47.read(iprot)
            self.gets.append(_elem47)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getMultiple_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.gets is not None:
      oprot.writeFieldBegin('gets', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.gets))
      for iter48 in self.gets:
        iter48.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.gets is None:
      raise TProtocol.TProtocolException(message='Required field gets is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getMultiple_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TResult, TResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype52, _size49) = iprot.readListBegin()
          for _i53 in xrange(_size49):
            _elem54 = TResult()
            _elem54.read(iprot)
            self.success.append(_elem54)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getMultiple_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter55 in self.success:
        iter55.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class put_args:
  """
  Attributes:
   - table: the table to put data in
   - put: the TPut to put
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.STRUCT, 'put', (TPut, TPut.thrift_spec), None, ), # 2
  )

  def __init__(self, table=None, put=None,):
    self.table = table
    self.put = put

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.put = TPut()
          self.put.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('put_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.put is not None:
      oprot.writeFieldBegin('put', TType.STRUCT, 2)
      self.put.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.put is None:
      raise TProtocol.TProtocolException(message='Required field put is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class put_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('put_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class checkAndPut_args:
  """
  Attributes:
   - table: to check in and put to
   - row: row to check
   - family: column family to check
   - qualifier: column qualifier to check
   - value: the expected value, if not provided the
  check is for the non-existence of the
  column in question
   - put: the TPut to put if the check succeeds
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'family', None, None, ), # 3
    (4, TType.STRING, 'qualifier', None, None, ), # 4
    (5, TType.STRING, 'value', None, None, ), # 5
    (6, TType.STRUCT, 'put', (TPut, TPut.thrift_spec), None, ), # 6
  )

  def __init__(self, table=None, row=None, family=None, qualifier=None, value=None, put=None,):
    self.table = table
    self.row = row
    self.family = family
    self.qualifier = qualifier
    self.value = value
    self.put = put

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.family = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.qualifier = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.value = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRUCT:
          self.put = TPut()
          self.put.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('checkAndPut_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.family is not None:
      oprot.writeFieldBegin('family', TType.STRING, 3)
      oprot.writeString(self.family)
      oprot.writeFieldEnd()
    if self.qualifier is not None:
      oprot.writeFieldBegin('qualifier', TType.STRING, 4)
      oprot.writeString(self.qualifier)
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.STRING, 5)
      oprot.writeString(self.value)
      oprot.writeFieldEnd()
    if self.put is not None:
      oprot.writeFieldBegin('put', TType.STRUCT, 6)
      self.put.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.row is None:
      raise TProtocol.TProtocolException(message='Required field row is unset!')
    if self.family is None:
      raise TProtocol.TProtocolException(message='Required field family is unset!')
    if self.qualifier is None:
      raise TProtocol.TProtocolException(message='Required field qualifier is unset!')
    if self.put is None:
      raise TProtocol.TProtocolException(message='Required field put is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class checkAndPut_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('checkAndPut_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class putMultiple_args:
  """
  Attributes:
   - table: the table to put data in
   - puts: a list of TPuts to commit
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.LIST, 'puts', (TType.STRUCT,(TPut, TPut.thrift_spec)), None, ), # 2
  )

  def __init__(self, table=None, puts=None,):
    self.table = table
    self.puts = puts

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.puts = []
          (_etype59, _size56) = iprot.readListBegin()
          for _i60 in xrange(_size56):
            _elem61 = TPut()
            _elem61.read(iprot)
            self.puts.append(_elem61)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('putMultiple_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.puts is not None:
      oprot.writeFieldBegin('puts', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.puts))
      for iter62 in self.puts:
        iter62.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.puts is None:
      raise TProtocol.TProtocolException(message='Required field puts is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class putMultiple_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('putMultiple_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteSingle_args:
  """
  Attributes:
   - table: the table to delete from
   - deleteSingle: the TDelete to delete
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.STRUCT, 'deleteSingle', (TDelete, TDelete.thrift_spec), None, ), # 2
  )

  def __init__(self, table=None, deleteSingle=None,):
    self.table = table
    self.deleteSingle = deleteSingle

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.deleteSingle = TDelete()
          self.deleteSingle.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteSingle_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.deleteSingle is not None:
      oprot.writeFieldBegin('deleteSingle', TType.STRUCT, 2)
      self.deleteSingle.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.deleteSingle is None:
      raise TProtocol.TProtocolException(message='Required field deleteSingle is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteSingle_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteSingle_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteMultiple_args:
  """
  Attributes:
   - table: the table to delete from
   - deletes: list of TDeletes to delete
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.LIST, 'deletes', (TType.STRUCT,(TDelete, TDelete.thrift_spec)), None, ), # 2
  )

  def __init__(self, table=None, deletes=None,):
    self.table = table
    self.deletes = deletes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.deletes = []
          (_etype66, _size63) = iprot.readListBegin()
          for _i67 in xrange(_size63):
            _elem68 = TDelete()
            _elem68.read(iprot)
            self.deletes.append(_elem68)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteMultiple_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.deletes is not None:
      oprot.writeFieldBegin('deletes', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.deletes))
      for iter69 in self.deletes:
        iter69.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.deletes is None:
      raise TProtocol.TProtocolException(message='Required field deletes is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteMultiple_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TDelete, TDelete.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype73, _size70) = iprot.readListBegin()
          for _i74 in xrange(_size70):
            _elem75 = TDelete()
            _elem75.read(iprot)
            self.success.append(_elem75)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteMultiple_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter76 in self.success:
        iter76.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class checkAndDelete_args:
  """
  Attributes:
   - table: to check in and delete from
   - row: row to check
   - family: column family to check
   - qualifier: column qualifier to check
   - value: the expected value, if not provided the
  check is for the non-existence of the
  column in question
   - deleteSingle: the TDelete to execute if the check succeeds
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'family', None, None, ), # 3
    (4, TType.STRING, 'qualifier', None, None, ), # 4
    (5, TType.STRING, 'value', None, None, ), # 5
    (6, TType.STRUCT, 'deleteSingle', (TDelete, TDelete.thrift_spec), None, ), # 6
  )

  def __init__(self, table=None, row=None, family=None, qualifier=None, value=None, deleteSingle=None,):
    self.table = table
    self.row = row
    self.family = family
    self.qualifier = qualifier
    self.value = value
    self.deleteSingle = deleteSingle

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.family = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.qualifier = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.value = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRUCT:
          self.deleteSingle = TDelete()
          self.deleteSingle.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('checkAndDelete_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.family is not None:
      oprot.writeFieldBegin('family', TType.STRING, 3)
      oprot.writeString(self.family)
      oprot.writeFieldEnd()
    if self.qualifier is not None:
      oprot.writeFieldBegin('qualifier', TType.STRING, 4)
      oprot.writeString(self.qualifier)
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.STRING, 5)
      oprot.writeString(self.value)
      oprot.writeFieldEnd()
    if self.deleteSingle is not None:
      oprot.writeFieldBegin('deleteSingle', TType.STRUCT, 6)
      self.deleteSingle.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.row is None:
      raise TProtocol.TProtocolException(message='Required field row is unset!')
    if self.family is None:
      raise TProtocol.TProtocolException(message='Required field family is unset!')
    if self.qualifier is None:
      raise TProtocol.TProtocolException(message='Required field qualifier is unset!')
    if self.deleteSingle is None:
      raise TProtocol.TProtocolException(message='Required field deleteSingle is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class checkAndDelete_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('checkAndDelete_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class increment_args:
  """
  Attributes:
   - table: the table to increment the value on
   - increment: the TIncrement to increment
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.STRUCT, 'increment', (TIncrement, TIncrement.thrift_spec), None, ), # 2
  )

  def __init__(self, table=None, increment=None,):
    self.table = table
    self.increment = increment

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.increment = TIncrement()
          self.increment.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('increment_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.increment is not None:
      oprot.writeFieldBegin('increment', TType.STRUCT, 2)
      self.increment.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.increment is None:
      raise TProtocol.TProtocolException(message='Required field increment is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class increment_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (TResult, TResult.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = TResult()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('increment_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class openScanner_args:
  """
  Attributes:
   - table: the table to get the Scanner for
   - scan: the scan object to get a Scanner for
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'table', None, None, ), # 1
    (2, TType.STRUCT, 'scan', (TScan, TScan.thrift_spec), None, ), # 2
  )

  def __init__(self, table=None, scan=None,):
    self.table = table
    self.scan = scan

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.table = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.scan = TScan()
          self.scan.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('openScanner_args')
    if self.table is not None:
      oprot.writeFieldBegin('table', TType.STRING, 1)
      oprot.writeString(self.table)
      oprot.writeFieldEnd()
    if self.scan is not None:
      oprot.writeFieldBegin('scan', TType.STRUCT, 2)
      self.scan.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.table is None:
      raise TProtocol.TProtocolException(message='Required field table is unset!')
    if self.scan is None:
      raise TProtocol.TProtocolException(message='Required field scan is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class openScanner_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('openScanner_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getScannerRows_args:
  """
  Attributes:
   - scannerId: the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
   - numRows: number of rows to return
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'scannerId', None, None, ), # 1
    (2, TType.I32, 'numRows', None, 1, ), # 2
  )

  def __init__(self, scannerId=None, numRows=thrift_spec[2][4],):
    self.scannerId = scannerId
    self.numRows = numRows

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.scannerId = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.numRows = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getScannerRows_args')
    if self.scannerId is not None:
      oprot.writeFieldBegin('scannerId', TType.I32, 1)
      oprot.writeI32(self.scannerId)
      oprot.writeFieldEnd()
    if self.numRows is not None:
      oprot.writeFieldBegin('numRows', TType.I32, 2)
      oprot.writeI32(self.numRows)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.scannerId is None:
      raise TProtocol.TProtocolException(message='Required field scannerId is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getScannerRows_result:
  """
  Attributes:
   - success
   - io
   - ia: if the scannerId is invalid
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TResult, TResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (TIllegalArgument, TIllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype80, _size77) = iprot.readListBegin()
          for _i81 in xrange(_size77):
            _elem82 = TResult()
            _elem82.read(iprot)
            self.success.append(_elem82)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = TIllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getScannerRows_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter83 in self.success:
        iter83.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class closeScanner_args:
  """
  Attributes:
   - scannerId: the Id of the Scanner to close *
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'scannerId', None, None, ), # 1
  )

  def __init__(self, scannerId=None,):
    self.scannerId = scannerId

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.scannerId = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('closeScanner_args')
    if self.scannerId is not None:
      oprot.writeFieldBegin('scannerId', TType.I32, 1)
      oprot.writeI32(self.scannerId)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    if self.scannerId is None:
      raise TProtocol.TProtocolException(message='Required field scannerId is unset!')
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class closeScanner_result:
  """
  Attributes:
   - io
   - ia: if the scannerId is invalid
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (TIOError, TIOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (TIllegalArgument, TIllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = TIOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = TIllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('closeScanner_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
