#
# Autogenerated by Thrift Compiler (0.9.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface:
  def enableTable(self, tableName):
    """
    Brings a table on-line (enables it)

    Parameters:
     - tableName: name of the table
    """
    pass

  def disableTable(self, tableName):
    """
    Disables a table (takes it off-line) If it is being served, the master
    will tell the servers to stop serving it.

    Parameters:
     - tableName: name of the table
    """
    pass

  def isTableEnabled(self, tableName):
    """
    @return true if table is on-line

    Parameters:
     - tableName: name of the table to check
    """
    pass

  def compact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    pass

  def majorCompact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    pass

  def getTableNames(self, ):
    """
    List all the userspace tables.

    @return returns a list of names
    """
    pass

  def getColumnDescriptors(self, tableName):
    """
    List all the column families assoicated with a table.

    @return list of column family descriptors

    Parameters:
     - tableName: table name
    """
    pass

  def getTableRegions(self, tableName):
    """
    List the regions associated with a table.

    @return list of region descriptors

    Parameters:
     - tableName: table name
    """
    pass

  def createTable(self, tableName, columnFamilies):
    """
    Create a table with the specified column families.  The name
    field for each ColumnDescriptor must be set and must end in a
    colon (:). All other fields are optional and will get default
    values if not explicitly specified.

    @throws IllegalArgument if an input parameter is invalid

    @throws AlreadyExists if the table name already exists

    Parameters:
     - tableName: name of table to create
     - columnFamilies: list of column family descriptors
    """
    pass

  def deleteTable(self, tableName):
    """
    Deletes a table

    @throws IOError if table doesn't exist on server or there was some other
    problem

    Parameters:
     - tableName: name of table to delete
    """
    pass

  def get(self, tableName, row, column, attributes):
    """
    Get a single TCell for the specified table, row, and column at the
    latest timestamp. Returns an empty list if no such value exists.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - attributes: Get attributes
    """
    pass

  def getVer(self, tableName, row, column, numVersions, attributes):
    """
    Get the specified number of versions for the specified table,
    row, and column.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - numVersions: number of versions to retrieve
     - attributes: Get attributes
    """
    pass

  def getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
    """
    Get the specified number of versions for the specified table,
    row, and column.  Only versions less than or equal to the specified
    timestamp will be returned.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - timestamp: timestamp
     - numVersions: number of versions to retrieve
     - attributes: Get attributes
    """
    pass

  def getRow(self, tableName, row, attributes):
    """
    Get all the data for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - attributes: Get attributes
    """
    pass

  def getRowWithColumns(self, tableName, row, columns, attributes):
    """
    Get the specified columns for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes
    """
    pass

  def getRowTs(self, tableName, row, timestamp, attributes):
    """
    Get all the data for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - row: row key
     - timestamp: timestamp
     - attributes: Get attributes
    """
    pass

  def getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
    """
    Get the specified columns for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes
    """
    pass

  def getRows(self, tableName, rows, attributes):
    """
    Get all the data for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - attributes: Get attributes
    """
    pass

  def getRowsWithColumns(self, tableName, rows, columns, attributes):
    """
    Get the specified columns for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes
    """
    pass

  def getRowsTs(self, tableName, rows, timestamp, attributes):
    """
    Get all the data for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - rows: row keys
     - timestamp: timestamp
     - attributes: Get attributes
    """
    pass

  def getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
    """
    Get the specified columns for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes
    """
    pass

  def mutateRow(self, tableName, row, mutations, attributes):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - attributes: Mutation attributes
    """
    pass

  def mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - timestamp: timestamp
     - attributes: Mutation attributes
    """
    pass

  def mutateRows(self, tableName, rowBatches, attributes):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - attributes: Mutation attributes
    """
    pass

  def mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - timestamp: timestamp
     - attributes: Mutation attributes
    """
    pass

  def atomicIncrement(self, tableName, row, column, value):
    """
    Atomically increment the column value specified.  Returns the next value post increment.

    Parameters:
     - tableName: name of table
     - row: row to increment
     - column: name of column
     - value: amount to increment by
    """
    pass

  def deleteAll(self, tableName, row, column, attributes):
    """
    Delete all cells that match the passed row and column.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - attributes: Delete attributes
    """
    pass

  def deleteAllTs(self, tableName, row, column, timestamp, attributes):
    """
    Delete all cells that match the passed row and column and whose
    timestamp is equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - timestamp: timestamp
     - attributes: Delete attributes
    """
    pass

  def deleteAllRow(self, tableName, row, attributes):
    """
    Completely delete the row's cells.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - attributes: Delete attributes
    """
    pass

  def increment(self, increment):
    """
    Increment a cell by the ammount.
    Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
    False is the default.  Turn to true if you need the extra performance and can accept some
    data loss if a thrift server dies with increments still in the queue.

    Parameters:
     - increment: The single increment to apply
    """
    pass

  def incrementRows(self, increments):
    """
    Parameters:
     - increments: The list of increments
    """
    pass

  def deleteAllRowTs(self, tableName, row, timestamp, attributes):
    """
    Completely delete the row's cells marked with a timestamp
    equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - timestamp: timestamp
     - attributes: Delete attributes
    """
    pass

  def scannerOpenWithScan(self, tableName, scan, attributes):
    """
    Get a scanner on the current table, using the Scan instance
    for the scan parameters.

    Parameters:
     - tableName: name of table
     - scan: Scan instance
     - attributes: Scan attributes
    """
    pass

  def scannerOpen(self, tableName, startRow, columns, attributes):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes
    """
    pass

  def scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes
    """
    pass

  def scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
    """
    Open a scanner for a given prefix.  That is all rows will have the specified
    prefix. No other rows will be returned.

    @return scanner id to use with other scanner calls

    Parameters:
     - tableName: name of table
     - startAndPrefix: the prefix (and thus start row) of the keys you want
     - columns: the columns you want returned
     - attributes: Scan attributes
    """
    pass

  def scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.
    Only values with the specified timestamp are returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes
    """
    pass

  def scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.  Only values with the specified timestamp are
    returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes
    """
    pass

  def scannerGet(self, id):
    """
    Returns the scanner's current row value and advances to the next
    row in the table.  When there are no more rows in the table, or a key
    greater-than-or-equal-to the scanner's specified stopRow is reached,
    an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    pass

  def scannerGetList(self, id, nbRows):
    """
    Returns, starting at the scanner's current row value nbRows worth of
    rows and advances to the next row in the table.  When there are no more
    rows in the table, or a key greater-than-or-equal-to the scanner's
    specified stopRow is reached,  an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
     - nbRows: number of results to return
    """
    pass

  def scannerClose(self, id):
    """
    Closes the server-state associated with an open scanner.

    @throws IllegalArgument if ScannerID is invalid

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    pass

  def getRowOrBefore(self, tableName, row, family):
    """
    Get the row just before the specified one.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - family: column name
    """
    pass

  def getRegionInfo(self, row):
    """
    Get the regininfo for the specified row. It scans
    the metatable to find region's start and end keys.

    @return value for specified row/column

    Parameters:
     - row: row key
    """
    pass


class Client(Iface):
  def __init__(self, iprot, oprot=None):
    self._iprot = self._oprot = iprot
    if oprot is not None:
      self._oprot = oprot
    self._seqid = 0

  def enableTable(self, tableName):
    """
    Brings a table on-line (enables it)

    Parameters:
     - tableName: name of the table
    """
    self.send_enableTable(tableName)
    self.recv_enableTable()

  def send_enableTable(self, tableName):
    self._oprot.writeMessageBegin('enableTable', TMessageType.CALL, self._seqid)
    args = enableTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_enableTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = enableTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def disableTable(self, tableName):
    """
    Disables a table (takes it off-line) If it is being served, the master
    will tell the servers to stop serving it.

    Parameters:
     - tableName: name of the table
    """
    self.send_disableTable(tableName)
    self.recv_disableTable()

  def send_disableTable(self, tableName):
    self._oprot.writeMessageBegin('disableTable', TMessageType.CALL, self._seqid)
    args = disableTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_disableTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = disableTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def isTableEnabled(self, tableName):
    """
    @return true if table is on-line

    Parameters:
     - tableName: name of the table to check
    """
    self.send_isTableEnabled(tableName)
    return self.recv_isTableEnabled()

  def send_isTableEnabled(self, tableName):
    self._oprot.writeMessageBegin('isTableEnabled', TMessageType.CALL, self._seqid)
    args = isTableEnabled_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_isTableEnabled(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = isTableEnabled_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "isTableEnabled failed: unknown result");

  def compact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    self.send_compact(tableNameOrRegionName)
    self.recv_compact()

  def send_compact(self, tableNameOrRegionName):
    self._oprot.writeMessageBegin('compact', TMessageType.CALL, self._seqid)
    args = compact_args()
    args.tableNameOrRegionName = tableNameOrRegionName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_compact(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = compact_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def majorCompact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    self.send_majorCompact(tableNameOrRegionName)
    self.recv_majorCompact()

  def send_majorCompact(self, tableNameOrRegionName):
    self._oprot.writeMessageBegin('majorCompact', TMessageType.CALL, self._seqid)
    args = majorCompact_args()
    args.tableNameOrRegionName = tableNameOrRegionName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_majorCompact(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = majorCompact_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def getTableNames(self, ):
    """
    List all the userspace tables.

    @return returns a list of names
    """
    self.send_getTableNames()
    return self.recv_getTableNames()

  def send_getTableNames(self, ):
    self._oprot.writeMessageBegin('getTableNames', TMessageType.CALL, self._seqid)
    args = getTableNames_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableNames(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTableNames_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableNames failed: unknown result");

  def getColumnDescriptors(self, tableName):
    """
    List all the column families assoicated with a table.

    @return list of column family descriptors

    Parameters:
     - tableName: table name
    """
    self.send_getColumnDescriptors(tableName)
    return self.recv_getColumnDescriptors()

  def send_getColumnDescriptors(self, tableName):
    self._oprot.writeMessageBegin('getColumnDescriptors', TMessageType.CALL, self._seqid)
    args = getColumnDescriptors_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getColumnDescriptors(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getColumnDescriptors_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getColumnDescriptors failed: unknown result");

  def getTableRegions(self, tableName):
    """
    List the regions associated with a table.

    @return list of region descriptors

    Parameters:
     - tableName: table name
    """
    self.send_getTableRegions(tableName)
    return self.recv_getTableRegions()

  def send_getTableRegions(self, tableName):
    self._oprot.writeMessageBegin('getTableRegions', TMessageType.CALL, self._seqid)
    args = getTableRegions_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableRegions(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTableRegions_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableRegions failed: unknown result");

  def createTable(self, tableName, columnFamilies):
    """
    Create a table with the specified column families.  The name
    field for each ColumnDescriptor must be set and must end in a
    colon (:). All other fields are optional and will get default
    values if not explicitly specified.

    @throws IllegalArgument if an input parameter is invalid

    @throws AlreadyExists if the table name already exists

    Parameters:
     - tableName: name of table to create
     - columnFamilies: list of column family descriptors
    """
    self.send_createTable(tableName, columnFamilies)
    self.recv_createTable()

  def send_createTable(self, tableName, columnFamilies):
    self._oprot.writeMessageBegin('createTable', TMessageType.CALL, self._seqid)
    args = createTable_args()
    args.tableName = tableName
    args.columnFamilies = columnFamilies
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    if result.exist is not None:
      raise result.exist
    return

  def deleteTable(self, tableName):
    """
    Deletes a table

    @throws IOError if table doesn't exist on server or there was some other
    problem

    Parameters:
     - tableName: name of table to delete
    """
    self.send_deleteTable(tableName)
    self.recv_deleteTable()

  def send_deleteTable(self, tableName):
    self._oprot.writeMessageBegin('deleteTable', TMessageType.CALL, self._seqid)
    args = deleteTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def get(self, tableName, row, column, attributes):
    """
    Get a single TCell for the specified table, row, and column at the
    latest timestamp. Returns an empty list if no such value exists.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - attributes: Get attributes
    """
    self.send_get(tableName, row, column, attributes)
    return self.recv_get()

  def send_get(self, tableName, row, column, attributes):
    self._oprot.writeMessageBegin('get', TMessageType.CALL, self._seqid)
    args = get_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get failed: unknown result");

  def getVer(self, tableName, row, column, numVersions, attributes):
    """
    Get the specified number of versions for the specified table,
    row, and column.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - numVersions: number of versions to retrieve
     - attributes: Get attributes
    """
    self.send_getVer(tableName, row, column, numVersions, attributes)
    return self.recv_getVer()

  def send_getVer(self, tableName, row, column, numVersions, attributes):
    self._oprot.writeMessageBegin('getVer', TMessageType.CALL, self._seqid)
    args = getVer_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.numVersions = numVersions
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getVer(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getVer_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getVer failed: unknown result");

  def getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
    """
    Get the specified number of versions for the specified table,
    row, and column.  Only versions less than or equal to the specified
    timestamp will be returned.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - timestamp: timestamp
     - numVersions: number of versions to retrieve
     - attributes: Get attributes
    """
    self.send_getVerTs(tableName, row, column, timestamp, numVersions, attributes)
    return self.recv_getVerTs()

  def send_getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
    self._oprot.writeMessageBegin('getVerTs', TMessageType.CALL, self._seqid)
    args = getVerTs_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.timestamp = timestamp
    args.numVersions = numVersions
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getVerTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getVerTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getVerTs failed: unknown result");

  def getRow(self, tableName, row, attributes):
    """
    Get all the data for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - attributes: Get attributes
    """
    self.send_getRow(tableName, row, attributes)
    return self.recv_getRow()

  def send_getRow(self, tableName, row, attributes):
    self._oprot.writeMessageBegin('getRow', TMessageType.CALL, self._seqid)
    args = getRow_args()
    args.tableName = tableName
    args.row = row
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRow failed: unknown result");

  def getRowWithColumns(self, tableName, row, columns, attributes):
    """
    Get the specified columns for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes
    """
    self.send_getRowWithColumns(tableName, row, columns, attributes)
    return self.recv_getRowWithColumns()

  def send_getRowWithColumns(self, tableName, row, columns, attributes):
    self._oprot.writeMessageBegin('getRowWithColumns', TMessageType.CALL, self._seqid)
    args = getRowWithColumns_args()
    args.tableName = tableName
    args.row = row
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowWithColumns(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowWithColumns_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowWithColumns failed: unknown result");

  def getRowTs(self, tableName, row, timestamp, attributes):
    """
    Get all the data for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - row: row key
     - timestamp: timestamp
     - attributes: Get attributes
    """
    self.send_getRowTs(tableName, row, timestamp, attributes)
    return self.recv_getRowTs()

  def send_getRowTs(self, tableName, row, timestamp, attributes):
    self._oprot.writeMessageBegin('getRowTs', TMessageType.CALL, self._seqid)
    args = getRowTs_args()
    args.tableName = tableName
    args.row = row
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowTs failed: unknown result");

  def getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
    """
    Get the specified columns for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes
    """
    self.send_getRowWithColumnsTs(tableName, row, columns, timestamp, attributes)
    return self.recv_getRowWithColumnsTs()

  def send_getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
    self._oprot.writeMessageBegin('getRowWithColumnsTs', TMessageType.CALL, self._seqid)
    args = getRowWithColumnsTs_args()
    args.tableName = tableName
    args.row = row
    args.columns = columns
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowWithColumnsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowWithColumnsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowWithColumnsTs failed: unknown result");

  def getRows(self, tableName, rows, attributes):
    """
    Get all the data for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - attributes: Get attributes
    """
    self.send_getRows(tableName, rows, attributes)
    return self.recv_getRows()

  def send_getRows(self, tableName, rows, attributes):
    self._oprot.writeMessageBegin('getRows', TMessageType.CALL, self._seqid)
    args = getRows_args()
    args.tableName = tableName
    args.rows = rows
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRows failed: unknown result");

  def getRowsWithColumns(self, tableName, rows, columns, attributes):
    """
    Get the specified columns for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes
    """
    self.send_getRowsWithColumns(tableName, rows, columns, attributes)
    return self.recv_getRowsWithColumns()

  def send_getRowsWithColumns(self, tableName, rows, columns, attributes):
    self._oprot.writeMessageBegin('getRowsWithColumns', TMessageType.CALL, self._seqid)
    args = getRowsWithColumns_args()
    args.tableName = tableName
    args.rows = rows
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsWithColumns(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsWithColumns_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsWithColumns failed: unknown result");

  def getRowsTs(self, tableName, rows, timestamp, attributes):
    """
    Get all the data for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - rows: row keys
     - timestamp: timestamp
     - attributes: Get attributes
    """
    self.send_getRowsTs(tableName, rows, timestamp, attributes)
    return self.recv_getRowsTs()

  def send_getRowsTs(self, tableName, rows, timestamp, attributes):
    self._oprot.writeMessageBegin('getRowsTs', TMessageType.CALL, self._seqid)
    args = getRowsTs_args()
    args.tableName = tableName
    args.rows = rows
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsTs failed: unknown result");

  def getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
    """
    Get the specified columns for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes
    """
    self.send_getRowsWithColumnsTs(tableName, rows, columns, timestamp, attributes)
    return self.recv_getRowsWithColumnsTs()

  def send_getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
    self._oprot.writeMessageBegin('getRowsWithColumnsTs', TMessageType.CALL, self._seqid)
    args = getRowsWithColumnsTs_args()
    args.tableName = tableName
    args.rows = rows
    args.columns = columns
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsWithColumnsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsWithColumnsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsWithColumnsTs failed: unknown result");

  def mutateRow(self, tableName, row, mutations, attributes):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - attributes: Mutation attributes
    """
    self.send_mutateRow(tableName, row, mutations, attributes)
    self.recv_mutateRow()

  def send_mutateRow(self, tableName, row, mutations, attributes):
    self._oprot.writeMessageBegin('mutateRow', TMessageType.CALL, self._seqid)
    args = mutateRow_args()
    args.tableName = tableName
    args.row = row
    args.mutations = mutations
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - timestamp: timestamp
     - attributes: Mutation attributes
    """
    self.send_mutateRowTs(tableName, row, mutations, timestamp, attributes)
    self.recv_mutateRowTs()

  def send_mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
    self._oprot.writeMessageBegin('mutateRowTs', TMessageType.CALL, self._seqid)
    args = mutateRowTs_args()
    args.tableName = tableName
    args.row = row
    args.mutations = mutations
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRows(self, tableName, rowBatches, attributes):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - attributes: Mutation attributes
    """
    self.send_mutateRows(tableName, rowBatches, attributes)
    self.recv_mutateRows()

  def send_mutateRows(self, tableName, rowBatches, attributes):
    self._oprot.writeMessageBegin('mutateRows', TMessageType.CALL, self._seqid)
    args = mutateRows_args()
    args.tableName = tableName
    args.rowBatches = rowBatches
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - timestamp: timestamp
     - attributes: Mutation attributes
    """
    self.send_mutateRowsTs(tableName, rowBatches, timestamp, attributes)
    self.recv_mutateRowsTs()

  def send_mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
    self._oprot.writeMessageBegin('mutateRowsTs', TMessageType.CALL, self._seqid)
    args = mutateRowsTs_args()
    args.tableName = tableName
    args.rowBatches = rowBatches
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRowsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRowsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def atomicIncrement(self, tableName, row, column, value):
    """
    Atomically increment the column value specified.  Returns the next value post increment.

    Parameters:
     - tableName: name of table
     - row: row to increment
     - column: name of column
     - value: amount to increment by
    """
    self.send_atomicIncrement(tableName, row, column, value)
    return self.recv_atomicIncrement()

  def send_atomicIncrement(self, tableName, row, column, value):
    self._oprot.writeMessageBegin('atomicIncrement', TMessageType.CALL, self._seqid)
    args = atomicIncrement_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.value = value
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_atomicIncrement(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = atomicIncrement_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "atomicIncrement failed: unknown result");

  def deleteAll(self, tableName, row, column, attributes):
    """
    Delete all cells that match the passed row and column.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - attributes: Delete attributes
    """
    self.send_deleteAll(tableName, row, column, attributes)
    self.recv_deleteAll()

  def send_deleteAll(self, tableName, row, column, attributes):
    self._oprot.writeMessageBegin('deleteAll', TMessageType.CALL, self._seqid)
    args = deleteAll_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAll(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAll_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllTs(self, tableName, row, column, timestamp, attributes):
    """
    Delete all cells that match the passed row and column and whose
    timestamp is equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - timestamp: timestamp
     - attributes: Delete attributes
    """
    self.send_deleteAllTs(tableName, row, column, timestamp, attributes)
    self.recv_deleteAllTs()

  def send_deleteAllTs(self, tableName, row, column, timestamp, attributes):
    self._oprot.writeMessageBegin('deleteAllTs', TMessageType.CALL, self._seqid)
    args = deleteAllTs_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllRow(self, tableName, row, attributes):
    """
    Completely delete the row's cells.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - attributes: Delete attributes
    """
    self.send_deleteAllRow(tableName, row, attributes)
    self.recv_deleteAllRow()

  def send_deleteAllRow(self, tableName, row, attributes):
    self._oprot.writeMessageBegin('deleteAllRow', TMessageType.CALL, self._seqid)
    args = deleteAllRow_args()
    args.tableName = tableName
    args.row = row
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def increment(self, increment):
    """
    Increment a cell by the ammount.
    Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
    False is the default.  Turn to true if you need the extra performance and can accept some
    data loss if a thrift server dies with increments still in the queue.

    Parameters:
     - increment: The single increment to apply
    """
    self.send_increment(increment)
    self.recv_increment()

  def send_increment(self, increment):
    self._oprot.writeMessageBegin('increment', TMessageType.CALL, self._seqid)
    args = increment_args()
    args.increment = increment
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_increment(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = increment_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def incrementRows(self, increments):
    """
    Parameters:
     - increments: The list of increments
    """
    self.send_incrementRows(increments)
    self.recv_incrementRows()

  def send_incrementRows(self, increments):
    self._oprot.writeMessageBegin('incrementRows', TMessageType.CALL, self._seqid)
    args = incrementRows_args()
    args.increments = increments
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_incrementRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = incrementRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllRowTs(self, tableName, row, timestamp, attributes):
    """
    Completely delete the row's cells marked with a timestamp
    equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - timestamp: timestamp
     - attributes: Delete attributes
    """
    self.send_deleteAllRowTs(tableName, row, timestamp, attributes)
    self.recv_deleteAllRowTs()

  def send_deleteAllRowTs(self, tableName, row, timestamp, attributes):
    self._oprot.writeMessageBegin('deleteAllRowTs', TMessageType.CALL, self._seqid)
    args = deleteAllRowTs_args()
    args.tableName = tableName
    args.row = row
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def scannerOpenWithScan(self, tableName, scan, attributes):
    """
    Get a scanner on the current table, using the Scan instance
    for the scan parameters.

    Parameters:
     - tableName: name of table
     - scan: Scan instance
     - attributes: Scan attributes
    """
    self.send_scannerOpenWithScan(tableName, scan, attributes)
    return self.recv_scannerOpenWithScan()

  def send_scannerOpenWithScan(self, tableName, scan, attributes):
    self._oprot.writeMessageBegin('scannerOpenWithScan', TMessageType.CALL, self._seqid)
    args = scannerOpenWithScan_args()
    args.tableName = tableName
    args.scan = scan
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithScan(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithScan_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithScan failed: unknown result");

  def scannerOpen(self, tableName, startRow, columns, attributes):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes
    """
    self.send_scannerOpen(tableName, startRow, columns, attributes)
    return self.recv_scannerOpen()

  def send_scannerOpen(self, tableName, startRow, columns, attributes):
    self._oprot.writeMessageBegin('scannerOpen', TMessageType.CALL, self._seqid)
    args = scannerOpen_args()
    args.tableName = tableName
    args.startRow = startRow
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpen(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpen_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpen failed: unknown result");

  def scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes
    """
    self.send_scannerOpenWithStop(tableName, startRow, stopRow, columns, attributes)
    return self.recv_scannerOpenWithStop()

  def send_scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
    self._oprot.writeMessageBegin('scannerOpenWithStop', TMessageType.CALL, self._seqid)
    args = scannerOpenWithStop_args()
    args.tableName = tableName
    args.startRow = startRow
    args.stopRow = stopRow
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithStop(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithStop_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStop failed: unknown result");

  def scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
    """
    Open a scanner for a given prefix.  That is all rows will have the specified
    prefix. No other rows will be returned.

    @return scanner id to use with other scanner calls

    Parameters:
     - tableName: name of table
     - startAndPrefix: the prefix (and thus start row) of the keys you want
     - columns: the columns you want returned
     - attributes: Scan attributes
    """
    self.send_scannerOpenWithPrefix(tableName, startAndPrefix, columns, attributes)
    return self.recv_scannerOpenWithPrefix()

  def send_scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
    self._oprot.writeMessageBegin('scannerOpenWithPrefix', TMessageType.CALL, self._seqid)
    args = scannerOpenWithPrefix_args()
    args.tableName = tableName
    args.startAndPrefix = startAndPrefix
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithPrefix(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithPrefix_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithPrefix failed: unknown result");

  def scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.
    Only values with the specified timestamp are returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes
    """
    self.send_scannerOpenTs(tableName, startRow, columns, timestamp, attributes)
    return self.recv_scannerOpenTs()

  def send_scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
    self._oprot.writeMessageBegin('scannerOpenTs', TMessageType.CALL, self._seqid)
    args = scannerOpenTs_args()
    args.tableName = tableName
    args.startRow = startRow
    args.columns = columns
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenTs failed: unknown result");

  def scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.  Only values with the specified timestamp are
    returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes
    """
    self.send_scannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp, attributes)
    return self.recv_scannerOpenWithStopTs()

  def send_scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
    self._oprot.writeMessageBegin('scannerOpenWithStopTs', TMessageType.CALL, self._seqid)
    args = scannerOpenWithStopTs_args()
    args.tableName = tableName
    args.startRow = startRow
    args.stopRow = stopRow
    args.columns = columns
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithStopTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithStopTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStopTs failed: unknown result");

  def scannerGet(self, id):
    """
    Returns the scanner's current row value and advances to the next
    row in the table.  When there are no more rows in the table, or a key
    greater-than-or-equal-to the scanner's specified stopRow is reached,
    an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    self.send_scannerGet(id)
    return self.recv_scannerGet()

  def send_scannerGet(self, id):
    self._oprot.writeMessageBegin('scannerGet', TMessageType.CALL, self._seqid)
    args = scannerGet_args()
    args.id = id
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerGet(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerGet_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerGet failed: unknown result");

  def scannerGetList(self, id, nbRows):
    """
    Returns, starting at the scanner's current row value nbRows worth of
    rows and advances to the next row in the table.  When there are no more
    rows in the table, or a key greater-than-or-equal-to the scanner's
    specified stopRow is reached,  an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
     - nbRows: number of results to return
    """
    self.send_scannerGetList(id, nbRows)
    return self.recv_scannerGetList()

  def send_scannerGetList(self, id, nbRows):
    self._oprot.writeMessageBegin('scannerGetList', TMessageType.CALL, self._seqid)
    args = scannerGetList_args()
    args.id = id
    args.nbRows = nbRows
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerGetList(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerGetList_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerGetList failed: unknown result");

  def scannerClose(self, id):
    """
    Closes the server-state associated with an open scanner.

    @throws IllegalArgument if ScannerID is invalid

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    self.send_scannerClose(id)
    self.recv_scannerClose()

  def send_scannerClose(self, id):
    self._oprot.writeMessageBegin('scannerClose', TMessageType.CALL, self._seqid)
    args = scannerClose_args()
    args.id = id
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerClose(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerClose_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def getRowOrBefore(self, tableName, row, family):
    """
    Get the row just before the specified one.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - family: column name
    """
    self.send_getRowOrBefore(tableName, row, family)
    return self.recv_getRowOrBefore()

  def send_getRowOrBefore(self, tableName, row, family):
    self._oprot.writeMessageBegin('getRowOrBefore', TMessageType.CALL, self._seqid)
    args = getRowOrBefore_args()
    args.tableName = tableName
    args.row = row
    args.family = family
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowOrBefore(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowOrBefore_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowOrBefore failed: unknown result");

  def getRegionInfo(self, row):
    """
    Get the regininfo for the specified row. It scans
    the metatable to find region's start and end keys.

    @return value for specified row/column

    Parameters:
     - row: row key
    """
    self.send_getRegionInfo(row)
    return self.recv_getRegionInfo()

  def send_getRegionInfo(self, row):
    self._oprot.writeMessageBegin('getRegionInfo', TMessageType.CALL, self._seqid)
    args = getRegionInfo_args()
    args.row = row
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRegionInfo(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRegionInfo_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRegionInfo failed: unknown result");


class Processor(Iface, TProcessor):
  def __init__(self, handler):
    self._handler = handler
    self._processMap = {}
    self._processMap["enableTable"] = Processor.process_enableTable
    self._processMap["disableTable"] = Processor.process_disableTable
    self._processMap["isTableEnabled"] = Processor.process_isTableEnabled
    self._processMap["compact"] = Processor.process_compact
    self._processMap["majorCompact"] = Processor.process_majorCompact
    self._processMap["getTableNames"] = Processor.process_getTableNames
    self._processMap["getColumnDescriptors"] = Processor.process_getColumnDescriptors
    self._processMap["getTableRegions"] = Processor.process_getTableRegions
    self._processMap["createTable"] = Processor.process_createTable
    self._processMap["deleteTable"] = Processor.process_deleteTable
    self._processMap["get"] = Processor.process_get
    self._processMap["getVer"] = Processor.process_getVer
    self._processMap["getVerTs"] = Processor.process_getVerTs
    self._processMap["getRow"] = Processor.process_getRow
    self._processMap["getRowWithColumns"] = Processor.process_getRowWithColumns
    self._processMap["getRowTs"] = Processor.process_getRowTs
    self._processMap["getRowWithColumnsTs"] = Processor.process_getRowWithColumnsTs
    self._processMap["getRows"] = Processor.process_getRows
    self._processMap["getRowsWithColumns"] = Processor.process_getRowsWithColumns
    self._processMap["getRowsTs"] = Processor.process_getRowsTs
    self._processMap["getRowsWithColumnsTs"] = Processor.process_getRowsWithColumnsTs
    self._processMap["mutateRow"] = Processor.process_mutateRow
    self._processMap["mutateRowTs"] = Processor.process_mutateRowTs
    self._processMap["mutateRows"] = Processor.process_mutateRows
    self._processMap["mutateRowsTs"] = Processor.process_mutateRowsTs
    self._processMap["atomicIncrement"] = Processor.process_atomicIncrement
    self._processMap["deleteAll"] = Processor.process_deleteAll
    self._processMap["deleteAllTs"] = Processor.process_deleteAllTs
    self._processMap["deleteAllRow"] = Processor.process_deleteAllRow
    self._processMap["increment"] = Processor.process_increment
    self._processMap["incrementRows"] = Processor.process_incrementRows
    self._processMap["deleteAllRowTs"] = Processor.process_deleteAllRowTs
    self._processMap["scannerOpenWithScan"] = Processor.process_scannerOpenWithScan
    self._processMap["scannerOpen"] = Processor.process_scannerOpen
    self._processMap["scannerOpenWithStop"] = Processor.process_scannerOpenWithStop
    self._processMap["scannerOpenWithPrefix"] = Processor.process_scannerOpenWithPrefix
    self._processMap["scannerOpenTs"] = Processor.process_scannerOpenTs
    self._processMap["scannerOpenWithStopTs"] = Processor.process_scannerOpenWithStopTs
    self._processMap["scannerGet"] = Processor.process_scannerGet
    self._processMap["scannerGetList"] = Processor.process_scannerGetList
    self._processMap["scannerClose"] = Processor.process_scannerClose
    self._processMap["getRowOrBefore"] = Processor.process_getRowOrBefore
    self._processMap["getRegionInfo"] = Processor.process_getRegionInfo

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_enableTable(self, seqid, iprot, oprot):
    args = enableTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = enableTable_result()
    try:
      self._handler.enableTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("enableTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_disableTable(self, seqid, iprot, oprot):
    args = disableTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = disableTable_result()
    try:
      self._handler.disableTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("disableTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_isTableEnabled(self, seqid, iprot, oprot):
    args = isTableEnabled_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = isTableEnabled_result()
    try:
      result.success = self._handler.isTableEnabled(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("isTableEnabled", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_compact(self, seqid, iprot, oprot):
    args = compact_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = compact_result()
    try:
      self._handler.compact(args.tableNameOrRegionName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("compact", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_majorCompact(self, seqid, iprot, oprot):
    args = majorCompact_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = majorCompact_result()
    try:
      self._handler.majorCompact(args.tableNameOrRegionName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("majorCompact", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableNames(self, seqid, iprot, oprot):
    args = getTableNames_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableNames_result()
    try:
      result.success = self._handler.getTableNames()
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getTableNames", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getColumnDescriptors(self, seqid, iprot, oprot):
    args = getColumnDescriptors_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getColumnDescriptors_result()
    try:
      result.success = self._handler.getColumnDescriptors(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getColumnDescriptors", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableRegions(self, seqid, iprot, oprot):
    args = getTableRegions_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableRegions_result()
    try:
      result.success = self._handler.getTableRegions(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getTableRegions", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createTable(self, seqid, iprot, oprot):
    args = createTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createTable_result()
    try:
      self._handler.createTable(args.tableName, args.columnFamilies)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    except AlreadyExists as exist:
      result.exist = exist
    oprot.writeMessageBegin("createTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteTable(self, seqid, iprot, oprot):
    args = deleteTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteTable_result()
    try:
      self._handler.deleteTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get(self, seqid, iprot, oprot):
    args = get_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_result()
    try:
      result.success = self._handler.get(args.tableName, args.row, args.column, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("get", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getVer(self, seqid, iprot, oprot):
    args = getVer_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getVer_result()
    try:
      result.success = self._handler.getVer(args.tableName, args.row, args.column, args.numVersions, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getVer", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getVerTs(self, seqid, iprot, oprot):
    args = getVerTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getVerTs_result()
    try:
      result.success = self._handler.getVerTs(args.tableName, args.row, args.column, args.timestamp, args.numVersions, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getVerTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRow(self, seqid, iprot, oprot):
    args = getRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRow_result()
    try:
      result.success = self._handler.getRow(args.tableName, args.row, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowWithColumns(self, seqid, iprot, oprot):
    args = getRowWithColumns_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowWithColumns_result()
    try:
      result.success = self._handler.getRowWithColumns(args.tableName, args.row, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowWithColumns", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowTs(self, seqid, iprot, oprot):
    args = getRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowTs_result()
    try:
      result.success = self._handler.getRowTs(args.tableName, args.row, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowWithColumnsTs(self, seqid, iprot, oprot):
    args = getRowWithColumnsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowWithColumnsTs_result()
    try:
      result.success = self._handler.getRowWithColumnsTs(args.tableName, args.row, args.columns, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowWithColumnsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRows(self, seqid, iprot, oprot):
    args = getRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRows_result()
    try:
      result.success = self._handler.getRows(args.tableName, args.rows, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsWithColumns(self, seqid, iprot, oprot):
    args = getRowsWithColumns_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsWithColumns_result()
    try:
      result.success = self._handler.getRowsWithColumns(args.tableName, args.rows, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsWithColumns", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsTs(self, seqid, iprot, oprot):
    args = getRowsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsTs_result()
    try:
      result.success = self._handler.getRowsTs(args.tableName, args.rows, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsWithColumnsTs(self, seqid, iprot, oprot):
    args = getRowsWithColumnsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsWithColumnsTs_result()
    try:
      result.success = self._handler.getRowsWithColumnsTs(args.tableName, args.rows, args.columns, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsWithColumnsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRow(self, seqid, iprot, oprot):
    args = mutateRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRow_result()
    try:
      self._handler.mutateRow(args.tableName, args.row, args.mutations, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRowTs(self, seqid, iprot, oprot):
    args = mutateRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRowTs_result()
    try:
      self._handler.mutateRowTs(args.tableName, args.row, args.mutations, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRows(self, seqid, iprot, oprot):
    args = mutateRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRows_result()
    try:
      self._handler.mutateRows(args.tableName, args.rowBatches, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRowsTs(self, seqid, iprot, oprot):
    args = mutateRowsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRowsTs_result()
    try:
      self._handler.mutateRowsTs(args.tableName, args.rowBatches, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRowsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_atomicIncrement(self, seqid, iprot, oprot):
    args = atomicIncrement_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = atomicIncrement_result()
    try:
      result.success = self._handler.atomicIncrement(args.tableName, args.row, args.column, args.value)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("atomicIncrement", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAll(self, seqid, iprot, oprot):
    args = deleteAll_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAll_result()
    try:
      self._handler.deleteAll(args.tableName, args.row, args.column, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAll", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllTs(self, seqid, iprot, oprot):
    args = deleteAllTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllTs_result()
    try:
      self._handler.deleteAllTs(args.tableName, args.row, args.column, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllRow(self, seqid, iprot, oprot):
    args = deleteAllRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllRow_result()
    try:
      self._handler.deleteAllRow(args.tableName, args.row, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_increment(self, seqid, iprot, oprot):
    args = increment_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = increment_result()
    try:
      self._handler.increment(args.increment)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("increment", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_incrementRows(self, seqid, iprot, oprot):
    args = incrementRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = incrementRows_result()
    try:
      self._handler.incrementRows(args.increments)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("incrementRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllRowTs(self, seqid, iprot, oprot):
    args = deleteAllRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllRowTs_result()
    try:
      self._handler.deleteAllRowTs(args.tableName, args.row, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithScan(self, seqid, iprot, oprot):
    args = scannerOpenWithScan_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithScan_result()
    try:
      result.success = self._handler.scannerOpenWithScan(args.tableName, args.scan, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithScan", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpen(self, seqid, iprot, oprot):
    args = scannerOpen_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpen_result()
    try:
      result.success = self._handler.scannerOpen(args.tableName, args.startRow, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpen", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithStop(self, seqid, iprot, oprot):
    args = scannerOpenWithStop_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithStop_result()
    try:
      result.success = self._handler.scannerOpenWithStop(args.tableName, args.startRow, args.stopRow, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithStop", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithPrefix(self, seqid, iprot, oprot):
    args = scannerOpenWithPrefix_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithPrefix_result()
    try:
      result.success = self._handler.scannerOpenWithPrefix(args.tableName, args.startAndPrefix, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithPrefix", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenTs(self, seqid, iprot, oprot):
    args = scannerOpenTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenTs_result()
    try:
      result.success = self._handler.scannerOpenTs(args.tableName, args.startRow, args.columns, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithStopTs(self, seqid, iprot, oprot):
    args = scannerOpenWithStopTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithStopTs_result()
    try:
      result.success = self._handler.scannerOpenWithStopTs(args.tableName, args.startRow, args.stopRow, args.columns, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithStopTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerGet(self, seqid, iprot, oprot):
    args = scannerGet_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerGet_result()
    try:
      result.success = self._handler.scannerGet(args.id)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerGet", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerGetList(self, seqid, iprot, oprot):
    args = scannerGetList_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerGetList_result()
    try:
      result.success = self._handler.scannerGetList(args.id, args.nbRows)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerGetList", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerClose(self, seqid, iprot, oprot):
    args = scannerClose_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerClose_result()
    try:
      self._handler.scannerClose(args.id)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerClose", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowOrBefore(self, seqid, iprot, oprot):
    args = getRowOrBefore_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowOrBefore_result()
    try:
      result.success = self._handler.getRowOrBefore(args.tableName, args.row, args.family)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowOrBefore", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRegionInfo(self, seqid, iprot, oprot):
    args = getRegionInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRegionInfo_result()
    try:
      result.success = self._handler.getRegionInfo(args.row)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRegionInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class enableTable_args:
  """
  Attributes:
   - tableName: name of the table
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enableTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class enableTable_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enableTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class disableTable_args:
  """
  Attributes:
   - tableName: name of the table
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('disableTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class disableTable_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('disableTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class isTableEnabled_args:
  """
  Attributes:
   - tableName: name of the table to check
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('isTableEnabled_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class isTableEnabled_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('isTableEnabled_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class compact_args:
  """
  Attributes:
   - tableNameOrRegionName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableNameOrRegionName', None, None, ), # 1
  )

  def __init__(self, tableNameOrRegionName=None,):
    self.tableNameOrRegionName = tableNameOrRegionName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableNameOrRegionName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('compact_args')
    if self.tableNameOrRegionName is not None:
      oprot.writeFieldBegin('tableNameOrRegionName', TType.STRING, 1)
      oprot.writeString(self.tableNameOrRegionName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class compact_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('compact_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class majorCompact_args:
  """
  Attributes:
   - tableNameOrRegionName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableNameOrRegionName', None, None, ), # 1
  )

  def __init__(self, tableNameOrRegionName=None,):
    self.tableNameOrRegionName = tableNameOrRegionName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableNameOrRegionName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('majorCompact_args')
    if self.tableNameOrRegionName is not None:
      oprot.writeFieldBegin('tableNameOrRegionName', TType.STRING, 1)
      oprot.writeString(self.tableNameOrRegionName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class majorCompact_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('majorCompact_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableNames_args:

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableNames_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableNames_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype26, _size23) = iprot.readListBegin()
          for _i27 in xrange(_size23):
            _elem28 = iprot.readString();
            self.success.append(_elem28)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableNames_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter29 in self.success:
        oprot.writeString(iter29)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getColumnDescriptors_args:
  """
  Attributes:
   - tableName: table name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getColumnDescriptors_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getColumnDescriptors_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING,None,TType.STRUCT,(ColumnDescriptor, ColumnDescriptor.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype31, _vtype32, _size30 ) = iprot.readMapBegin() 
          for _i34 in xrange(_size30):
            _key35 = iprot.readString();
            _val36 = ColumnDescriptor()
            _val36.read(iprot)
            self.success[_key35] = _val36
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getColumnDescriptors_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.success))
      for kiter37,viter38 in self.success.items():
        oprot.writeString(kiter37)
        viter38.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableRegions_args:
  """
  Attributes:
   - tableName: table name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableRegions_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableRegions_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRegionInfo, TRegionInfo.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype42, _size39) = iprot.readListBegin()
          for _i43 in xrange(_size39):
            _elem44 = TRegionInfo()
            _elem44.read(iprot)
            self.success.append(_elem44)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableRegions_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter45 in self.success:
        iter45.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTable_args:
  """
  Attributes:
   - tableName: name of table to create
   - columnFamilies: list of column family descriptors
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'columnFamilies', (TType.STRUCT,(ColumnDescriptor, ColumnDescriptor.thrift_spec)), None, ), # 2
  )

  def __init__(self, tableName=None, columnFamilies=None,):
    self.tableName = tableName
    self.columnFamilies = columnFamilies

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.columnFamilies = []
          (_etype49, _size46) = iprot.readListBegin()
          for _i50 in xrange(_size46):
            _elem51 = ColumnDescriptor()
            _elem51.read(iprot)
            self.columnFamilies.append(_elem51)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.columnFamilies is not None:
      oprot.writeFieldBegin('columnFamilies', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.columnFamilies))
      for iter52 in self.columnFamilies:
        iter52.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTable_result:
  """
  Attributes:
   - io
   - ia
   - exist
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'exist', (AlreadyExists, AlreadyExists.thrift_spec), None, ), # 3
  )

  def __init__(self, io=None, ia=None, exist=None,):
    self.io = io
    self.ia = ia
    self.exist = exist

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.exist = AlreadyExists()
          self.exist.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    if self.exist is not None:
      oprot.writeFieldBegin('exist', TType.STRUCT, 3)
      self.exist.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteTable_args:
  """
  Attributes:
   - tableName: name of table to delete
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteTable_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype54, _vtype55, _size53 ) = iprot.readMapBegin() 
          for _i57 in xrange(_size53):
            _key58 = iprot.readString();
            _val59 = iprot.readString();
            self.attributes[_key58] = _val59
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter60,viter61 in self.attributes.items():
        oprot.writeString(kiter60)
        oprot.writeString(viter61)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype65, _size62) = iprot.readListBegin()
          for _i66 in xrange(_size62):
            _elem67 = TCell()
            _elem67.read(iprot)
            self.success.append(_elem67)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter68 in self.success:
        iter68.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVer_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - numVersions: number of versions to retrieve
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I32, 'numVersions', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, row=None, column=None, numVersions=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.numVersions = numVersions
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.numVersions = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype70, _vtype71, _size69 ) = iprot.readMapBegin() 
          for _i73 in xrange(_size69):
            _key74 = iprot.readString();
            _val75 = iprot.readString();
            self.attributes[_key74] = _val75
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVer_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.numVersions is not None:
      oprot.writeFieldBegin('numVersions', TType.I32, 4)
      oprot.writeI32(self.numVersions)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter76,viter77 in self.attributes.items():
        oprot.writeString(kiter76)
        oprot.writeString(viter77)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVer_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype81, _size78) = iprot.readListBegin()
          for _i82 in xrange(_size78):
            _elem83 = TCell()
            _elem83.read(iprot)
            self.success.append(_elem83)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVer_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter84 in self.success:
        iter84.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVerTs_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - timestamp: timestamp
   - numVersions: number of versions to retrieve
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.I32, 'numVersions', None, None, ), # 5
    (6, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 6
  )

  def __init__(self, tableName=None, row=None, column=None, timestamp=None, numVersions=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.timestamp = timestamp
    self.numVersions = numVersions
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.numVersions = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype86, _vtype87, _size85 ) = iprot.readMapBegin() 
          for _i89 in xrange(_size85):
            _key90 = iprot.readString();
            _val91 = iprot.readString();
            self.attributes[_key90] = _val91
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVerTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.numVersions is not None:
      oprot.writeFieldBegin('numVersions', TType.I32, 5)
      oprot.writeI32(self.numVersions)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 6)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter92,viter93 in self.attributes.items():
        oprot.writeString(kiter92)
        oprot.writeString(viter93)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVerTs_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype97, _size94) = iprot.readListBegin()
          for _i98 in xrange(_size94):
            _elem99 = TCell()
            _elem99.read(iprot)
            self.success.append(_elem99)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVerTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter100 in self.success:
        iter100.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRow_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, row=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype102, _vtype103, _size101 ) = iprot.readMapBegin() 
          for _i105 in xrange(_size101):
            _key106 = iprot.readString();
            _val107 = iprot.readString();
            self.attributes[_key106] = _val107
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter108,viter109 in self.attributes.items():
        oprot.writeString(kiter108)
        oprot.writeString(viter109)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRow_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype113, _size110) = iprot.readListBegin()
          for _i114 in xrange(_size110):
            _elem115 = TRowResult()
            _elem115.read(iprot)
            self.success.append(_elem115)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRow_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter116 in self.success:
        iter116.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumns_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - columns: List of columns to return, null for all columns
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype120, _size117) = iprot.readListBegin()
          for _i121 in xrange(_size117):
            _elem122 = iprot.readString();
            self.columns.append(_elem122)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype124, _vtype125, _size123 ) = iprot.readMapBegin() 
          for _i127 in xrange(_size123):
            _key128 = iprot.readString();
            _val129 = iprot.readString();
            self.attributes[_key128] = _val129
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumns_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter130 in self.columns:
        oprot.writeString(iter130)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter131,viter132 in self.attributes.items():
        oprot.writeString(kiter131)
        oprot.writeString(viter132)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumns_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype136, _size133) = iprot.readListBegin()
          for _i137 in xrange(_size133):
            _elem138 = TRowResult()
            _elem138.read(iprot)
            self.success.append(_elem138)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumns_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter139 in self.success:
        iter139.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowTs_args:
  """
  Attributes:
   - tableName: name of the table
   - row: row key
   - timestamp: timestamp
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype141, _vtype142, _size140 ) = iprot.readMapBegin() 
          for _i144 in xrange(_size140):
            _key145 = iprot.readString();
            _val146 = iprot.readString();
            self.attributes[_key145] = _val146
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter147,viter148 in self.attributes.items():
        oprot.writeString(kiter147)
        oprot.writeString(viter148)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowTs_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype152, _size149) = iprot.readListBegin()
          for _i153 in xrange(_size149):
            _elem154 = TRowResult()
            _elem154.read(iprot)
            self.success.append(_elem154)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter155 in self.success:
        iter155.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumnsTs_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - columns: List of columns to return, null for all columns
   - timestamp
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, row=None, columns=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.columns = columns
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype159, _size156) = iprot.readListBegin()
          for _i160 in xrange(_size156):
            _elem161 = iprot.readString();
            self.columns.append(_elem161)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype163, _vtype164, _size162 ) = iprot.readMapBegin() 
          for _i166 in xrange(_size162):
            _key167 = iprot.readString();
            _val168 = iprot.readString();
            self.attributes[_key167] = _val168
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumnsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter169 in self.columns:
        oprot.writeString(iter169)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter170,viter171 in self.attributes.items():
        oprot.writeString(kiter170)
        oprot.writeString(viter171)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumnsTs_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype175, _size172) = iprot.readListBegin()
          for _i176 in xrange(_size172):
            _elem177 = TRowResult()
            _elem177.read(iprot)
            self.success.append(_elem177)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumnsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter178 in self.success:
        iter178.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRows_args:
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, rows=None, attributes=None,):
    self.tableName = tableName
    self.rows = rows
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype182, _size179) = iprot.readListBegin()
          for _i183 in xrange(_size179):
            _elem184 = iprot.readString();
            self.rows.append(_elem184)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype186, _vtype187, _size185 ) = iprot.readMapBegin() 
          for _i189 in xrange(_size185):
            _key190 = iprot.readString();
            _val191 = iprot.readString();
            self.attributes[_key190] = _val191
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRows_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter192 in self.rows:
        oprot.writeString(iter192)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter193,viter194 in self.attributes.items():
        oprot.writeString(kiter193)
        oprot.writeString(viter194)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRows_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype198, _size195) = iprot.readListBegin()
          for _i199 in xrange(_size195):
            _elem200 = TRowResult()
            _elem200.read(iprot)
            self.success.append(_elem200)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRows_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter201 in self.success:
        iter201.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumns_args:
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
   - columns: List of columns to return, null for all columns
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, rows=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.rows = rows
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype205, _size202) = iprot.readListBegin()
          for _i206 in xrange(_size202):
            _elem207 = iprot.readString();
            self.rows.append(_elem207)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype211, _size208) = iprot.readListBegin()
          for _i212 in xrange(_size208):
            _elem213 = iprot.readString();
            self.columns.append(_elem213)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype215, _vtype216, _size214 ) = iprot.readMapBegin() 
          for _i218 in xrange(_size214):
            _key219 = iprot.readString();
            _val220 = iprot.readString();
            self.attributes[_key219] = _val220
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumns_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter221 in self.rows:
        oprot.writeString(iter221)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter222 in self.columns:
        oprot.writeString(iter222)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter223,viter224 in self.attributes.items():
        oprot.writeString(kiter223)
        oprot.writeString(viter224)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumns_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype228, _size225) = iprot.readListBegin()
          for _i229 in xrange(_size225):
            _elem230 = TRowResult()
            _elem230.read(iprot)
            self.success.append(_elem230)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumns_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter231 in self.success:
        iter231.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsTs_args:
  """
  Attributes:
   - tableName: name of the table
   - rows: row keys
   - timestamp: timestamp
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, rows=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.rows = rows
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype235, _size232) = iprot.readListBegin()
          for _i236 in xrange(_size232):
            _elem237 = iprot.readString();
            self.rows.append(_elem237)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype239, _vtype240, _size238 ) = iprot.readMapBegin() 
          for _i242 in xrange(_size238):
            _key243 = iprot.readString();
            _val244 = iprot.readString();
            self.attributes[_key243] = _val244
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter245 in self.rows:
        oprot.writeString(iter245)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter246,viter247 in self.attributes.items():
        oprot.writeString(kiter246)
        oprot.writeString(viter247)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsTs_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype251, _size248) = iprot.readListBegin()
          for _i252 in xrange(_size248):
            _elem253 = TRowResult()
            _elem253.read(iprot)
            self.success.append(_elem253)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter254 in self.success:
        iter254.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumnsTs_args:
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
   - columns: List of columns to return, null for all columns
   - timestamp
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, rows=None, columns=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.rows = rows
    self.columns = columns
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype258, _size255) = iprot.readListBegin()
          for _i259 in xrange(_size255):
            _elem260 = iprot.readString();
            self.rows.append(_elem260)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype264, _size261) = iprot.readListBegin()
          for _i265 in xrange(_size261):
            _elem266 = iprot.readString();
            self.columns.append(_elem266)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype268, _vtype269, _size267 ) = iprot.readMapBegin() 
          for _i271 in xrange(_size267):
            _key272 = iprot.readString();
            _val273 = iprot.readString();
            self.attributes[_key272] = _val273
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumnsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter274 in self.rows:
        oprot.writeString(iter274)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter275 in self.columns:
        oprot.writeString(iter275)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter276,viter277 in self.attributes.items():
        oprot.writeString(kiter276)
        oprot.writeString(viter277)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumnsTs_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype281, _size278) = iprot.readListBegin()
          for _i282 in xrange(_size278):
            _elem283 = TRowResult()
            _elem283.read(iprot)
            self.success.append(_elem283)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumnsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter284 in self.success:
        iter284.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRow_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - mutations: list of mutation commands
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'mutations', (TType.STRUCT,(Mutation, Mutation.thrift_spec)), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, mutations=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.mutations = mutations
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.mutations = []
          (_etype288, _size285) = iprot.readListBegin()
          for _i289 in xrange(_size285):
            _elem290 = Mutation()
            _elem290.read(iprot)
            self.mutations.append(_elem290)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype292, _vtype293, _size291 ) = iprot.readMapBegin() 
          for _i295 in xrange(_size291):
            _key296 = iprot.readString();
            _val297 = iprot.readString();
            self.attributes[_key296] = _val297
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.mutations is not None:
      oprot.writeFieldBegin('mutations', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.mutations))
      for iter298 in self.mutations:
        iter298.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter299,viter300 in self.attributes.items():
        oprot.writeString(kiter299)
        oprot.writeString(viter300)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRow_result:
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRow_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowTs_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - mutations: list of mutation commands
   - timestamp: timestamp
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'mutations', (TType.STRUCT,(Mutation, Mutation.thrift_spec)), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, row=None, mutations=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.mutations = mutations
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.mutations = []
          (_etype304, _size301) = iprot.readListBegin()
          for _i305 in xrange(_size301):
            _elem306 = Mutation()
            _elem306.read(iprot)
            self.mutations.append(_elem306)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype308, _vtype309, _size307 ) = iprot.readMapBegin() 
          for _i311 in xrange(_size307):
            _key312 = iprot.readString();
            _val313 = iprot.readString();
            self.attributes[_key312] = _val313
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.mutations is not None:
      oprot.writeFieldBegin('mutations', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.mutations))
      for iter314 in self.mutations:
        iter314.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter315,viter316 in self.attributes.items():
        oprot.writeString(kiter315)
        oprot.writeString(viter316)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowTs_result:
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRows_args:
  """
  Attributes:
   - tableName: name of table
   - rowBatches: list of row batches
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rowBatches', (TType.STRUCT,(BatchMutation, BatchMutation.thrift_spec)), None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, rowBatches=None, attributes=None,):
    self.tableName = tableName
    self.rowBatches = rowBatches
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rowBatches = []
          (_etype320, _size317) = iprot.readListBegin()
          for _i321 in xrange(_size317):
            _elem322 = BatchMutation()
            _elem322.read(iprot)
            self.rowBatches.append(_elem322)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype324, _vtype325, _size323 ) = iprot.readMapBegin() 
          for _i327 in xrange(_size323):
            _key328 = iprot.readString();
            _val329 = iprot.readString();
            self.attributes[_key328] = _val329
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRows_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rowBatches is not None:
      oprot.writeFieldBegin('rowBatches', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.rowBatches))
      for iter330 in self.rowBatches:
        iter330.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter331,viter332 in self.attributes.items():
        oprot.writeString(kiter331)
        oprot.writeString(viter332)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRows_result:
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRows_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowsTs_args:
  """
  Attributes:
   - tableName: name of table
   - rowBatches: list of row batches
   - timestamp: timestamp
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rowBatches', (TType.STRUCT,(BatchMutation, BatchMutation.thrift_spec)), None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, rowBatches=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.rowBatches = rowBatches
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rowBatches = []
          (_etype336, _size333) = iprot.readListBegin()
          for _i337 in xrange(_size333):
            _elem338 = BatchMutation()
            _elem338.read(iprot)
            self.rowBatches.append(_elem338)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype340, _vtype341, _size339 ) = iprot.readMapBegin() 
          for _i343 in xrange(_size339):
            _key344 = iprot.readString();
            _val345 = iprot.readString();
            self.attributes[_key344] = _val345
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rowBatches is not None:
      oprot.writeFieldBegin('rowBatches', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.rowBatches))
      for iter346 in self.rowBatches:
        iter346.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter347,viter348 in self.attributes.items():
        oprot.writeString(kiter347)
        oprot.writeString(viter348)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowsTs_result:
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowsTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class atomicIncrement_args:
  """
  Attributes:
   - tableName: name of table
   - row: row to increment
   - column: name of column
   - value: amount to increment by
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'value', None, None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, value=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.value = value

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.value = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('atomicIncrement_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.I64, 4)
      oprot.writeI64(self.value)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class atomicIncrement_result:
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.I64, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I64:
          self.success = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('atomicIncrement_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I64, 0)
      oprot.writeI64(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAll_args:
  """
  Attributes:
   - tableName: name of table
   - row: Row to update
   - column: name of column whose value is to be deleted
   - attributes: Delete attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype350, _vtype351, _size349 ) = iprot.readMapBegin() 
          for _i353 in xrange(_size349):
            _key354 = iprot.readString();
            _val355 = iprot.readString();
            self.attributes[_key354] = _val355
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAll_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter356,viter357 in self.attributes.items():
        oprot.writeString(kiter356)
        oprot.writeString(viter357)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAll_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAll_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllTs_args:
  """
  Attributes:
   - tableName: name of table
   - row: Row to update
   - column: name of column whose value is to be deleted
   - timestamp: timestamp
   - attributes: Delete attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, row=None, column=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype359, _vtype360, _size358 ) = iprot.readMapBegin() 
          for _i362 in xrange(_size358):
            _key363 = iprot.readString();
            _val364 = iprot.readString();
            self.attributes[_key363] = _val364
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter365,viter366 in self.attributes.items():
        oprot.writeString(kiter365)
        oprot.writeString(viter366)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllTs_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRow_args:
  """
  Attributes:
   - tableName: name of table
   - row: key of the row to be completely deleted.
   - attributes: Delete attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, row=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype368, _vtype369, _size367 ) = iprot.readMapBegin() 
          for _i371 in xrange(_size367):
            _key372 = iprot.readString();
            _val373 = iprot.readString();
            self.attributes[_key372] = _val373
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter374,viter375 in self.attributes.items():
        oprot.writeString(kiter374)
        oprot.writeString(viter375)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRow_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRow_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class increment_args:
  """
  Attributes:
   - increment: The single increment to apply
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'increment', (TIncrement, TIncrement.thrift_spec), None, ), # 1
  )

  def __init__(self, increment=None,):
    self.increment = increment

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.increment = TIncrement()
          self.increment.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('increment_args')
    if self.increment is not None:
      oprot.writeFieldBegin('increment', TType.STRUCT, 1)
      self.increment.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class increment_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('increment_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class incrementRows_args:
  """
  Attributes:
   - increments: The list of increments
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'increments', (TType.STRUCT,(TIncrement, TIncrement.thrift_spec)), None, ), # 1
  )

  def __init__(self, increments=None,):
    self.increments = increments

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.increments = []
          (_etype379, _size376) = iprot.readListBegin()
          for _i380 in xrange(_size376):
            _elem381 = TIncrement()
            _elem381.read(iprot)
            self.increments.append(_elem381)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('incrementRows_args')
    if self.increments is not None:
      oprot.writeFieldBegin('increments', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.increments))
      for iter382 in self.increments:
        iter382.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class incrementRows_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('incrementRows_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRowTs_args:
  """
  Attributes:
   - tableName: name of table
   - row: key of the row to be completely deleted.
   - timestamp: timestamp
   - attributes: Delete attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype384, _vtype385, _size383 ) = iprot.readMapBegin() 
          for _i387 in xrange(_size383):
            _key388 = iprot.readString();
            _val389 = iprot.readString();
            self.attributes[_key388] = _val389
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter390,viter391 in self.attributes.items():
        oprot.writeString(kiter390)
        oprot.writeString(viter391)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRowTs_result:
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRowTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithScan_args:
  """
  Attributes:
   - tableName: name of table
   - scan: Scan instance
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRUCT, 'scan', (TScan, TScan.thrift_spec), None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, scan=None, attributes=None,):
    self.tableName = tableName
    self.scan = scan
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.scan = TScan()
          self.scan.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype393, _vtype394, _size392 ) = iprot.readMapBegin() 
          for _i396 in xrange(_size392):
            _key397 = iprot.readString();
            _val398 = iprot.readString();
            self.attributes[_key397] = _val398
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithScan_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.scan is not None:
      oprot.writeFieldBegin('scan', TType.STRUCT, 2)
      self.scan.write(oprot)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter399,viter400 in self.attributes.items():
        oprot.writeString(kiter399)
        oprot.writeString(viter400)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithScan_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithScan_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpen_args:
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, startRow=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype404, _size401) = iprot.readListBegin()
          for _i405 in xrange(_size401):
            _elem406 = iprot.readString();
            self.columns.append(_elem406)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype408, _vtype409, _size407 ) = iprot.readMapBegin() 
          for _i411 in xrange(_size407):
            _key412 = iprot.readString();
            _val413 = iprot.readString();
            self.attributes[_key412] = _val413
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpen_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter414 in self.columns:
        oprot.writeString(iter414)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter415,viter416 in self.attributes.items():
        oprot.writeString(kiter415)
        oprot.writeString(viter416)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpen_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpen_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStop_args:
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - stopRow: row to stop scanning on. This row is *not* included in the
  scanner's results
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.STRING, 'stopRow', None, None, ), # 3
    (4, TType.LIST, 'columns', (TType.STRING,None), None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, startRow=None, stopRow=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.stopRow = stopRow
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.stopRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.columns = []
          (_etype420, _size417) = iprot.readListBegin()
          for _i421 in xrange(_size417):
            _elem422 = iprot.readString();
            self.columns.append(_elem422)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype424, _vtype425, _size423 ) = iprot.readMapBegin() 
          for _i427 in xrange(_size423):
            _key428 = iprot.readString();
            _val429 = iprot.readString();
            self.attributes[_key428] = _val429
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStop_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.stopRow is not None:
      oprot.writeFieldBegin('stopRow', TType.STRING, 3)
      oprot.writeString(self.stopRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter430 in self.columns:
        oprot.writeString(iter430)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter431,viter432 in self.attributes.items():
        oprot.writeString(kiter431)
        oprot.writeString(viter432)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStop_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStop_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithPrefix_args:
  """
  Attributes:
   - tableName: name of table
   - startAndPrefix: the prefix (and thus start row) of the keys you want
   - columns: the columns you want returned
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startAndPrefix', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, startAndPrefix=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.startAndPrefix = startAndPrefix
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startAndPrefix = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype436, _size433) = iprot.readListBegin()
          for _i437 in xrange(_size433):
            _elem438 = iprot.readString();
            self.columns.append(_elem438)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype440, _vtype441, _size439 ) = iprot.readMapBegin() 
          for _i443 in xrange(_size439):
            _key444 = iprot.readString();
            _val445 = iprot.readString();
            self.attributes[_key444] = _val445
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithPrefix_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startAndPrefix is not None:
      oprot.writeFieldBegin('startAndPrefix', TType.STRING, 2)
      oprot.writeString(self.startAndPrefix)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter446 in self.columns:
        oprot.writeString(iter446)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter447,viter448 in self.attributes.items():
        oprot.writeString(kiter447)
        oprot.writeString(viter448)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithPrefix_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithPrefix_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenTs_args:
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - timestamp: timestamp
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, startRow=None, columns=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.columns = columns
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype452, _size449) = iprot.readListBegin()
          for _i453 in xrange(_size449):
            _elem454 = iprot.readString();
            self.columns.append(_elem454)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype456, _vtype457, _size455 ) = iprot.readMapBegin() 
          for _i459 in xrange(_size455):
            _key460 = iprot.readString();
            _val461 = iprot.readString();
            self.attributes[_key460] = _val461
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter462 in self.columns:
        oprot.writeString(iter462)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter463,viter464 in self.attributes.items():
        oprot.writeString(kiter463)
        oprot.writeString(viter464)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenTs_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStopTs_args:
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - stopRow: row to stop scanning on. This row is *not* included in the
  scanner's results
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - timestamp: timestamp
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.STRING, 'stopRow', None, None, ), # 3
    (4, TType.LIST, 'columns', (TType.STRING,None), None, ), # 4
    (5, TType.I64, 'timestamp', None, None, ), # 5
    (6, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 6
  )

  def __init__(self, tableName=None, startRow=None, stopRow=None, columns=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.stopRow = stopRow
    self.columns = columns
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.stopRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.columns = []
          (_etype468, _size465) = iprot.readListBegin()
          for _i469 in xrange(_size465):
            _elem470 = iprot.readString();
            self.columns.append(_elem470)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype472, _vtype473, _size471 ) = iprot.readMapBegin() 
          for _i475 in xrange(_size471):
            _key476 = iprot.readString();
            _val477 = iprot.readString();
            self.attributes[_key476] = _val477
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStopTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.stopRow is not None:
      oprot.writeFieldBegin('stopRow', TType.STRING, 3)
      oprot.writeString(self.stopRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter478 in self.columns:
        oprot.writeString(iter478)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 5)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 6)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter479,viter480 in self.attributes.items():
        oprot.writeString(kiter479)
        oprot.writeString(viter480)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStopTs_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStopTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGet_args:
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
  )

  def __init__(self, id=None,):
    self.id = id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGet_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGet_result:
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype484, _size481) = iprot.readListBegin()
          for _i485 in xrange(_size481):
            _elem486 = TRowResult()
            _elem486.read(iprot)
            self.success.append(_elem486)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGet_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter487 in self.success:
        iter487.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGetList_args:
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
   - nbRows: number of results to return
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
    (2, TType.I32, 'nbRows', None, None, ), # 2
  )

  def __init__(self, id=None, nbRows=None,):
    self.id = id
    self.nbRows = nbRows

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.nbRows = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGetList_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    if self.nbRows is not None:
      oprot.writeFieldBegin('nbRows', TType.I32, 2)
      oprot.writeI32(self.nbRows)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGetList_result:
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype491, _size488) = iprot.readListBegin()
          for _i492 in xrange(_size488):
            _elem493 = TRowResult()
            _elem493.read(iprot)
            self.success.append(_elem493)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGetList_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter494 in self.success:
        iter494.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerClose_args:
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
  )

  def __init__(self, id=None,):
    self.id = id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerClose_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerClose_result:
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerClose_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowOrBefore_args:
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - family: column name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'family', None, None, ), # 3
  )

  def __init__(self, tableName=None, row=None, family=None,):
    self.tableName = tableName
    self.row = row
    self.family = family

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.family = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowOrBefore_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.family is not None:
      oprot.writeFieldBegin('family', TType.STRING, 3)
      oprot.writeString(self.family)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowOrBefore_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype498, _size495) = iprot.readListBegin()
          for _i499 in xrange(_size495):
            _elem500 = TCell()
            _elem500.read(iprot)
            self.success.append(_elem500)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowOrBefore_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter501 in self.success:
        iter501.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRegionInfo_args:
  """
  Attributes:
   - row: row key
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'row', None, None, ), # 1
  )

  def __init__(self, row=None,):
    self.row = row

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRegionInfo_args')
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 1)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRegionInfo_result:
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (TRegionInfo, TRegionInfo.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = TRegionInfo()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRegionInfo_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
