/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.collect.Lists;
import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestRpcClient {
    private static final Log LOG = LogFactory.getLog(IntegrationTestRpcClient.class);
    private final Configuration conf = HBaseConfiguration.create();
    private int numIterations = 10;
    static String BIG_PAYLOAD;

    protected AbstractRpcClient<?> createRpcClient(Configuration conf, boolean isSyncClient) {
        return isSyncClient ? new BlockingRpcClient(conf) : new NettyRpcClient(conf){

            Codec getCodec() {
                return null;
            }
        };
    }

    @Test(timeout=30000L)
    public void testRpcWithWriteThread() throws IOException, InterruptedException {
        LOG.info((Object)"Starting test");
        Cluster cluster = new Cluster(1, 1);
        cluster.startServer();
        this.conf.setBoolean("hbase.ipc.client.specificThreadForWriting", true);
        for (int i = 0; i < 1000; ++i) {
            AbstractRpcClient<?> rpcClient = this.createRpcClient(this.conf, true);
            SimpleClient client = new SimpleClient(cluster, rpcClient, "Client1");
            client.start();
            while (!client.isSending()) {
                Thread.sleep(1L);
            }
            client.stopRunning();
            rpcClient.close();
        }
    }

    @Test(timeout=1800000L)
    public void testRpcWithChaosMonkeyWithSyncClient() throws Throwable {
        for (int i = 0; i < this.numIterations; ++i) {
            TimeoutThread.runWithTimeout(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        IntegrationTestRpcClient.this.testRpcWithChaosMonkey(true);
                    }
                    catch (Throwable e) {
                        if (e instanceof Exception) {
                            throw (Exception)e;
                        }
                        throw new Exception(e);
                    }
                    return null;
                }
            }, 180000L);
        }
    }

    @Test(timeout=900000L)
    @Ignore
    public void testRpcWithChaosMonkeyWithAsyncClient() throws Throwable {
        for (int i = 0; i < this.numIterations; ++i) {
            TimeoutThread.runWithTimeout(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        IntegrationTestRpcClient.this.testRpcWithChaosMonkey(false);
                    }
                    catch (Throwable e) {
                        if (e instanceof Exception) {
                            throw (Exception)e;
                        }
                        throw new Exception(e);
                    }
                    return null;
                }
            }, 90000L);
        }
    }

    public void testRpcWithChaosMonkey(boolean isSyncClient) throws Throwable {
        LOG.info((Object)"Starting test");
        Cluster cluster = new Cluster(10, 100);
        for (int i = 0; i < 10; ++i) {
            cluster.startServer();
        }
        ArrayList<SimpleClient> clients = new ArrayList<SimpleClient>();
        AbstractRpcClient<?> rpcClient = this.createRpcClient(this.conf, isSyncClient);
        for (int i = 0; i < 30; ++i) {
            String clientId = "client_" + i + "_";
            LOG.info((Object)("Starting client: " + clientId));
            SimpleClient client = new SimpleClient(cluster, rpcClient, clientId);
            client.start();
            clients.add(client);
        }
        LOG.info((Object)"Starting MiniChaosMonkey");
        MiniChaosMonkey cm = new MiniChaosMonkey(cluster);
        cm.start();
        Threads.sleep((long)30000L);
        LOG.info((Object)"Stopping MiniChaosMonkey");
        cm.stopRunning();
        cm.join();
        cm.rethrowException();
        LOG.info((Object)"Stopping clients");
        for (SimpleClient client : clients) {
            LOG.info((Object)("Stopping client: " + client.id));
            LOG.info((Object)(client.id + " numCalls:" + client.numCalls));
            client.stopRunning();
            client.join();
            client.rethrowException();
            Assert.assertTrue((client.numCalls > 10L ? 1 : 0) != 0);
        }
        LOG.info((Object)"Stopping RpcClient");
        rpcClient.close();
        LOG.info((Object)"Stopping Cluster");
        cluster.stopRunning();
    }

    static {
        StringBuilder builder = new StringBuilder();
        while (builder.length() < 0x100000) {
            builder.append("big.payload.");
        }
        BIG_PAYLOAD = builder.toString();
    }

    static class TimeoutThread
    extends Thread {
        long timeout;

        public TimeoutThread(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
                Threads.printThreadInfo((PrintStream)System.err, (String)"TEST TIMEOUT STACK DUMP");
                System.exit(1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        static void runWithTimeout(Callable<?> callable, long timeout) throws Exception {
            TimeoutThread thread = new TimeoutThread(timeout);
            thread.start();
            callable.call();
            thread.interrupt();
        }
    }

    static class SimpleClient
    extends Thread {
        AbstractRpcClient<?> rpcClient;
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicBoolean sending = new AtomicBoolean(false);
        AtomicReference<Throwable> exception = new AtomicReference<Object>(null);
        Cluster cluster;
        String id;
        long numCalls = 0L;
        Random random = new Random();

        public SimpleClient(Cluster cluster, AbstractRpcClient<?> rpcClient, String id) {
            this.cluster = cluster;
            this.rpcClient = rpcClient;
            this.id = id;
            this.setName(id);
        }

        @Override
        public void run() {
            while (this.running.get()) {
                TestProtos.EchoResponseProto ret;
                boolean isBigPayload = this.random.nextBoolean();
                String message = isBigPayload ? BIG_PAYLOAD : this.id + this.numCalls;
                TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage(message).build();
                TestRpcServer server = this.cluster.getRandomServer();
                try {
                    this.sending.set(true);
                    TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub(this.rpcClient, (InetSocketAddress)server.getListenerAddress());
                    ret = stub.echo(null, param);
                }
                catch (Exception e) {
                    LOG.warn((Object)e);
                    continue;
                }
                try {
                    Assert.assertNotNull((Object)ret);
                    Assert.assertEquals((Object)message, (Object)ret.getMessage());
                }
                catch (Throwable t) {
                    this.exception.compareAndSet(null, t);
                }
                ++this.numCalls;
            }
        }

        void stopRunning() {
            this.running.set(false);
        }

        boolean isSending() {
            return this.sending.get();
        }

        void rethrowException() throws Throwable {
            if (this.exception.get() != null) {
                throw this.exception.get();
            }
        }
    }

    static class MiniChaosMonkey
    extends Thread {
        AtomicBoolean running = new AtomicBoolean(true);
        Random random = new Random();
        AtomicReference<Exception> exception = new AtomicReference<Object>(null);
        Cluster cluster;

        public MiniChaosMonkey(Cluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public void run() {
            while (this.running.get()) {
                if (this.random.nextBoolean()) {
                    try {
                        this.cluster.startServer();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                        this.exception.compareAndSet(null, e);
                    }
                } else {
                    try {
                        this.cluster.stopRandomServer();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)e);
                        this.exception.compareAndSet(null, e);
                    }
                }
                Threads.sleep((long)100L);
            }
        }

        void stopRunning() {
            this.running.set(false);
        }

        void rethrowException() throws Exception {
            if (this.exception.get() != null) {
                throw this.exception.get();
            }
        }
    }

    class Cluster {
        Random random = new Random();
        ReadWriteLock lock = new ReentrantReadWriteLock();
        HashMap<InetSocketAddress, TestRpcServer> rpcServers = new HashMap();
        List<TestRpcServer> serverList = new ArrayList<TestRpcServer>();
        int maxServers;
        int minServers;

        Cluster(int minServers, int maxServers) {
            this.minServers = minServers;
            this.maxServers = maxServers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TestRpcServer startServer() throws IOException {
            this.lock.writeLock().lock();
            try {
                if (this.rpcServers.size() >= this.maxServers) {
                    TestRpcServer testRpcServer = null;
                    return testRpcServer;
                }
                TestRpcServer rpcServer = new TestRpcServer(IntegrationTestRpcClient.this.conf);
                rpcServer.start();
                InetSocketAddress address = rpcServer.getListenerAddress();
                if (address == null) {
                    throw new IOException("Listener channel is closed");
                }
                this.rpcServers.put(address, rpcServer);
                this.serverList.add(rpcServer);
                LOG.info((Object)("Started server: " + address));
                TestRpcServer testRpcServer = rpcServer;
                return testRpcServer;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopRandomServer() throws Exception {
            this.lock.writeLock().lock();
            TestRpcServer rpcServer = null;
            try {
                if (this.rpcServers.size() <= this.minServers) {
                    return;
                }
                int size = this.rpcServers.size();
                int rand = this.random.nextInt(size);
                rpcServer = this.serverList.remove(rand);
                InetSocketAddress address = rpcServer.getListenerAddress();
                if (address == null) {
                    throw new IOException("Listener channel is closed");
                }
                this.rpcServers.remove(address);
                if (rpcServer != null) {
                    this.stopServer(rpcServer);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        void stopServer(TestRpcServer rpcServer) throws InterruptedException {
            InetSocketAddress address = rpcServer.getListenerAddress();
            LOG.info((Object)("Stopping server: " + address));
            rpcServer.stop();
            rpcServer.join();
            LOG.info((Object)("Stopped server: " + address));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopRunning() throws InterruptedException {
            this.lock.writeLock().lock();
            try {
                for (TestRpcServer rpcServer : this.serverList) {
                    this.stopServer(rpcServer);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TestRpcServer getRandomServer() {
            this.lock.readLock().lock();
            try {
                int size = this.rpcServers.size();
                int rand = this.random.nextInt(size);
                TestRpcServer testRpcServer = this.serverList.get(rand);
                return testRpcServer;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    static class TestRpcServer
    extends RpcServer {
        TestRpcServer(Configuration conf) throws IOException {
            this((RpcScheduler)new FifoRpcScheduler(conf, 1), conf);
        }

        TestRpcServer(RpcScheduler scheduler, Configuration conf) throws IOException {
            super(null, "testRpcServer", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), new InetSocketAddress("localhost", 0), conf, scheduler);
        }

        public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status) throws IOException {
            return super.call(service, md, param, cellScanner, receiveTime, status);
        }
    }
}

