/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.DumpClusterStatusAction;
import org.apache.hadoop.hbase.chaos.actions.ForceBalancerAction;
import org.apache.hadoop.hbase.chaos.actions.RestartActiveMasterAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomDataNodeAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomRsExceptMetaAction;
import org.apache.hadoop.hbase.chaos.actions.RestartRandomZKNodeAction;
import org.apache.hadoop.hbase.chaos.actions.RollingBatchRestartRsExceptMetaAction;
import org.apache.hadoop.hbase.chaos.actions.RollingBatchSuspendResumeRsAction;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.CompositeSequentialPolicy;
import org.apache.hadoop.hbase.chaos.policies.DoActionsOncePolicy;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;

public class ServerAndDependenciesKillingMonkeyFactory
extends MonkeyFactory {
    private long rollingBatchSuspendRSSleepTime;
    private float rollingBatchSuspendtRSRatio;

    @Override
    public ChaosMonkey build() {
        this.loadProperties();
        Action[] actions1 = new Action[]{new RestartRandomRsExceptMetaAction(60000L), new RestartActiveMasterAction(5000L), new RollingBatchRestartRsExceptMetaAction(5000L, 1.0f, 2), new ForceBalancerAction(), new RestartRandomDataNodeAction(60000L), new RestartRandomZKNodeAction(60000L), new RollingBatchSuspendResumeRsAction(this.rollingBatchSuspendRSSleepTime, this.rollingBatchSuspendtRSRatio)};
        Action[] actions2 = new Action[]{new DumpClusterStatusAction()};
        return new PolicyBasedChaosMonkey(this.util, new CompositeSequentialPolicy(new DoActionsOncePolicy(60000L, actions1), new PeriodicRandomActionPolicy(60000L, actions1)), new PeriodicRandomActionPolicy(60000L, actions2));
    }

    private void loadProperties() {
        this.rollingBatchSuspendRSSleepTime = Long.parseLong(this.properties.getProperty("rolling.batch.restart.rs.sleep.time", "5000"));
        this.rollingBatchSuspendtRSRatio = Float.parseFloat(this.properties.getProperty("rolling.batch.restart.rs.ratio", "1.0"));
    }
}

