/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnbalanceRegionsAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(UnbalanceRegionsAction.class);
    private double fractionOfRegions;
    private double fractionOfServers;

    public UnbalanceRegionsAction(double fractionOfRegions, double fractionOfServers) {
        this.fractionOfRegions = fractionOfRegions;
        this.fractionOfServers = fractionOfServers;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().info("Unbalancing regions");
        ClusterStatus status = this.cluster.getClusterStatus();
        LinkedList<ServerName> victimServers = new LinkedList<ServerName>(status.getServers());
        int targetServerCount = (int)Math.ceil(this.fractionOfServers * (double)victimServers.size());
        ArrayList<ServerName> targetServers = new ArrayList<ServerName>(targetServerCount);
        for (int i = 0; i < targetServerCount; ++i) {
            int victimIx = RandomUtils.nextInt((int)victimServers.size());
            targetServers.add((ServerName)victimServers.remove(victimIx));
        }
        this.unbalanceRegions(status, victimServers, targetServers, this.fractionOfRegions);
    }
}

