/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.net.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpClusterStatusAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(DumpClusterStatusAction.class);
    private Set<Address> initialRegionServers;

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.initialRegionServers = DumpClusterStatusAction.collectKnownRegionServers(this.initialStatus);
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().debug("Performing action: Dump cluster status");
        ClusterStatus currentMetrics = this.cluster.getClusterStatus();
        this.getLogger().info("Cluster status\n{}", (Object)currentMetrics);
        this.reportMissingRegionServers(currentMetrics);
        this.reportNewRegionServers(currentMetrics);
    }

    private static Set<Address> collectKnownRegionServers(ClusterStatus clusterStatus) {
        HashSet<Address> regionServers = new HashSet<Address>();
        HashSet serverNames = new HashSet(clusterStatus.getLiveServersLoad().keySet());
        serverNames.addAll(clusterStatus.getDeadServerNames());
        for (ServerName serverName : serverNames) {
            regionServers.add(serverName.getAddress());
        }
        return Collections.unmodifiableSet(regionServers);
    }

    private void reportMissingRegionServers(ClusterStatus clusterStatus) {
        Set<Address> regionServers = DumpClusterStatusAction.collectKnownRegionServers(clusterStatus);
        HashSet<Address> missingRegionServers = new HashSet<Address>(this.initialRegionServers);
        missingRegionServers.removeAll(regionServers);
        if (!missingRegionServers.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("region server(s) are missing from this cluster report");
            ArrayList<Address> sortedAddresses = new ArrayList<Address>(missingRegionServers);
            Collections.sort(sortedAddresses);
            for (Address address : sortedAddresses) {
                stringBuilder.append("\n  ").append(address);
            }
            this.getLogger().warn(stringBuilder.toString());
        }
    }

    private void reportNewRegionServers(ClusterStatus clusterStatus) {
        Set<Address> regionServers = DumpClusterStatusAction.collectKnownRegionServers(clusterStatus);
        HashSet<Address> newRegionServers = new HashSet<Address>(regionServers);
        newRegionServers.removeAll(this.initialRegionServers);
        if (!newRegionServers.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append("region server(s) are new for this cluster report");
            ArrayList<Address> sortedAddresses = new ArrayList<Address>(newRegionServers);
            Collections.sort(sortedAddresses);
            for (Address address : sortedAddresses) {
                stringBuilder.append("\n  ").append(address);
            }
            this.getLogger().warn(stringBuilder.toString());
        }
    }
}

