/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEncodingAction
extends Action {
    private final TableName tableName;
    private Admin admin;
    private Random random;
    private static final Logger LOG = LoggerFactory.getLogger(ChangeEncodingAction.class);

    public ChangeEncodingAction(TableName tableName) {
        this.tableName = tableName;
        this.random = new Random();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
    }

    @Override
    public void perform() throws Exception {
        HTableDescriptor tableDescriptor = this.admin.getTableDescriptor(this.tableName);
        HColumnDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors == null || columnDescriptors.length == 0) {
            return;
        }
        this.getLogger().debug("Performing action: Changing encodings on " + this.tableName);
        int[] possibleIds = new int[]{0, 2, 3, 4, 6};
        for (HColumnDescriptor descriptor : columnDescriptors) {
            short id = (short)possibleIds[this.random.nextInt(possibleIds.length)];
            descriptor.setDataBlockEncoding(DataBlockEncoding.getEncodingById((short)id));
            this.getLogger().debug("Set encoding of column family " + descriptor.getNameAsString() + " to: " + descriptor.getDataBlockEncoding());
        }
        if (this.context.isStopping()) {
            return;
        }
        this.admin.modifyTable(this.tableName, tableDescriptor);
    }
}

