/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.chaos.ChaosAgent;
import org.apache.hadoop.hbase.chaos.ChaosUtils;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.util.GenericOptionsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ChaosService {
    private static final Logger LOG = LoggerFactory.getLogger((String)ChaosService.class.getName());

    public static void execute(String[] args, Configuration conf) {
        block8: {
            LOG.info("arguments : " + Arrays.toString(args));
            try {
                CommandLine cmdline = new GnuParser().parse(ChaosService.getOptions(), args);
                if (cmdline.hasOption(ChaosServiceName.CHAOSAGENT.toString().toLowerCase())) {
                    String actionStr = cmdline.getOptionValue(ChaosServiceName.CHAOSAGENT.toString().toLowerCase());
                    try {
                        ExecutorAction action = ExecutorAction.valueOf(actionStr.toUpperCase());
                        if (action == ExecutorAction.START) {
                            ChaosService.ChaosServiceStart(conf, ChaosServiceName.CHAOSAGENT);
                        } else if (action == ExecutorAction.STOP) {
                            ChaosService.ChaosServiceStop();
                        }
                        break block8;
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error("action passed: {} Unexpected action. Please provide only start/stop.", (Object)actionStr, (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                LOG.error("Invalid Options");
            }
            catch (Exception e) {
                LOG.error("Error while starting ChaosService : ", (Throwable)e);
            }
        }
    }

    private static void ChaosServiceStart(Configuration conf, ChaosServiceName serviceName) {
        switch (serviceName) {
            case CHAOSAGENT: {
                ChaosAgent.stopChaosAgent.set(false);
                try {
                    Thread t = new Thread(new ChaosAgent(conf, ChaosUtils.getZKQuorum(conf), ChaosUtils.getHostName()));
                    t.start();
                    t.join();
                }
                catch (InterruptedException | UnknownHostException e) {
                    LOG.error("Failed while executing next task execution of ChaosAgent on : {}", (Object)serviceName, (Object)e);
                }
                break;
            }
            default: {
                LOG.error("Service Name not known : " + serviceName.toString());
            }
        }
    }

    private static void ChaosServiceStop() {
        ChaosAgent.stopChaosAgent.set(true);
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption(new Option("c", ChaosServiceName.CHAOSAGENT.toString().toLowerCase(), true, "expecting a start/stop argument"));
        options.addOption(new Option("D", ChaosServiceName.GENERIC.toString(), true, "generic D param"));
        LOG.info(Arrays.toString(new Collection[]{options.getOptions()}));
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        new GenericOptionsParser(conf, args);
        ChoreService choreChaosService = null;
        ScheduledChore authChore = AuthUtil.getAuthChore((Configuration)conf);
        try {
            if (authChore != null) {
                choreChaosService = new ChoreService("ChaosService");
                choreChaosService.scheduleChore(authChore);
            }
            ChaosService.execute(args, conf);
        }
        finally {
            if (authChore != null) {
                choreChaosService.shutdown();
            }
        }
    }

    static enum ExecutorAction {
        START,
        STOP;

    }

    static enum ChaosServiceName {
        CHAOSAGENT,
        GENERIC;

    }
}

