/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.compaction.MajorCompactionRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class MajorCompactionRequestTest {
    protected static final HBaseTestingUtility UTILITY = new HBaseTestingUtility();
    protected static final String FAMILY = "a";
    protected Path rootRegionDir;
    protected Path regionStoreDir;

    @Before
    public void setUp() throws Exception {
        this.rootRegionDir = UTILITY.getDataTestDirOnTestFS("MajorCompactionRequestTest");
        this.regionStoreDir = new Path(this.rootRegionDir, FAMILY);
    }

    @Test
    public void testStoresNeedingCompaction() throws Exception {
        List<StoreFileInfo> storeFiles = this.mockStoreFiles(this.regionStoreDir, 5, 10L);
        MajorCompactionRequest request = this.makeMockRequest(storeFiles, false);
        Optional result = request.createRequest((Configuration)Mockito.mock(Configuration.class), (Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 100L);
        Assert.assertTrue((boolean)result.isPresent());
        storeFiles = this.mockStoreFiles(this.regionStoreDir, 5, 101L);
        request = this.makeMockRequest(storeFiles, false);
        result = request.createRequest((Configuration)Mockito.mock(Configuration.class), (Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 100L);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testIfWeHaveNewReferenceFilesButOldStoreFiles() throws Exception {
        TableName table = TableName.valueOf((String)"MajorCompactorTest");
        HTableDescriptor htd = UTILITY.createTableDescriptor(table, Bytes.toBytes((String)FAMILY));
        HRegionInfo hri = new HRegionInfo(htd.getTableName());
        HRegion region = HBaseTestingUtility.createRegionAndWAL(hri, this.rootRegionDir, UTILITY.getRandomDir(), UTILITY.getConfiguration(), htd);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        List<StoreFileInfo> storeFiles = this.mockStoreFiles(this.regionStoreDir, 4, 101L);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (StoreFileInfo storeFile : storeFiles) {
            Path path = storeFile.getPath();
            paths.add(path);
        }
        HRegionFileSystem fileSystem = this.mockFileSystem(region.getRegionInfo(), true, storeFiles, 50L);
        MajorCompactionRequest majorCompactionRequest = (MajorCompactionRequest)Mockito.spy((Object)new MajorCompactionRequest(configuration, region.getRegionInfo()));
        ((MajorCompactionRequest)Mockito.doReturn((Object)Mockito.mock(Connection.class)).when((Object)majorCompactionRequest)).getConnection((Configuration)Matchers.eq((Object)configuration));
        ((MajorCompactionRequest)Mockito.doReturn(paths).when((Object)majorCompactionRequest)).getReferenceFilePaths((FileSystem)Matchers.any(FileSystem.class), (Path)Matchers.any(Path.class));
        ((MajorCompactionRequest)Mockito.doReturn((Object)fileSystem).when((Object)majorCompactionRequest)).getFileSystem((Connection)Matchers.any(Connection.class));
        Set result = majorCompactionRequest.getStoresRequiringCompaction((Set)Sets.newHashSet((Object[])new String[]{FAMILY}), 100L);
        Assert.assertEquals((Object)FAMILY, (Object)Iterables.getOnlyElement((Iterable)result));
    }

    private HRegionFileSystem mockFileSystem(HRegionInfo info, boolean hasReferenceFiles, List<StoreFileInfo> storeFiles) throws IOException {
        Optional found = Optional.absent();
        Iterator<StoreFileInfo> i$ = storeFiles.iterator();
        if (i$.hasNext()) {
            StoreFileInfo storeFile = i$.next();
            found = Optional.of((Object)storeFile);
        }
        long timestamp = ((StoreFileInfo)found.get()).getModificationTime();
        return this.mockFileSystem(info, hasReferenceFiles, storeFiles, timestamp);
    }

    private HRegionFileSystem mockFileSystem(HRegionInfo info, boolean hasReferenceFiles, List<StoreFileInfo> storeFiles, long referenceFileTimestamp) throws IOException {
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        if (hasReferenceFiles) {
            FileStatus fileStatus = (FileStatus)Mockito.mock(FileStatus.class);
            ((FileStatus)Mockito.doReturn((Object)referenceFileTimestamp).when((Object)fileStatus)).getModificationTime();
            ((FileSystem)Mockito.doReturn((Object)fileStatus).when((Object)fileSystem)).getFileLinkStatus((Path)Matchers.isA(Path.class));
        }
        HRegionFileSystem mockSystem = (HRegionFileSystem)Mockito.mock(HRegionFileSystem.class);
        ((HRegionFileSystem)Mockito.doReturn((Object)info).when((Object)mockSystem)).getRegionInfo();
        ((HRegionFileSystem)Mockito.doReturn((Object)this.regionStoreDir).when((Object)mockSystem)).getStoreDir(FAMILY);
        ((HRegionFileSystem)Mockito.doReturn((Object)hasReferenceFiles).when((Object)mockSystem)).hasReferences(Matchers.anyString());
        ((HRegionFileSystem)Mockito.doReturn(storeFiles).when((Object)mockSystem)).getStoreFiles(Matchers.anyString());
        ((HRegionFileSystem)Mockito.doReturn((Object)fileSystem).when((Object)mockSystem)).getFileSystem();
        return mockSystem;
    }

    List<StoreFileInfo> mockStoreFiles(Path regionStoreDir, int howMany, long timestamp) throws IOException {
        ArrayList infos = Lists.newArrayList();
        for (int i = 0; i < howMany; ++i) {
            StoreFileInfo storeFileInfo = (StoreFileInfo)Mockito.mock(StoreFileInfo.class);
            ((StoreFileInfo)Mockito.doReturn((Object)timestamp).doReturn((Object)timestamp).when((Object)storeFileInfo)).getModificationTime();
            ((StoreFileInfo)Mockito.doReturn((Object)new Path(regionStoreDir, RandomStringUtils.randomAlphabetic((int)10))).when((Object)storeFileInfo)).getPath();
            infos.add(storeFileInfo);
        }
        return infos;
    }

    private MajorCompactionRequest makeMockRequest(List<StoreFileInfo> storeFiles, boolean references) throws IOException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        Mockito.when((Object)regionInfo.getEncodedName()).thenReturn((Object)"HBase");
        Mockito.when((Object)regionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)"foo"));
        MajorCompactionRequest request = new MajorCompactionRequest(configuration, regionInfo, (Set)Sets.newHashSet((Object[])new String[]{FAMILY}));
        MajorCompactionRequest spy = (MajorCompactionRequest)Mockito.spy((Object)request);
        HRegionFileSystem fileSystem = this.mockFileSystem(regionInfo, references, storeFiles);
        ((MajorCompactionRequest)Mockito.doReturn((Object)fileSystem).when((Object)spy)).getFileSystem((Connection)Matchers.isA(Connection.class));
        ((MajorCompactionRequest)Mockito.doReturn((Object)Mockito.mock(Connection.class)).when((Object)spy)).getConnection((Configuration)Matchers.eq((Object)configuration));
        return spy;
    }
}

