/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationSourceDummy;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.helper.DummyServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class TestReplicationSourceManagerBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationSourceManagerBase.class);
    protected static Configuration conf;
    protected static HBaseTestingUtility utility;
    protected static Replication replication;
    protected static ReplicationSourceManager manager;
    protected static ZooKeeperWatcher zkw;
    protected static HTableDescriptor htd;
    protected static HRegionInfo hri;
    protected static final byte[] r1;
    protected static final byte[] r2;
    protected static final byte[] f1;
    protected static final byte[] f2;
    protected static final TableName test;
    protected static final String slaveId = "1";
    protected static FileSystem fs;
    protected static Path oldLogDir;
    protected static Path logDir;
    protected static DummyServer server;
    @Rule
    public TestName testName = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = HBaseConfiguration.create();
        conf.set("replication.replicationsource.implementation", ReplicationSourceDummy.class.getCanonicalName());
        conf.setBoolean("hbase.replication", true);
        conf.setLong("replication.sleep.before.failover", 2000L);
        conf.setInt("replication.source.maxretriesmultiplier", 10);
        utility = new HBaseTestingUtility(conf);
        utility.startMiniZKCluster();
        zkw = new ZooKeeperWatcher(conf, "test", null);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication");
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1", (byte[])Bytes.toBytes((String)(conf.get("hbase.zookeeper.quorum") + ":" + conf.get("hbase.zookeeper.property.clientPort") + ":/1")));
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1/peer-state");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/peers/1/peer-state", (byte[])ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/hbase/replication/state");
        ZKUtil.setData((ZooKeeperWatcher)zkw, (String)"/hbase/replication/state", (byte[])ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
        ZKClusterId.setClusterId((ZooKeeperWatcher)zkw, (ClusterId)new ClusterId());
        FSUtils.setRootDir((Configuration)utility.getConfiguration(), (Path)utility.getDataTestDir());
        fs = FileSystem.get((Configuration)conf);
        oldLogDir = new Path(utility.getDataTestDir(), "oldWALs");
        logDir = new Path(utility.getDataTestDir(), "WALs");
        server = new DummyServer(conf, "example.hostname.com", zkw);
        replication = new Replication((Server)server, fs, logDir, oldLogDir);
        manager = replication.getReplicationManager();
        manager.addSource(slaveId);
        htd = new HTableDescriptor(test);
        HColumnDescriptor col = new HColumnDescriptor(f1);
        col.setScope(1);
        htd.addFamily(col);
        col = new HColumnDescriptor(f2);
        col.setScope(0);
        htd.addFamily(col);
        hri = new HRegionInfo(htd.getTableName(), r1, r2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        block2: {
            try {
                manager.join();
            }
            catch (RuntimeException re) {
                if (!re.getMessage().equals("Fake Exception")) break block2;
                LOG.info((Object)"It is fine");
            }
        }
        utility.shutdownMiniCluster();
    }

    private void cleanLogDir() throws IOException {
        fs.delete(logDir, true);
        fs.delete(oldLogDir, true);
    }

    @Before
    public void setUp() throws Exception {
        LOG.info((Object)("Start " + this.testName.getMethodName()));
        this.cleanLogDir();
    }

    @After
    public void tearDown() throws Exception {
        LOG.info((Object)("End " + this.testName.getMethodName()));
        this.cleanLogDir();
    }

    static {
        r1 = Bytes.toBytes((String)"r1");
        r2 = Bytes.toBytes((String)"r2");
        f1 = Bytes.toBytes((String)"f1");
        f2 = Bytes.toBytes((String)"f2");
        test = TableName.valueOf((String)"test");
    }
}

