/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.hbase.regionserver.compactions.CurrentHourProvider;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestCurrentHourProvider {
    private static final List<String> ZONE_IDS = Lists.newArrayList((Object[])new String[]{"UTC", "US/Pacific", "Etc/GMT+8"});

    @Test
    public void testWithEnvironmentEdge() {
        for (String zoneID : ZONE_IDS) {
            TimeZone timezone = TimeZone.getTimeZone(zoneID);
            TimeZone.setDefault(timezone);
            long deltaFor11 = TimeZone.getDefault().getRawOffset() - 28800000;
            final long timeFor11 = 1597895561000L - deltaFor11;
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)new EnvironmentEdge(){

                public long currentTime() {
                    return timeFor11;
                }
            });
            CurrentHourProvider.advanceTick();
            int hour11 = CurrentHourProvider.getCurrentHour();
            if (TimeZone.getDefault().inDaylightTime(new Date(timeFor11))) {
                hour11 = CurrentHourProvider.getCurrentHour() - 1;
            }
            Assert.assertEquals((long)11L, (long)hour11);
            long deltaFor15 = TimeZone.getDefault().getRawOffset() - 28800000;
            final long timeFor15 = 1597907081000L - deltaFor15;
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)new EnvironmentEdge(){

                public long currentTime() {
                    return timeFor15;
                }
            });
            CurrentHourProvider.advanceTick();
            int hour15 = CurrentHourProvider.getCurrentHour();
            if (TimeZone.getDefault().inDaylightTime(new Date(timeFor15))) {
                hour15 = CurrentHourProvider.getCurrentHour() - 1;
            }
            Assert.assertEquals((long)15L, (long)hour15);
        }
    }
}

