/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMemStoreFlusher {
    private MemStoreFlusher msf;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.hstore.flusher.count", "0");
        this.msf = new MemStoreFlusher(conf, null);
    }

    @Test
    public void testReplaceDelayedFlushEntry() {
        HRegionInfo hri = new HRegionInfo(1L, TableName.valueOf((String)"TestTable"), 0);
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)r)).getRegionInfo();
        this.msf.requestDelayedFlush((Region)r, 30000L, false);
        Assert.assertEquals((long)1L, (long)this.msf.getFlushQueueSize());
        Assert.assertTrue((boolean)((MemStoreFlusher.FlushRegionEntry)this.msf.regionsInQueue.get(r)).isDelay());
        Assert.assertTrue((boolean)this.msf.requestFlush((Region)r, false));
        Assert.assertEquals((long)1L, (long)this.msf.getFlushQueueSize());
        Assert.assertFalse((boolean)((MemStoreFlusher.FlushRegionEntry)this.msf.regionsInQueue.get(r)).isDelay());
    }

    @Test
    public void testNotReplaceDelayedFlushEntryWhichExpired() {
        HRegionInfo hri = new HRegionInfo(1L, TableName.valueOf((String)"TestTable"), 0);
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)r)).getRegionInfo();
        this.msf.requestDelayedFlush((Region)r, 100L, false);
        Assert.assertEquals((long)1L, (long)this.msf.getFlushQueueSize());
        Assert.assertTrue((boolean)((MemStoreFlusher.FlushRegionEntry)this.msf.regionsInQueue.get(r)).isDelay());
        Threads.sleep((long)200L);
        Assert.assertFalse((boolean)this.msf.requestFlush((Region)r, false));
        Assert.assertEquals((long)1L, (long)this.msf.getFlushQueueSize());
        Assert.assertTrue((boolean)((MemStoreFlusher.FlushRegionEntry)this.msf.regionsInQueue.get(r)).isDelay());
    }
}

