/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.RpcLogDetails;
import org.apache.hadoop.hbase.namequeues.TestNamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.slowlog.SlowLogTableAccessor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSlowLogAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(TestNamedQueueRecorder.class);
    private static final HBaseTestingUtility HBASE_TESTING_UTILITY = new HBaseTestingUtility();
    private NamedQueueRecorder namedQueueRecorder;

    @BeforeClass
    public static void setup() throws Exception {
        try {
            HBASE_TESTING_UTILITY.shutdownMiniHBaseCluster();
        }
        catch (IOException e) {
            LOG.debug("No worries.");
        }
        Configuration conf = HBASE_TESTING_UTILITY.getConfiguration();
        conf.setBoolean("hbase.regionserver.slowlog.buffer.enabled", true);
        conf.setBoolean("hbase.regionserver.slowlog.systable.enabled", true);
        conf.setInt("hbase.slowlog.systable.chore.duration", 900);
        conf.setInt("hbase.regionserver.slowlog.ringbuffer.size", 50000);
        HBASE_TESTING_UTILITY.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        HBASE_TESTING_UTILITY.shutdownMiniHBaseCluster();
    }

    @Before
    public void setUp() throws Exception {
        HRegionServer hRegionServer = HBASE_TESTING_UTILITY.getMiniHBaseCluster().getRegionServer(0);
        Field slowLogRecorder = HRegionServer.class.getDeclaredField("namedQueueRecorder");
        slowLogRecorder.setAccessible(true);
        this.namedQueueRecorder = (NamedQueueRecorder)slowLogRecorder.get(hRegionServer);
    }

    private List<TooSlowLog.SlowLogPayload> getSlowLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(0);
        namedQueueGetRequest.setSlowLogResponseRequest(request);
        NamedQueueGetResponse namedQueueGetResponse = this.namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
        return namedQueueGetResponse.getSlowLogPayloads();
    }

    @Test
    public void testSlowLogRecords() throws Exception {
        RpcLogDetails rpcLogDetails;
        int i;
        final AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(15).build();
        this.namedQueueRecorder.clearNamedQueue(NamedQueuePayload.NamedQueueEvent.SLOW_LOG);
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        final Connection connection = this.waitForSlowLogTableCreation();
        for (i = 0; i < 5; ++i) {
            rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
        }
        while (i < 7) {
            rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
            ++i;
        }
        while (i < 10) {
            rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
            ++i;
        }
        while (i < 14) {
            rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
            this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
            ++i;
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestSlowLogAccessor.this.getSlowLogPayloads(request).size() == 14;
            }
        }));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(3000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestSlowLogAccessor.this.getTableCount(connection) == 14;
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getTableCount(Connection connection) {
        try (Table table = connection.getTable(SlowLogTableAccessor.SLOW_LOG_TABLE_NAME);){
            ResultScanner resultScanner = table.getScanner(new Scan().setReadType(Scan.ReadType.STREAM));
            int count = 0;
            for (Result result : resultScanner) {
                ++count;
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Connection waitForSlowLogTableCreation() throws Exception {
        ClusterConnection connection = HBASE_TESTING_UTILITY.getMiniHBaseCluster().getRegionServer(0).getConnection();
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(2000L, new Waiter.Predicate<Exception>((Connection)connection){
            final /* synthetic */ Connection val$connection;
            {
                this.val$connection = connection;
            }

            public boolean evaluate() throws Exception {
                try {
                    return MetaTableAccessor.tableExists((Connection)this.val$connection, (TableName)SlowLogTableAccessor.SLOW_LOG_TABLE_NAME);
                }
                catch (IOException e) {
                    return false;
                }
            }
        }));
        return connection;
    }

    @Test
    public void testHigherSlowLogs() throws Exception {
        final Connection connection = this.waitForSlowLogTableCreation();
        this.namedQueueRecorder.clearNamedQueue(NamedQueuePayload.NamedQueueEvent.SLOW_LOG);
        final AdminProtos.SlowLogResponseRequest request = AdminProtos.SlowLogResponseRequest.newBuilder().setLimit(500000).build();
        Assert.assertEquals((long)this.getSlowLogPayloads(request).size(), (long)0L);
        for (int j = 0; j < 100; ++j) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 350; ++i) {
                        if (i == 300) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                LOG.warn("Interrupted.");
                            }
                        }
                        RpcLogDetails rpcLogDetails = TestNamedQueueRecorder.getRpcLogDetails("userName_" + (i + 1), "client_" + (i + 1), "class_" + (i + 1));
                        TestSlowLogAccessor.this.namedQueueRecorder.addRecord((NamedQueuePayload)rpcLogDetails);
                    }
                }
            }).start();
        }
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(8000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                int count = TestSlowLogAccessor.this.getSlowLogPayloads(request).size();
                LOG.debug("RingBuffer records count: {}", (Object)count);
                return count > 1500;
            }
        }));
        Assert.assertNotEquals((long)-1L, (long)HBASE_TESTING_UTILITY.waitFor(11000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                int count = TestSlowLogAccessor.this.getTableCount(connection);
                LOG.debug("SlowLog Table records count: {}", (Object)count);
                return count > 1500;
            }
        }));
    }
}

