/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestSimpleRegionNormalizerOnCluster {
    private static final Log LOG = LogFactory.getLog(TestSimpleRegionNormalizerOnCluster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static Admin admin;
    private static HMaster master;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.normalizer.merge.min_region_age.days", 0);
        TEST_UTIL.startMiniCluster(1);
        admin = TEST_UTIL.getHBaseAdmin();
        master = TEST_UTIL.getHBaseCluster().getMaster();
        Assert.assertNotNull((Object)master);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        admin.setNormalizerRunning(false);
    }

    @Test
    public void testHonorsNormalizerSwitch() throws IOException {
        Assert.assertFalse((boolean)admin.isNormalizerEnabled());
        Assert.assertFalse((boolean)admin.normalize());
        Assert.assertFalse((boolean)admin.setNormalizerRunning(true));
        Assert.assertTrue((boolean)admin.normalize());
    }

    @Test(timeout=60000L)
    public void testRegionNormalizationSplitOnCluster() throws Exception {
        int cnt;
        TableName TABLENAME = TableName.valueOf((String)this.name.getMethodName());
        try (HTable ht = TEST_UTIL.createMultiRegionTable(TABLENAME, FAMILYNAME, 5);){
            List<HRegion> generatedRegions = TEST_UTIL.getHBaseCluster().getRegions(TABLENAME);
            Collections.sort(generatedRegions, new Comparator<HRegion>(){

                @Override
                public int compare(HRegion o1, HRegion o2) {
                    return o1.getRegionInfo().compareTo(o2.getRegionInfo());
                }
            });
            HRegion region = generatedRegions.get(0);
            TestSimpleRegionNormalizerOnCluster.generateTestData((Region)region, 1);
            region.flush(true);
            region = generatedRegions.get(1);
            TestSimpleRegionNormalizerOnCluster.generateTestData((Region)region, 1);
            region.flush(true);
            region = generatedRegions.get(2);
            TestSimpleRegionNormalizerOnCluster.generateTestData((Region)region, 2);
            region.flush(true);
            region = generatedRegions.get(3);
            TestSimpleRegionNormalizerOnCluster.generateTestData((Region)region, 2);
            region.flush(true);
            region = generatedRegions.get(4);
            TestSimpleRegionNormalizerOnCluster.generateTestData((Region)region, 5);
            region.flush(true);
        }
        HTableDescriptor htd = admin.getTableDescriptor(TABLENAME);
        htd.setNormalizationEnabled(true);
        admin.modifyTable(TABLENAME, htd);
        admin.flush(TABLENAME);
        admin.setNormalizerRunning(true);
        System.out.println(admin.getTableDescriptor(TABLENAME));
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)TABLENAME));
        Thread.sleep(5000L);
        boolean b = master.normalizeRegions();
        Assert.assertTrue((boolean)b);
        do {
            List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(TABLENAME);
            cnt = 0;
            for (HRegion region : regions) {
                String regionName = region.getRegionInfo().getRegionNameAsString();
                if (!regionName.startsWith("testRegionNormalizationSplitOnCluster,zzzzz")) continue;
                ++cnt;
            }
        } while (cnt < 2);
        admin.disableTable(TABLENAME);
        admin.deleteTable(TABLENAME);
    }

    @Test(timeout=60000L)
    public void testRegionNormalizationMergeOnCluster() throws Exception {
        TableName TABLENAME = TableName.valueOf((String)this.name.getMethodName());
        this.createTable(TABLENAME, Arrays.asList(1, 1, 3, 3, 5));
        HTableDescriptor htd = admin.getTableDescriptor(TABLENAME);
        htd.setNormalizationEnabled(true);
        admin.modifyTable(TABLENAME, htd);
        admin.flush(TABLENAME);
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)TABLENAME));
        admin.setNormalizerRunning(true);
        Thread.sleep(5000L);
        master.normalizeRegions();
        while (MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)TABLENAME) > 4) {
            LOG.info((Object)"Waiting for normalization merge to complete");
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)4L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)TABLENAME));
        TestSimpleRegionNormalizerOnCluster.dropIfExists(TABLENAME);
    }

    @Test(timeout=60000L)
    public void testMultiTablePlans() throws IOException, InterruptedException, CoordinatedStateException {
        int i;
        int numOfTables = 3;
        String methodName = this.name.getMethodName();
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        for (i = 0; i < numOfTables; ++i) {
            tableNames.add(TableName.valueOf((String)(methodName + i)));
        }
        this.createTable((TableName)tableNames.get(0), Arrays.asList(1, 1, 3, 5, 3));
        this.createTable((TableName)tableNames.get(1), Arrays.asList(1, 1, 1, 1, 1));
        this.createTable((TableName)tableNames.get(2), Arrays.asList(1, 1, 3, 5, 3));
        for (i = 0; i < numOfTables; ++i) {
            HTableDescriptor htd = admin.getTableDescriptor((TableName)tableNames.get(i));
            htd.setNormalizationEnabled(true);
            admin.modifyTable((TableName)tableNames.get(i), htd);
        }
        for (i = 0; i < numOfTables; ++i) {
            Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)((TableName)tableNames.get(i))));
        }
        admin.setNormalizerRunning(true);
        Thread.sleep(5000L);
        boolean checkStatus = master.normalizeRegions();
        Assert.assertTrue((boolean)checkStatus);
        Thread.sleep(5000L);
        Assert.assertEquals((long)4L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)((TableName)tableNames.get(0))));
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)((TableName)tableNames.get(1))));
        Assert.assertEquals((long)4L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)((TableName)tableNames.get(2))));
        for (int i2 = 0; i2 < numOfTables; ++i2) {
            TestSimpleRegionNormalizerOnCluster.dropIfExists((TableName)tableNames.get(i2));
        }
    }

    private void createTable(TableName TABLENAME, List<Integer> rowsInRespectiveRegions) throws IOException {
        int numOfRegions = rowsInRespectiveRegions.size();
        try (HTable ht = TEST_UTIL.createMultiRegionTable(TABLENAME, FAMILYNAME, numOfRegions);){
            List<HRegion> generatedRegions = TEST_UTIL.getHBaseCluster().getRegions(TABLENAME);
            Collections.sort(generatedRegions, new Comparator<HRegion>(){

                @Override
                public int compare(HRegion o1, HRegion o2) {
                    return o1.getRegionInfo().compareTo(o2.getRegionInfo());
                }
            });
            for (int i = 0; i < numOfRegions; ++i) {
                HRegion region = generatedRegions.get(i);
                TestSimpleRegionNormalizerOnCluster.generateTestData((Region)region, (int)rowsInRespectiveRegions.get(i));
                region.flush(true);
            }
        }
    }

    private static void waitForTableSplit(final TableName tableName, final int targetRegionCount) throws IOException {
        TEST_UTIL.waitFor(10000L, new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() {
                return "expected normalizer to split region.";
            }

            public boolean evaluate() throws IOException {
                int currentRegionCount = MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
                return currentRegionCount >= targetRegionCount;
            }
        });
    }

    private static List<HRegion> generateTestData(TableName tableName, int ... regionSizesMb) throws IOException {
        List<HRegion> generatedRegions;
        int numRegions = regionSizesMb.length;
        try (HTable ignored = TEST_UTIL.createMultiRegionTable(tableName, FAMILYNAME, numRegions);){
            generatedRegions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
            Collections.sort(generatedRegions, new Comparator<HRegion>(){

                @Override
                public int compare(HRegion o1, HRegion o2) {
                    return o1.getRegionInfo().compareTo(o2.getRegionInfo());
                }
            });
            Assert.assertEquals((long)numRegions, (long)generatedRegions.size());
            for (int i = 0; i < numRegions; ++i) {
                HRegion region = generatedRegions.get(i);
                TestSimpleRegionNormalizerOnCluster.generateTestData((Region)region, regionSizesMb[i]);
                region.flush(true);
            }
        }
        return generatedRegions;
    }

    private static void generateTestData(Region region, int numRows) throws IOException {
        LoadTestKVGenerator dataGenerator = new LoadTestKVGenerator(0x100000, 0x100000);
        for (int i = 0; i < numRows; ++i) {
            byte[] key = Bytes.add((byte[])region.getRegionInfo().getStartKey(), (byte[])Bytes.toBytes((int)i));
            for (int j = 0; j < 1; ++j) {
                Put put = new Put(key);
                byte[] col = Bytes.toBytes((String)String.valueOf(j));
                byte[] value = dataGenerator.generateRandomSizeValue((byte[][])new byte[][]{key, col});
                put.add(FAMILYNAME, col, value);
                region.put(put);
            }
        }
    }

    private static double getRegionSizeMB(MasterServices masterServices, HRegionInfo regionInfo) {
        ServerName sn = masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion(regionInfo);
        if (sn == null) {
            LOG.debug((Object)(regionInfo.getRegionNameAsString() + " region was not found on any Server"));
            return -1.0;
        }
        ServerLoad load = masterServices.getServerManager().getLoad(sn);
        if (load == null) {
            LOG.debug((Object)(sn.getServerName() + " was not found in online servers"));
            return -1.0;
        }
        RegionLoad regionLoad = (RegionLoad)load.getRegionsLoad().get(regionInfo.getRegionName());
        if (regionLoad == null) {
            LOG.debug((Object)(regionInfo.getRegionNameAsString() + " was not found in RegionsLoad"));
            return -1.0;
        }
        return regionLoad.getStorefileSizeMB();
    }

    private static void dropIfExists(TableName tableName) throws IOException {
        if (tableName != null && admin.tableExists(tableName)) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
    }
}

