/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.FileIOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.UniqueIndexMap;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestVerifyBucketCacheFile {
    final int constructedBlockSize = 8192;
    final long capacitySize = 0x2000000L;
    final int writeThreads = 3;
    final int writerQLen = 64;

    @Test
    public void testRetrieveFromFile() throws Exception {
        CacheTestUtils.HFileBlockPair[] blocks;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, testDir + "/bucket.persistence");
        long usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize == 0L ? 1 : 0) != 0);
        for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(8192, 1)) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize != 0L ? 1 : 0) != 0);
        bucketCache.shutdown();
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)usedSize, (long)bucketCache.getAllocator().getUsedSize());
        bucketCache.shutdown();
        File cacheFile = new File(testDir + "/bucket.cache");
        Assert.assertTrue((boolean)cacheFile.delete());
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        for (CacheTestUtils.HFileBlockPair block : blocks) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize != 0L ? 1 : 0) != 0);
        bucketCache.shutdown();
        File mapFile = new File(testDir + "/bucket.persistence");
        Assert.assertTrue((boolean)mapFile.delete());
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testModifiedBucketCacheFileData() throws Exception {
        CacheTestUtils.HFileBlockPair[] blocks;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, testDir + "/bucket.persistence");
        long usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize == 0L ? 1 : 0) != 0);
        for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(8192, 1)) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize != 0L ? 1 : 0) != 0);
        bucketCache.shutdown();
        String file = testDir + "/bucket.cache";
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, false)));){
            out.write("test bucket cache");
        }
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testModifiedBucketCacheFileTime() throws Exception {
        CacheTestUtils.HFileBlockPair[] blocks;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, testDir + "/bucket.persistence");
        long usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize == 0L ? 1 : 0) != 0);
        for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(8192, 1)) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize != 0L ? 1 : 0) != 0);
        bucketCache.shutdown();
        File file = new File(testDir + "/bucket.cache");
        Assert.assertTrue((boolean)file.setLastModified(System.currentTimeMillis() + 1000L));
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, testDir + "/bucket.persistence");
        Assert.assertEquals((long)0L, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)0L, (long)bucketCache.backingMap.size());
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void compatibilityTest() throws Exception {
        CacheTestUtils.HFileBlockPair[] blocks;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        Path testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(testDir);
        String persistencePath = testDir + "/bucket.persistence";
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, persistencePath);
        long usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize == 0L ? 1 : 0) != 0);
        for (CacheTestUtils.HFileBlockPair block : blocks = CacheTestUtils.generateHFileBlocks(8192, 1)) {
            this.cacheAndWaitUntilFlushedToBucket(bucketCache, block.getBlockName(), (Cacheable)block.getBlock());
        }
        usedSize = bucketCache.getAllocator().getUsedSize();
        Assert.assertTrue((usedSize != 0L ? 1 : 0) != 0);
        this.persistToFileInOldWay(persistencePath + ".old", bucketCache.getMaxSize(), bucketCache.backingMap, bucketCache.getDeserialiserMap());
        bucketCache.shutdown();
        bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", 0x2000000L, 8192, null, 3, 64, persistencePath + ".old");
        Assert.assertEquals((long)usedSize, (long)bucketCache.getAllocator().getUsedSize());
        Assert.assertEquals((long)blocks.length, (long)bucketCache.backingMap.size());
    }

    private void persistToFileInOldWay(String persistencePath, long cacheCapacity, ConcurrentMap backingMap, UniqueIndexMap deserialiserMap) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(persistencePath, false));){
            oos.writeLong(cacheCapacity);
            oos.writeUTF(FileIOEngine.class.getName());
            oos.writeUTF(backingMap.getClass().getName());
            oos.writeObject(deserialiserMap);
            oos.writeObject(backingMap);
        }
    }

    private void waitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey) throws InterruptedException {
        while (!cache.backingMap.containsKey(cacheKey) || cache.ramCache.containsKey(cacheKey)) {
            Thread.sleep(100L);
        }
    }

    private void cacheAndWaitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey, Cacheable block) throws InterruptedException {
        cache.cacheBlock(cacheKey, block);
        this.waitUntilFlushedToBucket(cache, cacheKey);
    }
}

