/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestZKLessAssignment {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Test
    public void testZkLessAssignmentRollbackAndRollForward() throws Exception {
        Cell cell;
        boolean isStateQualifierExist;
        boolean isSNQualifierExist;
        List results;
        Configuration config = TEST_UTIL.getConfiguration();
        config.setBoolean("hbase.assignment.usezk.migrating", true);
        TEST_UTIL.startMiniCluster(2);
        TableName tableName = TableName.valueOf((String)"testZkLessAssignmentRollbackAndRollForward");
        TEST_UTIL.createTable(tableName.getName(), (byte[][])new byte[][]{Bytes.toBytes((String)"cf1")}, config).close();
        try (Connection connection = ConnectionFactory.createConnection((Configuration)config);){
            results = MetaTableAccessor.fullScanOfMeta((Connection)connection);
            isSNQualifierExist = false;
            isStateQualifierExist = false;
            for (Result result : results) {
                cell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SERVERNAME_QUALIFIER);
                if (cell != null && cell.getValueLength() > 0) {
                    isSNQualifierExist = true;
                }
                if ((cell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER)) == null || cell.getValueLength() <= 0) continue;
                isStateQualifierExist = true;
            }
            Assert.assertTrue((boolean)isSNQualifierExist);
            Assert.assertTrue((boolean)isStateQualifierExist);
        }
        TEST_UTIL.shutdownMiniHBaseCluster();
        config.unset("hbase.assignment.usezk.migrating");
        TEST_UTIL.restartHBaseCluster(2);
        connection = ConnectionFactory.createConnection((Configuration)config);
        var4_4 = null;
        try {
            results = MetaTableAccessor.fullScanOfMeta((Connection)connection);
            isSNQualifierExist = false;
            isStateQualifierExist = false;
            for (Result result : results) {
                cell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SERVERNAME_QUALIFIER);
                if (cell != null && cell.getValueLength() > 0) {
                    isSNQualifierExist = true;
                }
                if ((cell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER)) == null || cell.getValueLength() <= 0) continue;
                isStateQualifierExist = true;
            }
            Assert.assertFalse((boolean)isSNQualifierExist);
            Assert.assertFalse((boolean)isStateQualifierExist);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (connection != null) {
                if (var4_4 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    connection.close();
                }
            }
        }
    }
}

