/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.common.collect.Sets;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminServer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.rsgroup.RSGroupProtobufUtil;
import org.apache.hadoop.hbase.rsgroup.RSGroupableBalancer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Shell;

public class RSGroupAdminEndpoint
extends RSGroupAdminProtos.RSGroupAdminService
implements CoprocessorService,
Coprocessor,
MasterObserver {
    private static final Log LOG = LogFactory.getLog(RSGroupAdminEndpoint.class);
    private MasterServices master = null;
    private static RSGroupInfoManagerImpl groupInfoManager;
    private RSGroupAdminServer groupAdminServer;
    private AccessChecker accessChecker;
    private UserProvider userProvider;
    private RSGroupMappingScript script;

    public void start(CoprocessorEnvironment env) throws IOException {
        MasterCoprocessorEnvironment menv = (MasterCoprocessorEnvironment)env;
        this.master = menv.getMasterServices();
        this.setGroupInfoManager(new RSGroupInfoManagerImpl(this.master));
        this.groupAdminServer = new RSGroupAdminServer(this.master, groupInfoManager);
        Class clazz = this.master.getConfiguration().getClass("hbase.master.loadbalancer.class", null);
        if (!RSGroupableBalancer.class.isAssignableFrom(clazz)) {
            throw new IOException("Configured balancer is not a GroupableBalancer");
        }
        ZooKeeperWatcher zk = menv.getMasterServices().getZooKeeper();
        this.accessChecker = new AccessChecker(env.getConfiguration(), zk);
        this.userProvider = UserProvider.instantiate((Configuration)env.getConfiguration());
        this.script = new RSGroupMappingScript(env.getConfiguration());
    }

    public void stop(CoprocessorEnvironment env) {
        this.accessChecker.stop();
    }

    public Service getService() {
        return this;
    }

    private static void setStaticGroupInfoManager(RSGroupInfoManagerImpl groupInfoManager) {
        RSGroupAdminEndpoint.groupInfoManager = groupInfoManager;
    }

    private void setGroupInfoManager(RSGroupInfoManagerImpl groupInfoManager) throws IOException {
        if (groupInfoManager == null) {
            groupInfoManager = new RSGroupInfoManagerImpl(this.master);
            groupInfoManager.init();
        } else if (!groupInfoManager.isInit()) {
            groupInfoManager.init();
        }
        RSGroupAdminEndpoint.setStaticGroupInfoManager(groupInfoManager);
    }

    public RSGroupInfoManager getGroupInfoManager() {
        return groupInfoManager;
    }

    public void getRSGroupInfo(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoResponse> done) {
        RSGroupAdminProtos.GetRSGroupInfoResponse response = null;
        try {
            RSGroupAdminProtos.GetRSGroupInfoResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoResponse.newBuilder();
            RSGroupInfo RSGroupInfo2 = this.groupAdminServer.getRSGroupInfo(request.getRSGroupName());
            this.checkPermission("getRSGroupInfo");
            if (RSGroupInfo2 != null) {
                builder.setRSGroupInfo(RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2));
            }
            response = builder.build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(response);
    }

    public void getRSGroupInfoOfTable(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoOfTableRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoOfTableResponse> done) {
        RSGroupAdminProtos.GetRSGroupInfoOfTableResponse response = null;
        try {
            RSGroupAdminProtos.GetRSGroupInfoOfTableResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoOfTableResponse.newBuilder();
            TableName tableName = ProtobufUtil.toTableName((TableProtos.TableName)request.getTableName());
            this.checkPermission("getRSGroupInfoOfTable");
            RSGroupInfo info = this.groupAdminServer.getRSGroupInfoOfTable(tableName);
            response = info == null ? builder.build() : builder.setRSGroupInfo(RSGroupProtobufUtil.toProtoGroupInfo(info)).build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(response);
    }

    public void moveServers(RpcController controller, RSGroupAdminProtos.MoveServersRequest request, RpcCallback<RSGroupAdminProtos.MoveServersResponse> done) {
        RSGroupAdminProtos.MoveServersResponse response = null;
        try {
            RSGroupAdminProtos.MoveServersResponse.Builder builder = RSGroupAdminProtos.MoveServersResponse.newBuilder();
            HashSet servers = Sets.newHashSet();
            for (HBaseProtos.ServerName el : request.getServersList()) {
                servers.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
            }
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preMoveServers((Set)servers, request.getTargetGroup());
            }
            this.checkPermission("moveServers");
            this.groupAdminServer.moveServers(servers, request.getTargetGroup());
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postMoveServers((Set)servers, request.getTargetGroup());
            }
            response = builder.build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(response);
    }

    public void moveTables(RpcController controller, RSGroupAdminProtos.MoveTablesRequest request, RpcCallback<RSGroupAdminProtos.MoveTablesResponse> done) {
        RSGroupAdminProtos.MoveTablesResponse response = null;
        try {
            RSGroupAdminProtos.MoveTablesResponse.Builder builder = RSGroupAdminProtos.MoveTablesResponse.newBuilder();
            HashSet<TableName> tables = new HashSet<TableName>(request.getTableNameList().size());
            for (TableProtos.TableName tableName : request.getTableNameList()) {
                tables.add(ProtobufUtil.toTableName((TableProtos.TableName)tableName));
            }
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preMoveTables(tables, request.getTargetGroup());
            }
            this.checkPermission("moveTables");
            this.groupAdminServer.moveTables(tables, request.getTargetGroup());
            response = builder.build();
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postMoveTables(tables, request.getTargetGroup());
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(response);
    }

    public void moveServersAndTables(RpcController controller, RSGroupAdminProtos.MoveServersAndTablesRequest request, RpcCallback<RSGroupAdminProtos.MoveServersAndTablesResponse> done) {
        RSGroupAdminProtos.MoveServersAndTablesResponse.Builder builder = RSGroupAdminProtos.MoveServersAndTablesResponse.newBuilder();
        try {
            HashSet servers = Sets.newHashSet();
            for (HBaseProtos.ServerName el : request.getServersList()) {
                servers.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
            }
            HashSet<TableName> tables = new HashSet<TableName>(request.getTableNameList().size());
            for (TableProtos.TableName tableName : request.getTableNameList()) {
                tables.add(ProtobufUtil.toTableName((TableProtos.TableName)tableName));
            }
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preMoveServersAndTables((Set)servers, tables, request.getTargetGroup());
            }
            this.checkPermission("moveServersAndTables");
            this.groupAdminServer.moveServersAndTables(servers, tables, request.getTargetGroup());
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postMoveServersAndTables((Set)servers, tables, request.getTargetGroup());
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void addRSGroup(RpcController controller, RSGroupAdminProtos.AddRSGroupRequest request, RpcCallback<RSGroupAdminProtos.AddRSGroupResponse> done) {
        RSGroupAdminProtos.AddRSGroupResponse response = null;
        try {
            RSGroupAdminProtos.AddRSGroupResponse.Builder builder = RSGroupAdminProtos.AddRSGroupResponse.newBuilder();
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preAddRSGroup(request.getRSGroupName());
            }
            this.checkPermission("addRSGroup");
            this.groupAdminServer.addRSGroup(request.getRSGroupName());
            response = builder.build();
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postAddRSGroup(request.getRSGroupName());
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(response);
    }

    public void removeRSGroup(RpcController controller, RSGroupAdminProtos.RemoveRSGroupRequest request, RpcCallback<RSGroupAdminProtos.RemoveRSGroupResponse> done) {
        RSGroupAdminProtos.RemoveRSGroupResponse response = null;
        try {
            RSGroupAdminProtos.RemoveRSGroupResponse.Builder builder = RSGroupAdminProtos.RemoveRSGroupResponse.newBuilder();
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preRemoveRSGroup(request.getRSGroupName());
            }
            this.checkPermission("removeRSGroup");
            this.groupAdminServer.removeRSGroup(request.getRSGroupName());
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postRemoveRSGroup(request.getRSGroupName());
            }
            response = builder.build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(response);
    }

    public void balanceRSGroup(RpcController controller, RSGroupAdminProtos.BalanceRSGroupRequest request, RpcCallback<RSGroupAdminProtos.BalanceRSGroupResponse> done) {
        RSGroupAdminProtos.BalanceRSGroupResponse.Builder builder = RSGroupAdminProtos.BalanceRSGroupResponse.newBuilder();
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preBalanceRSGroup(request.getRSGroupName());
            }
            this.checkPermission("balanceRSGroup");
            boolean balancerRan = this.groupAdminServer.balanceRSGroup(request.getRSGroupName());
            builder.setBalanceRan(balancerRan);
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postBalanceRSGroup(request.getRSGroupName(), balancerRan);
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
            builder.setBalanceRan(false);
        }
        done.run((Object)builder.build());
    }

    public void listRSGroupInfos(RpcController controller, RSGroupAdminProtos.ListRSGroupInfosRequest request, RpcCallback<RSGroupAdminProtos.ListRSGroupInfosResponse> done) {
        RSGroupAdminProtos.ListRSGroupInfosResponse response = null;
        try {
            RSGroupAdminProtos.ListRSGroupInfosResponse.Builder builder = RSGroupAdminProtos.ListRSGroupInfosResponse.newBuilder();
            this.checkPermission("listRSGroupInfos");
            for (RSGroupInfo RSGroupInfo2 : this.groupAdminServer.listRSGroups()) {
                builder.addRSGroupInfo(RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2));
            }
            response = builder.build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run(response);
    }

    public void getRSGroupInfoOfServer(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoOfServerRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoOfServerResponse> done) {
        RSGroupAdminProtos.GetRSGroupInfoOfServerResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoOfServerResponse.newBuilder();
        try {
            Address server = Address.fromParts((String)request.getServer().getHostName(), (int)request.getServer().getPort());
            this.checkPermission("getRSGroupInfoOfServer");
            RSGroupInfo RSGroupInfo2 = this.groupAdminServer.getRSGroupOfServer(server);
            if (RSGroupInfo2 != null) {
                builder.setRSGroupInfo(RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2));
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void removeServers(RpcController controller, RSGroupAdminProtos.RemoveServersRequest request, RpcCallback<RSGroupAdminProtos.RemoveServersResponse> done) {
        RSGroupAdminProtos.RemoveServersResponse.Builder builder = RSGroupAdminProtos.RemoveServersResponse.newBuilder();
        try {
            HashSet servers = Sets.newHashSet();
            for (HBaseProtos.ServerName el : request.getServersList()) {
                servers.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
            }
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preRemoveServers((Set)servers);
            }
            this.checkPermission("removeServers");
            this.groupAdminServer.removeServers(servers);
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postRemoveServers((Set)servers);
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    void assignTableToGroup(HTableDescriptor desc) throws IOException {
        RSGroupInfo rsGroupInfo;
        String groupName;
        try {
            groupName = this.master.getNamespaceDescriptor(desc.getTableName().getNamespaceAsString()).getConfigurationValue("hbase.rsgroup.name");
            if (groupName == null) {
                groupName = "default";
            }
        }
        catch (MasterNotRunningException | PleaseHoldException e) {
            LOG.info((Object)"Master has not initialized yet; temporarily using default RSGroup 'default' for deploy of system table");
            groupName = "default";
        }
        if (groupName.equals("default")) {
            TableName tableName = desc.getTableName();
            groupName = this.script.getRSGroup(tableName.getNamespaceAsString(), tableName.getQualifierAsString());
            LOG.info((Object)("rsgroup for " + tableName + " is " + groupName));
        }
        if ((rsGroupInfo = this.groupAdminServer.getRSGroupInfo(groupName)) == null) {
            throw new ConstraintException("Default RSGroup (" + groupName + ") for this table's " + "namespace does not exist.");
        }
        if (!rsGroupInfo.containsTable(desc.getTableName())) {
            this.groupAdminServer.moveTables(Sets.newHashSet((Object[])new TableName[]{desc.getTableName()}), groupName);
        }
    }

    public void renameRSGroup(RpcController controller, RSGroupAdminProtos.RenameRSGroupRequest request, RpcCallback<RSGroupAdminProtos.RenameRSGroupResponse> done) {
        RSGroupAdminProtos.RenameRSGroupResponse.Builder builder = RSGroupAdminProtos.RenameRSGroupResponse.newBuilder();
        String oldRSGroup = request.getOldRsgroupName();
        String newRSGroup = request.getNewRsgroupName();
        try {
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().preRenameRSGroup(oldRSGroup, newRSGroup);
            }
            this.checkPermission("renameRSGroup");
            this.groupAdminServer.renameRSGroup(oldRSGroup, newRSGroup);
            if (this.master.getMasterCoprocessorHost() != null) {
                this.master.getMasterCoprocessorHost().postRenameRSGroup(oldRSGroup, newRSGroup);
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
        }
        done.run((Object)builder.build());
    }

    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        this.groupAdminServer.prepareRSGroupForTable(desc);
    }

    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        this.groupAdminServer.cleanupRSGroupForTable(tableName);
    }

    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        this.assignTableToGroup(desc);
    }

    public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void postTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    public void preModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    public void postModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    public void preAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    public void postAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    public void preModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    public void postModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
    }

    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
    }

    public void preDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
    }

    public void postDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
    }

    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void postEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void postDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preMove(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    public void postMove(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> ctx, ProcedureExecutor<MasterProcedureEnv> procEnv, long procId) throws IOException {
    }

    public void postAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void preListProcedures(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void postListProcedures(ObserverContext<MasterCoprocessorEnvironment> ctx, List<ProcedureInfo> procInfoList) throws IOException {
    }

    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
    }

    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
    }

    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
    }

    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
    }

    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> ctx, List<RegionPlan> plans) throws IOException {
    }

    public boolean preSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue, Admin.MasterSwitchType switchType) throws IOException {
        return false;
    }

    public void postSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue, Admin.MasterSwitchType switchType) throws IOException {
    }

    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue) throws IOException {
        return newValue;
    }

    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean oldValue, boolean newValue) throws IOException {
    }

    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    public void preListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    public void postListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.assignTableToGroup(hTableDescriptor);
    }

    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
    }

    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
    }

    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
    }

    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
    }

    public void preGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
    }

    public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
    }

    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        String group = ns.getConfigurationValue("hbase.rsgroup.name");
        if (group != null && this.groupAdminServer.getRSGroupInfo(group) == null) {
            throw new ConstraintException("Region server group " + group + " does not exit");
        }
    }

    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
    }

    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
    }

    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.preCreateNamespace(ctx, ns);
    }

    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
    }

    public void postGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    public void preListNamespaces(ObserverContext<MasterCoprocessorEnvironment> ctx, List<String> namespaces) {
    }

    public void postListNamespaces(ObserverContext<MasterCoprocessorEnvironment> ctx, List<String> namespaces) {
    }

    public void preListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
    }

    public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
    }

    public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void postTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void postSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void postSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, QuotaProtos.Quotas quotas) throws IOException {
    }

    public void preDispatchMerge(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionA, HRegionInfo regionB) throws IOException {
    }

    public void postDispatchMerge(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionA, HRegionInfo regionB) throws IOException {
    }

    public void preGetClusterStatus(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void postGetClusterStatus(ObserverContext<MasterCoprocessorEnvironment> ctx, ClusterStatus status) throws IOException {
    }

    public void preClearDeadServers(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    public void postClearDeadServers(ObserverContext<MasterCoprocessorEnvironment> ctx, List<ServerName> servers, List<ServerName> notClearedServers) throws IOException {
        HashSet clearedServers = Sets.newHashSet();
        for (ServerName server : servers) {
            if (notClearedServers.contains(server)) continue;
            clearedServers.add(server.getAddress());
        }
        if (clearedServers.isEmpty()) {
            return;
        }
        this.groupAdminServer.removeServers(clearedServers);
    }

    public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
    }

    public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
    }

    public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void preMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void postMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void preRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
    }

    public void postRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
    }

    public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
    }

    public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
    }

    public void preRenameRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String oldName, String newName) throws IOException {
    }

    public void postRenameRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String oldName, String newName) throws IOException {
    }

    public void checkPermission(String request) throws IOException {
        this.accessChecker.requirePermission(this.getActiveUser(), request, Permission.Action.ADMIN);
    }

    private User getActiveUser() throws IOException {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            user = this.userProvider.getCurrent();
        }
        return user;
    }

    static class RSGroupMappingScript {
        static final String RS_GROUP_MAPPING_SCRIPT = "hbase.rsgroup.table.mapping.script";
        static final String RS_GROUP_MAPPING_SCRIPT_TIMEOUT = "hbase.rsgroup.table.mapping.script.timeout";
        private Shell.ShellCommandExecutor rsgroupMappingScript;

        RSGroupMappingScript(Configuration conf) {
            String script = conf.get(RS_GROUP_MAPPING_SCRIPT);
            if (script == null || script.isEmpty()) {
                return;
            }
            this.rsgroupMappingScript = new Shell.ShellCommandExecutor(new String[]{script, "", ""}, null, null, conf.getLong(RS_GROUP_MAPPING_SCRIPT_TIMEOUT, 5000L));
        }

        String getRSGroup(String namespace, String tablename) {
            if (this.rsgroupMappingScript == null) {
                return "default";
            }
            String[] exec = this.rsgroupMappingScript.getExecString();
            exec[1] = namespace;
            exec[2] = tablename;
            try {
                this.rsgroupMappingScript.execute();
            }
            catch (IOException e) {
                LOG.error((Object)(e.getMessage() + " placing back to default rsgroup"));
                return "default";
            }
            return this.rsgroupMappingScript.getOutput().trim();
        }
    }
}

