/**
 * Autogenerated by Thrift Compiler (0.13.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.hadoop.hbase.thrift.generated;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
@javax.annotation.Generated(value = "Autogenerated by Thrift Compiler (0.13.0)", date = "2021-02-09")
public class Hbase {

  public interface Iface {

    /**
     * Brings a table on-line (enables it)
     * 
     * @param tableName name of the table
     */
    public void enableTable(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * Disables a table (takes it off-line) If it is being served, the master
     * will tell the servers to stop serving it.
     * 
     * @param tableName name of the table
     */
    public void disableTable(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * @return true if table is on-line
     * 
     * @param tableName name of the table to check
     */
    public boolean isTableEnabled(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    public void compact(java.nio.ByteBuffer tableNameOrRegionName) throws IOError, org.apache.thrift.TException;

    public void majorCompact(java.nio.ByteBuffer tableNameOrRegionName) throws IOError, org.apache.thrift.TException;

    /**
     * List all the userspace tables.
     * 
     * @return returns a list of names
     */
    public java.util.List<java.nio.ByteBuffer> getTableNames() throws IOError, org.apache.thrift.TException;

    /**
     * List all the column families assoicated with a table.
     * 
     * @return list of column family descriptors
     * 
     * @param tableName table name
     */
    public java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> getColumnDescriptors(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * List the regions associated with a table.
     * 
     * @return list of region descriptors
     * 
     * @param tableName table name
     */
    public java.util.List<TRegionInfo> getTableRegions(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * Create a table with the specified column families.  The name
     * field for each ColumnDescriptor must be set and must end in a
     * colon (:). All other fields are optional and will get default
     * values if not explicitly specified.
     * 
     * @throws IllegalArgument if an input parameter is invalid
     * 
     * @throws AlreadyExists if the table name already exists
     * 
     * @param tableName name of table to create
     * 
     * @param columnFamilies list of column family descriptors
     */
    public void createTable(java.nio.ByteBuffer tableName, java.util.List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists, org.apache.thrift.TException;

    /**
     * Deletes a table
     * 
     * @throws IOError if table doesn't exist on server or there was some other
     * problem
     * 
     * @param tableName name of table to delete
     */
    public void deleteTable(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException;

    /**
     * Get a single TCell for the specified table, row, and column at the
     * latest timestamp. Returns an empty list if no such value exists.
     * 
     * @return value for specified row/column
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param column column name
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TCell> get(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified number of versions for the specified table,
     * row, and column.
     * 
     * @return list of cells for specified row/column
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param column column name
     * 
     * @param numVersions number of versions to retrieve
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TCell> getVer(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified number of versions for the specified table,
     * row, and column.  Only versions less than or equal to the specified
     * timestamp will be returned.
     * 
     * @return list of cells for specified row/column
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param column column name
     * 
     * @param timestamp timestamp
     * 
     * @param numVersions number of versions to retrieve
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TCell> getVerTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get all the data for the specified table and row at the latest
     * timestamp. Returns an empty list if the row does not exist.
     * 
     * @return TRowResult containing the row and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TRowResult> getRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified columns for the specified table and row at the latest
     * timestamp. Returns an empty list if the row does not exist.
     * 
     * @return TRowResult containing the row and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param columns List of columns to return, null for all columns
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TRowResult> getRowWithColumns(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get all the data for the specified table and row at the specified
     * timestamp. Returns an empty list if the row does not exist.
     * 
     * @return TRowResult containing the row and map of columns to TCells
     * 
     * @param tableName name of the table
     * 
     * @param row row key
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TRowResult> getRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified columns for the specified table and row at the specified
     * timestamp. Returns an empty list if the row does not exist.
     * 
     * @return TRowResult containing the row and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param columns List of columns to return, null for all columns
     * 
     * @param timestamp
     * @param attributes Get attributes
     */
    public java.util.List<TRowResult> getRowWithColumnsTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get all the data for the specified table and rows at the latest
     * timestamp. Returns an empty list if no rows exist.
     * 
     * @return TRowResult containing the rows and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param rows row keys
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TRowResult> getRows(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified columns for the specified table and rows at the latest
     * timestamp. Returns an empty list if no rows exist.
     * 
     * @return TRowResult containing the rows and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param rows row keys
     * 
     * @param columns List of columns to return, null for all columns
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TRowResult> getRowsWithColumns(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get all the data for the specified table and rows at the specified
     * timestamp. Returns an empty list if no rows exist.
     * 
     * @return TRowResult containing the rows and map of columns to TCells
     * 
     * @param tableName name of the table
     * 
     * @param rows row keys
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Get attributes
     */
    public java.util.List<TRowResult> getRowsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get the specified columns for the specified table and rows at the specified
     * timestamp. Returns an empty list if no rows exist.
     * 
     * @return TRowResult containing the rows and map of columns to TCells
     * 
     * @param tableName name of table
     * 
     * @param rows row keys
     * 
     * @param columns List of columns to return, null for all columns
     * 
     * @param timestamp
     * @param attributes Get attributes
     */
    public java.util.List<TRowResult> getRowsWithColumnsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Apply a series of mutations (updates/deletes) to a row in a
     * single transaction.  If an exception is thrown, then the
     * transaction is aborted.  Default current timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param mutations list of mutation commands
     * 
     * @param attributes Mutation attributes
     */
    public void mutateRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Apply a series of mutations (updates/deletes) to a row in a
     * single transaction.  If an exception is thrown, then the
     * transaction is aborted.  The specified timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param mutations list of mutation commands
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Mutation attributes
     */
    public void mutateRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Apply a series of batches (each a series of mutations on a single row)
     * in a single transaction.  If an exception is thrown, then the
     * transaction is aborted.  Default current timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * 
     * @param rowBatches list of row batches
     * 
     * @param attributes Mutation attributes
     */
    public void mutateRows(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Apply a series of batches (each a series of mutations on a single row)
     * in a single transaction.  If an exception is thrown, then the
     * transaction is aborted.  The specified timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * 
     * @param rowBatches list of row batches
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Mutation attributes
     */
    public void mutateRowsTs(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Atomically increment the column value specified.  Returns the next value post increment.
     * 
     * @param tableName name of table
     * 
     * @param row row to increment
     * 
     * @param column name of column
     * 
     * @param value amount to increment by
     */
    public long atomicIncrement(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long value) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Delete all cells that match the passed row and column.
     * 
     * @param tableName name of table
     * 
     * @param row Row to update
     * 
     * @param column name of column whose value is to be deleted
     * 
     * @param attributes Delete attributes
     */
    public void deleteAll(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Delete all cells that match the passed row and column and whose
     * timestamp is equal-to or older than the passed timestamp.
     * 
     * @param tableName name of table
     * 
     * @param row Row to update
     * 
     * @param column name of column whose value is to be deleted
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Delete attributes
     */
    public void deleteAllTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Completely delete the row's cells.
     * 
     * @param tableName name of table
     * 
     * @param row key of the row to be completely deleted.
     * 
     * @param attributes Delete attributes
     */
    public void deleteAllRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Increment a cell by the ammount.
     * Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
     * False is the default.  Turn to true if you need the extra performance and can accept some
     * data loss if a thrift server dies with increments still in the queue.
     * 
     * @param increment The single increment to apply
     */
    public void increment(TIncrement increment) throws IOError, org.apache.thrift.TException;

    public void incrementRows(java.util.List<TIncrement> increments) throws IOError, org.apache.thrift.TException;

    /**
     * Completely delete the row's cells marked with a timestamp
     * equal-to or older than the passed timestamp.
     * 
     * @param tableName name of table
     * 
     * @param row key of the row to be completely deleted.
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Delete attributes
     */
    public void deleteAllRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table, using the Scan instance
     * for the scan parameters.
     * 
     * @param tableName name of table
     * 
     * @param scan Scan instance
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenWithScan(java.nio.ByteBuffer tableName, TScan scan, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table starting at the specified row and
     * ending at the last row in the table.  Return the specified columns.
     * 
     * @return scanner id to be used with other scanner procedures
     * 
     * @param tableName name of table
     * 
     * @param startRow Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpen(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table starting and stopping at the
     * specified rows.  ending at the last row in the table.  Return the
     * specified columns.
     * 
     * @return scanner id to be used with other scanner procedures
     * 
     * @param tableName name of table
     * 
     * @param startRow Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     * 
     * @param stopRow row to stop scanning on. This row is *not* included in the
     * scanner's results
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenWithStop(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Open a scanner for a given prefix.  That is all rows will have the specified
     * prefix. No other rows will be returned.
     * 
     * @return scanner id to use with other scanner calls
     * 
     * @param tableName name of table
     * 
     * @param startAndPrefix the prefix (and thus start row) of the keys you want
     * 
     * @param columns the columns you want returned
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenWithPrefix(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startAndPrefix, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table starting at the specified row and
     * ending at the last row in the table.  Return the specified columns.
     * Only values with the specified timestamp are returned.
     * 
     * @return scanner id to be used with other scanner procedures
     * 
     * @param tableName name of table
     * 
     * @param startRow Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Get a scanner on the current table starting and stopping at the
     * specified rows.  ending at the last row in the table.  Return the
     * specified columns.  Only values with the specified timestamp are
     * returned.
     * 
     * @return scanner id to be used with other scanner procedures
     * 
     * @param tableName name of table
     * 
     * @param startRow Starting row in table to scan.
     * Send "" (empty string) to start at the first row.
     * 
     * @param stopRow row to stop scanning on. This row is *not* included in the
     * scanner's results
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned. It's also possible
     * to pass a regex in the column qualifier.
     * 
     * @param timestamp timestamp
     * 
     * @param attributes Scan attributes
     */
    public int scannerOpenWithStopTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException;

    /**
     * Returns the scanner's current row value and advances to the next
     * row in the table.  When there are no more rows in the table, or a key
     * greater-than-or-equal-to the scanner's specified stopRow is reached,
     * an empty list is returned.
     * 
     * @return a TRowResult containing the current row and a map of the columns to TCells.
     * 
     * @throws IllegalArgument if ScannerID is invalid
     * 
     * @throws NotFound when the scanner reaches the end
     * 
     * @param id id of a scanner returned by scannerOpen
     */
    public java.util.List<TRowResult> scannerGet(int id) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Returns, starting at the scanner's current row value nbRows worth of
     * rows and advances to the next row in the table.  When there are no more
     * rows in the table, or a key greater-than-or-equal-to the scanner's
     * specified stopRow is reached,  an empty list is returned.
     * 
     * @return a TRowResult containing the current row and a map of the columns to TCells.
     * 
     * @throws IllegalArgument if ScannerID is invalid
     * 
     * @throws NotFound when the scanner reaches the end
     * 
     * @param id id of a scanner returned by scannerOpen
     * 
     * @param nbRows number of results to return
     */
    public java.util.List<TRowResult> scannerGetList(int id, int nbRows) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Closes the server-state associated with an open scanner.
     * 
     * @throws IllegalArgument if ScannerID is invalid
     * 
     * @param id id of a scanner returned by scannerOpen
     */
    public void scannerClose(int id) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Get the regininfo for the specified row. It scans
     * the metatable to find region's start and end keys.
     * 
     * @return value for specified row/column
     * 
     * @param row row key
     */
    public TRegionInfo getRegionInfo(java.nio.ByteBuffer row) throws IOError, org.apache.thrift.TException;

    /**
     * Appends values to one or more columns within a single row.
     * 
     * @return values of columns after the append operation.
     * 
     * @param append The single append operation to apply
     */
    public java.util.List<TCell> append(TAppend append) throws IOError, org.apache.thrift.TException;

    /**
     * Atomically checks if a row/family/qualifier value matches the expected
     * value. If it does, it adds the corresponding mutation operation for put.
     * 
     * @return true if the new put was executed, false otherwise
     * 
     * @param tableName name of table
     * 
     * @param row row key
     * 
     * @param column column name
     * 
     * @param value the expected value for the column parameter, if not
     * provided the check is for the non-existence of the
     * column in question
     * 
     * @param mput mutation for the put
     * 
     * @param attributes Mutation attributes
     */
    public boolean checkAndPut(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.nio.ByteBuffer value, Mutation mput, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException;

    /**
     * Get the type of this thrift server.
     * 
     * @return the type of this thrift server
     */
    public TThriftServerType getThriftServerType() throws org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void enableTable(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void disableTable(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void isTableEnabled(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void compact(java.nio.ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void majorCompact(java.nio.ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void getTableNames(org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.nio.ByteBuffer>> resultHandler) throws org.apache.thrift.TException;

    public void getColumnDescriptors(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>> resultHandler) throws org.apache.thrift.TException;

    public void getTableRegions(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRegionInfo>> resultHandler) throws org.apache.thrift.TException;

    public void createTable(java.nio.ByteBuffer tableName, java.util.List<ColumnDescriptor> columnFamilies, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteTable(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void get(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException;

    public void getVer(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException;

    public void getVerTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException;

    public void getRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void getRowWithColumns(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void getRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void getRowWithColumnsTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void getRows(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void getRowsWithColumns(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void getRowsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void getRowsWithColumnsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void mutateRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void mutateRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void mutateRows(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void mutateRowsTs(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void atomicIncrement(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long value, org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> resultHandler) throws org.apache.thrift.TException;

    public void deleteAll(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteAllTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteAllRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void increment(TIncrement increment, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void incrementRows(java.util.List<TIncrement> increments, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteAllRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenWithScan(java.nio.ByteBuffer tableName, TScan scan, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpen(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenWithStop(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenWithPrefix(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startAndPrefix, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException;

    public void scannerOpenWithStopTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException;

    public void scannerGet(int id, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void scannerGetList(int id, int nbRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException;

    public void scannerClose(int id, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void getRegionInfo(java.nio.ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback<TRegionInfo> resultHandler) throws org.apache.thrift.TException;

    public void append(TAppend append, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException;

    public void checkAndPut(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.nio.ByteBuffer value, Mutation mput, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void getThriftServerType(org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public void enableTable(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_enableTable(tableName);
      recv_enableTable();
    }

    public void send_enableTable(java.nio.ByteBuffer tableName) throws org.apache.thrift.TException
    {
      enableTable_args args = new enableTable_args();
      args.setTableName(tableName);
      sendBase("enableTable", args);
    }

    public void recv_enableTable() throws IOError, org.apache.thrift.TException
    {
      enableTable_result result = new enableTable_result();
      receiveBase(result, "enableTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void disableTable(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_disableTable(tableName);
      recv_disableTable();
    }

    public void send_disableTable(java.nio.ByteBuffer tableName) throws org.apache.thrift.TException
    {
      disableTable_args args = new disableTable_args();
      args.setTableName(tableName);
      sendBase("disableTable", args);
    }

    public void recv_disableTable() throws IOError, org.apache.thrift.TException
    {
      disableTable_result result = new disableTable_result();
      receiveBase(result, "disableTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public boolean isTableEnabled(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_isTableEnabled(tableName);
      return recv_isTableEnabled();
    }

    public void send_isTableEnabled(java.nio.ByteBuffer tableName) throws org.apache.thrift.TException
    {
      isTableEnabled_args args = new isTableEnabled_args();
      args.setTableName(tableName);
      sendBase("isTableEnabled", args);
    }

    public boolean recv_isTableEnabled() throws IOError, org.apache.thrift.TException
    {
      isTableEnabled_result result = new isTableEnabled_result();
      receiveBase(result, "isTableEnabled");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isTableEnabled failed: unknown result");
    }

    public void compact(java.nio.ByteBuffer tableNameOrRegionName) throws IOError, org.apache.thrift.TException
    {
      send_compact(tableNameOrRegionName);
      recv_compact();
    }

    public void send_compact(java.nio.ByteBuffer tableNameOrRegionName) throws org.apache.thrift.TException
    {
      compact_args args = new compact_args();
      args.setTableNameOrRegionName(tableNameOrRegionName);
      sendBase("compact", args);
    }

    public void recv_compact() throws IOError, org.apache.thrift.TException
    {
      compact_result result = new compact_result();
      receiveBase(result, "compact");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void majorCompact(java.nio.ByteBuffer tableNameOrRegionName) throws IOError, org.apache.thrift.TException
    {
      send_majorCompact(tableNameOrRegionName);
      recv_majorCompact();
    }

    public void send_majorCompact(java.nio.ByteBuffer tableNameOrRegionName) throws org.apache.thrift.TException
    {
      majorCompact_args args = new majorCompact_args();
      args.setTableNameOrRegionName(tableNameOrRegionName);
      sendBase("majorCompact", args);
    }

    public void recv_majorCompact() throws IOError, org.apache.thrift.TException
    {
      majorCompact_result result = new majorCompact_result();
      receiveBase(result, "majorCompact");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public java.util.List<java.nio.ByteBuffer> getTableNames() throws IOError, org.apache.thrift.TException
    {
      send_getTableNames();
      return recv_getTableNames();
    }

    public void send_getTableNames() throws org.apache.thrift.TException
    {
      getTableNames_args args = new getTableNames_args();
      sendBase("getTableNames", args);
    }

    public java.util.List<java.nio.ByteBuffer> recv_getTableNames() throws IOError, org.apache.thrift.TException
    {
      getTableNames_result result = new getTableNames_result();
      receiveBase(result, "getTableNames");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableNames failed: unknown result");
    }

    public java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> getColumnDescriptors(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_getColumnDescriptors(tableName);
      return recv_getColumnDescriptors();
    }

    public void send_getColumnDescriptors(java.nio.ByteBuffer tableName) throws org.apache.thrift.TException
    {
      getColumnDescriptors_args args = new getColumnDescriptors_args();
      args.setTableName(tableName);
      sendBase("getColumnDescriptors", args);
    }

    public java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> recv_getColumnDescriptors() throws IOError, org.apache.thrift.TException
    {
      getColumnDescriptors_result result = new getColumnDescriptors_result();
      receiveBase(result, "getColumnDescriptors");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getColumnDescriptors failed: unknown result");
    }

    public java.util.List<TRegionInfo> getTableRegions(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_getTableRegions(tableName);
      return recv_getTableRegions();
    }

    public void send_getTableRegions(java.nio.ByteBuffer tableName) throws org.apache.thrift.TException
    {
      getTableRegions_args args = new getTableRegions_args();
      args.setTableName(tableName);
      sendBase("getTableRegions", args);
    }

    public java.util.List<TRegionInfo> recv_getTableRegions() throws IOError, org.apache.thrift.TException
    {
      getTableRegions_result result = new getTableRegions_result();
      receiveBase(result, "getTableRegions");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableRegions failed: unknown result");
    }

    public void createTable(java.nio.ByteBuffer tableName, java.util.List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists, org.apache.thrift.TException
    {
      send_createTable(tableName, columnFamilies);
      recv_createTable();
    }

    public void send_createTable(java.nio.ByteBuffer tableName, java.util.List<ColumnDescriptor> columnFamilies) throws org.apache.thrift.TException
    {
      createTable_args args = new createTable_args();
      args.setTableName(tableName);
      args.setColumnFamilies(columnFamilies);
      sendBase("createTable", args);
    }

    public void recv_createTable() throws IOError, IllegalArgument, AlreadyExists, org.apache.thrift.TException
    {
      createTable_result result = new createTable_result();
      receiveBase(result, "createTable");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      if (result.exist != null) {
        throw result.exist;
      }
      return;
    }

    public void deleteTable(java.nio.ByteBuffer tableName) throws IOError, org.apache.thrift.TException
    {
      send_deleteTable(tableName);
      recv_deleteTable();
    }

    public void send_deleteTable(java.nio.ByteBuffer tableName) throws org.apache.thrift.TException
    {
      deleteTable_args args = new deleteTable_args();
      args.setTableName(tableName);
      sendBase("deleteTable", args);
    }

    public void recv_deleteTable() throws IOError, org.apache.thrift.TException
    {
      deleteTable_result result = new deleteTable_result();
      receiveBase(result, "deleteTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public java.util.List<TCell> get(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_get(tableName, row, column, attributes);
      return recv_get();
    }

    public void send_get(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      get_args args = new get_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setAttributes(attributes);
      sendBase("get", args);
    }

    public java.util.List<TCell> recv_get() throws IOError, org.apache.thrift.TException
    {
      get_result result = new get_result();
      receiveBase(result, "get");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get failed: unknown result");
    }

    public java.util.List<TCell> getVer(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getVer(tableName, row, column, numVersions, attributes);
      return recv_getVer();
    }

    public void send_getVer(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getVer_args args = new getVer_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setNumVersions(numVersions);
      args.setAttributes(attributes);
      sendBase("getVer", args);
    }

    public java.util.List<TCell> recv_getVer() throws IOError, org.apache.thrift.TException
    {
      getVer_result result = new getVer_result();
      receiveBase(result, "getVer");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getVer failed: unknown result");
    }

    public java.util.List<TCell> getVerTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getVerTs(tableName, row, column, timestamp, numVersions, attributes);
      return recv_getVerTs();
    }

    public void send_getVerTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getVerTs_args args = new getVerTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setTimestamp(timestamp);
      args.setNumVersions(numVersions);
      args.setAttributes(attributes);
      sendBase("getVerTs", args);
    }

    public java.util.List<TCell> recv_getVerTs() throws IOError, org.apache.thrift.TException
    {
      getVerTs_result result = new getVerTs_result();
      receiveBase(result, "getVerTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getVerTs failed: unknown result");
    }

    public java.util.List<TRowResult> getRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRow(tableName, row, attributes);
      return recv_getRow();
    }

    public void send_getRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRow_args args = new getRow_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setAttributes(attributes);
      sendBase("getRow", args);
    }

    public java.util.List<TRowResult> recv_getRow() throws IOError, org.apache.thrift.TException
    {
      getRow_result result = new getRow_result();
      receiveBase(result, "getRow");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRow failed: unknown result");
    }

    public java.util.List<TRowResult> getRowWithColumns(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowWithColumns(tableName, row, columns, attributes);
      return recv_getRowWithColumns();
    }

    public void send_getRowWithColumns(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowWithColumns_args args = new getRowWithColumns_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("getRowWithColumns", args);
    }

    public java.util.List<TRowResult> recv_getRowWithColumns() throws IOError, org.apache.thrift.TException
    {
      getRowWithColumns_result result = new getRowWithColumns_result();
      receiveBase(result, "getRowWithColumns");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowWithColumns failed: unknown result");
    }

    public java.util.List<TRowResult> getRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowTs(tableName, row, timestamp, attributes);
      return recv_getRowTs();
    }

    public void send_getRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowTs_args args = new getRowTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("getRowTs", args);
    }

    public java.util.List<TRowResult> recv_getRowTs() throws IOError, org.apache.thrift.TException
    {
      getRowTs_result result = new getRowTs_result();
      receiveBase(result, "getRowTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowTs failed: unknown result");
    }

    public java.util.List<TRowResult> getRowWithColumnsTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowWithColumnsTs(tableName, row, columns, timestamp, attributes);
      return recv_getRowWithColumnsTs();
    }

    public void send_getRowWithColumnsTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowWithColumnsTs_args args = new getRowWithColumnsTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumns(columns);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("getRowWithColumnsTs", args);
    }

    public java.util.List<TRowResult> recv_getRowWithColumnsTs() throws IOError, org.apache.thrift.TException
    {
      getRowWithColumnsTs_result result = new getRowWithColumnsTs_result();
      receiveBase(result, "getRowWithColumnsTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowWithColumnsTs failed: unknown result");
    }

    public java.util.List<TRowResult> getRows(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRows(tableName, rows, attributes);
      return recv_getRows();
    }

    public void send_getRows(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRows_args args = new getRows_args();
      args.setTableName(tableName);
      args.setRows(rows);
      args.setAttributes(attributes);
      sendBase("getRows", args);
    }

    public java.util.List<TRowResult> recv_getRows() throws IOError, org.apache.thrift.TException
    {
      getRows_result result = new getRows_result();
      receiveBase(result, "getRows");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRows failed: unknown result");
    }

    public java.util.List<TRowResult> getRowsWithColumns(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowsWithColumns(tableName, rows, columns, attributes);
      return recv_getRowsWithColumns();
    }

    public void send_getRowsWithColumns(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowsWithColumns_args args = new getRowsWithColumns_args();
      args.setTableName(tableName);
      args.setRows(rows);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("getRowsWithColumns", args);
    }

    public java.util.List<TRowResult> recv_getRowsWithColumns() throws IOError, org.apache.thrift.TException
    {
      getRowsWithColumns_result result = new getRowsWithColumns_result();
      receiveBase(result, "getRowsWithColumns");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowsWithColumns failed: unknown result");
    }

    public java.util.List<TRowResult> getRowsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowsTs(tableName, rows, timestamp, attributes);
      return recv_getRowsTs();
    }

    public void send_getRowsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowsTs_args args = new getRowsTs_args();
      args.setTableName(tableName);
      args.setRows(rows);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("getRowsTs", args);
    }

    public java.util.List<TRowResult> recv_getRowsTs() throws IOError, org.apache.thrift.TException
    {
      getRowsTs_result result = new getRowsTs_result();
      receiveBase(result, "getRowsTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowsTs failed: unknown result");
    }

    public java.util.List<TRowResult> getRowsWithColumnsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_getRowsWithColumnsTs(tableName, rows, columns, timestamp, attributes);
      return recv_getRowsWithColumnsTs();
    }

    public void send_getRowsWithColumnsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      getRowsWithColumnsTs_args args = new getRowsWithColumnsTs_args();
      args.setTableName(tableName);
      args.setRows(rows);
      args.setColumns(columns);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("getRowsWithColumnsTs", args);
    }

    public java.util.List<TRowResult> recv_getRowsWithColumnsTs() throws IOError, org.apache.thrift.TException
    {
      getRowsWithColumnsTs_result result = new getRowsWithColumnsTs_result();
      receiveBase(result, "getRowsWithColumnsTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRowsWithColumnsTs failed: unknown result");
    }

    public void mutateRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_mutateRow(tableName, row, mutations, attributes);
      recv_mutateRow();
    }

    public void send_mutateRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      mutateRow_args args = new mutateRow_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setMutations(mutations);
      args.setAttributes(attributes);
      sendBase("mutateRow", args);
    }

    public void recv_mutateRow() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      mutateRow_result result = new mutateRow_result();
      receiveBase(result, "mutateRow");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public void mutateRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_mutateRowTs(tableName, row, mutations, timestamp, attributes);
      recv_mutateRowTs();
    }

    public void send_mutateRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      mutateRowTs_args args = new mutateRowTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setMutations(mutations);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("mutateRowTs", args);
    }

    public void recv_mutateRowTs() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      mutateRowTs_result result = new mutateRowTs_result();
      receiveBase(result, "mutateRowTs");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public void mutateRows(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_mutateRows(tableName, rowBatches, attributes);
      recv_mutateRows();
    }

    public void send_mutateRows(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      mutateRows_args args = new mutateRows_args();
      args.setTableName(tableName);
      args.setRowBatches(rowBatches);
      args.setAttributes(attributes);
      sendBase("mutateRows", args);
    }

    public void recv_mutateRows() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      mutateRows_result result = new mutateRows_result();
      receiveBase(result, "mutateRows");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public void mutateRowsTs(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_mutateRowsTs(tableName, rowBatches, timestamp, attributes);
      recv_mutateRowsTs();
    }

    public void send_mutateRowsTs(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      mutateRowsTs_args args = new mutateRowsTs_args();
      args.setTableName(tableName);
      args.setRowBatches(rowBatches);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("mutateRowsTs", args);
    }

    public void recv_mutateRowsTs() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      mutateRowsTs_result result = new mutateRowsTs_result();
      receiveBase(result, "mutateRowsTs");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public long atomicIncrement(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long value) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_atomicIncrement(tableName, row, column, value);
      return recv_atomicIncrement();
    }

    public void send_atomicIncrement(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long value) throws org.apache.thrift.TException
    {
      atomicIncrement_args args = new atomicIncrement_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setValue(value);
      sendBase("atomicIncrement", args);
    }

    public long recv_atomicIncrement() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      atomicIncrement_result result = new atomicIncrement_result();
      receiveBase(result, "atomicIncrement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "atomicIncrement failed: unknown result");
    }

    public void deleteAll(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_deleteAll(tableName, row, column, attributes);
      recv_deleteAll();
    }

    public void send_deleteAll(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      deleteAll_args args = new deleteAll_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setAttributes(attributes);
      sendBase("deleteAll", args);
    }

    public void recv_deleteAll() throws IOError, org.apache.thrift.TException
    {
      deleteAll_result result = new deleteAll_result();
      receiveBase(result, "deleteAll");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteAllTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_deleteAllTs(tableName, row, column, timestamp, attributes);
      recv_deleteAllTs();
    }

    public void send_deleteAllTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      deleteAllTs_args args = new deleteAllTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("deleteAllTs", args);
    }

    public void recv_deleteAllTs() throws IOError, org.apache.thrift.TException
    {
      deleteAllTs_result result = new deleteAllTs_result();
      receiveBase(result, "deleteAllTs");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteAllRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_deleteAllRow(tableName, row, attributes);
      recv_deleteAllRow();
    }

    public void send_deleteAllRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      deleteAllRow_args args = new deleteAllRow_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setAttributes(attributes);
      sendBase("deleteAllRow", args);
    }

    public void recv_deleteAllRow() throws IOError, org.apache.thrift.TException
    {
      deleteAllRow_result result = new deleteAllRow_result();
      receiveBase(result, "deleteAllRow");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void increment(TIncrement increment) throws IOError, org.apache.thrift.TException
    {
      send_increment(increment);
      recv_increment();
    }

    public void send_increment(TIncrement increment) throws org.apache.thrift.TException
    {
      increment_args args = new increment_args();
      args.setIncrement(increment);
      sendBase("increment", args);
    }

    public void recv_increment() throws IOError, org.apache.thrift.TException
    {
      increment_result result = new increment_result();
      receiveBase(result, "increment");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void incrementRows(java.util.List<TIncrement> increments) throws IOError, org.apache.thrift.TException
    {
      send_incrementRows(increments);
      recv_incrementRows();
    }

    public void send_incrementRows(java.util.List<TIncrement> increments) throws org.apache.thrift.TException
    {
      incrementRows_args args = new incrementRows_args();
      args.setIncrements(increments);
      sendBase("incrementRows", args);
    }

    public void recv_incrementRows() throws IOError, org.apache.thrift.TException
    {
      incrementRows_result result = new incrementRows_result();
      receiveBase(result, "incrementRows");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteAllRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_deleteAllRowTs(tableName, row, timestamp, attributes);
      recv_deleteAllRowTs();
    }

    public void send_deleteAllRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      deleteAllRowTs_args args = new deleteAllRowTs_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("deleteAllRowTs", args);
    }

    public void recv_deleteAllRowTs() throws IOError, org.apache.thrift.TException
    {
      deleteAllRowTs_result result = new deleteAllRowTs_result();
      receiveBase(result, "deleteAllRowTs");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public int scannerOpenWithScan(java.nio.ByteBuffer tableName, TScan scan, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenWithScan(tableName, scan, attributes);
      return recv_scannerOpenWithScan();
    }

    public void send_scannerOpenWithScan(java.nio.ByteBuffer tableName, TScan scan, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenWithScan_args args = new scannerOpenWithScan_args();
      args.setTableName(tableName);
      args.setScan(scan);
      args.setAttributes(attributes);
      sendBase("scannerOpenWithScan", args);
    }

    public int recv_scannerOpenWithScan() throws IOError, org.apache.thrift.TException
    {
      scannerOpenWithScan_result result = new scannerOpenWithScan_result();
      receiveBase(result, "scannerOpenWithScan");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenWithScan failed: unknown result");
    }

    public int scannerOpen(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpen(tableName, startRow, columns, attributes);
      return recv_scannerOpen();
    }

    public void send_scannerOpen(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpen_args args = new scannerOpen_args();
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("scannerOpen", args);
    }

    public int recv_scannerOpen() throws IOError, org.apache.thrift.TException
    {
      scannerOpen_result result = new scannerOpen_result();
      receiveBase(result, "scannerOpen");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpen failed: unknown result");
    }

    public int scannerOpenWithStop(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenWithStop(tableName, startRow, stopRow, columns, attributes);
      return recv_scannerOpenWithStop();
    }

    public void send_scannerOpenWithStop(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenWithStop_args args = new scannerOpenWithStop_args();
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setStopRow(stopRow);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("scannerOpenWithStop", args);
    }

    public int recv_scannerOpenWithStop() throws IOError, org.apache.thrift.TException
    {
      scannerOpenWithStop_result result = new scannerOpenWithStop_result();
      receiveBase(result, "scannerOpenWithStop");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenWithStop failed: unknown result");
    }

    public int scannerOpenWithPrefix(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startAndPrefix, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenWithPrefix(tableName, startAndPrefix, columns, attributes);
      return recv_scannerOpenWithPrefix();
    }

    public void send_scannerOpenWithPrefix(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startAndPrefix, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenWithPrefix_args args = new scannerOpenWithPrefix_args();
      args.setTableName(tableName);
      args.setStartAndPrefix(startAndPrefix);
      args.setColumns(columns);
      args.setAttributes(attributes);
      sendBase("scannerOpenWithPrefix", args);
    }

    public int recv_scannerOpenWithPrefix() throws IOError, org.apache.thrift.TException
    {
      scannerOpenWithPrefix_result result = new scannerOpenWithPrefix_result();
      receiveBase(result, "scannerOpenWithPrefix");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenWithPrefix failed: unknown result");
    }

    public int scannerOpenTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenTs(tableName, startRow, columns, timestamp, attributes);
      return recv_scannerOpenTs();
    }

    public void send_scannerOpenTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenTs_args args = new scannerOpenTs_args();
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setColumns(columns);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("scannerOpenTs", args);
    }

    public int recv_scannerOpenTs() throws IOError, org.apache.thrift.TException
    {
      scannerOpenTs_result result = new scannerOpenTs_result();
      receiveBase(result, "scannerOpenTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenTs failed: unknown result");
    }

    public int scannerOpenWithStopTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, org.apache.thrift.TException
    {
      send_scannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp, attributes);
      return recv_scannerOpenWithStopTs();
    }

    public void send_scannerOpenWithStopTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      scannerOpenWithStopTs_args args = new scannerOpenWithStopTs_args();
      args.setTableName(tableName);
      args.setStartRow(startRow);
      args.setStopRow(stopRow);
      args.setColumns(columns);
      args.setTimestamp(timestamp);
      args.setAttributes(attributes);
      sendBase("scannerOpenWithStopTs", args);
    }

    public int recv_scannerOpenWithStopTs() throws IOError, org.apache.thrift.TException
    {
      scannerOpenWithStopTs_result result = new scannerOpenWithStopTs_result();
      receiveBase(result, "scannerOpenWithStopTs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerOpenWithStopTs failed: unknown result");
    }

    public java.util.List<TRowResult> scannerGet(int id) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_scannerGet(id);
      return recv_scannerGet();
    }

    public void send_scannerGet(int id) throws org.apache.thrift.TException
    {
      scannerGet_args args = new scannerGet_args();
      args.setId(id);
      sendBase("scannerGet", args);
    }

    public java.util.List<TRowResult> recv_scannerGet() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      scannerGet_result result = new scannerGet_result();
      receiveBase(result, "scannerGet");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerGet failed: unknown result");
    }

    public java.util.List<TRowResult> scannerGetList(int id, int nbRows) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_scannerGetList(id, nbRows);
      return recv_scannerGetList();
    }

    public void send_scannerGetList(int id, int nbRows) throws org.apache.thrift.TException
    {
      scannerGetList_args args = new scannerGetList_args();
      args.setId(id);
      args.setNbRows(nbRows);
      sendBase("scannerGetList", args);
    }

    public java.util.List<TRowResult> recv_scannerGetList() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      scannerGetList_result result = new scannerGetList_result();
      receiveBase(result, "scannerGetList");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "scannerGetList failed: unknown result");
    }

    public void scannerClose(int id) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_scannerClose(id);
      recv_scannerClose();
    }

    public void send_scannerClose(int id) throws org.apache.thrift.TException
    {
      scannerClose_args args = new scannerClose_args();
      args.setId(id);
      sendBase("scannerClose", args);
    }

    public void recv_scannerClose() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      scannerClose_result result = new scannerClose_result();
      receiveBase(result, "scannerClose");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public TRegionInfo getRegionInfo(java.nio.ByteBuffer row) throws IOError, org.apache.thrift.TException
    {
      send_getRegionInfo(row);
      return recv_getRegionInfo();
    }

    public void send_getRegionInfo(java.nio.ByteBuffer row) throws org.apache.thrift.TException
    {
      getRegionInfo_args args = new getRegionInfo_args();
      args.setRow(row);
      sendBase("getRegionInfo", args);
    }

    public TRegionInfo recv_getRegionInfo() throws IOError, org.apache.thrift.TException
    {
      getRegionInfo_result result = new getRegionInfo_result();
      receiveBase(result, "getRegionInfo");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRegionInfo failed: unknown result");
    }

    public java.util.List<TCell> append(TAppend append) throws IOError, org.apache.thrift.TException
    {
      send_append(append);
      return recv_append();
    }

    public void send_append(TAppend append) throws org.apache.thrift.TException
    {
      append_args args = new append_args();
      args.setAppend(append);
      sendBase("append", args);
    }

    public java.util.List<TCell> recv_append() throws IOError, org.apache.thrift.TException
    {
      append_result result = new append_result();
      receiveBase(result, "append");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "append failed: unknown result");
    }

    public boolean checkAndPut(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.nio.ByteBuffer value, Mutation mput, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      send_checkAndPut(tableName, row, column, value, mput, attributes);
      return recv_checkAndPut();
    }

    public void send_checkAndPut(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.nio.ByteBuffer value, Mutation mput, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) throws org.apache.thrift.TException
    {
      checkAndPut_args args = new checkAndPut_args();
      args.setTableName(tableName);
      args.setRow(row);
      args.setColumn(column);
      args.setValue(value);
      args.setMput(mput);
      args.setAttributes(attributes);
      sendBase("checkAndPut", args);
    }

    public boolean recv_checkAndPut() throws IOError, IllegalArgument, org.apache.thrift.TException
    {
      checkAndPut_result result = new checkAndPut_result();
      receiveBase(result, "checkAndPut");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkAndPut failed: unknown result");
    }

    public TThriftServerType getThriftServerType() throws org.apache.thrift.TException
    {
      send_getThriftServerType();
      return recv_getThriftServerType();
    }

    public void send_getThriftServerType() throws org.apache.thrift.TException
    {
      getThriftServerType_args args = new getThriftServerType_args();
      sendBase("getThriftServerType", args);
    }

    public TThriftServerType recv_getThriftServerType() throws org.apache.thrift.TException
    {
      getThriftServerType_result result = new getThriftServerType_result();
      receiveBase(result, "getThriftServerType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getThriftServerType failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void enableTable(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      enableTable_call method_call = new enableTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class enableTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      public enableTable_call(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("enableTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        enableTable_args args = new enableTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void disableTable(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      disableTable_call method_call = new disableTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class disableTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      public disableTable_call(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("disableTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        disableTable_args args = new disableTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void isTableEnabled(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isTableEnabled_call method_call = new isTableEnabled_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isTableEnabled_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private java.nio.ByteBuffer tableName;
      public isTableEnabled_call(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isTableEnabled", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isTableEnabled_args args = new isTableEnabled_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isTableEnabled();
      }
    }

    public void compact(java.nio.ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      compact_call method_call = new compact_call(tableNameOrRegionName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class compact_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableNameOrRegionName;
      public compact_call(java.nio.ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableNameOrRegionName = tableNameOrRegionName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("compact", org.apache.thrift.protocol.TMessageType.CALL, 0));
        compact_args args = new compact_args();
        args.setTableNameOrRegionName(tableNameOrRegionName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void majorCompact(java.nio.ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      majorCompact_call method_call = new majorCompact_call(tableNameOrRegionName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class majorCompact_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableNameOrRegionName;
      public majorCompact_call(java.nio.ByteBuffer tableNameOrRegionName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableNameOrRegionName = tableNameOrRegionName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("majorCompact", org.apache.thrift.protocol.TMessageType.CALL, 0));
        majorCompact_args args = new majorCompact_args();
        args.setTableNameOrRegionName(tableNameOrRegionName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void getTableNames(org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.nio.ByteBuffer>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableNames_call method_call = new getTableNames_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableNames_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<java.nio.ByteBuffer>> {
      public getTableNames_call(org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.nio.ByteBuffer>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableNames", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableNames_args args = new getTableNames_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<java.nio.ByteBuffer> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableNames();
      }
    }

    public void getColumnDescriptors(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getColumnDescriptors_call method_call = new getColumnDescriptors_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getColumnDescriptors_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>> {
      private java.nio.ByteBuffer tableName;
      public getColumnDescriptors_call(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getColumnDescriptors", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getColumnDescriptors_args args = new getColumnDescriptors_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getColumnDescriptors();
      }
    }

    public void getTableRegions(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRegionInfo>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableRegions_call method_call = new getTableRegions_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableRegions_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRegionInfo>> {
      private java.nio.ByteBuffer tableName;
      public getTableRegions_call(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRegionInfo>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableRegions", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableRegions_args args = new getTableRegions_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRegionInfo> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableRegions();
      }
    }

    public void createTable(java.nio.ByteBuffer tableName, java.util.List<ColumnDescriptor> columnFamilies, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createTable_call method_call = new createTable_call(tableName, columnFamilies, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.util.List<ColumnDescriptor> columnFamilies;
      public createTable_call(java.nio.ByteBuffer tableName, java.util.List<ColumnDescriptor> columnFamilies, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.columnFamilies = columnFamilies;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createTable_args args = new createTable_args();
        args.setTableName(tableName);
        args.setColumnFamilies(columnFamilies);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, IllegalArgument, AlreadyExists, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteTable(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteTable_call method_call = new deleteTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      public deleteTable_call(java.nio.ByteBuffer tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteTable_args args = new deleteTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void get(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_call method_call = new get_call(tableName, row, column, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TCell>> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer column;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public get_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_args args = new get_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get();
      }
    }

    public void getVer(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getVer_call method_call = new getVer_call(tableName, row, column, numVersions, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getVer_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TCell>> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer column;
      private int numVersions;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getVer_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.numVersions = numVersions;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getVer", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getVer_args args = new getVer_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setNumVersions(numVersions);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getVer();
      }
    }

    public void getVerTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getVerTs_call method_call = new getVerTs_call(tableName, row, column, timestamp, numVersions, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getVerTs_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TCell>> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer column;
      private long timestamp;
      private int numVersions;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getVerTs_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, int numVersions, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.timestamp = timestamp;
        this.numVersions = numVersions;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getVerTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getVerTs_args args = new getVerTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setTimestamp(timestamp);
        args.setNumVersions(numVersions);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getVerTs();
      }
    }

    public void getRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRow_call method_call = new getRow_call(tableName, row, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRow_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getRow_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRow_args args = new getRow_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRow();
      }
    }

    public void getRowWithColumns(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowWithColumns_call method_call = new getRowWithColumns_call(tableName, row, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowWithColumns_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.util.List<java.nio.ByteBuffer> columns;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getRowWithColumns_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowWithColumns", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowWithColumns_args args = new getRowWithColumns_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowWithColumns();
      }
    }

    public void getRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowTs_call method_call = new getRowTs_call(tableName, row, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowTs_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getRowTs_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowTs_args args = new getRowTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowTs();
      }
    }

    public void getRowWithColumnsTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowWithColumnsTs_call method_call = new getRowWithColumnsTs_call(tableName, row, columns, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowWithColumnsTs_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.util.List<java.nio.ByteBuffer> columns;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getRowWithColumnsTs_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.columns = columns;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowWithColumnsTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowWithColumnsTs_args args = new getRowWithColumnsTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumns(columns);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowWithColumnsTs();
      }
    }

    public void getRows(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRows_call method_call = new getRows_call(tableName, rows, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRows_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private java.nio.ByteBuffer tableName;
      private java.util.List<java.nio.ByteBuffer> rows;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getRows_call(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rows = rows;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRows_args args = new getRows_args();
        args.setTableName(tableName);
        args.setRows(rows);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRows();
      }
    }

    public void getRowsWithColumns(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowsWithColumns_call method_call = new getRowsWithColumns_call(tableName, rows, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowsWithColumns_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private java.nio.ByteBuffer tableName;
      private java.util.List<java.nio.ByteBuffer> rows;
      private java.util.List<java.nio.ByteBuffer> columns;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getRowsWithColumns_call(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rows = rows;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowsWithColumns", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowsWithColumns_args args = new getRowsWithColumns_args();
        args.setTableName(tableName);
        args.setRows(rows);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowsWithColumns();
      }
    }

    public void getRowsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowsTs_call method_call = new getRowsTs_call(tableName, rows, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowsTs_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private java.nio.ByteBuffer tableName;
      private java.util.List<java.nio.ByteBuffer> rows;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getRowsTs_call(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rows = rows;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowsTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowsTs_args args = new getRowsTs_args();
        args.setTableName(tableName);
        args.setRows(rows);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowsTs();
      }
    }

    public void getRowsWithColumnsTs(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRowsWithColumnsTs_call method_call = new getRowsWithColumnsTs_call(tableName, rows, columns, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRowsWithColumnsTs_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private java.nio.ByteBuffer tableName;
      private java.util.List<java.nio.ByteBuffer> rows;
      private java.util.List<java.nio.ByteBuffer> columns;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public getRowsWithColumnsTs_call(java.nio.ByteBuffer tableName, java.util.List<java.nio.ByteBuffer> rows, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rows = rows;
        this.columns = columns;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRowsWithColumnsTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRowsWithColumnsTs_args args = new getRowsWithColumnsTs_args();
        args.setTableName(tableName);
        args.setRows(rows);
        args.setColumns(columns);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRowsWithColumnsTs();
      }
    }

    public void mutateRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRow_call method_call = new mutateRow_call(tableName, row, mutations, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRow_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.util.List<Mutation> mutations;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public mutateRow_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.mutations = mutations;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRow_args args = new mutateRow_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setMutations(mutations);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void mutateRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRowTs_call method_call = new mutateRowTs_call(tableName, row, mutations, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRowTs_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.util.List<Mutation> mutations;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public mutateRowTs_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.List<Mutation> mutations, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.mutations = mutations;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRowTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRowTs_args args = new mutateRowTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setMutations(mutations);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void mutateRows(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRows_call method_call = new mutateRows_call(tableName, rowBatches, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRows_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.util.List<BatchMutation> rowBatches;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public mutateRows_call(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rowBatches = rowBatches;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRows_args args = new mutateRows_args();
        args.setTableName(tableName);
        args.setRowBatches(rowBatches);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void mutateRowsTs(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRowsTs_call method_call = new mutateRowsTs_call(tableName, rowBatches, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRowsTs_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.util.List<BatchMutation> rowBatches;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public mutateRowsTs_call(java.nio.ByteBuffer tableName, java.util.List<BatchMutation> rowBatches, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.rowBatches = rowBatches;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRowsTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRowsTs_args args = new mutateRowsTs_args();
        args.setTableName(tableName);
        args.setRowBatches(rowBatches);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void atomicIncrement(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long value, org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      atomicIncrement_call method_call = new atomicIncrement_call(tableName, row, column, value, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class atomicIncrement_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Long> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer column;
      private long value;
      public atomicIncrement_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long value, org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.value = value;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("atomicIncrement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        atomicIncrement_args args = new atomicIncrement_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setValue(value);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Long getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_atomicIncrement();
      }
    }

    public void deleteAll(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteAll_call method_call = new deleteAll_call(tableName, row, column, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteAll_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer column;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public deleteAll_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteAll", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteAll_args args = new deleteAll_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteAllTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteAllTs_call method_call = new deleteAllTs_call(tableName, row, column, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteAllTs_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer column;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public deleteAllTs_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteAllTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteAllTs_args args = new deleteAllTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteAllRow(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteAllRow_call method_call = new deleteAllRow_call(tableName, row, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteAllRow_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public deleteAllRow_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteAllRow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteAllRow_args args = new deleteAllRow_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void increment(TIncrement increment, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      increment_call method_call = new increment_call(increment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class increment_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TIncrement increment;
      public increment_call(TIncrement increment, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.increment = increment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("increment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        increment_args args = new increment_args();
        args.setIncrement(increment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void incrementRows(java.util.List<TIncrement> increments, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      incrementRows_call method_call = new incrementRows_call(increments, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class incrementRows_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.util.List<TIncrement> increments;
      public incrementRows_call(java.util.List<TIncrement> increments, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.increments = increments;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("incrementRows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        incrementRows_args args = new incrementRows_args();
        args.setIncrements(increments);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteAllRowTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteAllRowTs_call method_call = new deleteAllRowTs_call(tableName, row, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteAllRowTs_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public deleteAllRowTs_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteAllRowTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteAllRowTs_args args = new deleteAllRowTs_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void scannerOpenWithScan(java.nio.ByteBuffer tableName, TScan scan, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenWithScan_call method_call = new scannerOpenWithScan_call(tableName, scan, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenWithScan_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
      private java.nio.ByteBuffer tableName;
      private TScan scan;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public scannerOpenWithScan_call(java.nio.ByteBuffer tableName, TScan scan, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.scan = scan;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenWithScan", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenWithScan_args args = new scannerOpenWithScan_args();
        args.setTableName(tableName);
        args.setScan(scan);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Integer getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenWithScan();
      }
    }

    public void scannerOpen(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpen_call method_call = new scannerOpen_call(tableName, startRow, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpen_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer startRow;
      private java.util.List<java.nio.ByteBuffer> columns;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public scannerOpen_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startRow = startRow;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpen", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpen_args args = new scannerOpen_args();
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Integer getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpen();
      }
    }

    public void scannerOpenWithStop(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenWithStop_call method_call = new scannerOpenWithStop_call(tableName, startRow, stopRow, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenWithStop_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer startRow;
      private java.nio.ByteBuffer stopRow;
      private java.util.List<java.nio.ByteBuffer> columns;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public scannerOpenWithStop_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startRow = startRow;
        this.stopRow = stopRow;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenWithStop", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenWithStop_args args = new scannerOpenWithStop_args();
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setStopRow(stopRow);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Integer getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenWithStop();
      }
    }

    public void scannerOpenWithPrefix(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startAndPrefix, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenWithPrefix_call method_call = new scannerOpenWithPrefix_call(tableName, startAndPrefix, columns, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenWithPrefix_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer startAndPrefix;
      private java.util.List<java.nio.ByteBuffer> columns;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public scannerOpenWithPrefix_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startAndPrefix, java.util.List<java.nio.ByteBuffer> columns, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startAndPrefix = startAndPrefix;
        this.columns = columns;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenWithPrefix", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenWithPrefix_args args = new scannerOpenWithPrefix_args();
        args.setTableName(tableName);
        args.setStartAndPrefix(startAndPrefix);
        args.setColumns(columns);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Integer getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenWithPrefix();
      }
    }

    public void scannerOpenTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenTs_call method_call = new scannerOpenTs_call(tableName, startRow, columns, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenTs_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer startRow;
      private java.util.List<java.nio.ByteBuffer> columns;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public scannerOpenTs_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startRow = startRow;
        this.columns = columns;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenTs_args args = new scannerOpenTs_args();
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setColumns(columns);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Integer getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenTs();
      }
    }

    public void scannerOpenWithStopTs(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerOpenWithStopTs_call method_call = new scannerOpenWithStopTs_call(tableName, startRow, stopRow, columns, timestamp, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerOpenWithStopTs_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer startRow;
      private java.nio.ByteBuffer stopRow;
      private java.util.List<java.nio.ByteBuffer> columns;
      private long timestamp;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public scannerOpenWithStopTs_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer startRow, java.nio.ByteBuffer stopRow, java.util.List<java.nio.ByteBuffer> columns, long timestamp, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.startRow = startRow;
        this.stopRow = stopRow;
        this.columns = columns;
        this.timestamp = timestamp;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerOpenWithStopTs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerOpenWithStopTs_args args = new scannerOpenWithStopTs_args();
        args.setTableName(tableName);
        args.setStartRow(startRow);
        args.setStopRow(stopRow);
        args.setColumns(columns);
        args.setTimestamp(timestamp);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Integer getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerOpenWithStopTs();
      }
    }

    public void scannerGet(int id, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerGet_call method_call = new scannerGet_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerGet_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private int id;
      public scannerGet_call(int id, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerGet", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerGet_args args = new scannerGet_args();
        args.setId(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerGet();
      }
    }

    public void scannerGetList(int id, int nbRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerGetList_call method_call = new scannerGetList_call(id, nbRows, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerGetList_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TRowResult>> {
      private int id;
      private int nbRows;
      public scannerGetList_call(int id, int nbRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
        this.nbRows = nbRows;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerGetList", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerGetList_args args = new scannerGetList_args();
        args.setId(id);
        args.setNbRows(nbRows);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TRowResult> getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_scannerGetList();
      }
    }

    public void scannerClose(int id, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      scannerClose_call method_call = new scannerClose_call(id, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class scannerClose_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private int id;
      public scannerClose_call(int id, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.id = id;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("scannerClose", org.apache.thrift.protocol.TMessageType.CALL, 0));
        scannerClose_args args = new scannerClose_args();
        args.setId(id);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void getRegionInfo(java.nio.ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback<TRegionInfo> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRegionInfo_call method_call = new getRegionInfo_call(row, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRegionInfo_call extends org.apache.thrift.async.TAsyncMethodCall<TRegionInfo> {
      private java.nio.ByteBuffer row;
      public getRegionInfo_call(java.nio.ByteBuffer row, org.apache.thrift.async.AsyncMethodCallback<TRegionInfo> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.row = row;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRegionInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRegionInfo_args args = new getRegionInfo_args();
        args.setRow(row);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TRegionInfo getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRegionInfo();
      }
    }

    public void append(TAppend append, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      append_call method_call = new append_call(append, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class append_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TCell>> {
      private TAppend append;
      public append_call(TAppend append, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.append = append;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("append", org.apache.thrift.protocol.TMessageType.CALL, 0));
        append_args args = new append_args();
        args.setAppend(append);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TCell> getResult() throws IOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_append();
      }
    }

    public void checkAndPut(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.nio.ByteBuffer value, Mutation mput, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkAndPut_call method_call = new checkAndPut_call(tableName, row, column, value, mput, attributes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkAndPut_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private java.nio.ByteBuffer tableName;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer column;
      private java.nio.ByteBuffer value;
      private Mutation mput;
      private java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes;
      public checkAndPut_call(java.nio.ByteBuffer tableName, java.nio.ByteBuffer row, java.nio.ByteBuffer column, java.nio.ByteBuffer value, Mutation mput, java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.row = row;
        this.column = column;
        this.value = value;
        this.mput = mput;
        this.attributes = attributes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkAndPut", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkAndPut_args args = new checkAndPut_args();
        args.setTableName(tableName);
        args.setRow(row);
        args.setColumn(column);
        args.setValue(value);
        args.setMput(mput);
        args.setAttributes(attributes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws IOError, IllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkAndPut();
      }
    }

    public void getThriftServerType(org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getThriftServerType_call method_call = new getThriftServerType_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getThriftServerType_call extends org.apache.thrift.async.TAsyncMethodCall<TThriftServerType> {
      public getThriftServerType_call(org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getThriftServerType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getThriftServerType_args args = new getThriftServerType_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TThriftServerType getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getThriftServerType();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final org.slf4j.Logger _LOGGER = org.slf4j.LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new java.util.HashMap<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> java.util.Map<java.lang.String,  org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> getProcessMap(java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("enableTable", new enableTable());
      processMap.put("disableTable", new disableTable());
      processMap.put("isTableEnabled", new isTableEnabled());
      processMap.put("compact", new compact());
      processMap.put("majorCompact", new majorCompact());
      processMap.put("getTableNames", new getTableNames());
      processMap.put("getColumnDescriptors", new getColumnDescriptors());
      processMap.put("getTableRegions", new getTableRegions());
      processMap.put("createTable", new createTable());
      processMap.put("deleteTable", new deleteTable());
      processMap.put("get", new get());
      processMap.put("getVer", new getVer());
      processMap.put("getVerTs", new getVerTs());
      processMap.put("getRow", new getRow());
      processMap.put("getRowWithColumns", new getRowWithColumns());
      processMap.put("getRowTs", new getRowTs());
      processMap.put("getRowWithColumnsTs", new getRowWithColumnsTs());
      processMap.put("getRows", new getRows());
      processMap.put("getRowsWithColumns", new getRowsWithColumns());
      processMap.put("getRowsTs", new getRowsTs());
      processMap.put("getRowsWithColumnsTs", new getRowsWithColumnsTs());
      processMap.put("mutateRow", new mutateRow());
      processMap.put("mutateRowTs", new mutateRowTs());
      processMap.put("mutateRows", new mutateRows());
      processMap.put("mutateRowsTs", new mutateRowsTs());
      processMap.put("atomicIncrement", new atomicIncrement());
      processMap.put("deleteAll", new deleteAll());
      processMap.put("deleteAllTs", new deleteAllTs());
      processMap.put("deleteAllRow", new deleteAllRow());
      processMap.put("increment", new increment());
      processMap.put("incrementRows", new incrementRows());
      processMap.put("deleteAllRowTs", new deleteAllRowTs());
      processMap.put("scannerOpenWithScan", new scannerOpenWithScan());
      processMap.put("scannerOpen", new scannerOpen());
      processMap.put("scannerOpenWithStop", new scannerOpenWithStop());
      processMap.put("scannerOpenWithPrefix", new scannerOpenWithPrefix());
      processMap.put("scannerOpenTs", new scannerOpenTs());
      processMap.put("scannerOpenWithStopTs", new scannerOpenWithStopTs());
      processMap.put("scannerGet", new scannerGet());
      processMap.put("scannerGetList", new scannerGetList());
      processMap.put("scannerClose", new scannerClose());
      processMap.put("getRegionInfo", new getRegionInfo());
      processMap.put("append", new append());
      processMap.put("checkAndPut", new checkAndPut());
      processMap.put("getThriftServerType", new getThriftServerType());
      return processMap;
    }

    public static class enableTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, enableTable_args> {
      public enableTable() {
        super("enableTable");
      }

      public enableTable_args getEmptyArgsInstance() {
        return new enableTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public enableTable_result getResult(I iface, enableTable_args args) throws org.apache.thrift.TException {
        enableTable_result result = new enableTable_result();
        try {
          iface.enableTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class disableTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, disableTable_args> {
      public disableTable() {
        super("disableTable");
      }

      public disableTable_args getEmptyArgsInstance() {
        return new disableTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public disableTable_result getResult(I iface, disableTable_args args) throws org.apache.thrift.TException {
        disableTable_result result = new disableTable_result();
        try {
          iface.disableTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class isTableEnabled<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isTableEnabled_args> {
      public isTableEnabled() {
        super("isTableEnabled");
      }

      public isTableEnabled_args getEmptyArgsInstance() {
        return new isTableEnabled_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public isTableEnabled_result getResult(I iface, isTableEnabled_args args) throws org.apache.thrift.TException {
        isTableEnabled_result result = new isTableEnabled_result();
        try {
          result.success = iface.isTableEnabled(args.tableName);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class compact<I extends Iface> extends org.apache.thrift.ProcessFunction<I, compact_args> {
      public compact() {
        super("compact");
      }

      public compact_args getEmptyArgsInstance() {
        return new compact_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public compact_result getResult(I iface, compact_args args) throws org.apache.thrift.TException {
        compact_result result = new compact_result();
        try {
          iface.compact(args.tableNameOrRegionName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class majorCompact<I extends Iface> extends org.apache.thrift.ProcessFunction<I, majorCompact_args> {
      public majorCompact() {
        super("majorCompact");
      }

      public majorCompact_args getEmptyArgsInstance() {
        return new majorCompact_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public majorCompact_result getResult(I iface, majorCompact_args args) throws org.apache.thrift.TException {
        majorCompact_result result = new majorCompact_result();
        try {
          iface.majorCompact(args.tableNameOrRegionName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableNames<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableNames_args> {
      public getTableNames() {
        super("getTableNames");
      }

      public getTableNames_args getEmptyArgsInstance() {
        return new getTableNames_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getTableNames_result getResult(I iface, getTableNames_args args) throws org.apache.thrift.TException {
        getTableNames_result result = new getTableNames_result();
        try {
          result.success = iface.getTableNames();
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getColumnDescriptors<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getColumnDescriptors_args> {
      public getColumnDescriptors() {
        super("getColumnDescriptors");
      }

      public getColumnDescriptors_args getEmptyArgsInstance() {
        return new getColumnDescriptors_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getColumnDescriptors_result getResult(I iface, getColumnDescriptors_args args) throws org.apache.thrift.TException {
        getColumnDescriptors_result result = new getColumnDescriptors_result();
        try {
          result.success = iface.getColumnDescriptors(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableRegions<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableRegions_args> {
      public getTableRegions() {
        super("getTableRegions");
      }

      public getTableRegions_args getEmptyArgsInstance() {
        return new getTableRegions_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getTableRegions_result getResult(I iface, getTableRegions_args args) throws org.apache.thrift.TException {
        getTableRegions_result result = new getTableRegions_result();
        try {
          result.success = iface.getTableRegions(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class createTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createTable_args> {
      public createTable() {
        super("createTable");
      }

      public createTable_args getEmptyArgsInstance() {
        return new createTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public createTable_result getResult(I iface, createTable_args args) throws org.apache.thrift.TException {
        createTable_result result = new createTable_result();
        try {
          iface.createTable(args.tableName, args.columnFamilies);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        } catch (AlreadyExists exist) {
          result.exist = exist;
        }
        return result;
      }
    }

    public static class deleteTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteTable_args> {
      public deleteTable() {
        super("deleteTable");
      }

      public deleteTable_args getEmptyArgsInstance() {
        return new deleteTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteTable_result getResult(I iface, deleteTable_args args) throws org.apache.thrift.TException {
        deleteTable_result result = new deleteTable_result();
        try {
          iface.deleteTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class get<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_args> {
      public get() {
        super("get");
      }

      public get_args getEmptyArgsInstance() {
        return new get_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public get_result getResult(I iface, get_args args) throws org.apache.thrift.TException {
        get_result result = new get_result();
        try {
          result.success = iface.get(args.tableName, args.row, args.column, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getVer<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getVer_args> {
      public getVer() {
        super("getVer");
      }

      public getVer_args getEmptyArgsInstance() {
        return new getVer_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getVer_result getResult(I iface, getVer_args args) throws org.apache.thrift.TException {
        getVer_result result = new getVer_result();
        try {
          result.success = iface.getVer(args.tableName, args.row, args.column, args.numVersions, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getVerTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getVerTs_args> {
      public getVerTs() {
        super("getVerTs");
      }

      public getVerTs_args getEmptyArgsInstance() {
        return new getVerTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getVerTs_result getResult(I iface, getVerTs_args args) throws org.apache.thrift.TException {
        getVerTs_result result = new getVerTs_result();
        try {
          result.success = iface.getVerTs(args.tableName, args.row, args.column, args.timestamp, args.numVersions, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRow_args> {
      public getRow() {
        super("getRow");
      }

      public getRow_args getEmptyArgsInstance() {
        return new getRow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRow_result getResult(I iface, getRow_args args) throws org.apache.thrift.TException {
        getRow_result result = new getRow_result();
        try {
          result.success = iface.getRow(args.tableName, args.row, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowWithColumns<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowWithColumns_args> {
      public getRowWithColumns() {
        super("getRowWithColumns");
      }

      public getRowWithColumns_args getEmptyArgsInstance() {
        return new getRowWithColumns_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRowWithColumns_result getResult(I iface, getRowWithColumns_args args) throws org.apache.thrift.TException {
        getRowWithColumns_result result = new getRowWithColumns_result();
        try {
          result.success = iface.getRowWithColumns(args.tableName, args.row, args.columns, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowTs_args> {
      public getRowTs() {
        super("getRowTs");
      }

      public getRowTs_args getEmptyArgsInstance() {
        return new getRowTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRowTs_result getResult(I iface, getRowTs_args args) throws org.apache.thrift.TException {
        getRowTs_result result = new getRowTs_result();
        try {
          result.success = iface.getRowTs(args.tableName, args.row, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowWithColumnsTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowWithColumnsTs_args> {
      public getRowWithColumnsTs() {
        super("getRowWithColumnsTs");
      }

      public getRowWithColumnsTs_args getEmptyArgsInstance() {
        return new getRowWithColumnsTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRowWithColumnsTs_result getResult(I iface, getRowWithColumnsTs_args args) throws org.apache.thrift.TException {
        getRowWithColumnsTs_result result = new getRowWithColumnsTs_result();
        try {
          result.success = iface.getRowWithColumnsTs(args.tableName, args.row, args.columns, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRows_args> {
      public getRows() {
        super("getRows");
      }

      public getRows_args getEmptyArgsInstance() {
        return new getRows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRows_result getResult(I iface, getRows_args args) throws org.apache.thrift.TException {
        getRows_result result = new getRows_result();
        try {
          result.success = iface.getRows(args.tableName, args.rows, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowsWithColumns<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowsWithColumns_args> {
      public getRowsWithColumns() {
        super("getRowsWithColumns");
      }

      public getRowsWithColumns_args getEmptyArgsInstance() {
        return new getRowsWithColumns_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRowsWithColumns_result getResult(I iface, getRowsWithColumns_args args) throws org.apache.thrift.TException {
        getRowsWithColumns_result result = new getRowsWithColumns_result();
        try {
          result.success = iface.getRowsWithColumns(args.tableName, args.rows, args.columns, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowsTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowsTs_args> {
      public getRowsTs() {
        super("getRowsTs");
      }

      public getRowsTs_args getEmptyArgsInstance() {
        return new getRowsTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRowsTs_result getResult(I iface, getRowsTs_args args) throws org.apache.thrift.TException {
        getRowsTs_result result = new getRowsTs_result();
        try {
          result.success = iface.getRowsTs(args.tableName, args.rows, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRowsWithColumnsTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRowsWithColumnsTs_args> {
      public getRowsWithColumnsTs() {
        super("getRowsWithColumnsTs");
      }

      public getRowsWithColumnsTs_args getEmptyArgsInstance() {
        return new getRowsWithColumnsTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRowsWithColumnsTs_result getResult(I iface, getRowsWithColumnsTs_args args) throws org.apache.thrift.TException {
        getRowsWithColumnsTs_result result = new getRowsWithColumnsTs_result();
        try {
          result.success = iface.getRowsWithColumnsTs(args.tableName, args.rows, args.columns, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class mutateRow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRow_args> {
      public mutateRow() {
        super("mutateRow");
      }

      public mutateRow_args getEmptyArgsInstance() {
        return new mutateRow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public mutateRow_result getResult(I iface, mutateRow_args args) throws org.apache.thrift.TException {
        mutateRow_result result = new mutateRow_result();
        try {
          iface.mutateRow(args.tableName, args.row, args.mutations, args.attributes);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class mutateRowTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRowTs_args> {
      public mutateRowTs() {
        super("mutateRowTs");
      }

      public mutateRowTs_args getEmptyArgsInstance() {
        return new mutateRowTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public mutateRowTs_result getResult(I iface, mutateRowTs_args args) throws org.apache.thrift.TException {
        mutateRowTs_result result = new mutateRowTs_result();
        try {
          iface.mutateRowTs(args.tableName, args.row, args.mutations, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class mutateRows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRows_args> {
      public mutateRows() {
        super("mutateRows");
      }

      public mutateRows_args getEmptyArgsInstance() {
        return new mutateRows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public mutateRows_result getResult(I iface, mutateRows_args args) throws org.apache.thrift.TException {
        mutateRows_result result = new mutateRows_result();
        try {
          iface.mutateRows(args.tableName, args.rowBatches, args.attributes);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class mutateRowsTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRowsTs_args> {
      public mutateRowsTs() {
        super("mutateRowsTs");
      }

      public mutateRowsTs_args getEmptyArgsInstance() {
        return new mutateRowsTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public mutateRowsTs_result getResult(I iface, mutateRowsTs_args args) throws org.apache.thrift.TException {
        mutateRowsTs_result result = new mutateRowsTs_result();
        try {
          iface.mutateRowsTs(args.tableName, args.rowBatches, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class atomicIncrement<I extends Iface> extends org.apache.thrift.ProcessFunction<I, atomicIncrement_args> {
      public atomicIncrement() {
        super("atomicIncrement");
      }

      public atomicIncrement_args getEmptyArgsInstance() {
        return new atomicIncrement_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public atomicIncrement_result getResult(I iface, atomicIncrement_args args) throws org.apache.thrift.TException {
        atomicIncrement_result result = new atomicIncrement_result();
        try {
          result.success = iface.atomicIncrement(args.tableName, args.row, args.column, args.value);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class deleteAll<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteAll_args> {
      public deleteAll() {
        super("deleteAll");
      }

      public deleteAll_args getEmptyArgsInstance() {
        return new deleteAll_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteAll_result getResult(I iface, deleteAll_args args) throws org.apache.thrift.TException {
        deleteAll_result result = new deleteAll_result();
        try {
          iface.deleteAll(args.tableName, args.row, args.column, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteAllTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteAllTs_args> {
      public deleteAllTs() {
        super("deleteAllTs");
      }

      public deleteAllTs_args getEmptyArgsInstance() {
        return new deleteAllTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteAllTs_result getResult(I iface, deleteAllTs_args args) throws org.apache.thrift.TException {
        deleteAllTs_result result = new deleteAllTs_result();
        try {
          iface.deleteAllTs(args.tableName, args.row, args.column, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteAllRow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteAllRow_args> {
      public deleteAllRow() {
        super("deleteAllRow");
      }

      public deleteAllRow_args getEmptyArgsInstance() {
        return new deleteAllRow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteAllRow_result getResult(I iface, deleteAllRow_args args) throws org.apache.thrift.TException {
        deleteAllRow_result result = new deleteAllRow_result();
        try {
          iface.deleteAllRow(args.tableName, args.row, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class increment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, increment_args> {
      public increment() {
        super("increment");
      }

      public increment_args getEmptyArgsInstance() {
        return new increment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public increment_result getResult(I iface, increment_args args) throws org.apache.thrift.TException {
        increment_result result = new increment_result();
        try {
          iface.increment(args.increment);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class incrementRows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, incrementRows_args> {
      public incrementRows() {
        super("incrementRows");
      }

      public incrementRows_args getEmptyArgsInstance() {
        return new incrementRows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public incrementRows_result getResult(I iface, incrementRows_args args) throws org.apache.thrift.TException {
        incrementRows_result result = new incrementRows_result();
        try {
          iface.incrementRows(args.increments);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteAllRowTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteAllRowTs_args> {
      public deleteAllRowTs() {
        super("deleteAllRowTs");
      }

      public deleteAllRowTs_args getEmptyArgsInstance() {
        return new deleteAllRowTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteAllRowTs_result getResult(I iface, deleteAllRowTs_args args) throws org.apache.thrift.TException {
        deleteAllRowTs_result result = new deleteAllRowTs_result();
        try {
          iface.deleteAllRowTs(args.tableName, args.row, args.timestamp, args.attributes);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenWithScan<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenWithScan_args> {
      public scannerOpenWithScan() {
        super("scannerOpenWithScan");
      }

      public scannerOpenWithScan_args getEmptyArgsInstance() {
        return new scannerOpenWithScan_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerOpenWithScan_result getResult(I iface, scannerOpenWithScan_args args) throws org.apache.thrift.TException {
        scannerOpenWithScan_result result = new scannerOpenWithScan_result();
        try {
          result.success = iface.scannerOpenWithScan(args.tableName, args.scan, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpen<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpen_args> {
      public scannerOpen() {
        super("scannerOpen");
      }

      public scannerOpen_args getEmptyArgsInstance() {
        return new scannerOpen_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerOpen_result getResult(I iface, scannerOpen_args args) throws org.apache.thrift.TException {
        scannerOpen_result result = new scannerOpen_result();
        try {
          result.success = iface.scannerOpen(args.tableName, args.startRow, args.columns, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenWithStop<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenWithStop_args> {
      public scannerOpenWithStop() {
        super("scannerOpenWithStop");
      }

      public scannerOpenWithStop_args getEmptyArgsInstance() {
        return new scannerOpenWithStop_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerOpenWithStop_result getResult(I iface, scannerOpenWithStop_args args) throws org.apache.thrift.TException {
        scannerOpenWithStop_result result = new scannerOpenWithStop_result();
        try {
          result.success = iface.scannerOpenWithStop(args.tableName, args.startRow, args.stopRow, args.columns, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenWithPrefix<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenWithPrefix_args> {
      public scannerOpenWithPrefix() {
        super("scannerOpenWithPrefix");
      }

      public scannerOpenWithPrefix_args getEmptyArgsInstance() {
        return new scannerOpenWithPrefix_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerOpenWithPrefix_result getResult(I iface, scannerOpenWithPrefix_args args) throws org.apache.thrift.TException {
        scannerOpenWithPrefix_result result = new scannerOpenWithPrefix_result();
        try {
          result.success = iface.scannerOpenWithPrefix(args.tableName, args.startAndPrefix, args.columns, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenTs_args> {
      public scannerOpenTs() {
        super("scannerOpenTs");
      }

      public scannerOpenTs_args getEmptyArgsInstance() {
        return new scannerOpenTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerOpenTs_result getResult(I iface, scannerOpenTs_args args) throws org.apache.thrift.TException {
        scannerOpenTs_result result = new scannerOpenTs_result();
        try {
          result.success = iface.scannerOpenTs(args.tableName, args.startRow, args.columns, args.timestamp, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerOpenWithStopTs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerOpenWithStopTs_args> {
      public scannerOpenWithStopTs() {
        super("scannerOpenWithStopTs");
      }

      public scannerOpenWithStopTs_args getEmptyArgsInstance() {
        return new scannerOpenWithStopTs_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerOpenWithStopTs_result getResult(I iface, scannerOpenWithStopTs_args args) throws org.apache.thrift.TException {
        scannerOpenWithStopTs_result result = new scannerOpenWithStopTs_result();
        try {
          result.success = iface.scannerOpenWithStopTs(args.tableName, args.startRow, args.stopRow, args.columns, args.timestamp, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class scannerGet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerGet_args> {
      public scannerGet() {
        super("scannerGet");
      }

      public scannerGet_args getEmptyArgsInstance() {
        return new scannerGet_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerGet_result getResult(I iface, scannerGet_args args) throws org.apache.thrift.TException {
        scannerGet_result result = new scannerGet_result();
        try {
          result.success = iface.scannerGet(args.id);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class scannerGetList<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerGetList_args> {
      public scannerGetList() {
        super("scannerGetList");
      }

      public scannerGetList_args getEmptyArgsInstance() {
        return new scannerGetList_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerGetList_result getResult(I iface, scannerGetList_args args) throws org.apache.thrift.TException {
        scannerGetList_result result = new scannerGetList_result();
        try {
          result.success = iface.scannerGetList(args.id, args.nbRows);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class scannerClose<I extends Iface> extends org.apache.thrift.ProcessFunction<I, scannerClose_args> {
      public scannerClose() {
        super("scannerClose");
      }

      public scannerClose_args getEmptyArgsInstance() {
        return new scannerClose_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public scannerClose_result getResult(I iface, scannerClose_args args) throws org.apache.thrift.TException {
        scannerClose_result result = new scannerClose_result();
        try {
          iface.scannerClose(args.id);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class getRegionInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRegionInfo_args> {
      public getRegionInfo() {
        super("getRegionInfo");
      }

      public getRegionInfo_args getEmptyArgsInstance() {
        return new getRegionInfo_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRegionInfo_result getResult(I iface, getRegionInfo_args args) throws org.apache.thrift.TException {
        getRegionInfo_result result = new getRegionInfo_result();
        try {
          result.success = iface.getRegionInfo(args.row);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class append<I extends Iface> extends org.apache.thrift.ProcessFunction<I, append_args> {
      public append() {
        super("append");
      }

      public append_args getEmptyArgsInstance() {
        return new append_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public append_result getResult(I iface, append_args args) throws org.apache.thrift.TException {
        append_result result = new append_result();
        try {
          result.success = iface.append(args.append);
        } catch (IOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class checkAndPut<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkAndPut_args> {
      public checkAndPut() {
        super("checkAndPut");
      }

      public checkAndPut_args getEmptyArgsInstance() {
        return new checkAndPut_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public checkAndPut_result getResult(I iface, checkAndPut_args args) throws org.apache.thrift.TException {
        checkAndPut_result result = new checkAndPut_result();
        try {
          result.success = iface.checkAndPut(args.tableName, args.row, args.column, args.value, args.mput, args.attributes);
          result.setSuccessIsSet(true);
        } catch (IOError io) {
          result.io = io;
        } catch (IllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class getThriftServerType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getThriftServerType_args> {
      public getThriftServerType() {
        super("getThriftServerType");
      }

      public getThriftServerType_args getEmptyArgsInstance() {
        return new getThriftServerType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getThriftServerType_result getResult(I iface, getThriftServerType_args args) throws org.apache.thrift.TException {
        getThriftServerType_result result = new getThriftServerType_result();
        result.success = iface.getThriftServerType();
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final org.slf4j.Logger _LOGGER = org.slf4j.LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new java.util.HashMap<java.lang.String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("enableTable", new enableTable());
      processMap.put("disableTable", new disableTable());
      processMap.put("isTableEnabled", new isTableEnabled());
      processMap.put("compact", new compact());
      processMap.put("majorCompact", new majorCompact());
      processMap.put("getTableNames", new getTableNames());
      processMap.put("getColumnDescriptors", new getColumnDescriptors());
      processMap.put("getTableRegions", new getTableRegions());
      processMap.put("createTable", new createTable());
      processMap.put("deleteTable", new deleteTable());
      processMap.put("get", new get());
      processMap.put("getVer", new getVer());
      processMap.put("getVerTs", new getVerTs());
      processMap.put("getRow", new getRow());
      processMap.put("getRowWithColumns", new getRowWithColumns());
      processMap.put("getRowTs", new getRowTs());
      processMap.put("getRowWithColumnsTs", new getRowWithColumnsTs());
      processMap.put("getRows", new getRows());
      processMap.put("getRowsWithColumns", new getRowsWithColumns());
      processMap.put("getRowsTs", new getRowsTs());
      processMap.put("getRowsWithColumnsTs", new getRowsWithColumnsTs());
      processMap.put("mutateRow", new mutateRow());
      processMap.put("mutateRowTs", new mutateRowTs());
      processMap.put("mutateRows", new mutateRows());
      processMap.put("mutateRowsTs", new mutateRowsTs());
      processMap.put("atomicIncrement", new atomicIncrement());
      processMap.put("deleteAll", new deleteAll());
      processMap.put("deleteAllTs", new deleteAllTs());
      processMap.put("deleteAllRow", new deleteAllRow());
      processMap.put("increment", new increment());
      processMap.put("incrementRows", new incrementRows());
      processMap.put("deleteAllRowTs", new deleteAllRowTs());
      processMap.put("scannerOpenWithScan", new scannerOpenWithScan());
      processMap.put("scannerOpen", new scannerOpen());
      processMap.put("scannerOpenWithStop", new scannerOpenWithStop());
      processMap.put("scannerOpenWithPrefix", new scannerOpenWithPrefix());
      processMap.put("scannerOpenTs", new scannerOpenTs());
      processMap.put("scannerOpenWithStopTs", new scannerOpenWithStopTs());
      processMap.put("scannerGet", new scannerGet());
      processMap.put("scannerGetList", new scannerGetList());
      processMap.put("scannerClose", new scannerClose());
      processMap.put("getRegionInfo", new getRegionInfo());
      processMap.put("append", new append());
      processMap.put("checkAndPut", new checkAndPut());
      processMap.put("getThriftServerType", new getThriftServerType());
      return processMap;
    }

    public static class enableTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, enableTable_args, Void> {
      public enableTable() {
        super("enableTable");
      }

      public enableTable_args getEmptyArgsInstance() {
        return new enableTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            enableTable_result result = new enableTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            enableTable_result result = new enableTable_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, enableTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.enableTable(args.tableName,resultHandler);
      }
    }

    public static class disableTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, disableTable_args, Void> {
      public disableTable() {
        super("disableTable");
      }

      public disableTable_args getEmptyArgsInstance() {
        return new disableTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            disableTable_result result = new disableTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            disableTable_result result = new disableTable_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, disableTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.disableTable(args.tableName,resultHandler);
      }
    }

    public static class isTableEnabled<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isTableEnabled_args, java.lang.Boolean> {
      public isTableEnabled() {
        super("isTableEnabled");
      }

      public isTableEnabled_args getEmptyArgsInstance() {
        return new isTableEnabled_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            isTableEnabled_result result = new isTableEnabled_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            isTableEnabled_result result = new isTableEnabled_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isTableEnabled_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.isTableEnabled(args.tableName,resultHandler);
      }
    }

    public static class compact<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, compact_args, Void> {
      public compact() {
        super("compact");
      }

      public compact_args getEmptyArgsInstance() {
        return new compact_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            compact_result result = new compact_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            compact_result result = new compact_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, compact_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.compact(args.tableNameOrRegionName,resultHandler);
      }
    }

    public static class majorCompact<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, majorCompact_args, Void> {
      public majorCompact() {
        super("majorCompact");
      }

      public majorCompact_args getEmptyArgsInstance() {
        return new majorCompact_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            majorCompact_result result = new majorCompact_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            majorCompact_result result = new majorCompact_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, majorCompact_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.majorCompact(args.tableNameOrRegionName,resultHandler);
      }
    }

    public static class getTableNames<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableNames_args, java.util.List<java.nio.ByteBuffer>> {
      public getTableNames() {
        super("getTableNames");
      }

      public getTableNames_args getEmptyArgsInstance() {
        return new getTableNames_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.nio.ByteBuffer>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.nio.ByteBuffer>>() { 
          public void onComplete(java.util.List<java.nio.ByteBuffer> o) {
            getTableNames_result result = new getTableNames_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTableNames_result result = new getTableNames_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableNames_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.nio.ByteBuffer>> resultHandler) throws org.apache.thrift.TException {
        iface.getTableNames(resultHandler);
      }
    }

    public static class getColumnDescriptors<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getColumnDescriptors_args, java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>> {
      public getColumnDescriptors() {
        super("getColumnDescriptors");
      }

      public getColumnDescriptors_args getEmptyArgsInstance() {
        return new getColumnDescriptors_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>>() { 
          public void onComplete(java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> o) {
            getColumnDescriptors_result result = new getColumnDescriptors_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getColumnDescriptors_result result = new getColumnDescriptors_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getColumnDescriptors_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>> resultHandler) throws org.apache.thrift.TException {
        iface.getColumnDescriptors(args.tableName,resultHandler);
      }
    }

    public static class getTableRegions<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableRegions_args, java.util.List<TRegionInfo>> {
      public getTableRegions() {
        super("getTableRegions");
      }

      public getTableRegions_args getEmptyArgsInstance() {
        return new getTableRegions_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRegionInfo>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRegionInfo>>() { 
          public void onComplete(java.util.List<TRegionInfo> o) {
            getTableRegions_result result = new getTableRegions_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTableRegions_result result = new getTableRegions_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableRegions_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRegionInfo>> resultHandler) throws org.apache.thrift.TException {
        iface.getTableRegions(args.tableName,resultHandler);
      }
    }

    public static class createTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createTable_args, Void> {
      public createTable() {
        super("createTable");
      }

      public createTable_args getEmptyArgsInstance() {
        return new createTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createTable_result result = new createTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            createTable_result result = new createTable_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof AlreadyExists) {
              result.exist = (AlreadyExists) e;
              result.setExistIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.createTable(args.tableName, args.columnFamilies,resultHandler);
      }
    }

    public static class deleteTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteTable_args, Void> {
      public deleteTable() {
        super("deleteTable");
      }

      public deleteTable_args getEmptyArgsInstance() {
        return new deleteTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteTable_result result = new deleteTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteTable_result result = new deleteTable_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteTable(args.tableName,resultHandler);
      }
    }

    public static class get<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, get_args, java.util.List<TCell>> {
      public get() {
        super("get");
      }

      public get_args getEmptyArgsInstance() {
        return new get_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>>() { 
          public void onComplete(java.util.List<TCell> o) {
            get_result result = new get_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            get_result result = new get_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, get_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException {
        iface.get(args.tableName, args.row, args.column, args.attributes,resultHandler);
      }
    }

    public static class getVer<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getVer_args, java.util.List<TCell>> {
      public getVer() {
        super("getVer");
      }

      public getVer_args getEmptyArgsInstance() {
        return new getVer_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>>() { 
          public void onComplete(java.util.List<TCell> o) {
            getVer_result result = new getVer_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getVer_result result = new getVer_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getVer_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException {
        iface.getVer(args.tableName, args.row, args.column, args.numVersions, args.attributes,resultHandler);
      }
    }

    public static class getVerTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getVerTs_args, java.util.List<TCell>> {
      public getVerTs() {
        super("getVerTs");
      }

      public getVerTs_args getEmptyArgsInstance() {
        return new getVerTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>>() { 
          public void onComplete(java.util.List<TCell> o) {
            getVerTs_result result = new getVerTs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getVerTs_result result = new getVerTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getVerTs_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException {
        iface.getVerTs(args.tableName, args.row, args.column, args.timestamp, args.numVersions, args.attributes,resultHandler);
      }
    }

    public static class getRow<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRow_args, java.util.List<TRowResult>> {
      public getRow() {
        super("getRow");
      }

      public getRow_args getEmptyArgsInstance() {
        return new getRow_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            getRow_result result = new getRow_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRow_result result = new getRow_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRow_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getRow(args.tableName, args.row, args.attributes,resultHandler);
      }
    }

    public static class getRowWithColumns<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRowWithColumns_args, java.util.List<TRowResult>> {
      public getRowWithColumns() {
        super("getRowWithColumns");
      }

      public getRowWithColumns_args getEmptyArgsInstance() {
        return new getRowWithColumns_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            getRowWithColumns_result result = new getRowWithColumns_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRowWithColumns_result result = new getRowWithColumns_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRowWithColumns_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getRowWithColumns(args.tableName, args.row, args.columns, args.attributes,resultHandler);
      }
    }

    public static class getRowTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRowTs_args, java.util.List<TRowResult>> {
      public getRowTs() {
        super("getRowTs");
      }

      public getRowTs_args getEmptyArgsInstance() {
        return new getRowTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            getRowTs_result result = new getRowTs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRowTs_result result = new getRowTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRowTs_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getRowTs(args.tableName, args.row, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class getRowWithColumnsTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRowWithColumnsTs_args, java.util.List<TRowResult>> {
      public getRowWithColumnsTs() {
        super("getRowWithColumnsTs");
      }

      public getRowWithColumnsTs_args getEmptyArgsInstance() {
        return new getRowWithColumnsTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            getRowWithColumnsTs_result result = new getRowWithColumnsTs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRowWithColumnsTs_result result = new getRowWithColumnsTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRowWithColumnsTs_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getRowWithColumnsTs(args.tableName, args.row, args.columns, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class getRows<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRows_args, java.util.List<TRowResult>> {
      public getRows() {
        super("getRows");
      }

      public getRows_args getEmptyArgsInstance() {
        return new getRows_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            getRows_result result = new getRows_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRows_result result = new getRows_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRows_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getRows(args.tableName, args.rows, args.attributes,resultHandler);
      }
    }

    public static class getRowsWithColumns<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRowsWithColumns_args, java.util.List<TRowResult>> {
      public getRowsWithColumns() {
        super("getRowsWithColumns");
      }

      public getRowsWithColumns_args getEmptyArgsInstance() {
        return new getRowsWithColumns_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            getRowsWithColumns_result result = new getRowsWithColumns_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRowsWithColumns_result result = new getRowsWithColumns_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRowsWithColumns_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getRowsWithColumns(args.tableName, args.rows, args.columns, args.attributes,resultHandler);
      }
    }

    public static class getRowsTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRowsTs_args, java.util.List<TRowResult>> {
      public getRowsTs() {
        super("getRowsTs");
      }

      public getRowsTs_args getEmptyArgsInstance() {
        return new getRowsTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            getRowsTs_result result = new getRowsTs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRowsTs_result result = new getRowsTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRowsTs_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getRowsTs(args.tableName, args.rows, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class getRowsWithColumnsTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRowsWithColumnsTs_args, java.util.List<TRowResult>> {
      public getRowsWithColumnsTs() {
        super("getRowsWithColumnsTs");
      }

      public getRowsWithColumnsTs_args getEmptyArgsInstance() {
        return new getRowsWithColumnsTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            getRowsWithColumnsTs_result result = new getRowsWithColumnsTs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRowsWithColumnsTs_result result = new getRowsWithColumnsTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRowsWithColumnsTs_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getRowsWithColumnsTs(args.tableName, args.rows, args.columns, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class mutateRow<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, mutateRow_args, Void> {
      public mutateRow() {
        super("mutateRow");
      }

      public mutateRow_args getEmptyArgsInstance() {
        return new mutateRow_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            mutateRow_result result = new mutateRow_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            mutateRow_result result = new mutateRow_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, mutateRow_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.mutateRow(args.tableName, args.row, args.mutations, args.attributes,resultHandler);
      }
    }

    public static class mutateRowTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, mutateRowTs_args, Void> {
      public mutateRowTs() {
        super("mutateRowTs");
      }

      public mutateRowTs_args getEmptyArgsInstance() {
        return new mutateRowTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            mutateRowTs_result result = new mutateRowTs_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            mutateRowTs_result result = new mutateRowTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, mutateRowTs_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.mutateRowTs(args.tableName, args.row, args.mutations, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class mutateRows<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, mutateRows_args, Void> {
      public mutateRows() {
        super("mutateRows");
      }

      public mutateRows_args getEmptyArgsInstance() {
        return new mutateRows_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            mutateRows_result result = new mutateRows_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            mutateRows_result result = new mutateRows_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, mutateRows_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.mutateRows(args.tableName, args.rowBatches, args.attributes,resultHandler);
      }
    }

    public static class mutateRowsTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, mutateRowsTs_args, Void> {
      public mutateRowsTs() {
        super("mutateRowsTs");
      }

      public mutateRowsTs_args getEmptyArgsInstance() {
        return new mutateRowsTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            mutateRowsTs_result result = new mutateRowsTs_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            mutateRowsTs_result result = new mutateRowsTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, mutateRowsTs_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.mutateRowsTs(args.tableName, args.rowBatches, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class atomicIncrement<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, atomicIncrement_args, java.lang.Long> {
      public atomicIncrement() {
        super("atomicIncrement");
      }

      public atomicIncrement_args getEmptyArgsInstance() {
        return new atomicIncrement_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Long>() { 
          public void onComplete(java.lang.Long o) {
            atomicIncrement_result result = new atomicIncrement_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            atomicIncrement_result result = new atomicIncrement_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, atomicIncrement_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> resultHandler) throws org.apache.thrift.TException {
        iface.atomicIncrement(args.tableName, args.row, args.column, args.value,resultHandler);
      }
    }

    public static class deleteAll<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteAll_args, Void> {
      public deleteAll() {
        super("deleteAll");
      }

      public deleteAll_args getEmptyArgsInstance() {
        return new deleteAll_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteAll_result result = new deleteAll_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteAll_result result = new deleteAll_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteAll_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteAll(args.tableName, args.row, args.column, args.attributes,resultHandler);
      }
    }

    public static class deleteAllTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteAllTs_args, Void> {
      public deleteAllTs() {
        super("deleteAllTs");
      }

      public deleteAllTs_args getEmptyArgsInstance() {
        return new deleteAllTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteAllTs_result result = new deleteAllTs_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteAllTs_result result = new deleteAllTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteAllTs_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteAllTs(args.tableName, args.row, args.column, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class deleteAllRow<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteAllRow_args, Void> {
      public deleteAllRow() {
        super("deleteAllRow");
      }

      public deleteAllRow_args getEmptyArgsInstance() {
        return new deleteAllRow_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteAllRow_result result = new deleteAllRow_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteAllRow_result result = new deleteAllRow_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteAllRow_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteAllRow(args.tableName, args.row, args.attributes,resultHandler);
      }
    }

    public static class increment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, increment_args, Void> {
      public increment() {
        super("increment");
      }

      public increment_args getEmptyArgsInstance() {
        return new increment_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            increment_result result = new increment_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            increment_result result = new increment_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, increment_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.increment(args.increment,resultHandler);
      }
    }

    public static class incrementRows<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, incrementRows_args, Void> {
      public incrementRows() {
        super("incrementRows");
      }

      public incrementRows_args getEmptyArgsInstance() {
        return new incrementRows_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            incrementRows_result result = new incrementRows_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            incrementRows_result result = new incrementRows_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, incrementRows_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.incrementRows(args.increments,resultHandler);
      }
    }

    public static class deleteAllRowTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteAllRowTs_args, Void> {
      public deleteAllRowTs() {
        super("deleteAllRowTs");
      }

      public deleteAllRowTs_args getEmptyArgsInstance() {
        return new deleteAllRowTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteAllRowTs_result result = new deleteAllRowTs_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteAllRowTs_result result = new deleteAllRowTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteAllRowTs_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteAllRowTs(args.tableName, args.row, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class scannerOpenWithScan<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerOpenWithScan_args, java.lang.Integer> {
      public scannerOpenWithScan() {
        super("scannerOpenWithScan");
      }

      public scannerOpenWithScan_args getEmptyArgsInstance() {
        return new scannerOpenWithScan_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() { 
          public void onComplete(java.lang.Integer o) {
            scannerOpenWithScan_result result = new scannerOpenWithScan_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerOpenWithScan_result result = new scannerOpenWithScan_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerOpenWithScan_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
        iface.scannerOpenWithScan(args.tableName, args.scan, args.attributes,resultHandler);
      }
    }

    public static class scannerOpen<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerOpen_args, java.lang.Integer> {
      public scannerOpen() {
        super("scannerOpen");
      }

      public scannerOpen_args getEmptyArgsInstance() {
        return new scannerOpen_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() { 
          public void onComplete(java.lang.Integer o) {
            scannerOpen_result result = new scannerOpen_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerOpen_result result = new scannerOpen_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerOpen_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
        iface.scannerOpen(args.tableName, args.startRow, args.columns, args.attributes,resultHandler);
      }
    }

    public static class scannerOpenWithStop<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerOpenWithStop_args, java.lang.Integer> {
      public scannerOpenWithStop() {
        super("scannerOpenWithStop");
      }

      public scannerOpenWithStop_args getEmptyArgsInstance() {
        return new scannerOpenWithStop_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() { 
          public void onComplete(java.lang.Integer o) {
            scannerOpenWithStop_result result = new scannerOpenWithStop_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerOpenWithStop_result result = new scannerOpenWithStop_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerOpenWithStop_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
        iface.scannerOpenWithStop(args.tableName, args.startRow, args.stopRow, args.columns, args.attributes,resultHandler);
      }
    }

    public static class scannerOpenWithPrefix<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerOpenWithPrefix_args, java.lang.Integer> {
      public scannerOpenWithPrefix() {
        super("scannerOpenWithPrefix");
      }

      public scannerOpenWithPrefix_args getEmptyArgsInstance() {
        return new scannerOpenWithPrefix_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() { 
          public void onComplete(java.lang.Integer o) {
            scannerOpenWithPrefix_result result = new scannerOpenWithPrefix_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerOpenWithPrefix_result result = new scannerOpenWithPrefix_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerOpenWithPrefix_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
        iface.scannerOpenWithPrefix(args.tableName, args.startAndPrefix, args.columns, args.attributes,resultHandler);
      }
    }

    public static class scannerOpenTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerOpenTs_args, java.lang.Integer> {
      public scannerOpenTs() {
        super("scannerOpenTs");
      }

      public scannerOpenTs_args getEmptyArgsInstance() {
        return new scannerOpenTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() { 
          public void onComplete(java.lang.Integer o) {
            scannerOpenTs_result result = new scannerOpenTs_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerOpenTs_result result = new scannerOpenTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerOpenTs_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
        iface.scannerOpenTs(args.tableName, args.startRow, args.columns, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class scannerOpenWithStopTs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerOpenWithStopTs_args, java.lang.Integer> {
      public scannerOpenWithStopTs() {
        super("scannerOpenWithStopTs");
      }

      public scannerOpenWithStopTs_args getEmptyArgsInstance() {
        return new scannerOpenWithStopTs_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() { 
          public void onComplete(java.lang.Integer o) {
            scannerOpenWithStopTs_result result = new scannerOpenWithStopTs_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerOpenWithStopTs_result result = new scannerOpenWithStopTs_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerOpenWithStopTs_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
        iface.scannerOpenWithStopTs(args.tableName, args.startRow, args.stopRow, args.columns, args.timestamp, args.attributes,resultHandler);
      }
    }

    public static class scannerGet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerGet_args, java.util.List<TRowResult>> {
      public scannerGet() {
        super("scannerGet");
      }

      public scannerGet_args getEmptyArgsInstance() {
        return new scannerGet_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            scannerGet_result result = new scannerGet_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerGet_result result = new scannerGet_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerGet_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.scannerGet(args.id,resultHandler);
      }
    }

    public static class scannerGetList<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerGetList_args, java.util.List<TRowResult>> {
      public scannerGetList() {
        super("scannerGetList");
      }

      public scannerGetList_args getEmptyArgsInstance() {
        return new scannerGetList_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>>() { 
          public void onComplete(java.util.List<TRowResult> o) {
            scannerGetList_result result = new scannerGetList_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerGetList_result result = new scannerGetList_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerGetList_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TRowResult>> resultHandler) throws org.apache.thrift.TException {
        iface.scannerGetList(args.id, args.nbRows,resultHandler);
      }
    }

    public static class scannerClose<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, scannerClose_args, Void> {
      public scannerClose() {
        super("scannerClose");
      }

      public scannerClose_args getEmptyArgsInstance() {
        return new scannerClose_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            scannerClose_result result = new scannerClose_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            scannerClose_result result = new scannerClose_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, scannerClose_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.scannerClose(args.id,resultHandler);
      }
    }

    public static class getRegionInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRegionInfo_args, TRegionInfo> {
      public getRegionInfo() {
        super("getRegionInfo");
      }

      public getRegionInfo_args getEmptyArgsInstance() {
        return new getRegionInfo_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<TRegionInfo> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TRegionInfo>() { 
          public void onComplete(TRegionInfo o) {
            getRegionInfo_result result = new getRegionInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRegionInfo_result result = new getRegionInfo_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRegionInfo_args args, org.apache.thrift.async.AsyncMethodCallback<TRegionInfo> resultHandler) throws org.apache.thrift.TException {
        iface.getRegionInfo(args.row,resultHandler);
      }
    }

    public static class append<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, append_args, java.util.List<TCell>> {
      public append() {
        super("append");
      }

      public append_args getEmptyArgsInstance() {
        return new append_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>>() { 
          public void onComplete(java.util.List<TCell> o) {
            append_result result = new append_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            append_result result = new append_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, append_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCell>> resultHandler) throws org.apache.thrift.TException {
        iface.append(args.append,resultHandler);
      }
    }

    public static class checkAndPut<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkAndPut_args, java.lang.Boolean> {
      public checkAndPut() {
        super("checkAndPut");
      }

      public checkAndPut_args getEmptyArgsInstance() {
        return new checkAndPut_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            checkAndPut_result result = new checkAndPut_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            checkAndPut_result result = new checkAndPut_result();
            if (e instanceof IOError) {
              result.io = (IOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof IllegalArgument) {
              result.ia = (IllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkAndPut_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.checkAndPut(args.tableName, args.row, args.column, args.value, args.mput, args.attributes,resultHandler);
      }
    }

    public static class getThriftServerType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getThriftServerType_args, TThriftServerType> {
      public getThriftServerType() {
        super("getThriftServerType");
      }

      public getThriftServerType_args getEmptyArgsInstance() {
        return new getThriftServerType_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TThriftServerType>() { 
          public void onComplete(TThriftServerType o) {
            getThriftServerType_result result = new getThriftServerType_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getThriftServerType_result result = new getThriftServerType_result();
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getThriftServerType_args args, org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> resultHandler) throws org.apache.thrift.TException {
        iface.getThriftServerType(resultHandler);
      }
    }

  }

  public static class enableTable_args implements org.apache.thrift.TBase<enableTable_args, enableTable_args._Fields>, java.io.Serializable, Cloneable, Comparable<enableTable_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("enableTable_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new enableTable_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new enableTable_argsTupleSchemeFactory();

    /**
     * name of the table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table
       */
      TABLE_NAME((short)1, "tableName");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(enableTable_args.class, metaDataMap);
    }

    public enableTable_args() {
    }

    public enableTable_args(
      java.nio.ByteBuffer tableName)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public enableTable_args(enableTable_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
    }

    public enableTable_args deepCopy() {
      return new enableTable_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * name of the table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of the table
     */
    public enableTable_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public enableTable_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof enableTable_args)
        return this.equals((enableTable_args)that);
      return false;
    }

    public boolean equals(enableTable_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(enableTable_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("enableTable_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class enableTable_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public enableTable_argsStandardScheme getScheme() {
        return new enableTable_argsStandardScheme();
      }
    }

    private static class enableTable_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<enableTable_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, enableTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, enableTable_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class enableTable_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public enableTable_argsTupleScheme getScheme() {
        return new enableTable_argsTupleScheme();
      }
    }

    private static class enableTable_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<enableTable_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, enableTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, enableTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class enableTable_result implements org.apache.thrift.TBase<enableTable_result, enableTable_result._Fields>, java.io.Serializable, Cloneable, Comparable<enableTable_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("enableTable_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new enableTable_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new enableTable_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(enableTable_result.class, metaDataMap);
    }

    public enableTable_result() {
    }

    public enableTable_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public enableTable_result(enableTable_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public enableTable_result deepCopy() {
      return new enableTable_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public enableTable_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof enableTable_result)
        return this.equals((enableTable_result)that);
      return false;
    }

    public boolean equals(enableTable_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(enableTable_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("enableTable_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class enableTable_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public enableTable_resultStandardScheme getScheme() {
        return new enableTable_resultStandardScheme();
      }
    }

    private static class enableTable_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<enableTable_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, enableTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, enableTable_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class enableTable_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public enableTable_resultTupleScheme getScheme() {
        return new enableTable_resultTupleScheme();
      }
    }

    private static class enableTable_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<enableTable_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, enableTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, enableTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class disableTable_args implements org.apache.thrift.TBase<disableTable_args, disableTable_args._Fields>, java.io.Serializable, Cloneable, Comparable<disableTable_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("disableTable_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new disableTable_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new disableTable_argsTupleSchemeFactory();

    /**
     * name of the table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table
       */
      TABLE_NAME((short)1, "tableName");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(disableTable_args.class, metaDataMap);
    }

    public disableTable_args() {
    }

    public disableTable_args(
      java.nio.ByteBuffer tableName)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public disableTable_args(disableTable_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
    }

    public disableTable_args deepCopy() {
      return new disableTable_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * name of the table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of the table
     */
    public disableTable_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public disableTable_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof disableTable_args)
        return this.equals((disableTable_args)that);
      return false;
    }

    public boolean equals(disableTable_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(disableTable_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("disableTable_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class disableTable_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public disableTable_argsStandardScheme getScheme() {
        return new disableTable_argsStandardScheme();
      }
    }

    private static class disableTable_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<disableTable_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, disableTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, disableTable_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class disableTable_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public disableTable_argsTupleScheme getScheme() {
        return new disableTable_argsTupleScheme();
      }
    }

    private static class disableTable_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<disableTable_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, disableTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, disableTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class disableTable_result implements org.apache.thrift.TBase<disableTable_result, disableTable_result._Fields>, java.io.Serializable, Cloneable, Comparable<disableTable_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("disableTable_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new disableTable_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new disableTable_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(disableTable_result.class, metaDataMap);
    }

    public disableTable_result() {
    }

    public disableTable_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public disableTable_result(disableTable_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public disableTable_result deepCopy() {
      return new disableTable_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public disableTable_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof disableTable_result)
        return this.equals((disableTable_result)that);
      return false;
    }

    public boolean equals(disableTable_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(disableTable_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("disableTable_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class disableTable_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public disableTable_resultStandardScheme getScheme() {
        return new disableTable_resultStandardScheme();
      }
    }

    private static class disableTable_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<disableTable_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, disableTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, disableTable_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class disableTable_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public disableTable_resultTupleScheme getScheme() {
        return new disableTable_resultTupleScheme();
      }
    }

    private static class disableTable_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<disableTable_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, disableTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, disableTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class isTableEnabled_args implements org.apache.thrift.TBase<isTableEnabled_args, isTableEnabled_args._Fields>, java.io.Serializable, Cloneable, Comparable<isTableEnabled_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isTableEnabled_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new isTableEnabled_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new isTableEnabled_argsTupleSchemeFactory();

    /**
     * name of the table to check
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table to check
       */
      TABLE_NAME((short)1, "tableName");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isTableEnabled_args.class, metaDataMap);
    }

    public isTableEnabled_args() {
    }

    public isTableEnabled_args(
      java.nio.ByteBuffer tableName)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isTableEnabled_args(isTableEnabled_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
    }

    public isTableEnabled_args deepCopy() {
      return new isTableEnabled_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * name of the table to check
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of the table to check
     */
    public isTableEnabled_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public isTableEnabled_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof isTableEnabled_args)
        return this.equals((isTableEnabled_args)that);
      return false;
    }

    public boolean equals(isTableEnabled_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(isTableEnabled_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("isTableEnabled_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isTableEnabled_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public isTableEnabled_argsStandardScheme getScheme() {
        return new isTableEnabled_argsStandardScheme();
      }
    }

    private static class isTableEnabled_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<isTableEnabled_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isTableEnabled_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isTableEnabled_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isTableEnabled_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public isTableEnabled_argsTupleScheme getScheme() {
        return new isTableEnabled_argsTupleScheme();
      }
    }

    private static class isTableEnabled_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<isTableEnabled_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isTableEnabled_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isTableEnabled_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class isTableEnabled_result implements org.apache.thrift.TBase<isTableEnabled_result, isTableEnabled_result._Fields>, java.io.Serializable, Cloneable, Comparable<isTableEnabled_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("isTableEnabled_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new isTableEnabled_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new isTableEnabled_resultTupleSchemeFactory();

    public boolean success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(isTableEnabled_result.class, metaDataMap);
    }

    public isTableEnabled_result() {
    }

    public isTableEnabled_result(
      boolean success,
      IOError io)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public isTableEnabled_result(isTableEnabled_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public isTableEnabled_result deepCopy() {
      return new isTableEnabled_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.io = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public isTableEnabled_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public isTableEnabled_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.lang.Boolean)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof isTableEnabled_result)
        return this.equals((isTableEnabled_result)that);
      return false;
    }

    public boolean equals(isTableEnabled_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((success) ? 131071 : 524287);

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(isTableEnabled_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("isTableEnabled_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class isTableEnabled_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public isTableEnabled_resultStandardScheme getScheme() {
        return new isTableEnabled_resultStandardScheme();
      }
    }

    private static class isTableEnabled_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<isTableEnabled_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, isTableEnabled_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, isTableEnabled_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class isTableEnabled_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public isTableEnabled_resultTupleScheme getScheme() {
        return new isTableEnabled_resultTupleScheme();
      }
    }

    private static class isTableEnabled_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<isTableEnabled_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, isTableEnabled_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, isTableEnabled_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class compact_args implements org.apache.thrift.TBase<compact_args, compact_args._Fields>, java.io.Serializable, Cloneable, Comparable<compact_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("compact_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_OR_REGION_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableNameOrRegionName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new compact_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new compact_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableNameOrRegionName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TABLE_NAME_OR_REGION_NAME((short)1, "tableNameOrRegionName");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME_OR_REGION_NAME
            return TABLE_NAME_OR_REGION_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME_OR_REGION_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableNameOrRegionName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(compact_args.class, metaDataMap);
    }

    public compact_args() {
    }

    public compact_args(
      java.nio.ByteBuffer tableNameOrRegionName)
    {
      this();
      this.tableNameOrRegionName = org.apache.thrift.TBaseHelper.copyBinary(tableNameOrRegionName);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public compact_args(compact_args other) {
      if (other.isSetTableNameOrRegionName()) {
        this.tableNameOrRegionName = org.apache.thrift.TBaseHelper.copyBinary(other.tableNameOrRegionName);
      }
    }

    public compact_args deepCopy() {
      return new compact_args(this);
    }

    @Override
    public void clear() {
      this.tableNameOrRegionName = null;
    }

    public byte[] getTableNameOrRegionName() {
      setTableNameOrRegionName(org.apache.thrift.TBaseHelper.rightSize(tableNameOrRegionName));
      return tableNameOrRegionName == null ? null : tableNameOrRegionName.array();
    }

    public java.nio.ByteBuffer bufferForTableNameOrRegionName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableNameOrRegionName);
    }

    public compact_args setTableNameOrRegionName(byte[] tableNameOrRegionName) {
      this.tableNameOrRegionName = tableNameOrRegionName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableNameOrRegionName.clone());
      return this;
    }

    public compact_args setTableNameOrRegionName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableNameOrRegionName) {
      this.tableNameOrRegionName = org.apache.thrift.TBaseHelper.copyBinary(tableNameOrRegionName);
      return this;
    }

    public void unsetTableNameOrRegionName() {
      this.tableNameOrRegionName = null;
    }

    /** Returns true if field tableNameOrRegionName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableNameOrRegionName() {
      return this.tableNameOrRegionName != null;
    }

    public void setTableNameOrRegionNameIsSet(boolean value) {
      if (!value) {
        this.tableNameOrRegionName = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        if (value == null) {
          unsetTableNameOrRegionName();
        } else {
          if (value instanceof byte[]) {
            setTableNameOrRegionName((byte[])value);
          } else {
            setTableNameOrRegionName((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        return getTableNameOrRegionName();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        return isSetTableNameOrRegionName();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof compact_args)
        return this.equals((compact_args)that);
      return false;
    }

    public boolean equals(compact_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableNameOrRegionName = true && this.isSetTableNameOrRegionName();
      boolean that_present_tableNameOrRegionName = true && that.isSetTableNameOrRegionName();
      if (this_present_tableNameOrRegionName || that_present_tableNameOrRegionName) {
        if (!(this_present_tableNameOrRegionName && that_present_tableNameOrRegionName))
          return false;
        if (!this.tableNameOrRegionName.equals(that.tableNameOrRegionName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableNameOrRegionName()) ? 131071 : 524287);
      if (isSetTableNameOrRegionName())
        hashCode = hashCode * 8191 + tableNameOrRegionName.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(compact_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableNameOrRegionName()).compareTo(other.isSetTableNameOrRegionName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableNameOrRegionName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableNameOrRegionName, other.tableNameOrRegionName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("compact_args(");
      boolean first = true;

      sb.append("tableNameOrRegionName:");
      if (this.tableNameOrRegionName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableNameOrRegionName, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class compact_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public compact_argsStandardScheme getScheme() {
        return new compact_argsStandardScheme();
      }
    }

    private static class compact_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<compact_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, compact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME_OR_REGION_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableNameOrRegionName = iprot.readBinary();
                struct.setTableNameOrRegionNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, compact_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableNameOrRegionName != null) {
          oprot.writeFieldBegin(TABLE_NAME_OR_REGION_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableNameOrRegionName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class compact_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public compact_argsTupleScheme getScheme() {
        return new compact_argsTupleScheme();
      }
    }

    private static class compact_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<compact_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, compact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableNameOrRegionName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableNameOrRegionName()) {
          oprot.writeBinary(struct.tableNameOrRegionName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, compact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableNameOrRegionName = iprot.readBinary();
          struct.setTableNameOrRegionNameIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class compact_result implements org.apache.thrift.TBase<compact_result, compact_result._Fields>, java.io.Serializable, Cloneable, Comparable<compact_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("compact_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new compact_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new compact_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(compact_result.class, metaDataMap);
    }

    public compact_result() {
    }

    public compact_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public compact_result(compact_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public compact_result deepCopy() {
      return new compact_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public compact_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof compact_result)
        return this.equals((compact_result)that);
      return false;
    }

    public boolean equals(compact_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(compact_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("compact_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class compact_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public compact_resultStandardScheme getScheme() {
        return new compact_resultStandardScheme();
      }
    }

    private static class compact_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<compact_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, compact_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, compact_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class compact_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public compact_resultTupleScheme getScheme() {
        return new compact_resultTupleScheme();
      }
    }

    private static class compact_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<compact_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, compact_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, compact_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class majorCompact_args implements org.apache.thrift.TBase<majorCompact_args, majorCompact_args._Fields>, java.io.Serializable, Cloneable, Comparable<majorCompact_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("majorCompact_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_OR_REGION_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableNameOrRegionName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new majorCompact_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new majorCompact_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableNameOrRegionName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TABLE_NAME_OR_REGION_NAME((short)1, "tableNameOrRegionName");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME_OR_REGION_NAME
            return TABLE_NAME_OR_REGION_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME_OR_REGION_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableNameOrRegionName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Bytes")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(majorCompact_args.class, metaDataMap);
    }

    public majorCompact_args() {
    }

    public majorCompact_args(
      java.nio.ByteBuffer tableNameOrRegionName)
    {
      this();
      this.tableNameOrRegionName = org.apache.thrift.TBaseHelper.copyBinary(tableNameOrRegionName);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public majorCompact_args(majorCompact_args other) {
      if (other.isSetTableNameOrRegionName()) {
        this.tableNameOrRegionName = org.apache.thrift.TBaseHelper.copyBinary(other.tableNameOrRegionName);
      }
    }

    public majorCompact_args deepCopy() {
      return new majorCompact_args(this);
    }

    @Override
    public void clear() {
      this.tableNameOrRegionName = null;
    }

    public byte[] getTableNameOrRegionName() {
      setTableNameOrRegionName(org.apache.thrift.TBaseHelper.rightSize(tableNameOrRegionName));
      return tableNameOrRegionName == null ? null : tableNameOrRegionName.array();
    }

    public java.nio.ByteBuffer bufferForTableNameOrRegionName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableNameOrRegionName);
    }

    public majorCompact_args setTableNameOrRegionName(byte[] tableNameOrRegionName) {
      this.tableNameOrRegionName = tableNameOrRegionName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableNameOrRegionName.clone());
      return this;
    }

    public majorCompact_args setTableNameOrRegionName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableNameOrRegionName) {
      this.tableNameOrRegionName = org.apache.thrift.TBaseHelper.copyBinary(tableNameOrRegionName);
      return this;
    }

    public void unsetTableNameOrRegionName() {
      this.tableNameOrRegionName = null;
    }

    /** Returns true if field tableNameOrRegionName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableNameOrRegionName() {
      return this.tableNameOrRegionName != null;
    }

    public void setTableNameOrRegionNameIsSet(boolean value) {
      if (!value) {
        this.tableNameOrRegionName = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        if (value == null) {
          unsetTableNameOrRegionName();
        } else {
          if (value instanceof byte[]) {
            setTableNameOrRegionName((byte[])value);
          } else {
            setTableNameOrRegionName((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        return getTableNameOrRegionName();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME_OR_REGION_NAME:
        return isSetTableNameOrRegionName();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof majorCompact_args)
        return this.equals((majorCompact_args)that);
      return false;
    }

    public boolean equals(majorCompact_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableNameOrRegionName = true && this.isSetTableNameOrRegionName();
      boolean that_present_tableNameOrRegionName = true && that.isSetTableNameOrRegionName();
      if (this_present_tableNameOrRegionName || that_present_tableNameOrRegionName) {
        if (!(this_present_tableNameOrRegionName && that_present_tableNameOrRegionName))
          return false;
        if (!this.tableNameOrRegionName.equals(that.tableNameOrRegionName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableNameOrRegionName()) ? 131071 : 524287);
      if (isSetTableNameOrRegionName())
        hashCode = hashCode * 8191 + tableNameOrRegionName.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(majorCompact_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableNameOrRegionName()).compareTo(other.isSetTableNameOrRegionName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableNameOrRegionName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableNameOrRegionName, other.tableNameOrRegionName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("majorCompact_args(");
      boolean first = true;

      sb.append("tableNameOrRegionName:");
      if (this.tableNameOrRegionName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableNameOrRegionName, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class majorCompact_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public majorCompact_argsStandardScheme getScheme() {
        return new majorCompact_argsStandardScheme();
      }
    }

    private static class majorCompact_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<majorCompact_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, majorCompact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME_OR_REGION_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableNameOrRegionName = iprot.readBinary();
                struct.setTableNameOrRegionNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, majorCompact_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableNameOrRegionName != null) {
          oprot.writeFieldBegin(TABLE_NAME_OR_REGION_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableNameOrRegionName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class majorCompact_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public majorCompact_argsTupleScheme getScheme() {
        return new majorCompact_argsTupleScheme();
      }
    }

    private static class majorCompact_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<majorCompact_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, majorCompact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableNameOrRegionName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableNameOrRegionName()) {
          oprot.writeBinary(struct.tableNameOrRegionName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, majorCompact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableNameOrRegionName = iprot.readBinary();
          struct.setTableNameOrRegionNameIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class majorCompact_result implements org.apache.thrift.TBase<majorCompact_result, majorCompact_result._Fields>, java.io.Serializable, Cloneable, Comparable<majorCompact_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("majorCompact_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new majorCompact_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new majorCompact_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(majorCompact_result.class, metaDataMap);
    }

    public majorCompact_result() {
    }

    public majorCompact_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public majorCompact_result(majorCompact_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public majorCompact_result deepCopy() {
      return new majorCompact_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public majorCompact_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof majorCompact_result)
        return this.equals((majorCompact_result)that);
      return false;
    }

    public boolean equals(majorCompact_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(majorCompact_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("majorCompact_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class majorCompact_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public majorCompact_resultStandardScheme getScheme() {
        return new majorCompact_resultStandardScheme();
      }
    }

    private static class majorCompact_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<majorCompact_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, majorCompact_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, majorCompact_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class majorCompact_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public majorCompact_resultTupleScheme getScheme() {
        return new majorCompact_resultTupleScheme();
      }
    }

    private static class majorCompact_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<majorCompact_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, majorCompact_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, majorCompact_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getTableNames_args implements org.apache.thrift.TBase<getTableNames_args, getTableNames_args._Fields>, java.io.Serializable, Cloneable, Comparable<getTableNames_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTableNames_args");


    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getTableNames_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getTableNames_argsTupleSchemeFactory();


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTableNames_args.class, metaDataMap);
    }

    public getTableNames_args() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTableNames_args(getTableNames_args other) {
    }

    public getTableNames_args deepCopy() {
      return new getTableNames_args(this);
    }

    @Override
    public void clear() {
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableNames_args)
        return this.equals((getTableNames_args)that);
      return false;
    }

    public boolean equals(getTableNames_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      return hashCode;
    }

    @Override
    public int compareTo(getTableNames_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getTableNames_args(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTableNames_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getTableNames_argsStandardScheme getScheme() {
        return new getTableNames_argsStandardScheme();
      }
    }

    private static class getTableNames_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getTableNames_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTableNames_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTableNames_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTableNames_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getTableNames_argsTupleScheme getScheme() {
        return new getTableNames_argsTupleScheme();
      }
    }

    private static class getTableNames_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getTableNames_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTableNames_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTableNames_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getTableNames_result implements org.apache.thrift.TBase<getTableNames_result, getTableNames_result._Fields>, java.io.Serializable, Cloneable, Comparable<getTableNames_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTableNames_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getTableNames_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getTableNames_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<java.nio.ByteBuffer> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTableNames_result.class, metaDataMap);
    }

    public getTableNames_result() {
    }

    public getTableNames_result(
      java.util.List<java.nio.ByteBuffer> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTableNames_result(getTableNames_result other) {
      if (other.isSetSuccess()) {
        java.util.List<java.nio.ByteBuffer> __this__success = new java.util.ArrayList<java.nio.ByteBuffer>(other.success.size());
        for (java.nio.ByteBuffer other_element : other.success) {
          __this__success.add(org.apache.thrift.TBaseHelper.copyBinary(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getTableNames_result deepCopy() {
      return new getTableNames_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<java.nio.ByteBuffer> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(java.nio.ByteBuffer elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<java.nio.ByteBuffer>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<java.nio.ByteBuffer> getSuccess() {
      return this.success;
    }

    public getTableNames_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<java.nio.ByteBuffer> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public getTableNames_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<java.nio.ByteBuffer>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableNames_result)
        return this.equals((getTableNames_result)that);
      return false;
    }

    public boolean equals(getTableNames_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getTableNames_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getTableNames_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.success, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTableNames_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getTableNames_resultStandardScheme getScheme() {
        return new getTableNames_resultStandardScheme();
      }
    }

    private static class getTableNames_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getTableNames_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTableNames_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list50 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<java.nio.ByteBuffer>(_list50.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _elem51;
                  for (int _i52 = 0; _i52 < _list50.size; ++_i52)
                  {
                    _elem51 = iprot.readBinary();
                    struct.success.add(_elem51);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTableNames_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.success.size()));
            for (java.nio.ByteBuffer _iter53 : struct.success)
            {
              oprot.writeBinary(_iter53);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTableNames_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getTableNames_resultTupleScheme getScheme() {
        return new getTableNames_resultTupleScheme();
      }
    }

    private static class getTableNames_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getTableNames_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTableNames_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (java.nio.ByteBuffer _iter54 : struct.success)
            {
              oprot.writeBinary(_iter54);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTableNames_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list55 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.success = new java.util.ArrayList<java.nio.ByteBuffer>(_list55.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _elem56;
            for (int _i57 = 0; _i57 < _list55.size; ++_i57)
            {
              _elem56 = iprot.readBinary();
              struct.success.add(_elem56);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getColumnDescriptors_args implements org.apache.thrift.TBase<getColumnDescriptors_args, getColumnDescriptors_args._Fields>, java.io.Serializable, Cloneable, Comparable<getColumnDescriptors_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getColumnDescriptors_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getColumnDescriptors_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getColumnDescriptors_argsTupleSchemeFactory();

    /**
     * table name
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * table name
       */
      TABLE_NAME((short)1, "tableName");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getColumnDescriptors_args.class, metaDataMap);
    }

    public getColumnDescriptors_args() {
    }

    public getColumnDescriptors_args(
      java.nio.ByteBuffer tableName)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getColumnDescriptors_args(getColumnDescriptors_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
    }

    public getColumnDescriptors_args deepCopy() {
      return new getColumnDescriptors_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * table name
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * table name
     */
    public getColumnDescriptors_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public getColumnDescriptors_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getColumnDescriptors_args)
        return this.equals((getColumnDescriptors_args)that);
      return false;
    }

    public boolean equals(getColumnDescriptors_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getColumnDescriptors_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getColumnDescriptors_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getColumnDescriptors_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getColumnDescriptors_argsStandardScheme getScheme() {
        return new getColumnDescriptors_argsStandardScheme();
      }
    }

    private static class getColumnDescriptors_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getColumnDescriptors_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getColumnDescriptors_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getColumnDescriptors_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getColumnDescriptors_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getColumnDescriptors_argsTupleScheme getScheme() {
        return new getColumnDescriptors_argsTupleScheme();
      }
    }

    private static class getColumnDescriptors_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getColumnDescriptors_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getColumnDescriptors_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getColumnDescriptors_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getColumnDescriptors_result implements org.apache.thrift.TBase<getColumnDescriptors_result, getColumnDescriptors_result._Fields>, java.io.Serializable, Cloneable, Comparable<getColumnDescriptors_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getColumnDescriptors_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.MAP, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getColumnDescriptors_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getColumnDescriptors_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnDescriptor.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getColumnDescriptors_result.class, metaDataMap);
    }

    public getColumnDescriptors_result() {
    }

    public getColumnDescriptors_result(
      java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getColumnDescriptors_result(getColumnDescriptors_result other) {
      if (other.isSetSuccess()) {
        java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> __this__success = new java.util.HashMap<java.nio.ByteBuffer,ColumnDescriptor>(other.success.size());
        for (java.util.Map.Entry<java.nio.ByteBuffer, ColumnDescriptor> other_element : other.success.entrySet()) {

          java.nio.ByteBuffer other_element_key = other_element.getKey();
          ColumnDescriptor other_element_value = other_element.getValue();

          java.nio.ByteBuffer __this__success_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);

          ColumnDescriptor __this__success_copy_value = new ColumnDescriptor(other_element_value);

          __this__success.put(__this__success_copy_key, __this__success_copy_value);
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getColumnDescriptors_result deepCopy() {
      return new getColumnDescriptors_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    public void putToSuccess(java.nio.ByteBuffer key, ColumnDescriptor val) {
      if (this.success == null) {
        this.success = new java.util.HashMap<java.nio.ByteBuffer,ColumnDescriptor>();
      }
      this.success.put(key, val);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> getSuccess() {
      return this.success;
    }

    public getColumnDescriptors_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,ColumnDescriptor> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public getColumnDescriptors_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.Map<java.nio.ByteBuffer,ColumnDescriptor>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getColumnDescriptors_result)
        return this.equals((getColumnDescriptors_result)that);
      return false;
    }

    public boolean equals(getColumnDescriptors_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getColumnDescriptors_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getColumnDescriptors_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getColumnDescriptors_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getColumnDescriptors_resultStandardScheme getScheme() {
        return new getColumnDescriptors_resultStandardScheme();
      }
    }

    private static class getColumnDescriptors_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getColumnDescriptors_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getColumnDescriptors_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map58 = iprot.readMapBegin();
                  struct.success = new java.util.HashMap<java.nio.ByteBuffer,ColumnDescriptor>(2*_map58.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key59;
                  @org.apache.thrift.annotation.Nullable ColumnDescriptor _val60;
                  for (int _i61 = 0; _i61 < _map58.size; ++_i61)
                  {
                    _key59 = iprot.readBinary();
                    _val60 = new ColumnDescriptor();
                    _val60.read(iprot);
                    struct.success.put(_key59, _val60);
                  }
                  iprot.readMapEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getColumnDescriptors_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (java.util.Map.Entry<java.nio.ByteBuffer, ColumnDescriptor> _iter62 : struct.success.entrySet())
            {
              oprot.writeBinary(_iter62.getKey());
              _iter62.getValue().write(oprot);
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getColumnDescriptors_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getColumnDescriptors_resultTupleScheme getScheme() {
        return new getColumnDescriptors_resultTupleScheme();
      }
    }

    private static class getColumnDescriptors_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getColumnDescriptors_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getColumnDescriptors_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (java.util.Map.Entry<java.nio.ByteBuffer, ColumnDescriptor> _iter63 : struct.success.entrySet())
            {
              oprot.writeBinary(_iter63.getKey());
              _iter63.getValue().write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getColumnDescriptors_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TMap _map64 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new java.util.HashMap<java.nio.ByteBuffer,ColumnDescriptor>(2*_map64.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key65;
            @org.apache.thrift.annotation.Nullable ColumnDescriptor _val66;
            for (int _i67 = 0; _i67 < _map64.size; ++_i67)
            {
              _key65 = iprot.readBinary();
              _val66 = new ColumnDescriptor();
              _val66.read(iprot);
              struct.success.put(_key65, _val66);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getTableRegions_args implements org.apache.thrift.TBase<getTableRegions_args, getTableRegions_args._Fields>, java.io.Serializable, Cloneable, Comparable<getTableRegions_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTableRegions_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getTableRegions_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getTableRegions_argsTupleSchemeFactory();

    /**
     * table name
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * table name
       */
      TABLE_NAME((short)1, "tableName");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTableRegions_args.class, metaDataMap);
    }

    public getTableRegions_args() {
    }

    public getTableRegions_args(
      java.nio.ByteBuffer tableName)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTableRegions_args(getTableRegions_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
    }

    public getTableRegions_args deepCopy() {
      return new getTableRegions_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * table name
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * table name
     */
    public getTableRegions_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public getTableRegions_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableRegions_args)
        return this.equals((getTableRegions_args)that);
      return false;
    }

    public boolean equals(getTableRegions_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getTableRegions_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getTableRegions_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTableRegions_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getTableRegions_argsStandardScheme getScheme() {
        return new getTableRegions_argsStandardScheme();
      }
    }

    private static class getTableRegions_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getTableRegions_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTableRegions_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTableRegions_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTableRegions_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getTableRegions_argsTupleScheme getScheme() {
        return new getTableRegions_argsTupleScheme();
      }
    }

    private static class getTableRegions_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getTableRegions_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTableRegions_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTableRegions_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getTableRegions_result implements org.apache.thrift.TBase<getTableRegions_result, getTableRegions_result._Fields>, java.io.Serializable, Cloneable, Comparable<getTableRegions_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTableRegions_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getTableRegions_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getTableRegions_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TRegionInfo> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRegionInfo.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTableRegions_result.class, metaDataMap);
    }

    public getTableRegions_result() {
    }

    public getTableRegions_result(
      java.util.List<TRegionInfo> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTableRegions_result(getTableRegions_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TRegionInfo> __this__success = new java.util.ArrayList<TRegionInfo>(other.success.size());
        for (TRegionInfo other_element : other.success) {
          __this__success.add(new TRegionInfo(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getTableRegions_result deepCopy() {
      return new getTableRegions_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TRegionInfo> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRegionInfo elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TRegionInfo>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TRegionInfo> getSuccess() {
      return this.success;
    }

    public getTableRegions_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TRegionInfo> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public getTableRegions_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TRegionInfo>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableRegions_result)
        return this.equals((getTableRegions_result)that);
      return false;
    }

    public boolean equals(getTableRegions_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getTableRegions_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getTableRegions_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getTableRegions_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getTableRegions_resultStandardScheme getScheme() {
        return new getTableRegions_resultStandardScheme();
      }
    }

    private static class getTableRegions_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getTableRegions_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getTableRegions_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list68 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TRegionInfo>(_list68.size);
                  @org.apache.thrift.annotation.Nullable TRegionInfo _elem69;
                  for (int _i70 = 0; _i70 < _list68.size; ++_i70)
                  {
                    _elem69 = new TRegionInfo();
                    _elem69.read(iprot);
                    struct.success.add(_elem69);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getTableRegions_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRegionInfo _iter71 : struct.success)
            {
              _iter71.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getTableRegions_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getTableRegions_resultTupleScheme getScheme() {
        return new getTableRegions_resultTupleScheme();
      }
    }

    private static class getTableRegions_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getTableRegions_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getTableRegions_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRegionInfo _iter72 : struct.success)
            {
              _iter72.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getTableRegions_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list73 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new java.util.ArrayList<TRegionInfo>(_list73.size);
            @org.apache.thrift.annotation.Nullable TRegionInfo _elem74;
            for (int _i75 = 0; _i75 < _list73.size; ++_i75)
            {
              _elem74 = new TRegionInfo();
              _elem74.read(iprot);
              struct.success.add(_elem74);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class createTable_args implements org.apache.thrift.TBase<createTable_args, createTable_args._Fields>, java.io.Serializable, Cloneable, Comparable<createTable_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createTable_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField COLUMN_FAMILIES_FIELD_DESC = new org.apache.thrift.protocol.TField("columnFamilies", org.apache.thrift.protocol.TType.LIST, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new createTable_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new createTable_argsTupleSchemeFactory();

    /**
     * name of table to create
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required
    /**
     * list of column family descriptors
     */
    public @org.apache.thrift.annotation.Nullable java.util.List<ColumnDescriptor> columnFamilies; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table to create
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * list of column family descriptors
       */
      COLUMN_FAMILIES((short)2, "columnFamilies");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // COLUMN_FAMILIES
            return COLUMN_FAMILIES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMN_FAMILIES, new org.apache.thrift.meta_data.FieldMetaData("columnFamilies", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ColumnDescriptor.class))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createTable_args.class, metaDataMap);
    }

    public createTable_args() {
    }

    public createTable_args(
      java.nio.ByteBuffer tableName,
      java.util.List<ColumnDescriptor> columnFamilies)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      this.columnFamilies = columnFamilies;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createTable_args(createTable_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
      if (other.isSetColumnFamilies()) {
        java.util.List<ColumnDescriptor> __this__columnFamilies = new java.util.ArrayList<ColumnDescriptor>(other.columnFamilies.size());
        for (ColumnDescriptor other_element : other.columnFamilies) {
          __this__columnFamilies.add(new ColumnDescriptor(other_element));
        }
        this.columnFamilies = __this__columnFamilies;
      }
    }

    public createTable_args deepCopy() {
      return new createTable_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.columnFamilies = null;
    }

    /**
     * name of table to create
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of table to create
     */
    public createTable_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public createTable_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public int getColumnFamiliesSize() {
      return (this.columnFamilies == null) ? 0 : this.columnFamilies.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<ColumnDescriptor> getColumnFamiliesIterator() {
      return (this.columnFamilies == null) ? null : this.columnFamilies.iterator();
    }

    public void addToColumnFamilies(ColumnDescriptor elem) {
      if (this.columnFamilies == null) {
        this.columnFamilies = new java.util.ArrayList<ColumnDescriptor>();
      }
      this.columnFamilies.add(elem);
    }

    /**
     * list of column family descriptors
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.List<ColumnDescriptor> getColumnFamilies() {
      return this.columnFamilies;
    }

    /**
     * list of column family descriptors
     */
    public createTable_args setColumnFamilies(@org.apache.thrift.annotation.Nullable java.util.List<ColumnDescriptor> columnFamilies) {
      this.columnFamilies = columnFamilies;
      return this;
    }

    public void unsetColumnFamilies() {
      this.columnFamilies = null;
    }

    /** Returns true if field columnFamilies is set (has been assigned a value) and false otherwise */
    public boolean isSetColumnFamilies() {
      return this.columnFamilies != null;
    }

    public void setColumnFamiliesIsSet(boolean value) {
      if (!value) {
        this.columnFamilies = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      case COLUMN_FAMILIES:
        if (value == null) {
          unsetColumnFamilies();
        } else {
          setColumnFamilies((java.util.List<ColumnDescriptor>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case COLUMN_FAMILIES:
        return getColumnFamilies();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case COLUMN_FAMILIES:
        return isSetColumnFamilies();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof createTable_args)
        return this.equals((createTable_args)that);
      return false;
    }

    public boolean equals(createTable_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_columnFamilies = true && this.isSetColumnFamilies();
      boolean that_present_columnFamilies = true && that.isSetColumnFamilies();
      if (this_present_columnFamilies || that_present_columnFamilies) {
        if (!(this_present_columnFamilies && that_present_columnFamilies))
          return false;
        if (!this.columnFamilies.equals(that.columnFamilies))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      hashCode = hashCode * 8191 + ((isSetColumnFamilies()) ? 131071 : 524287);
      if (isSetColumnFamilies())
        hashCode = hashCode * 8191 + columnFamilies.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(createTable_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetColumnFamilies()).compareTo(other.isSetColumnFamilies());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumnFamilies()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columnFamilies, other.columnFamilies);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("createTable_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columnFamilies:");
      if (this.columnFamilies == null) {
        sb.append("null");
      } else {
        sb.append(this.columnFamilies);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createTable_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public createTable_argsStandardScheme getScheme() {
        return new createTable_argsStandardScheme();
      }
    }

    private static class createTable_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<createTable_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // COLUMN_FAMILIES
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list76 = iprot.readListBegin();
                  struct.columnFamilies = new java.util.ArrayList<ColumnDescriptor>(_list76.size);
                  @org.apache.thrift.annotation.Nullable ColumnDescriptor _elem77;
                  for (int _i78 = 0; _i78 < _list76.size; ++_i78)
                  {
                    _elem77 = new ColumnDescriptor();
                    _elem77.read(iprot);
                    struct.columnFamilies.add(_elem77);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnFamiliesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createTable_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.columnFamilies != null) {
          oprot.writeFieldBegin(COLUMN_FAMILIES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.columnFamilies.size()));
            for (ColumnDescriptor _iter79 : struct.columnFamilies)
            {
              _iter79.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createTable_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public createTable_argsTupleScheme getScheme() {
        return new createTable_argsTupleScheme();
      }
    }

    private static class createTable_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<createTable_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetColumnFamilies()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetColumnFamilies()) {
          {
            oprot.writeI32(struct.columnFamilies.size());
            for (ColumnDescriptor _iter80 : struct.columnFamilies)
            {
              _iter80.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          {
            org.apache.thrift.protocol.TList _list81 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.columnFamilies = new java.util.ArrayList<ColumnDescriptor>(_list81.size);
            @org.apache.thrift.annotation.Nullable ColumnDescriptor _elem82;
            for (int _i83 = 0; _i83 < _list81.size; ++_i83)
            {
              _elem82 = new ColumnDescriptor();
              _elem82.read(iprot);
              struct.columnFamilies.add(_elem82);
            }
          }
          struct.setColumnFamiliesIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class createTable_result implements org.apache.thrift.TBase<createTable_result, createTable_result._Fields>, java.io.Serializable, Cloneable, Comparable<createTable_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("createTable_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField IA_FIELD_DESC = new org.apache.thrift.protocol.TField("ia", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField EXIST_FIELD_DESC = new org.apache.thrift.protocol.TField("exist", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new createTable_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new createTable_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable IOError io; // required
    public @org.apache.thrift.annotation.Nullable IllegalArgument ia; // required
    public @org.apache.thrift.annotation.Nullable AlreadyExists exist; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io"),
      IA((short)2, "ia"),
      EXIST((short)3, "exist");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          case 2: // IA
            return IA;
          case 3: // EXIST
            return EXIST;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      tmpMap.put(_Fields.IA, new org.apache.thrift.meta_data.FieldMetaData("ia", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IllegalArgument.class)));
      tmpMap.put(_Fields.EXIST, new org.apache.thrift.meta_data.FieldMetaData("exist", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, AlreadyExists.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(createTable_result.class, metaDataMap);
    }

    public createTable_result() {
    }

    public createTable_result(
      IOError io,
      IllegalArgument ia,
      AlreadyExists exist)
    {
      this();
      this.io = io;
      this.ia = ia;
      this.exist = exist;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public createTable_result(createTable_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
      if (other.isSetIa()) {
        this.ia = new IllegalArgument(other.ia);
      }
      if (other.isSetExist()) {
        this.exist = new AlreadyExists(other.exist);
      }
    }

    public createTable_result deepCopy() {
      return new createTable_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
      this.ia = null;
      this.exist = null;
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public createTable_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IllegalArgument getIa() {
      return this.ia;
    }

    public createTable_result setIa(@org.apache.thrift.annotation.Nullable IllegalArgument ia) {
      this.ia = ia;
      return this;
    }

    public void unsetIa() {
      this.ia = null;
    }

    /** Returns true if field ia is set (has been assigned a value) and false otherwise */
    public boolean isSetIa() {
      return this.ia != null;
    }

    public void setIaIsSet(boolean value) {
      if (!value) {
        this.ia = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public AlreadyExists getExist() {
      return this.exist;
    }

    public createTable_result setExist(@org.apache.thrift.annotation.Nullable AlreadyExists exist) {
      this.exist = exist;
      return this;
    }

    public void unsetExist() {
      this.exist = null;
    }

    /** Returns true if field exist is set (has been assigned a value) and false otherwise */
    public boolean isSetExist() {
      return this.exist != null;
    }

    public void setExistIsSet(boolean value) {
      if (!value) {
        this.exist = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      case IA:
        if (value == null) {
          unsetIa();
        } else {
          setIa((IllegalArgument)value);
        }
        break;

      case EXIST:
        if (value == null) {
          unsetExist();
        } else {
          setExist((AlreadyExists)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      case IA:
        return getIa();

      case EXIST:
        return getExist();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      case IA:
        return isSetIa();
      case EXIST:
        return isSetExist();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof createTable_result)
        return this.equals((createTable_result)that);
      return false;
    }

    public boolean equals(createTable_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && this.isSetIa();
      boolean that_present_ia = true && that.isSetIa();
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      boolean this_present_exist = true && this.isSetExist();
      boolean that_present_exist = true && that.isSetExist();
      if (this_present_exist || that_present_exist) {
        if (!(this_present_exist && that_present_exist))
          return false;
        if (!this.exist.equals(that.exist))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      hashCode = hashCode * 8191 + ((isSetIa()) ? 131071 : 524287);
      if (isSetIa())
        hashCode = hashCode * 8191 + ia.hashCode();

      hashCode = hashCode * 8191 + ((isSetExist()) ? 131071 : 524287);
      if (isSetExist())
        hashCode = hashCode * 8191 + exist.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(createTable_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIa()).compareTo(other.isSetIa());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIa()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ia, other.ia);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetExist()).compareTo(other.isSetExist());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExist()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.exist, other.exist);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("createTable_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ia:");
      if (this.ia == null) {
        sb.append("null");
      } else {
        sb.append(this.ia);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("exist:");
      if (this.exist == null) {
        sb.append("null");
      } else {
        sb.append(this.exist);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class createTable_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public createTable_resultStandardScheme getScheme() {
        return new createTable_resultStandardScheme();
      }
    }

    private static class createTable_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<createTable_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, createTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // IA
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ia = new IllegalArgument();
                struct.ia.read(iprot);
                struct.setIaIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // EXIST
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.exist = new AlreadyExists();
                struct.exist.read(iprot);
                struct.setExistIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, createTable_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ia != null) {
          oprot.writeFieldBegin(IA_FIELD_DESC);
          struct.ia.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.exist != null) {
          oprot.writeFieldBegin(EXIST_FIELD_DESC);
          struct.exist.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class createTable_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public createTable_resultTupleScheme getScheme() {
        return new createTable_resultTupleScheme();
      }
    }

    private static class createTable_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<createTable_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, createTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        if (struct.isSetIa()) {
          optionals.set(1);
        }
        if (struct.isSetExist()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
        if (struct.isSetIa()) {
          struct.ia.write(oprot);
        }
        if (struct.isSetExist()) {
          struct.exist.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, createTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ia = new IllegalArgument();
          struct.ia.read(iprot);
          struct.setIaIsSet(true);
        }
        if (incoming.get(2)) {
          struct.exist = new AlreadyExists();
          struct.exist.read(iprot);
          struct.setExistIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class deleteTable_args implements org.apache.thrift.TBase<deleteTable_args, deleteTable_args._Fields>, java.io.Serializable, Cloneable, Comparable<deleteTable_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteTable_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new deleteTable_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new deleteTable_argsTupleSchemeFactory();

    /**
     * name of table to delete
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table to delete
       */
      TABLE_NAME((short)1, "tableName");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteTable_args.class, metaDataMap);
    }

    public deleteTable_args() {
    }

    public deleteTable_args(
      java.nio.ByteBuffer tableName)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteTable_args(deleteTable_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
    }

    public deleteTable_args deepCopy() {
      return new deleteTable_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
    }

    /**
     * name of table to delete
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of table to delete
     */
    public deleteTable_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public deleteTable_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteTable_args)
        return this.equals((deleteTable_args)that);
      return false;
    }

    public boolean equals(deleteTable_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(deleteTable_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("deleteTable_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteTable_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteTable_argsStandardScheme getScheme() {
        return new deleteTable_argsStandardScheme();
      }
    }

    private static class deleteTable_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<deleteTable_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteTable_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteTable_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteTable_argsTupleScheme getScheme() {
        return new deleteTable_argsTupleScheme();
      }
    }

    private static class deleteTable_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<deleteTable_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteTable_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class deleteTable_result implements org.apache.thrift.TBase<deleteTable_result, deleteTable_result._Fields>, java.io.Serializable, Cloneable, Comparable<deleteTable_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteTable_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new deleteTable_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new deleteTable_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteTable_result.class, metaDataMap);
    }

    public deleteTable_result() {
    }

    public deleteTable_result(
      IOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteTable_result(deleteTable_result other) {
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public deleteTable_result deepCopy() {
      return new deleteTable_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public deleteTable_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteTable_result)
        return this.equals((deleteTable_result)that);
      return false;
    }

    public boolean equals(deleteTable_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(deleteTable_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("deleteTable_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteTable_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteTable_resultStandardScheme getScheme() {
        return new deleteTable_resultStandardScheme();
      }
    }

    private static class deleteTable_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<deleteTable_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteTable_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteTable_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteTable_resultTupleScheme getScheme() {
        return new deleteTable_resultTupleScheme();
      }
    }

    private static class deleteTable_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<deleteTable_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteTable_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class get_args implements org.apache.thrift.TBase<get_args, get_args._Fields>, java.io.Serializable, Cloneable, Comparable<get_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("column", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new get_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new get_argsTupleSchemeFactory();

    /**
     * name of table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required
    /**
     * row key
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * column name
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer column; // required
    /**
     * Get attributes
     */
    public @org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * column name
       */
      COLUMN((short)3, "column"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)4, "attributes");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMN
            return COLUMN;
          case 4: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMN, new org.apache.thrift.meta_data.FieldMetaData("column", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_args.class, metaDataMap);
    }

    public get_args() {
    }

    public get_args(
      java.nio.ByteBuffer tableName,
      java.nio.ByteBuffer row,
      java.nio.ByteBuffer column,
      java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.column = org.apache.thrift.TBaseHelper.copyBinary(column);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_args(get_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      if (other.isSetColumn()) {
        this.column = org.apache.thrift.TBaseHelper.copyBinary(other.column);
      }
      if (other.isSetAttributes()) {
        java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> __this__attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(other.attributes.size());
        for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> other_element : other.attributes.entrySet()) {

          java.nio.ByteBuffer other_element_key = other_element.getKey();
          java.nio.ByteBuffer other_element_value = other_element.getValue();

          java.nio.ByteBuffer __this__attributes_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);

          java.nio.ByteBuffer __this__attributes_copy_value = org.apache.thrift.TBaseHelper.copyBinary(other_element_value);

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public get_args deepCopy() {
      return new get_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.column = null;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of table
     */
    public get_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public get_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row key
     */
    public get_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public get_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * column name
     */
    public byte[] getColumn() {
      setColumn(org.apache.thrift.TBaseHelper.rightSize(column));
      return column == null ? null : column.array();
    }

    public java.nio.ByteBuffer bufferForColumn() {
      return org.apache.thrift.TBaseHelper.copyBinary(column);
    }

    /**
     * column name
     */
    public get_args setColumn(byte[] column) {
      this.column = column == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(column.clone());
      return this;
    }

    public get_args setColumn(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer column) {
      this.column = org.apache.thrift.TBaseHelper.copyBinary(column);
      return this;
    }

    public void unsetColumn() {
      this.column = null;
    }

    /** Returns true if field column is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn() {
      return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
      if (!value) {
        this.column = null;
      }
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(java.nio.ByteBuffer key, java.nio.ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public get_args setAttributes(@org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case COLUMN:
        if (value == null) {
          unsetColumn();
        } else {
          if (value instanceof byte[]) {
            setColumn((byte[])value);
          } else {
            setColumn((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMN:
        return getColumn();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMN:
        return isSetColumn();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof get_args)
        return this.equals((get_args)that);
      return false;
    }

    public boolean equals(get_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_column = true && this.isSetColumn();
      boolean that_present_column = true && that.isSetColumn();
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!this.column.equals(that.column))
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + ((isSetColumn()) ? 131071 : 524287);
      if (isSetColumn())
        hashCode = hashCode * 8191 + column.hashCode();

      hashCode = hashCode * 8191 + ((isSetAttributes()) ? 131071 : 524287);
      if (isSetAttributes())
        hashCode = hashCode * 8191 + attributes.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(get_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetRow()).compareTo(other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetColumn()).compareTo(other.isSetColumn());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column, other.column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetAttributes()).compareTo(other.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, other.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("get_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column:");
      if (this.column == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.column, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class get_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public get_argsStandardScheme getScheme() {
        return new get_argsStandardScheme();
      }
    }

    private static class get_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<get_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, get_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.column = iprot.readBinary();
                struct.setColumnIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map84 = iprot.readMapBegin();
                  struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map84.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key85;
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val86;
                  for (int _i87 = 0; _i87 < _map84.size; ++_i87)
                  {
                    _key85 = iprot.readBinary();
                    _val86 = iprot.readBinary();
                    struct.attributes.put(_key85, _val86);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, get_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.column != null) {
          oprot.writeFieldBegin(COLUMN_FIELD_DESC);
          oprot.writeBinary(struct.column);
          oprot.writeFieldEnd();
        }
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter88 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter88.getKey());
              oprot.writeBinary(_iter88.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class get_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public get_argsTupleScheme getScheme() {
        return new get_argsTupleScheme();
      }
    }

    private static class get_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<get_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, get_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumn()) {
          optionals.set(2);
        }
        if (struct.isSetAttributes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumn()) {
          oprot.writeBinary(struct.column);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter89 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter89.getKey());
              oprot.writeBinary(_iter89.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, get_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          struct.column = iprot.readBinary();
          struct.setColumnIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map90 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map90.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key91;
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val92;
            for (int _i93 = 0; _i93 < _map90.size; ++_i93)
            {
              _key91 = iprot.readBinary();
              _val92 = iprot.readBinary();
              struct.attributes.put(_key91, _val92);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class get_result implements org.apache.thrift.TBase<get_result, get_result._Fields>, java.io.Serializable, Cloneable, Comparable<get_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new get_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new get_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TCell> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TCell.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_result.class, metaDataMap);
    }

    public get_result() {
    }

    public get_result(
      java.util.List<TCell> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_result(get_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TCell> __this__success = new java.util.ArrayList<TCell>(other.success.size());
        for (TCell other_element : other.success) {
          __this__success.add(new TCell(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public get_result deepCopy() {
      return new get_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TCell> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TCell elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TCell>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TCell> getSuccess() {
      return this.success;
    }

    public get_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TCell> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public get_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TCell>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof get_result)
        return this.equals((get_result)that);
      return false;
    }

    public boolean equals(get_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(get_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("get_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class get_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public get_resultStandardScheme getScheme() {
        return new get_resultStandardScheme();
      }
    }

    private static class get_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<get_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, get_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list94 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TCell>(_list94.size);
                  @org.apache.thrift.annotation.Nullable TCell _elem95;
                  for (int _i96 = 0; _i96 < _list94.size; ++_i96)
                  {
                    _elem95 = new TCell();
                    _elem95.read(iprot);
                    struct.success.add(_elem95);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, get_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TCell _iter97 : struct.success)
            {
              _iter97.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class get_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public get_resultTupleScheme getScheme() {
        return new get_resultTupleScheme();
      }
    }

    private static class get_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<get_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, get_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TCell _iter98 : struct.success)
            {
              _iter98.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, get_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list99 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new java.util.ArrayList<TCell>(_list99.size);
            @org.apache.thrift.annotation.Nullable TCell _elem100;
            for (int _i101 = 0; _i101 < _list99.size; ++_i101)
            {
              _elem100 = new TCell();
              _elem100.read(iprot);
              struct.success.add(_elem100);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getVer_args implements org.apache.thrift.TBase<getVer_args, getVer_args._Fields>, java.io.Serializable, Cloneable, Comparable<getVer_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getVer_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("column", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField NUM_VERSIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("numVersions", org.apache.thrift.protocol.TType.I32, (short)4);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)5);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getVer_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getVer_argsTupleSchemeFactory();

    /**
     * name of table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required
    /**
     * row key
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * column name
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer column; // required
    /**
     * number of versions to retrieve
     */
    public int numVersions; // required
    /**
     * Get attributes
     */
    public @org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * column name
       */
      COLUMN((short)3, "column"),
      /**
       * number of versions to retrieve
       */
      NUM_VERSIONS((short)4, "numVersions"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)5, "attributes");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMN
            return COLUMN;
          case 4: // NUM_VERSIONS
            return NUM_VERSIONS;
          case 5: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __NUMVERSIONS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMN, new org.apache.thrift.meta_data.FieldMetaData("column", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.NUM_VERSIONS, new org.apache.thrift.meta_data.FieldMetaData("numVersions", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getVer_args.class, metaDataMap);
    }

    public getVer_args() {
    }

    public getVer_args(
      java.nio.ByteBuffer tableName,
      java.nio.ByteBuffer row,
      java.nio.ByteBuffer column,
      int numVersions,
      java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.column = org.apache.thrift.TBaseHelper.copyBinary(column);
      this.numVersions = numVersions;
      setNumVersionsIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getVer_args(getVer_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      if (other.isSetColumn()) {
        this.column = org.apache.thrift.TBaseHelper.copyBinary(other.column);
      }
      this.numVersions = other.numVersions;
      if (other.isSetAttributes()) {
        java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> __this__attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(other.attributes.size());
        for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> other_element : other.attributes.entrySet()) {

          java.nio.ByteBuffer other_element_key = other_element.getKey();
          java.nio.ByteBuffer other_element_value = other_element.getValue();

          java.nio.ByteBuffer __this__attributes_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);

          java.nio.ByteBuffer __this__attributes_copy_value = org.apache.thrift.TBaseHelper.copyBinary(other_element_value);

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getVer_args deepCopy() {
      return new getVer_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.column = null;
      setNumVersionsIsSet(false);
      this.numVersions = 0;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of table
     */
    public getVer_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public getVer_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row key
     */
    public getVer_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public getVer_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * column name
     */
    public byte[] getColumn() {
      setColumn(org.apache.thrift.TBaseHelper.rightSize(column));
      return column == null ? null : column.array();
    }

    public java.nio.ByteBuffer bufferForColumn() {
      return org.apache.thrift.TBaseHelper.copyBinary(column);
    }

    /**
     * column name
     */
    public getVer_args setColumn(byte[] column) {
      this.column = column == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(column.clone());
      return this;
    }

    public getVer_args setColumn(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer column) {
      this.column = org.apache.thrift.TBaseHelper.copyBinary(column);
      return this;
    }

    public void unsetColumn() {
      this.column = null;
    }

    /** Returns true if field column is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn() {
      return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
      if (!value) {
        this.column = null;
      }
    }

    /**
     * number of versions to retrieve
     */
    public int getNumVersions() {
      return this.numVersions;
    }

    /**
     * number of versions to retrieve
     */
    public getVer_args setNumVersions(int numVersions) {
      this.numVersions = numVersions;
      setNumVersionsIsSet(true);
      return this;
    }

    public void unsetNumVersions() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID);
    }

    /** Returns true if field numVersions is set (has been assigned a value) and false otherwise */
    public boolean isSetNumVersions() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID);
    }

    public void setNumVersionsIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(java.nio.ByteBuffer key, java.nio.ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getVer_args setAttributes(@org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case COLUMN:
        if (value == null) {
          unsetColumn();
        } else {
          if (value instanceof byte[]) {
            setColumn((byte[])value);
          } else {
            setColumn((java.nio.ByteBuffer)value);
          }
        }
        break;

      case NUM_VERSIONS:
        if (value == null) {
          unsetNumVersions();
        } else {
          setNumVersions((java.lang.Integer)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMN:
        return getColumn();

      case NUM_VERSIONS:
        return getNumVersions();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMN:
        return isSetColumn();
      case NUM_VERSIONS:
        return isSetNumVersions();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getVer_args)
        return this.equals((getVer_args)that);
      return false;
    }

    public boolean equals(getVer_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_column = true && this.isSetColumn();
      boolean that_present_column = true && that.isSetColumn();
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!this.column.equals(that.column))
          return false;
      }

      boolean this_present_numVersions = true;
      boolean that_present_numVersions = true;
      if (this_present_numVersions || that_present_numVersions) {
        if (!(this_present_numVersions && that_present_numVersions))
          return false;
        if (this.numVersions != that.numVersions)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + ((isSetColumn()) ? 131071 : 524287);
      if (isSetColumn())
        hashCode = hashCode * 8191 + column.hashCode();

      hashCode = hashCode * 8191 + numVersions;

      hashCode = hashCode * 8191 + ((isSetAttributes()) ? 131071 : 524287);
      if (isSetAttributes())
        hashCode = hashCode * 8191 + attributes.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getVer_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetRow()).compareTo(other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetColumn()).compareTo(other.isSetColumn());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column, other.column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetNumVersions()).compareTo(other.isSetNumVersions());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNumVersions()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.numVersions, other.numVersions);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetAttributes()).compareTo(other.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, other.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getVer_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column:");
      if (this.column == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.column, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("numVersions:");
      sb.append(this.numVersions);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getVer_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getVer_argsStandardScheme getScheme() {
        return new getVer_argsStandardScheme();
      }
    }

    private static class getVer_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getVer_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getVer_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.column = iprot.readBinary();
                struct.setColumnIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // NUM_VERSIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.numVersions = iprot.readI32();
                struct.setNumVersionsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map102 = iprot.readMapBegin();
                  struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map102.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key103;
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val104;
                  for (int _i105 = 0; _i105 < _map102.size; ++_i105)
                  {
                    _key103 = iprot.readBinary();
                    _val104 = iprot.readBinary();
                    struct.attributes.put(_key103, _val104);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getVer_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.column != null) {
          oprot.writeFieldBegin(COLUMN_FIELD_DESC);
          oprot.writeBinary(struct.column);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(NUM_VERSIONS_FIELD_DESC);
        oprot.writeI32(struct.numVersions);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter106 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter106.getKey());
              oprot.writeBinary(_iter106.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getVer_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getVer_argsTupleScheme getScheme() {
        return new getVer_argsTupleScheme();
      }
    }

    private static class getVer_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getVer_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getVer_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumn()) {
          optionals.set(2);
        }
        if (struct.isSetNumVersions()) {
          optionals.set(3);
        }
        if (struct.isSetAttributes()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumn()) {
          oprot.writeBinary(struct.column);
        }
        if (struct.isSetNumVersions()) {
          oprot.writeI32(struct.numVersions);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter107 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter107.getKey());
              oprot.writeBinary(_iter107.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getVer_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          struct.column = iprot.readBinary();
          struct.setColumnIsSet(true);
        }
        if (incoming.get(3)) {
          struct.numVersions = iprot.readI32();
          struct.setNumVersionsIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TMap _map108 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map108.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key109;
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val110;
            for (int _i111 = 0; _i111 < _map108.size; ++_i111)
            {
              _key109 = iprot.readBinary();
              _val110 = iprot.readBinary();
              struct.attributes.put(_key109, _val110);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getVer_result implements org.apache.thrift.TBase<getVer_result, getVer_result._Fields>, java.io.Serializable, Cloneable, Comparable<getVer_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getVer_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getVer_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getVer_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TCell> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TCell.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getVer_result.class, metaDataMap);
    }

    public getVer_result() {
    }

    public getVer_result(
      java.util.List<TCell> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getVer_result(getVer_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TCell> __this__success = new java.util.ArrayList<TCell>(other.success.size());
        for (TCell other_element : other.success) {
          __this__success.add(new TCell(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getVer_result deepCopy() {
      return new getVer_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TCell> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TCell elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TCell>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TCell> getSuccess() {
      return this.success;
    }

    public getVer_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TCell> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public getVer_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TCell>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getVer_result)
        return this.equals((getVer_result)that);
      return false;
    }

    public boolean equals(getVer_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getVer_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getVer_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getVer_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getVer_resultStandardScheme getScheme() {
        return new getVer_resultStandardScheme();
      }
    }

    private static class getVer_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getVer_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getVer_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list112 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TCell>(_list112.size);
                  @org.apache.thrift.annotation.Nullable TCell _elem113;
                  for (int _i114 = 0; _i114 < _list112.size; ++_i114)
                  {
                    _elem113 = new TCell();
                    _elem113.read(iprot);
                    struct.success.add(_elem113);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getVer_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TCell _iter115 : struct.success)
            {
              _iter115.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getVer_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getVer_resultTupleScheme getScheme() {
        return new getVer_resultTupleScheme();
      }
    }

    private static class getVer_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getVer_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getVer_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TCell _iter116 : struct.success)
            {
              _iter116.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getVer_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list117 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new java.util.ArrayList<TCell>(_list117.size);
            @org.apache.thrift.annotation.Nullable TCell _elem118;
            for (int _i119 = 0; _i119 < _list117.size; ++_i119)
            {
              _elem118 = new TCell();
              _elem118.read(iprot);
              struct.success.add(_elem118);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getVerTs_args implements org.apache.thrift.TBase<getVerTs_args, getVerTs_args._Fields>, java.io.Serializable, Cloneable, Comparable<getVerTs_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getVerTs_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMN_FIELD_DESC = new org.apache.thrift.protocol.TField("column", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)4);
    private static final org.apache.thrift.protocol.TField NUM_VERSIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("numVersions", org.apache.thrift.protocol.TType.I32, (short)5);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)6);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getVerTs_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getVerTs_argsTupleSchemeFactory();

    /**
     * name of table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required
    /**
     * row key
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * column name
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer column; // required
    /**
     * timestamp
     */
    public long timestamp; // required
    /**
     * number of versions to retrieve
     */
    public int numVersions; // required
    /**
     * Get attributes
     */
    public @org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * column name
       */
      COLUMN((short)3, "column"),
      /**
       * timestamp
       */
      TIMESTAMP((short)4, "timestamp"),
      /**
       * number of versions to retrieve
       */
      NUM_VERSIONS((short)5, "numVersions"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)6, "attributes");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMN
            return COLUMN;
          case 4: // TIMESTAMP
            return TIMESTAMP;
          case 5: // NUM_VERSIONS
            return NUM_VERSIONS;
          case 6: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private static final int __NUMVERSIONS_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMN, new org.apache.thrift.meta_data.FieldMetaData("column", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.NUM_VERSIONS, new org.apache.thrift.meta_data.FieldMetaData("numVersions", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getVerTs_args.class, metaDataMap);
    }

    public getVerTs_args() {
    }

    public getVerTs_args(
      java.nio.ByteBuffer tableName,
      java.nio.ByteBuffer row,
      java.nio.ByteBuffer column,
      long timestamp,
      int numVersions,
      java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.column = org.apache.thrift.TBaseHelper.copyBinary(column);
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.numVersions = numVersions;
      setNumVersionsIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getVerTs_args(getVerTs_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      if (other.isSetColumn()) {
        this.column = org.apache.thrift.TBaseHelper.copyBinary(other.column);
      }
      this.timestamp = other.timestamp;
      this.numVersions = other.numVersions;
      if (other.isSetAttributes()) {
        java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> __this__attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(other.attributes.size());
        for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> other_element : other.attributes.entrySet()) {

          java.nio.ByteBuffer other_element_key = other_element.getKey();
          java.nio.ByteBuffer other_element_value = other_element.getValue();

          java.nio.ByteBuffer __this__attributes_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);

          java.nio.ByteBuffer __this__attributes_copy_value = org.apache.thrift.TBaseHelper.copyBinary(other_element_value);

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getVerTs_args deepCopy() {
      return new getVerTs_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.column = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      setNumVersionsIsSet(false);
      this.numVersions = 0;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of table
     */
    public getVerTs_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public getVerTs_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row key
     */
    public getVerTs_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public getVerTs_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * column name
     */
    public byte[] getColumn() {
      setColumn(org.apache.thrift.TBaseHelper.rightSize(column));
      return column == null ? null : column.array();
    }

    public java.nio.ByteBuffer bufferForColumn() {
      return org.apache.thrift.TBaseHelper.copyBinary(column);
    }

    /**
     * column name
     */
    public getVerTs_args setColumn(byte[] column) {
      this.column = column == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(column.clone());
      return this;
    }

    public getVerTs_args setColumn(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer column) {
      this.column = org.apache.thrift.TBaseHelper.copyBinary(column);
      return this;
    }

    public void unsetColumn() {
      this.column = null;
    }

    /** Returns true if field column is set (has been assigned a value) and false otherwise */
    public boolean isSetColumn() {
      return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
      if (!value) {
        this.column = null;
      }
    }

    /**
     * timestamp
     */
    public long getTimestamp() {
      return this.timestamp;
    }

    /**
     * timestamp
     */
    public getVerTs_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TIMESTAMP_ISSET_ID, value);
    }

    /**
     * number of versions to retrieve
     */
    public int getNumVersions() {
      return this.numVersions;
    }

    /**
     * number of versions to retrieve
     */
    public getVerTs_args setNumVersions(int numVersions) {
      this.numVersions = numVersions;
      setNumVersionsIsSet(true);
      return this;
    }

    public void unsetNumVersions() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID);
    }

    /** Returns true if field numVersions is set (has been assigned a value) and false otherwise */
    public boolean isSetNumVersions() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID);
    }

    public void setNumVersionsIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __NUMVERSIONS_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(java.nio.ByteBuffer key, java.nio.ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getVerTs_args setAttributes(@org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case COLUMN:
        if (value == null) {
          unsetColumn();
        } else {
          if (value instanceof byte[]) {
            setColumn((byte[])value);
          } else {
            setColumn((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((java.lang.Long)value);
        }
        break;

      case NUM_VERSIONS:
        if (value == null) {
          unsetNumVersions();
        } else {
          setNumVersions((java.lang.Integer)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMN:
        return getColumn();

      case TIMESTAMP:
        return getTimestamp();

      case NUM_VERSIONS:
        return getNumVersions();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMN:
        return isSetColumn();
      case TIMESTAMP:
        return isSetTimestamp();
      case NUM_VERSIONS:
        return isSetNumVersions();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getVerTs_args)
        return this.equals((getVerTs_args)that);
      return false;
    }

    public boolean equals(getVerTs_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_column = true && this.isSetColumn();
      boolean that_present_column = true && that.isSetColumn();
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!this.column.equals(that.column))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_numVersions = true;
      boolean that_present_numVersions = true;
      if (this_present_numVersions || that_present_numVersions) {
        if (!(this_present_numVersions && that_present_numVersions))
          return false;
        if (this.numVersions != that.numVersions)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + ((isSetColumn()) ? 131071 : 524287);
      if (isSetColumn())
        hashCode = hashCode * 8191 + column.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(timestamp);

      hashCode = hashCode * 8191 + numVersions;

      hashCode = hashCode * 8191 + ((isSetAttributes()) ? 131071 : 524287);
      if (isSetAttributes())
        hashCode = hashCode * 8191 + attributes.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getVerTs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetRow()).compareTo(other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetColumn()).compareTo(other.isSetColumn());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumn()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.column, other.column);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetTimestamp()).compareTo(other.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, other.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetNumVersions()).compareTo(other.isSetNumVersions());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNumVersions()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.numVersions, other.numVersions);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetAttributes()).compareTo(other.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, other.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getVerTs_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("column:");
      if (this.column == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.column, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("numVersions:");
      sb.append(this.numVersions);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getVerTs_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getVerTs_argsStandardScheme getScheme() {
        return new getVerTs_argsStandardScheme();
      }
    }

    private static class getVerTs_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getVerTs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getVerTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.column = iprot.readBinary();
                struct.setColumnIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TIMESTAMP
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // NUM_VERSIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.numVersions = iprot.readI32();
                struct.setNumVersionsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map120 = iprot.readMapBegin();
                  struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map120.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key121;
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val122;
                  for (int _i123 = 0; _i123 < _map120.size; ++_i123)
                  {
                    _key121 = iprot.readBinary();
                    _val122 = iprot.readBinary();
                    struct.attributes.put(_key121, _val122);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getVerTs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.column != null) {
          oprot.writeFieldBegin(COLUMN_FIELD_DESC);
          oprot.writeBinary(struct.column);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
        oprot.writeI64(struct.timestamp);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(NUM_VERSIONS_FIELD_DESC);
        oprot.writeI32(struct.numVersions);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter124 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter124.getKey());
              oprot.writeBinary(_iter124.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getVerTs_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getVerTs_argsTupleScheme getScheme() {
        return new getVerTs_argsTupleScheme();
      }
    }

    private static class getVerTs_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getVerTs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getVerTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumn()) {
          optionals.set(2);
        }
        if (struct.isSetTimestamp()) {
          optionals.set(3);
        }
        if (struct.isSetNumVersions()) {
          optionals.set(4);
        }
        if (struct.isSetAttributes()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumn()) {
          oprot.writeBinary(struct.column);
        }
        if (struct.isSetTimestamp()) {
          oprot.writeI64(struct.timestamp);
        }
        if (struct.isSetNumVersions()) {
          oprot.writeI32(struct.numVersions);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter125 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter125.getKey());
              oprot.writeBinary(_iter125.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getVerTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          struct.column = iprot.readBinary();
          struct.setColumnIsSet(true);
        }
        if (incoming.get(3)) {
          struct.timestamp = iprot.readI64();
          struct.setTimestampIsSet(true);
        }
        if (incoming.get(4)) {
          struct.numVersions = iprot.readI32();
          struct.setNumVersionsIsSet(true);
        }
        if (incoming.get(5)) {
          {
            org.apache.thrift.protocol.TMap _map126 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map126.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key127;
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val128;
            for (int _i129 = 0; _i129 < _map126.size; ++_i129)
            {
              _key127 = iprot.readBinary();
              _val128 = iprot.readBinary();
              struct.attributes.put(_key127, _val128);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getVerTs_result implements org.apache.thrift.TBase<getVerTs_result, getVerTs_result._Fields>, java.io.Serializable, Cloneable, Comparable<getVerTs_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getVerTs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getVerTs_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getVerTs_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TCell> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TCell.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getVerTs_result.class, metaDataMap);
    }

    public getVerTs_result() {
    }

    public getVerTs_result(
      java.util.List<TCell> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getVerTs_result(getVerTs_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TCell> __this__success = new java.util.ArrayList<TCell>(other.success.size());
        for (TCell other_element : other.success) {
          __this__success.add(new TCell(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getVerTs_result deepCopy() {
      return new getVerTs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TCell> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TCell elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TCell>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TCell> getSuccess() {
      return this.success;
    }

    public getVerTs_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TCell> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public getVerTs_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TCell>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getVerTs_result)
        return this.equals((getVerTs_result)that);
      return false;
    }

    public boolean equals(getVerTs_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getVerTs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getVerTs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getVerTs_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getVerTs_resultStandardScheme getScheme() {
        return new getVerTs_resultStandardScheme();
      }
    }

    private static class getVerTs_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getVerTs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getVerTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list130 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TCell>(_list130.size);
                  @org.apache.thrift.annotation.Nullable TCell _elem131;
                  for (int _i132 = 0; _i132 < _list130.size; ++_i132)
                  {
                    _elem131 = new TCell();
                    _elem131.read(iprot);
                    struct.success.add(_elem131);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getVerTs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TCell _iter133 : struct.success)
            {
              _iter133.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getVerTs_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getVerTs_resultTupleScheme getScheme() {
        return new getVerTs_resultTupleScheme();
      }
    }

    private static class getVerTs_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getVerTs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getVerTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TCell _iter134 : struct.success)
            {
              _iter134.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getVerTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list135 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new java.util.ArrayList<TCell>(_list135.size);
            @org.apache.thrift.annotation.Nullable TCell _elem136;
            for (int _i137 = 0; _i137 < _list135.size; ++_i137)
            {
              _elem136 = new TCell();
              _elem136.read(iprot);
              struct.success.add(_elem136);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getRow_args implements org.apache.thrift.TBase<getRow_args, getRow_args._Fields>, java.io.Serializable, Cloneable, Comparable<getRow_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRow_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)3);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getRow_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getRow_argsTupleSchemeFactory();

    /**
     * name of table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required
    /**
     * row key
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * Get attributes
     */
    public @org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)3, "attributes");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRow_args.class, metaDataMap);
    }

    public getRow_args() {
    }

    public getRow_args(
      java.nio.ByteBuffer tableName,
      java.nio.ByteBuffer row,
      java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRow_args(getRow_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      if (other.isSetAttributes()) {
        java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> __this__attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(other.attributes.size());
        for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> other_element : other.attributes.entrySet()) {

          java.nio.ByteBuffer other_element_key = other_element.getKey();
          java.nio.ByteBuffer other_element_value = other_element.getValue();

          java.nio.ByteBuffer __this__attributes_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);

          java.nio.ByteBuffer __this__attributes_copy_value = org.apache.thrift.TBaseHelper.copyBinary(other_element_value);

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRow_args deepCopy() {
      return new getRow_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of table
     */
    public getRow_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public getRow_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row key
     */
    public getRow_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public getRow_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(java.nio.ByteBuffer key, java.nio.ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRow_args setAttributes(@org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getRow_args)
        return this.equals((getRow_args)that);
      return false;
    }

    public boolean equals(getRow_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + ((isSetAttributes()) ? 131071 : 524287);
      if (isSetAttributes())
        hashCode = hashCode * 8191 + attributes.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getRow_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetRow()).compareTo(other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetAttributes()).compareTo(other.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, other.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getRow_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRow_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRow_argsStandardScheme getScheme() {
        return new getRow_argsStandardScheme();
      }
    }

    private static class getRow_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getRow_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map138 = iprot.readMapBegin();
                  struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map138.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key139;
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val140;
                  for (int _i141 = 0; _i141 < _map138.size; ++_i141)
                  {
                    _key139 = iprot.readBinary();
                    _val140 = iprot.readBinary();
                    struct.attributes.put(_key139, _val140);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRow_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter142 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter142.getKey());
              oprot.writeBinary(_iter142.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRow_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRow_argsTupleScheme getScheme() {
        return new getRow_argsTupleScheme();
      }
    }

    private static class getRow_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getRow_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetAttributes()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter143 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter143.getKey());
              oprot.writeBinary(_iter143.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TMap _map144 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map144.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key145;
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val146;
            for (int _i147 = 0; _i147 < _map144.size; ++_i147)
            {
              _key145 = iprot.readBinary();
              _val146 = iprot.readBinary();
              struct.attributes.put(_key145, _val146);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getRow_result implements org.apache.thrift.TBase<getRow_result, getRow_result._Fields>, java.io.Serializable, Cloneable, Comparable<getRow_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRow_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getRow_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getRow_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TRowResult> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRow_result.class, metaDataMap);
    }

    public getRow_result() {
    }

    public getRow_result(
      java.util.List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRow_result(getRow_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TRowResult> __this__success = new java.util.ArrayList<TRowResult>(other.success.size());
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRow_result deepCopy() {
      return new getRow_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRow_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public getRow_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getRow_result)
        return this.equals((getRow_result)that);
      return false;
    }

    public boolean equals(getRow_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getRow_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getRow_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRow_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRow_resultStandardScheme getScheme() {
        return new getRow_resultStandardScheme();
      }
    }

    private static class getRow_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getRow_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list148 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TRowResult>(_list148.size);
                  @org.apache.thrift.annotation.Nullable TRowResult _elem149;
                  for (int _i150 = 0; _i150 < _list148.size; ++_i150)
                  {
                    _elem149 = new TRowResult();
                    _elem149.read(iprot);
                    struct.success.add(_elem149);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRow_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter151 : struct.success)
            {
              _iter151.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRow_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRow_resultTupleScheme getScheme() {
        return new getRow_resultTupleScheme();
      }
    }

    private static class getRow_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getRow_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter152 : struct.success)
            {
              _iter152.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list153 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new java.util.ArrayList<TRowResult>(_list153.size);
            @org.apache.thrift.annotation.Nullable TRowResult _elem154;
            for (int _i155 = 0; _i155 < _list153.size; ++_i155)
            {
              _elem154 = new TRowResult();
              _elem154.read(iprot);
              struct.success.add(_elem154);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getRowWithColumns_args implements org.apache.thrift.TBase<getRowWithColumns_args, getRowWithColumns_args._Fields>, java.io.Serializable, Cloneable, Comparable<getRowWithColumns_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowWithColumns_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMNS_FIELD_DESC = new org.apache.thrift.protocol.TField("columns", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getRowWithColumns_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getRowWithColumns_argsTupleSchemeFactory();

    /**
     * name of table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required
    /**
     * row key
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * List of columns to return, null for all columns
     */
    public @org.apache.thrift.annotation.Nullable java.util.List<java.nio.ByteBuffer> columns; // required
    /**
     * Get attributes
     */
    public @org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * List of columns to return, null for all columns
       */
      COLUMNS((short)3, "columns"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)4, "attributes");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMNS
            return COLUMNS;
          case 4: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMNS, new org.apache.thrift.meta_data.FieldMetaData("columns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowWithColumns_args.class, metaDataMap);
    }

    public getRowWithColumns_args() {
    }

    public getRowWithColumns_args(
      java.nio.ByteBuffer tableName,
      java.nio.ByteBuffer row,
      java.util.List<java.nio.ByteBuffer> columns,
      java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.columns = columns;
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowWithColumns_args(getRowWithColumns_args other) {
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      if (other.isSetColumns()) {
        java.util.List<java.nio.ByteBuffer> __this__columns = new java.util.ArrayList<java.nio.ByteBuffer>(other.columns.size());
        for (java.nio.ByteBuffer other_element : other.columns) {
          __this__columns.add(org.apache.thrift.TBaseHelper.copyBinary(other_element));
        }
        this.columns = __this__columns;
      }
      if (other.isSetAttributes()) {
        java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> __this__attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(other.attributes.size());
        for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> other_element : other.attributes.entrySet()) {

          java.nio.ByteBuffer other_element_key = other_element.getKey();
          java.nio.ByteBuffer other_element_value = other_element.getValue();

          java.nio.ByteBuffer __this__attributes_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);

          java.nio.ByteBuffer __this__attributes_copy_value = org.apache.thrift.TBaseHelper.copyBinary(other_element_value);

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowWithColumns_args deepCopy() {
      return new getRowWithColumns_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.columns = null;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of table
     */
    public getRowWithColumns_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public getRowWithColumns_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row key
     */
    public getRowWithColumns_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public getRowWithColumns_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    public int getColumnsSize() {
      return (this.columns == null) ? 0 : this.columns.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<java.nio.ByteBuffer> getColumnsIterator() {
      return (this.columns == null) ? null : this.columns.iterator();
    }

    public void addToColumns(java.nio.ByteBuffer elem) {
      if (this.columns == null) {
        this.columns = new java.util.ArrayList<java.nio.ByteBuffer>();
      }
      this.columns.add(elem);
    }

    /**
     * List of columns to return, null for all columns
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.List<java.nio.ByteBuffer> getColumns() {
      return this.columns;
    }

    /**
     * List of columns to return, null for all columns
     */
    public getRowWithColumns_args setColumns(@org.apache.thrift.annotation.Nullable java.util.List<java.nio.ByteBuffer> columns) {
      this.columns = columns;
      return this;
    }

    public void unsetColumns() {
      this.columns = null;
    }

    /** Returns true if field columns is set (has been assigned a value) and false otherwise */
    public boolean isSetColumns() {
      return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
      if (!value) {
        this.columns = null;
      }
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(java.nio.ByteBuffer key, java.nio.ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowWithColumns_args setAttributes(@org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case COLUMNS:
        if (value == null) {
          unsetColumns();
        } else {
          setColumns((java.util.List<java.nio.ByteBuffer>)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMNS:
        return getColumns();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMNS:
        return isSetColumns();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowWithColumns_args)
        return this.equals((getRowWithColumns_args)that);
      return false;
    }

    public boolean equals(getRowWithColumns_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_columns = true && this.isSetColumns();
      boolean that_present_columns = true && that.isSetColumns();
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + ((isSetColumns()) ? 131071 : 524287);
      if (isSetColumns())
        hashCode = hashCode * 8191 + columns.hashCode();

      hashCode = hashCode * 8191 + ((isSetAttributes()) ? 131071 : 524287);
      if (isSetAttributes())
        hashCode = hashCode * 8191 + attributes.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getRowWithColumns_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetRow()).compareTo(other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetColumns()).compareTo(other.isSetColumns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columns, other.columns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetAttributes()).compareTo(other.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, other.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getRowWithColumns_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columns:");
      if (this.columns == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.columns, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowWithColumns_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowWithColumns_argsStandardScheme getScheme() {
        return new getRowWithColumns_argsStandardScheme();
      }
    }

    private static class getRowWithColumns_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getRowWithColumns_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowWithColumns_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // COLUMNS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list156 = iprot.readListBegin();
                  struct.columns = new java.util.ArrayList<java.nio.ByteBuffer>(_list156.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _elem157;
                  for (int _i158 = 0; _i158 < _list156.size; ++_i158)
                  {
                    _elem157 = iprot.readBinary();
                    struct.columns.add(_elem157);
                  }
                  iprot.readListEnd();
                }
                struct.setColumnsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map159 = iprot.readMapBegin();
                  struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map159.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key160;
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val161;
                  for (int _i162 = 0; _i162 < _map159.size; ++_i162)
                  {
                    _key160 = iprot.readBinary();
                    _val161 = iprot.readBinary();
                    struct.attributes.put(_key160, _val161);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowWithColumns_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.columns != null) {
          oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.columns.size()));
            for (java.nio.ByteBuffer _iter163 : struct.columns)
            {
              oprot.writeBinary(_iter163);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter164 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter164.getKey());
              oprot.writeBinary(_iter164.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowWithColumns_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowWithColumns_argsTupleScheme getScheme() {
        return new getRowWithColumns_argsTupleScheme();
      }
    }

    private static class getRowWithColumns_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getRowWithColumns_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowWithColumns_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetColumns()) {
          optionals.set(2);
        }
        if (struct.isSetAttributes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetColumns()) {
          {
            oprot.writeI32(struct.columns.size());
            for (java.nio.ByteBuffer _iter165 : struct.columns)
            {
              oprot.writeBinary(_iter165);
            }
          }
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter166 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter166.getKey());
              oprot.writeBinary(_iter166.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowWithColumns_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TList _list167 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.columns = new java.util.ArrayList<java.nio.ByteBuffer>(_list167.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _elem168;
            for (int _i169 = 0; _i169 < _list167.size; ++_i169)
            {
              _elem168 = iprot.readBinary();
              struct.columns.add(_elem168);
            }
          }
          struct.setColumnsIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map170 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map170.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key171;
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val172;
            for (int _i173 = 0; _i173 < _map170.size; ++_i173)
            {
              _key171 = iprot.readBinary();
              _val172 = iprot.readBinary();
              struct.attributes.put(_key171, _val172);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getRowWithColumns_result implements org.apache.thrift.TBase<getRowWithColumns_result, getRowWithColumns_result._Fields>, java.io.Serializable, Cloneable, Comparable<getRowWithColumns_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowWithColumns_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getRowWithColumns_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getRowWithColumns_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TRowResult> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowWithColumns_result.class, metaDataMap);
    }

    public getRowWithColumns_result() {
    }

    public getRowWithColumns_result(
      java.util.List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowWithColumns_result(getRowWithColumns_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TRowResult> __this__success = new java.util.ArrayList<TRowResult>(other.success.size());
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRowWithColumns_result deepCopy() {
      return new getRowWithColumns_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRowWithColumns_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public getRowWithColumns_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowWithColumns_result)
        return this.equals((getRowWithColumns_result)that);
      return false;
    }

    public boolean equals(getRowWithColumns_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getRowWithColumns_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getRowWithColumns_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowWithColumns_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowWithColumns_resultStandardScheme getScheme() {
        return new getRowWithColumns_resultStandardScheme();
      }
    }

    private static class getRowWithColumns_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getRowWithColumns_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowWithColumns_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list174 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TRowResult>(_list174.size);
                  @org.apache.thrift.annotation.Nullable TRowResult _elem175;
                  for (int _i176 = 0; _i176 < _list174.size; ++_i176)
                  {
                    _elem175 = new TRowResult();
                    _elem175.read(iprot);
                    struct.success.add(_elem175);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowWithColumns_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter177 : struct.success)
            {
              _iter177.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowWithColumns_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowWithColumns_resultTupleScheme getScheme() {
        return new getRowWithColumns_resultTupleScheme();
      }
    }

    private static class getRowWithColumns_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getRowWithColumns_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowWithColumns_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter178 : struct.success)
            {
              _iter178.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowWithColumns_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list179 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new java.util.ArrayList<TRowResult>(_list179.size);
            @org.apache.thrift.annotation.Nullable TRowResult _elem180;
            for (int _i181 = 0; _i181 < _list179.size; ++_i181)
            {
              _elem180 = new TRowResult();
              _elem180.read(iprot);
              struct.success.add(_elem180);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getRowTs_args implements org.apache.thrift.TBase<getRowTs_args, getRowTs_args._Fields>, java.io.Serializable, Cloneable, Comparable<getRowTs_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowTs_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)4);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getRowTs_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getRowTs_argsTupleSchemeFactory();

    /**
     * name of the table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required
    /**
     * row key
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * timestamp
     */
    public long timestamp; // required
    /**
     * Get attributes
     */
    public @org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of the table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * timestamp
       */
      TIMESTAMP((short)3, "timestamp"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)4, "attributes");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // TIMESTAMP
            return TIMESTAMP;
          case 4: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowTs_args.class, metaDataMap);
    }

    public getRowTs_args() {
    }

    public getRowTs_args(
      java.nio.ByteBuffer tableName,
      java.nio.ByteBuffer row,
      long timestamp,
      java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowTs_args(getRowTs_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      this.timestamp = other.timestamp;
      if (other.isSetAttributes()) {
        java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> __this__attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(other.attributes.size());
        for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> other_element : other.attributes.entrySet()) {

          java.nio.ByteBuffer other_element_key = other_element.getKey();
          java.nio.ByteBuffer other_element_value = other_element.getValue();

          java.nio.ByteBuffer __this__attributes_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);

          java.nio.ByteBuffer __this__attributes_copy_value = org.apache.thrift.TBaseHelper.copyBinary(other_element_value);

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowTs_args deepCopy() {
      return new getRowTs_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      this.attributes = null;
    }

    /**
     * name of the table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of the table
     */
    public getRowTs_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public getRowTs_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row key
     */
    public getRowTs_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public getRowTs_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * timestamp
     */
    public long getTimestamp() {
      return this.timestamp;
    }

    /**
     * timestamp
     */
    public getRowTs_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TIMESTAMP_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(java.nio.ByteBuffer key, java.nio.ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowTs_args setAttributes(@org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((java.lang.Long)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case TIMESTAMP:
        return getTimestamp();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case TIMESTAMP:
        return isSetTimestamp();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowTs_args)
        return this.equals((getRowTs_args)that);
      return false;
    }

    public boolean equals(getRowTs_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(timestamp);

      hashCode = hashCode * 8191 + ((isSetAttributes()) ? 131071 : 524287);
      if (isSetAttributes())
        hashCode = hashCode * 8191 + attributes.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getRowTs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetRow()).compareTo(other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetTimestamp()).compareTo(other.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, other.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetAttributes()).compareTo(other.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, other.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getRowTs_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowTs_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowTs_argsStandardScheme getScheme() {
        return new getRowTs_argsStandardScheme();
      }
    }

    private static class getRowTs_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getRowTs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TIMESTAMP
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.timestamp = iprot.readI64();
                struct.setTimestampIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // ATTRIBUTES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map182 = iprot.readMapBegin();
                  struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map182.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key183;
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val184;
                  for (int _i185 = 0; _i185 < _map182.size; ++_i185)
                  {
                    _key183 = iprot.readBinary();
                    _val184 = iprot.readBinary();
                    struct.attributes.put(_key183, _val184);
                  }
                  iprot.readMapEnd();
                }
                struct.setAttributesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowTs_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tableName != null) {
          oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
          oprot.writeBinary(struct.tableName);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
        oprot.writeI64(struct.timestamp);
        oprot.writeFieldEnd();
        if (struct.attributes != null) {
          oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.attributes.size()));
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter186 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter186.getKey());
              oprot.writeBinary(_iter186.getValue());
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowTs_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowTs_argsTupleScheme getScheme() {
        return new getRowTs_argsTupleScheme();
      }
    }

    private static class getRowTs_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getRowTs_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTableName()) {
          optionals.set(0);
        }
        if (struct.isSetRow()) {
          optionals.set(1);
        }
        if (struct.isSetTimestamp()) {
          optionals.set(2);
        }
        if (struct.isSetAttributes()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTableName()) {
          oprot.writeBinary(struct.tableName);
        }
        if (struct.isSetRow()) {
          oprot.writeBinary(struct.row);
        }
        if (struct.isSetTimestamp()) {
          oprot.writeI64(struct.timestamp);
        }
        if (struct.isSetAttributes()) {
          {
            oprot.writeI32(struct.attributes.size());
            for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> _iter187 : struct.attributes.entrySet())
            {
              oprot.writeBinary(_iter187.getKey());
              oprot.writeBinary(_iter187.getValue());
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tableName = iprot.readBinary();
          struct.setTableNameIsSet(true);
        }
        if (incoming.get(1)) {
          struct.row = iprot.readBinary();
          struct.setRowIsSet(true);
        }
        if (incoming.get(2)) {
          struct.timestamp = iprot.readI64();
          struct.setTimestampIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map188 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
            struct.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(2*_map188.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _key189;
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _val190;
            for (int _i191 = 0; _i191 < _map188.size; ++_i191)
            {
              _key189 = iprot.readBinary();
              _val190 = iprot.readBinary();
              struct.attributes.put(_key189, _val190);
            }
          }
          struct.setAttributesIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getRowTs_result implements org.apache.thrift.TBase<getRowTs_result, getRowTs_result._Fields>, java.io.Serializable, Cloneable, Comparable<getRowTs_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowTs_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getRowTs_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getRowTs_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TRowResult> success; // required
    public @org.apache.thrift.annotation.Nullable IOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, IOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowTs_result.class, metaDataMap);
    }

    public getRowTs_result() {
    }

    public getRowTs_result(
      java.util.List<TRowResult> success,
      IOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowTs_result(getRowTs_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TRowResult> __this__success = new java.util.ArrayList<TRowResult>(other.success.size());
        for (TRowResult other_element : other.success) {
          __this__success.add(new TRowResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new IOError(other.io);
      }
    }

    public getRowTs_result deepCopy() {
      return new getRowTs_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TRowResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TRowResult elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TRowResult>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TRowResult> getSuccess() {
      return this.success;
    }

    public getRowTs_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TRowResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public IOError getIo() {
      return this.io;
    }

    public getRowTs_result setIo(@org.apache.thrift.annotation.Nullable IOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TRowResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((IOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowTs_result)
        return this.equals((getRowTs_result)that);
      return false;
    }

    public boolean equals(getRowTs_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getRowTs_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetIo()).compareTo(other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getRowTs_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowTs_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowTs_resultStandardScheme getScheme() {
        return new getRowTs_resultStandardScheme();
      }
    }

    private static class getRowTs_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getRowTs_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list192 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TRowResult>(_list192.size);
                  @org.apache.thrift.annotation.Nullable TRowResult _elem193;
                  for (int _i194 = 0; _i194 < _list192.size; ++_i194)
                  {
                    _elem193 = new TRowResult();
                    _elem193.read(iprot);
                    struct.success.add(_elem193);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new IOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getRowTs_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TRowResult _iter195 : struct.success)
            {
              _iter195.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getRowTs_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowTs_resultTupleScheme getScheme() {
        return new getRowTs_resultTupleScheme();
      }
    }

    private static class getRowTs_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getRowTs_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getRowTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TRowResult _iter196 : struct.success)
            {
              _iter196.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getRowTs_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list197 = new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
            struct.success = new java.util.ArrayList<TRowResult>(_list197.size);
            @org.apache.thrift.annotation.Nullable TRowResult _elem198;
            for (int _i199 = 0; _i199 < _list197.size; ++_i199)
            {
              _elem198 = new TRowResult();
              _elem198.read(iprot);
              struct.success.add(_elem198);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new IOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getRowWithColumnsTs_args implements org.apache.thrift.TBase<getRowWithColumnsTs_args, getRowWithColumnsTs_args._Fields>, java.io.Serializable, Cloneable, Comparable<getRowWithColumnsTs_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRowWithColumnsTs_args");

    private static final org.apache.thrift.protocol.TField TABLE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("tableName", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField COLUMNS_FIELD_DESC = new org.apache.thrift.protocol.TField("columns", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField TIMESTAMP_FIELD_DESC = new org.apache.thrift.protocol.TField("timestamp", org.apache.thrift.protocol.TType.I64, (short)4);
    private static final org.apache.thrift.protocol.TField ATTRIBUTES_FIELD_DESC = new org.apache.thrift.protocol.TField("attributes", org.apache.thrift.protocol.TType.MAP, (short)5);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getRowWithColumnsTs_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getRowWithColumnsTs_argsTupleSchemeFactory();

    /**
     * name of table
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName; // required
    /**
     * row key
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * List of columns to return, null for all columns
     */
    public @org.apache.thrift.annotation.Nullable java.util.List<java.nio.ByteBuffer> columns; // required
    public long timestamp; // required
    /**
     * Get attributes
     */
    public @org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * name of table
       */
      TABLE_NAME((short)1, "tableName"),
      /**
       * row key
       */
      ROW((short)2, "row"),
      /**
       * List of columns to return, null for all columns
       */
      COLUMNS((short)3, "columns"),
      TIMESTAMP((short)4, "timestamp"),
      /**
       * Get attributes
       */
      ATTRIBUTES((short)5, "attributes");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE_NAME
            return TABLE_NAME;
          case 2: // ROW
            return ROW;
          case 3: // COLUMNS
            return COLUMNS;
          case 4: // TIMESTAMP
            return TIMESTAMP;
          case 5: // ATTRIBUTES
            return ATTRIBUTES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TIMESTAMP_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE_NAME, new org.apache.thrift.meta_data.FieldMetaData("tableName", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , "Text")));
      tmpMap.put(_Fields.COLUMNS, new org.apache.thrift.meta_data.FieldMetaData("columns", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      tmpMap.put(_Fields.TIMESTAMP, new org.apache.thrift.meta_data.FieldMetaData("timestamp", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.ATTRIBUTES, new org.apache.thrift.meta_data.FieldMetaData("attributes", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"), 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , "Text"))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRowWithColumnsTs_args.class, metaDataMap);
    }

    public getRowWithColumnsTs_args() {
    }

    public getRowWithColumnsTs_args(
      java.nio.ByteBuffer tableName,
      java.nio.ByteBuffer row,
      java.util.List<java.nio.ByteBuffer> columns,
      long timestamp,
      java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes)
    {
      this();
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.columns = columns;
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      this.attributes = attributes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRowWithColumnsTs_args(getRowWithColumnsTs_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTableName()) {
        this.tableName = org.apache.thrift.TBaseHelper.copyBinary(other.tableName);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      if (other.isSetColumns()) {
        java.util.List<java.nio.ByteBuffer> __this__columns = new java.util.ArrayList<java.nio.ByteBuffer>(other.columns.size());
        for (java.nio.ByteBuffer other_element : other.columns) {
          __this__columns.add(org.apache.thrift.TBaseHelper.copyBinary(other_element));
        }
        this.columns = __this__columns;
      }
      this.timestamp = other.timestamp;
      if (other.isSetAttributes()) {
        java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> __this__attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>(other.attributes.size());
        for (java.util.Map.Entry<java.nio.ByteBuffer, java.nio.ByteBuffer> other_element : other.attributes.entrySet()) {

          java.nio.ByteBuffer other_element_key = other_element.getKey();
          java.nio.ByteBuffer other_element_value = other_element.getValue();

          java.nio.ByteBuffer __this__attributes_copy_key = org.apache.thrift.TBaseHelper.copyBinary(other_element_key);

          java.nio.ByteBuffer __this__attributes_copy_value = org.apache.thrift.TBaseHelper.copyBinary(other_element_value);

          __this__attributes.put(__this__attributes_copy_key, __this__attributes_copy_value);
        }
        this.attributes = __this__attributes;
      }
    }

    public getRowWithColumnsTs_args deepCopy() {
      return new getRowWithColumnsTs_args(this);
    }

    @Override
    public void clear() {
      this.tableName = null;
      this.row = null;
      this.columns = null;
      setTimestampIsSet(false);
      this.timestamp = 0;
      this.attributes = null;
    }

    /**
     * name of table
     */
    public byte[] getTableName() {
      setTableName(org.apache.thrift.TBaseHelper.rightSize(tableName));
      return tableName == null ? null : tableName.array();
    }

    public java.nio.ByteBuffer bufferForTableName() {
      return org.apache.thrift.TBaseHelper.copyBinary(tableName);
    }

    /**
     * name of table
     */
    public getRowWithColumnsTs_args setTableName(byte[] tableName) {
      this.tableName = tableName == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(tableName.clone());
      return this;
    }

    public getRowWithColumnsTs_args setTableName(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer tableName) {
      this.tableName = org.apache.thrift.TBaseHelper.copyBinary(tableName);
      return this;
    }

    public void unsetTableName() {
      this.tableName = null;
    }

    /** Returns true if field tableName is set (has been assigned a value) and false otherwise */
    public boolean isSetTableName() {
      return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
      if (!value) {
        this.tableName = null;
      }
    }

    /**
     * row key
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row key
     */
    public getRowWithColumnsTs_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public getRowWithColumnsTs_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    public int getColumnsSize() {
      return (this.columns == null) ? 0 : this.columns.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<java.nio.ByteBuffer> getColumnsIterator() {
      return (this.columns == null) ? null : this.columns.iterator();
    }

    public void addToColumns(java.nio.ByteBuffer elem) {
      if (this.columns == null) {
        this.columns = new java.util.ArrayList<java.nio.ByteBuffer>();
      }
      this.columns.add(elem);
    }

    /**
     * List of columns to return, null for all columns
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.List<java.nio.ByteBuffer> getColumns() {
      return this.columns;
    }

    /**
     * List of columns to return, null for all columns
     */
    public getRowWithColumnsTs_args setColumns(@org.apache.thrift.annotation.Nullable java.util.List<java.nio.ByteBuffer> columns) {
      this.columns = columns;
      return this;
    }

    public void unsetColumns() {
      this.columns = null;
    }

    /** Returns true if field columns is set (has been assigned a value) and false otherwise */
    public boolean isSetColumns() {
      return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
      if (!value) {
        this.columns = null;
      }
    }

    public long getTimestamp() {
      return this.timestamp;
    }

    public getRowWithColumnsTs_args setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      setTimestampIsSet(true);
      return this;
    }

    public void unsetTimestamp() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    /** Returns true if field timestamp is set (has been assigned a value) and false otherwise */
    public boolean isSetTimestamp() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TIMESTAMP_ISSET_ID);
    }

    public void setTimestampIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TIMESTAMP_ISSET_ID, value);
    }

    public int getAttributesSize() {
      return (this.attributes == null) ? 0 : this.attributes.size();
    }

    public void putToAttributes(java.nio.ByteBuffer key, java.nio.ByteBuffer val) {
      if (this.attributes == null) {
        this.attributes = new java.util.HashMap<java.nio.ByteBuffer,java.nio.ByteBuffer>();
      }
      this.attributes.put(key, val);
    }

    /**
     * Get attributes
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> getAttributes() {
      return this.attributes;
    }

    /**
     * Get attributes
     */
    public getRowWithColumnsTs_args setAttributes(@org.apache.thrift.annotation.Nullable java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer> attributes) {
      this.attributes = attributes;
      return this;
    }

    public void unsetAttributes() {
      this.attributes = null;
    }

    /** Returns true if field attributes is set (has been assigned a value) and false otherwise */
    public boolean isSetAttributes() {
      return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
      if (!value) {
        this.attributes = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE_NAME:
        if (value == null) {
          unsetTableName();
        } else {
          if (value instanceof byte[]) {
            setTableName((byte[])value);
          } else {
            setTableName((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case COLUMNS:
        if (value == null) {
          unsetColumns();
        } else {
          setColumns((java.util.List<java.nio.ByteBuffer>)value);
        }
        break;

      case TIMESTAMP:
        if (value == null) {
          unsetTimestamp();
        } else {
          setTimestamp((java.lang.Long)value);
        }
        break;

      case ATTRIBUTES:
        if (value == null) {
          unsetAttributes();
        } else {
          setAttributes((java.util.Map<java.nio.ByteBuffer,java.nio.ByteBuffer>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE_NAME:
        return getTableName();

      case ROW:
        return getRow();

      case COLUMNS:
        return getColumns();

      case TIMESTAMP:
        return getTimestamp();

      case ATTRIBUTES:
        return getAttributes();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE_NAME:
        return isSetTableName();
      case ROW:
        return isSetRow();
      case COLUMNS:
        return isSetColumns();
      case TIMESTAMP:
        return isSetTimestamp();
      case ATTRIBUTES:
        return isSetAttributes();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowWithColumnsTs_args)
        return this.equals((getRowWithColumnsTs_args)that);
      return false;
    }

    public boolean equals(getRowWithColumnsTs_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tableName = true && this.isSetTableName();
      boolean that_present_tableName = true && that.isSetTableName();
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!this.tableName.equals(that.tableName))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_columns = true && this.isSetColumns();
      boolean that_present_columns = true && that.isSetColumns();
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_attributes = true && this.isSetAttributes();
      boolean that_present_attributes = true && that.isSetAttributes();
      if (this_present_attributes || that_present_attributes) {
        if (!(this_present_attributes && that_present_attributes))
          return false;
        if (!this.attributes.equals(that.attributes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTableName()) ? 131071 : 524287);
      if (isSetTableName())
        hashCode = hashCode * 8191 + tableName.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + ((isSetColumns()) ? 131071 : 524287);
      if (isSetColumns())
        hashCode = hashCode * 8191 + columns.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(timestamp);

      hashCode = hashCode * 8191 + ((isSetAttributes()) ? 131071 : 524287);
      if (isSetAttributes())
        hashCode = hashCode * 8191 + attributes.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getRowWithColumnsTs_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.valueOf(isSetTableName()).compareTo(other.isSetTableName());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableName()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableName, other.tableName);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetRow()).compareTo(other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetColumns()).compareTo(other.isSetColumns());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetColumns()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.columns, other.columns);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetTimestamp()).compareTo(other.isSetTimestamp());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTimestamp()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.timestamp, other.timestamp);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.valueOf(isSetAttributes()).compareTo(other.isSetAttributes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAttributes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.attributes, other.attributes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getRowWithColumnsTs_args(");
      boolean first = true;

      sb.append("tableName:");
      if (this.tableName == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.tableName, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("columns:");
      if (this.columns == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.columns, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("timestamp:");
      sb.append(this.timestamp);
      first = false;
      if (!first) sb.append(", ");
      sb.append("attributes:");
      if (this.attributes == null) {
        sb.append("null");
      } else {
        sb.append(this.attributes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getRowWithColumnsTs_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getRowWithColumnsTs_argsStandardScheme getScheme() {
        return new getRowWithColumnsTs_argsStandardScheme();
      }
    }

    private static class getRowWithColumnsTs_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getRowWithColumnsTs_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getRowWithColumnsTs_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE_NAME
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableName = iprot.readBinary();
                struct.setTableNameIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row =