/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hbase.codec.prefixtree.row;

import java.util.List;

import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;

import com.google.common.collect.Lists;

public abstract class BaseTestRowData implements TestRowData {

  @Override
  public List<Integer> getRowStartIndexes() {
    List<Integer> rowStartIndexes = Lists.newArrayList();
    rowStartIndexes.add(0);
    List<KeyValue> inputs = getInputs();
    for (int i = 1; i < inputs.size(); ++i) {
      KeyValue lastKv = inputs.get(i - 1);
      KeyValue kv = inputs.get(i);
      if (!CellComparator.equalsRow(lastKv, kv)) {
        rowStartIndexes.add(i);
      }
    }
    return rowStartIndexes;
  }

  @Override
  public void individualBlockMetaAssertions(PrefixTreeBlockMeta blockMeta) {
  }

  @Override
  public void individualSearcherAssertions(CellSearcher searcher) {
  }
}
