#
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# HBase ruby classes.
# Has wrapper classes for org.apache.hadoop.hbase.client.Admin
# and for org.apache.hadoop.hbase.client.Table.  Classes take
# Formatters on construction and outputs any results using
# Formatter methods.  These classes are only really for use by
# the hirb.rb HBase Shell script; they don't make much sense elsewhere.
# For example, the exists method on Admin class prints to the formatter
# whether the table exists and returns nil regardless.
include Java

include_class('java.lang.Integer') {|package,name| "J#{name}" }
include_class('java.lang.Long') {|package,name| "J#{name}" }
include_class('java.lang.Boolean') {|package,name| "J#{name}" }

module HBaseConstants
  COLUMN = "COLUMN"
  COLUMNS = "COLUMNS"
  TIMESTAMP = "TIMESTAMP"
  TIMERANGE = "TIMERANGE"
  NAME = org.apache.hadoop.hbase.HConstants::NAME
  VERSIONS = org.apache.hadoop.hbase.HConstants::VERSIONS
  IN_MEMORY = org.apache.hadoop.hbase.HConstants::IN_MEMORY
  METADATA = org.apache.hadoop.hbase.HConstants::METADATA
  STOPROW = "STOPROW"
  STARTROW = "STARTROW"
  ROWPREFIXFILTER = "ROWPREFIXFILTER"
  ENDROW = STOPROW
  RAW = "RAW"
  LIMIT = "LIMIT"
  METHOD = "METHOD"
  MAXLENGTH = "MAXLENGTH"
  CACHE_BLOCKS = "CACHE_BLOCKS"
  ALL_METRICS = "ALL_METRICS"
  METRICS = "METRICS"
  REVERSED = "REVERSED"
  REPLICATION_SCOPE = "REPLICATION_SCOPE"
  INTERVAL = 'INTERVAL'
  CACHE = 'CACHE'
  FILTER = 'FILTER'
  SPLITS = 'SPLITS'
  SPLITS_FILE = 'SPLITS_FILE'
  SPLITALGO = 'SPLITALGO'
  NUMREGIONS = 'NUMREGIONS'
  REGION_REPLICATION = 'REGION_REPLICATION'
  REGION_REPLICA_ID = 'REGION_REPLICA_ID'
  CONFIGURATION = org.apache.hadoop.hbase.HConstants::CONFIGURATION
  ATTRIBUTES="ATTRIBUTES"
  VISIBILITY="VISIBILITY"
  AUTHORIZATIONS = "AUTHORIZATIONS"
  SKIP_FLUSH = 'SKIP_FLUSH'
  CONSISTENCY = "CONSISTENCY"
  ENDPOINT_CLASSNAME = 'ENDPOINT_CLASSNAME'
  CLUSTER_KEY = 'CLUSTER_KEY'
  TABLE_CFS = 'TABLE_CFS'
  CONFIG = 'CONFIG'
  DATA = 'DATA'
  USER = 'USER'
  TABLE = 'TABLE'
  NAMESPACE = 'NAMESPACE'
  TYPE = 'TYPE'
  NONE = 'NONE'
  VALUE = 'VALUE'
  NAMESPACES = 'NAMESPACES'
  SERVER_NAME = 'SERVER_NAME'
  LOCALITY_THRESHOLD = 'LOCALITY_THRESHOLD'
  RESTORE_ACL = 'RESTORE_ACL'

  # Load constants from hbase java API
  def self.promote_constants(constants)
    # The constants to import are all in uppercase
    constants.each do |c|
      next if c =~ /DEFAULT_.*/ || c != c.upcase
      next if eval("defined?(#{c})")
      eval("#{c} = '#{c}'")
    end
  end

  promote_constants(org.apache.hadoop.hbase.HColumnDescriptor.constants)
  promote_constants(org.apache.hadoop.hbase.HTableDescriptor.constants)
end

# Include classes definition
require 'hbase/hbase'
require 'hbase/admin'
require 'hbase/taskmonitor'
require 'hbase/table'
require 'hbase/quotas'
require 'hbase/replication_admin'
require 'hbase/security'
require 'hbase/visibility_labels'
require 'hbase/rsgroup_admin'


include HBaseQuotasConstants
