/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.net;

import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BoundSocketMaker
implements Closeable {
    private static final Log LOG = LogFactory.getLog(BoundSocketMaker.class);
    private final ServerSocket socket;

    private BoundSocketMaker() {
        this.socket = null;
    }

    public BoundSocketMaker(Supplier<Integer> randomPortMaker) {
        this(InetAddress.getLoopbackAddress().getHostName(), randomPortMaker);
    }

    public BoundSocketMaker(String hostname, Supplier<Integer> randomPortMaker) {
        this.socket = this.get(hostname, randomPortMaker);
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    private ServerSocket get(String hostname, Supplier<Integer> randomPortMaker) {
        ServerSocket ss = null;
        int port = -1;
        while (true) {
            port = (Integer)randomPortMaker.get();
            try {
                ss = new ServerSocket();
                ss.bind(new InetSocketAddress(hostname, port));
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Failed bind", (Throwable)ioe);
                try {
                    ss.close();
                }
                catch (IOException ioe2) {
                    LOG.warn((Object)"FAILED CLOSE of failed bind socket", (Throwable)ioe2);
                }
                continue;
            }
            break;
        }
        return ss;
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

