/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ChaosUtils {
    public static String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static String getZKQuorum(Configuration conf) {
        String port = Integer.toString(conf.getInt("hbase.zookeeper.property.clientPort", 2181));
        String[] serverHosts = conf.getStrings("hbase.zookeeper.quorum", new String[]{"localhost"});
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < serverHosts.length; ++i) {
            serverHosts[i] = serverHosts[i] + ":" + port;
            sb.append(serverHosts[i]);
            if (i >= serverHosts.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

