/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class VersionInfo {
    private static final Log LOG = LogFactory.getLog((String)VersionInfo.class.getName());
    private static int VERY_LARGE_NUMBER = 100000;

    public static String getVersion() {
        return "1.7.1";
    }

    public static String getRevision() {
        return "2d9273667e418e7023f9104a830cdcb8233b6f25";
    }

    public static String getDate() {
        return "Fri Jul 16 00:20:26 PDT 2021";
    }

    public static String getUser() {
        return "bharathv";
    }

    public static String getUrl() {
        return "git://localhost.localdomain/home/bharathv/IdeaProjects/rc/hbase-rc-clone";
    }

    static String[] versionReport() {
        return new String[]{"HBase " + VersionInfo.getVersion(), "Source code repository " + VersionInfo.getUrl() + " revision=" + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate(), "From source with checksum " + VersionInfo.getSrcChecksum()};
    }

    public static String getSrcChecksum() {
        return "cb15e8fa7fadc65448aa9a30e3f40b27";
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void writeTo(PrintStream out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info((Object)line);
        }
    }

    public static int compareVersion(String v1, String v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        String[] v1Comps = VersionInfo.getVersionComponents(v1);
        String[] v2Comps = VersionInfo.getVersionComponents(v2);
        int length = Math.max(v1Comps.length, v2Comps.length);
        for (int i = 0; i < length; ++i) {
            Integer vb;
            Integer va = i < v1Comps.length ? Integer.parseInt(v1Comps[i]) : 0;
            int compare = va.compareTo(vb = Integer.valueOf(i < v2Comps.length ? Integer.parseInt(v2Comps[i]) : 0));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    private static String[] getVersionComponents(String version) {
        assert (version != null);
        String[] strComps = version.split("[\\.-]");
        assert (strComps.length > 0);
        String[] comps = new String[strComps.length];
        for (int i = 0; i < strComps.length; ++i) {
            comps[i] = StringUtils.isEmpty((String)strComps[i]) ? String.valueOf(VERY_LARGE_NUMBER) : (StringUtils.isNumeric((String)strComps[i]) ? strComps[i] : ("SNAPSHOT".equals(strComps[i]) ? "-1" : ("beta".equals(strComps[i]) ? "-2" : ("alpha".equals(strComps[i]) ? "-3" : "-4"))));
        }
        return comps;
    }

    public static void main(String[] args) {
        VersionInfo.writeTo(System.out);
    }
}

