/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.monkies;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.Policy;
import org.apache.hadoop.hbase.util.Pair;

public class PolicyBasedChaosMonkey
extends ChaosMonkey {
    private static final Log LOG = LogFactory.getLog(PolicyBasedChaosMonkey.class);
    private static final long ONE_SEC = 1000L;
    private static final long ONE_MIN = 60000L;
    public static final long TIMEOUT = 60000L;
    final IntegrationTestingUtility util;
    private final Policy[] policies;
    private final ExecutorService monkeyThreadPool;

    public PolicyBasedChaosMonkey(IntegrationTestingUtility util, Collection<Policy> policies) {
        this(util, policies.toArray(new Policy[0]));
    }

    public PolicyBasedChaosMonkey(IntegrationTestingUtility util, Policy ... policies) {
        this.util = Objects.requireNonNull(util);
        this.policies = Objects.requireNonNull(policies);
        if (policies.length == 0) {
            throw new IllegalArgumentException("policies may not be empty");
        }
        this.monkeyThreadPool = PolicyBasedChaosMonkey.buildMonkeyThreadPool(policies.length);
    }

    private static ExecutorService buildMonkeyThreadPool(int size) {
        return Executors.newFixedThreadPool(size, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("ChaosMonkey-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                throw new RuntimeException(e);
            }
        }).build());
    }

    public static <T> T selectRandomItem(T[] items) {
        return items[RandomUtils.nextInt((int)items.length)];
    }

    public static <T> T selectWeightedRandomItem(List<Pair<T, Integer>> items) {
        int totalWeight = 0;
        for (Pair<T, Integer> pair : items) {
            totalWeight += ((Integer)pair.getSecond()).intValue();
        }
        int cutoff = RandomUtils.nextInt((int)totalWeight);
        int cummulative = 0;
        Object item = null;
        for (int i = 0; i < items.size(); ++i) {
            int curWeight = (Integer)items.get(i).getSecond();
            if (cutoff < cummulative + curWeight) {
                item = items.get(i).getFirst();
                break;
            }
            cummulative += curWeight;
        }
        return (T)item;
    }

    public static <T> List<T> selectRandomItems(T[] items, float ratio) {
        int selectedNumber = (int)Math.ceil((float)items.length * ratio);
        List<T> originalItems = Arrays.asList(items);
        Collections.shuffle(originalItems);
        int startIndex = RandomUtils.nextInt((int)(items.length - selectedNumber));
        return originalItems.subList(startIndex, startIndex + selectedNumber);
    }

    @Override
    public void start() throws Exception {
        Policy.PolicyContext context = new Policy.PolicyContext(this.util);
        for (Policy policy : this.policies) {
            policy.init(context);
            this.monkeyThreadPool.execute(policy);
        }
    }

    @Override
    public void stop(String why) {
        this.monkeyThreadPool.shutdown();
        for (Policy policy : this.policies) {
            policy.stop(why);
        }
    }

    @Override
    public boolean isStopped() {
        return this.monkeyThreadPool.isTerminated();
    }

    @Override
    public void waitForStop() throws InterruptedException {
        this.monkeyThreadPool.awaitTermination(1L, TimeUnit.MINUTES);
    }

    @Override
    public boolean isDestructive() {
        return true;
    }
}

