/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnbalanceKillAndRebalanceAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(UnbalanceKillAndRebalanceAction.class);
    private static final double FRC_SERVERS_THAT_HOARD_AND_LIVE = 0.1;
    private static final double FRC_SERVERS_THAT_HOARD_AND_DIE = 0.1;
    private static final double HOARD_FRC_OF_REGIONS = 0.8;
    private long waitForUnbalanceMilliSec;
    private long waitForKillsMilliSec;
    private long waitAfterBalanceMilliSec;
    private boolean killMetaRs;

    public UnbalanceKillAndRebalanceAction(long waitUnbalance, long waitKill, long waitAfterBalance, boolean killMetaRs) {
        this.waitForUnbalanceMilliSec = waitUnbalance;
        this.waitForKillsMilliSec = waitKill;
        this.waitAfterBalanceMilliSec = waitAfterBalance;
        this.killMetaRs = killMetaRs;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        ClusterStatus status = this.cluster.getClusterStatus();
        LinkedList<ServerName> victimServers = new LinkedList<ServerName>(status.getServers());
        HashSet<ServerName> killedServers = new HashSet<ServerName>();
        int liveCount = (int)Math.ceil(0.1 * (double)victimServers.size());
        int deadCount = (int)Math.ceil(0.1 * (double)victimServers.size());
        Assert.assertTrue((String)("There are not enough victim servers: " + victimServers.size()), (liveCount + deadCount < victimServers.size() ? 1 : 0) != 0);
        ArrayList<ServerName> targetServers = new ArrayList<ServerName>(liveCount);
        for (int i = 0; i < liveCount + deadCount; ++i) {
            int victimIx = RandomUtils.nextInt((int)victimServers.size());
            targetServers.add((ServerName)victimServers.remove(victimIx));
        }
        this.unbalanceRegions(status, victimServers, targetServers, 0.8);
        Thread.sleep(this.waitForUnbalanceMilliSec);
        ServerName metaServer = this.cluster.getServerHoldingMeta();
        for (ServerName targetServer : targetServers) {
            if (this.context.isStopping() || killedServers.size() >= liveCount) break;
            if (!this.killMetaRs && targetServer.equals((Object)metaServer)) {
                this.getLogger().info("Not killing server because it holds hbase:meta.");
                continue;
            }
            this.killRs(targetServer);
            killedServers.add(targetServer);
        }
        Thread.sleep(this.waitForKillsMilliSec);
        this.forceBalancer();
        Thread.sleep(this.waitAfterBalanceMilliSec);
        for (ServerName server : killedServers) {
            this.startRs(server);
        }
    }
}

