/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitRandomRegionOfTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(SplitRandomRegionOfTableAction.class);
    private final long sleepTime;
    private final TableName tableName;

    public SplitRandomRegionOfTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public SplitRandomRegionOfTableAction(int sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        this.getLogger().info("Performing action: Split random region of table " + this.tableName);
        List regions = admin.getTableRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            this.getLogger().info("Table " + this.tableName + " doesn't have regions to split");
            return;
        }
        if (this.context.isStopping()) {
            return;
        }
        HRegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new HRegionInfo[regions.size()]));
        this.getLogger().debug("Splitting region " + region.getRegionNameAsString());
        try {
            admin.splitRegion(region.getRegionName());
        }
        catch (Exception ex) {
            this.getLogger().warn("Split failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

