/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingBatchSuspendResumeRsAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(RollingBatchSuspendResumeRsAction.class);
    private float ratio;
    private long sleepTime;
    private int maxSuspendedServers;

    public RollingBatchSuspendResumeRsAction(long sleepTime, float ratio) {
        this(sleepTime, ratio, 5);
    }

    public RollingBatchSuspendResumeRsAction(long sleepTime, float ratio, int maxSuspendedServers) {
        this.ratio = ratio;
        this.sleepTime = sleepTime;
        this.maxSuspendedServers = maxSuspendedServers;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().info(String.format("Performing action: Rolling batch restarting %d%% of region servers", (int)(this.ratio * 100.0f)));
        List<ServerName> selectedServers = this.selectServers();
        LinkedList<ServerName> serversToBeSuspended = new LinkedList<ServerName>(selectedServers);
        LinkedList<ServerName> suspendedServers = new LinkedList<ServerName>();
        while (!(serversToBeSuspended.isEmpty() && suspendedServers.isEmpty() || this.context.isStopping())) {
            SuspendOrResume action = serversToBeSuspended.isEmpty() ? SuspendOrResume.RESUME : (suspendedServers.isEmpty() ? SuspendOrResume.SUSPEND : (suspendedServers.size() >= this.maxSuspendedServers ? SuspendOrResume.RESUME : (RandomUtils.nextBoolean() ? SuspendOrResume.SUSPEND : SuspendOrResume.RESUME)));
            switch (action) {
                case SUSPEND: {
                    ServerName server = (ServerName)serversToBeSuspended.remove();
                    try {
                        this.suspendRs(server);
                    }
                    catch (Shell.ExitCodeException e) {
                        this.getLogger().warn("Problem suspending but presume successful; code=" + e.getExitCode(), (Throwable)e);
                    }
                    suspendedServers.add(server);
                    break;
                }
                case RESUME: {
                    ServerName server = (ServerName)suspendedServers.remove();
                    try {
                        this.resumeRs(server);
                    }
                    catch (Shell.ExitCodeException e) {
                        this.getLogger().info("Problem resuming, will retry; code= " + e.getExitCode(), (Throwable)e);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Encountered unexpected action type: " + action.name());
                }
            }
            this.getLogger().info("Sleeping for: " + this.sleepTime);
            Threads.sleep((long)this.sleepTime);
        }
    }

    protected List<ServerName> selectServers() throws IOException {
        return PolicyBasedChaosMonkey.selectRandomItems(this.getCurrentServers(), this.ratio);
    }

    static enum SuspendOrResume {
        SUSPEND,
        RESUME;

    }
}

