/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.proto.HAZKInfoProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartActiveNameNodeAction
extends RestartActionBaseAction {
    private static final Logger LOG = LoggerFactory.getLogger(RestartActiveNameNodeAction.class);
    private static final String ACTIVE_NN_LOCK_NAME = "ActiveStandbyElectorLock";
    private static final String ZK_PARENT_ZNODE_DEFAULT = "/hadoop-ha";
    private static final String ZK_PARENT_ZNODE_KEY = "ha.zookeeper.parent-znode";

    public RestartActiveNameNodeAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws Exception {
        this.getLogger().info("Performing action: Restart active namenode");
        Configuration conf = FSUtils.getRootDir((Configuration)this.getConf()).getFileSystem(this.getConf()).getConf();
        String nameServiceID = DFSUtil.getNamenodeNameServiceId((Configuration)conf);
        if (!HAUtil.isHAEnabled((Configuration)conf, (String)nameServiceID)) {
            throw new Exception("HA for namenode is not enabled");
        }
        ZooKeeperWatcher zkw = null;
        RecoverableZooKeeper rzk = null;
        String activeNamenode = null;
        String hadoopHAZkNode = conf.get(ZK_PARENT_ZNODE_KEY, ZK_PARENT_ZNODE_DEFAULT);
        try {
            zkw = new ZooKeeperWatcher(conf, "get-active-namenode", null);
            rzk = zkw.getRecoverableZooKeeper();
            String hadoopHAZkNodePath = ZKUtil.joinZNode((String)hadoopHAZkNode, (String)nameServiceID);
            List subChildern = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)hadoopHAZkNodePath);
            for (String eachEntry : subChildern) {
                if (!eachEntry.contains(ACTIVE_NN_LOCK_NAME)) continue;
                byte[] data = rzk.getData(ZKUtil.joinZNode((String)hadoopHAZkNodePath, (String)ACTIVE_NN_LOCK_NAME), false, null);
                HAZKInfoProtos.ActiveNodeInfo proto = HAZKInfoProtos.ActiveNodeInfo.parseFrom((byte[])data);
                activeNamenode = proto.getHostname();
            }
        }
        finally {
            if (zkw != null) {
                zkw.close();
            }
        }
        if (activeNamenode == null) {
            throw new Exception("No active Name node found in zookeeper under " + hadoopHAZkNode);
        }
        this.getLogger().info("Found active namenode host:" + activeNamenode);
        ServerName activeNNHost = ServerName.valueOf(activeNamenode, (int)-1, (long)-1L);
        this.getLogger().info("Restarting Active NameNode :" + activeNamenode);
        this.restartNameNode(activeNNHost, this.sleepTime);
    }
}

