/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Random;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecreaseMaxHFileSizeAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(DecreaseMaxHFileSizeAction.class);
    private static final long minFileSize = 0x40000000L;
    private final long sleepTime;
    private final TableName tableName;
    private final Random random;

    public DecreaseMaxHFileSizeAction(long sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
        this.random = new Random();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        HTableDescriptor htd = admin.getTableDescriptor(this.tableName);
        long currentValue = htd.getMaxFileSize();
        if (currentValue <= 0L) {
            currentValue = this.context.getHBaseCluster().getConf().getLong("hbase.hregion.max.filesize", 0x280000000L);
        }
        long newValue = (long)((double)currentValue * 0.9);
        newValue = Math.max(0x40000000L, newValue) - (long)(512 - this.random.nextInt(1024));
        htd.setMaxFileSize(newValue);
        if (this.context.isStopping()) {
            return;
        }
        admin.modifyTable(this.tableName, htd);
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

