/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.ShellExecEndpointCoprocessor;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ShellExecEndpoint;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestShellExecEndpointCoprocessor {
    private static IntegrationTestingUtility util;
    private static Connection connection;

    @BeforeClass
    public static void setUp() throws Exception {
        if (util == null) {
            util = new IntegrationTestingUtility(TestShellExecEndpointCoprocessor.createConfiguration());
            util.initializeCluster(3);
            connection = util.getConnection();
        }
    }

    @AfterClass
    public static void teardown() throws Exception {
        IOUtils.closeQuietly((Closeable)connection);
        if (util != null) {
            util.restoreCluster();
            util = null;
        }
    }

    @Test
    public void testShellExecUnspecified() throws IOException, ServiceException {
        this.testShellExecForeground(ShellExecEndpoint.ShellExecRequest.newBuilder());
    }

    @Test
    public void testShellExecForeground() throws IOException, ServiceException {
        this.testShellExecForeground(ShellExecEndpoint.ShellExecRequest.newBuilder().setAwaitResponse(true));
    }

    private void testShellExecForeground(ShellExecEndpoint.ShellExecRequest.Builder builder) throws IOException, ServiceException {
        Admin admin = connection.getAdmin();
        String command = "echo -n \"hello world\"";
        builder.setCommand("echo -n \"hello world\"");
        ShellExecEndpoint.ShellExecService.BlockingInterface stub = ShellExecEndpoint.ShellExecService.newBlockingStub((BlockingRpcChannel)admin.coprocessorService());
        HBaseRpcControllerImpl controller = new HBaseRpcControllerImpl();
        ShellExecEndpoint.ShellExecResponse resp = stub.shellExec((RpcController)controller, builder.build());
        Assert.assertEquals((long)0L, (long)resp.getExitCode());
        Assert.assertEquals((Object)"hello world", (Object)resp.getStdout());
    }

    @Test
    public void testShellExecBackground() throws IOException, ServiceException {
        Admin admin = connection.getAdmin();
        File testDataDir = TestShellExecEndpointCoprocessor.ensureTestDataDirExists(util);
        final File testFile = new File(testDataDir, "shell_exec_background.txt");
        Assert.assertTrue((boolean)testFile.createNewFile());
        Assert.assertEquals((long)0L, (long)testFile.length());
        String command = "echo \"hello world\" >> " + testFile.getAbsolutePath();
        ShellExecEndpoint.ShellExecRequest req = ShellExecEndpoint.ShellExecRequest.newBuilder().setCommand(command).setAwaitResponse(false).build();
        ShellExecEndpoint.ShellExecService.BlockingInterface stub = ShellExecEndpoint.ShellExecService.newBlockingStub((BlockingRpcChannel)admin.coprocessorService());
        HBaseRpcControllerImpl controller = new HBaseRpcControllerImpl();
        ShellExecEndpoint.ShellExecResponse resp = stub.shellExec((RpcController)controller, req);
        Assert.assertFalse((String)"the response from a background task should have no exit code", (boolean)resp.hasExitCode());
        Assert.assertFalse((String)"the response from a background task should have no stdout", (boolean)resp.hasStdout());
        Assert.assertFalse((String)"the response from a background task should have no stderr", (boolean)resp.hasStderr());
        Waiter.waitFor((Configuration)util.getConfiguration(), (long)5000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return testFile.length() > 0L;
            }
        });
        String content = new String(Files.readAllBytes(testFile.toPath())).trim();
        Assert.assertEquals((Object)"hello world", (Object)content);
    }

    private static File ensureTestDataDirExists(HBaseTestingUtility testingUtility) throws IOException {
        Path testDataDir = Paths.get(testingUtility.getDataTestDir().toString(), new String[0]);
        File testDataDirFile = Files.createDirectories(testDataDir, new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)testDataDirFile.exists());
        return testDataDirFile;
    }

    private static Configuration createConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.coprocessor.master.classes", ShellExecEndpointCoprocessor.class.getName());
        return conf;
    }
}

