/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ShellExecEndpoint;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ShellExecEndpointCoprocessor
extends ShellExecEndpoint.ShellExecService
implements Coprocessor,
CoprocessorService {
    private static final Logger LOG = LoggerFactory.getLogger(ShellExecEndpointCoprocessor.class);
    private static final String BACKGROUND_DELAY_MS_KEY = "hbase.it.shellexeccoproc.async.delay.ms";
    private static final long DEFAULT_BACKGROUND_DELAY_MS = 1000L;
    private final ExecutorService backgroundExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(ShellExecEndpointCoprocessor.class.getSimpleName() + "-{}").setDaemon(true).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.warn(String.format("Thread %s threw %s", t, e));
        }
    }).build());
    private Configuration conf;

    public void start(CoprocessorEnvironment env) {
        this.conf = env.getConfiguration();
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    public void shellExec(RpcController controller, ShellExecEndpoint.ShellExecRequest request, RpcCallback<ShellExecEndpoint.ShellExecResponse> done) {
        String command = request.getCommand();
        if (StringUtils.isBlank((String)command)) {
            throw new RuntimeException("Request contained an empty command.");
        }
        boolean awaitResponse = !request.hasAwaitResponse() || request.getAwaitResponse();
        String[] subShellCmd = new String[]{"/usr/bin/env", "bash", "-c", command};
        Shell.ShellCommandExecutor shell = new Shell.ShellCommandExecutor(subShellCmd);
        String msgFmt = "Executing command" + (!awaitResponse ? " on a background thread" : "") + ": {}";
        LOG.info(msgFmt, (Object)command);
        if (awaitResponse) {
            this.runForegroundTask(shell, controller, done);
        } else {
            this.runBackgroundTask(shell, done);
        }
    }

    private void runForegroundTask(Shell.ShellCommandExecutor shell, RpcController controller, RpcCallback<ShellExecEndpoint.ShellExecResponse> done) {
        ShellExecEndpoint.ShellExecResponse.Builder builder = ShellExecEndpoint.ShellExecResponse.newBuilder();
        try {
            this.doExec(shell, builder);
        }
        catch (IOException e) {
            LOG.error("Failure launching process", (Throwable)e);
            controller.setFailed(e.getMessage());
        }
        done.run((Object)builder.build());
    }

    private void runBackgroundTask(final Shell.ShellCommandExecutor shell, RpcCallback<ShellExecEndpoint.ShellExecResponse> done) {
        final long sleepDuration = this.conf.getLong(BACKGROUND_DELAY_MS_KEY, 1000L);
        this.backgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(sleepDuration);
                    ShellExecEndpointCoprocessor.this.doExec(shell, ShellExecEndpoint.ShellExecResponse.newBuilder());
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted before launching process.", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("Failure launching process", (Throwable)e);
                }
            }
        });
        done.run((Object)ShellExecEndpoint.ShellExecResponse.newBuilder().build());
    }

    private void doExec(Shell.ShellCommandExecutor shell, ShellExecEndpoint.ShellExecResponse.Builder builder) throws IOException {
        try {
            shell.execute();
            builder.setExitCode(shell.getExitCode()).setStdout(shell.getOutput());
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn("Launched process failed", (Throwable)e);
            builder.setExitCode(e.getExitCode()).setStdout(shell.getOutput()).setStderr(e.getMessage());
        }
    }

    public Service getService() {
        return this;
    }
}

