/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestDDLMasterFailover
extends IntegrationTestBase {
    private static final Log LOG = LogFactory.getLog(IntegrationTestDDLMasterFailover.class);
    private static final int SERVER_COUNT = 1;
    protected static final long DEFAULT_RUN_TIME = 1200000L;
    protected static final int DEFAULT_NUM_THREADS = 20;
    protected static final int DEFAULT_NUM_REGIONS = 50;
    private boolean keepObjectsAtTheEnd = false;
    protected HBaseCluster cluster;
    protected Connection connection;
    protected static final String RUN_TIME_KEY = "hbase.%s.runtime";
    protected static final String NUM_THREADS_KEY = "hbase.%s.numThreads";
    protected static final String NUM_REGIONS_KEY = "hbase.%s.numRegions";
    protected AtomicBoolean running = new AtomicBoolean(true);
    protected AtomicBoolean create_table = new AtomicBoolean(true);
    protected int numThreads;
    protected int numRegions;
    ConcurrentHashMap<String, NamespaceDescriptor> namespaceMap = new ConcurrentHashMap();
    ConcurrentHashMap<TableName, HTableDescriptor> enabledTables = new ConcurrentHashMap();
    ConcurrentHashMap<TableName, HTableDescriptor> disabledTables = new ConcurrentHashMap();
    ConcurrentHashMap<TableName, HTableDescriptor> deletedTables = new ConcurrentHashMap();

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        LOG.debug((Object)"Initializing/checking cluster has 1 servers");
        this.util.initializeCluster(this.getMinServerCount());
        LOG.debug((Object)"Done initializing/checking cluster");
        this.cluster = this.util.getHBaseClusterInterface();
    }

    @Override
    public void cleanUpCluster() throws Exception {
        if (!this.keepObjectsAtTheEnd) {
            NamespaceDescriptor[] nsds;
            HBaseAdmin admin = this.util.getHBaseAdmin();
            admin.disableTables("ittable-\\d+");
            admin.deleteTables("ittable-\\d+");
            for (NamespaceDescriptor nsd : nsds = admin.listNamespaceDescriptors()) {
                if (!nsd.getName().matches("itnamespace\\d+")) continue;
                LOG.info((Object)("Removing namespace=" + nsd.getName()));
                admin.deleteNamespace(nsd.getName());
            }
        }
        this.enabledTables.clear();
        this.disabledTables.clear();
        this.deletedTables.clear();
        this.namespaceMap.clear();
        Connection connection = this.getConnection();
        connection.close();
        super.cleanUpCluster();
    }

    protected int getMinServerCount() {
        return 1;
    }

    protected synchronized void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected synchronized Connection getConnection() {
        if (this.connection == null) {
            try {
                Connection connection = ConnectionFactory.createConnection((Configuration)this.getConf());
                this.setConnection(connection);
            }
            catch (IOException e) {
                LOG.fatal((Object)"Failed to establish connection.", (Throwable)e);
            }
        }
        return this.connection;
    }

    protected void verifyNamespaces() throws IOException {
        Connection connection = this.getConnection();
        Admin admin = connection.getAdmin();
        for (String nsName : this.namespaceMap.keySet()) {
            try {
                Assert.assertTrue((String)("Namespace: " + nsName + " in namespaceMap does not exist"), (admin.getNamespaceDescriptor(nsName) != null ? 1 : 0) != 0);
            }
            catch (NamespaceNotFoundException nsnfe) {
                Assert.fail((String)("Namespace: " + nsName + " in namespaceMap does not exist: " + nsnfe.getMessage()));
            }
        }
        admin.close();
    }

    protected void verifyTables() throws IOException {
        Connection connection = this.getConnection();
        Admin admin = connection.getAdmin();
        for (TableName tableName : this.enabledTables.keySet()) {
            Assert.assertTrue((String)("Table: " + tableName + " in enabledTables is not enabled"), (boolean)admin.isTableEnabled(tableName));
        }
        for (TableName tableName : this.disabledTables.keySet()) {
            Assert.assertTrue((String)("Table: " + tableName + " in disabledTables is not disabled"), (boolean)admin.isTableDisabled(tableName));
        }
        for (TableName tableName : this.deletedTables.keySet()) {
            Assert.assertFalse((String)("Table: " + tableName + " in deletedTables is not deleted"), (boolean)admin.tableExists(tableName));
        }
        admin.close();
    }

    @Test
    public void testAsUnitTest() throws Exception {
        this.runTest();
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        int ret = this.runTest();
        return ret;
    }

    private void checkException(List<Worker> workers) {
        if (workers == null || workers.isEmpty()) {
            return;
        }
        for (Worker worker : workers) {
            Exception e = worker.getSavedException();
            if (e != null) {
                LOG.error((Object)("Found exception in thread: " + worker.getName()));
                e.printStackTrace();
            }
            Assert.assertNull((String)("Action failed: " + (Object)((Object)worker.getAction()) + " in thread: " + worker.getName()), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runTest() throws Exception {
        LOG.info((Object)"Starting the test");
        String runtimeKey = String.format(RUN_TIME_KEY, ((Object)((Object)this)).getClass().getSimpleName());
        long runtime = this.util.getConfiguration().getLong(runtimeKey, 1200000L);
        String numThreadKey = String.format(NUM_THREADS_KEY, ((Object)((Object)this)).getClass().getSimpleName());
        this.numThreads = this.util.getConfiguration().getInt(numThreadKey, 20);
        ArrayList<Worker> workers = new ArrayList<Worker>();
        for (int i = 0; i < this.numThreads; ++i) {
            this.checkException(workers);
            Worker worker = new Worker();
            LOG.info((Object)("Launching worker thread " + worker.getName()));
            workers.add(worker);
            worker.start();
        }
        Threads.sleep((long)(runtime / 2L));
        LOG.info((Object)"Stopping creating new tables");
        this.create_table.set(false);
        Threads.sleep((long)(runtime / 2L));
        LOG.info((Object)"Runtime is up");
        this.running.set(false);
        this.checkException(workers);
        for (Worker worker : workers) {
            worker.join();
        }
        LOG.info((Object)"All Worker threads stopped");
        LOG.info((Object)"Verify actions of all threads succeeded");
        this.checkException(workers);
        LOG.info((Object)"Verify namespaces");
        this.verifyNamespaces();
        LOG.info((Object)"Verify states of all tables");
        this.verifyTables();
        try (HBaseFsck hbck = null;){
            LOG.info((Object)"Running hbck");
            hbck = HbckTestingUtil.doFsck((Configuration)this.util.getConfiguration(), (boolean)false);
            if (HbckTestingUtil.inconsistencyFound((HBaseFsck)hbck)) {
                this.keepObjectsAtTheEnd = true;
            }
            HbckTestingUtil.assertNoErrors((HBaseFsck)hbck);
            LOG.info((Object)"Finished hbck");
        }
        return 0;
    }

    @Override
    public TableName getTablename() {
        return null;
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        IntegrationTestDDLMasterFailover masterFailover = new IntegrationTestDDLMasterFailover();
        Connection connection = null;
        int ret = 1;
        try {
            LOG.debug((Object)"Setting up connection ...");
            connection = ConnectionFactory.createConnection((Configuration)conf);
            masterFailover.setConnection(connection);
            ret = ToolRunner.run((Configuration)conf, (Tool)masterFailover, (String[])args);
        }
        catch (IOException e) {
            LOG.fatal((Object)"Failed to establish connection. Aborting test ...", (Throwable)e);
        }
        finally {
            connection = masterFailover.getConnection();
            if (connection != null) {
                connection.close();
            }
            System.exit(ret);
        }
    }

    private class Worker
    extends Thread {
        private Exception savedException;
        private ACTION action;

        private Worker() {
        }

        @Override
        public void run() {
            while (IntegrationTestDDLMasterFailover.this.running.get()) {
                ACTION selectedAction;
                this.action = selectedAction = ACTION.values()[RandomUtils.nextInt() % ACTION.values().length];
                LOG.info((Object)("Performing Action: " + (Object)((Object)selectedAction)));
                try {
                    switch (selectedAction) {
                        case CREATE_NAMESPACE: {
                            new CreateNamespaceAction().perform();
                            break;
                        }
                        case MODIFY_NAMESPACE: {
                            new ModifyNamespaceAction().perform();
                            break;
                        }
                        case DELETE_NAMESPACE: {
                            new DeleteNamespaceAction().perform();
                            break;
                        }
                        case CREATE_TABLE: {
                            if (!IntegrationTestDDLMasterFailover.this.create_table.get()) break;
                            new CreateTableAction().perform();
                            break;
                        }
                        case ADD_ROW: {
                            new AddRowAction().perform();
                            break;
                        }
                        case DISABLE_TABLE: {
                            new DisableTableAction().perform();
                            break;
                        }
                        case ENABLE_TABLE: {
                            new EnableTableAction().perform();
                            break;
                        }
                        case DELETE_TABLE: {
                            if (RandomUtils.nextInt((int)100) >= 20) break;
                            new DeleteTableAction().perform();
                            break;
                        }
                        case ADD_COLUMNFAMILY: {
                            new AddColumnFamilyAction().perform();
                            break;
                        }
                        case DELETE_COLUMNFAMILY: {
                            if (RandomUtils.nextInt((int)100) >= 20) break;
                            new DeleteColumnFamilyAction().perform();
                            break;
                        }
                        case ALTER_FAMILYVERSIONS: {
                            new AlterFamilyVersionsAction().perform();
                            break;
                        }
                        case ALTER_FAMILYENCODING: {
                            new AlterFamilyEncodingAction().perform();
                        }
                    }
                }
                catch (Exception ex) {
                    this.savedException = ex;
                    return;
                }
            }
            LOG.info((Object)(this.getName() + " stopped"));
        }

        public Exception getSavedException() {
            return this.savedException;
        }

        public ACTION getAction() {
            return this.action;
        }
    }

    private static enum ACTION {
        CREATE_NAMESPACE,
        MODIFY_NAMESPACE,
        DELETE_NAMESPACE,
        CREATE_TABLE,
        DISABLE_TABLE,
        ENABLE_TABLE,
        DELETE_TABLE,
        ADD_COLUMNFAMILY,
        DELETE_COLUMNFAMILY,
        ALTER_FAMILYVERSIONS,
        ALTER_FAMILYENCODING,
        ADD_ROW;

    }

    private class AddRowAction
    extends ColumnAction {
        private AddRowAction() {
        }

        @Override
        void perform() throws IOException {
            HTableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.enabledTables);
            if (selected == null) {
                return;
            }
            TableName tableName = selected.getTableName();
            try (Admin admin = this.connection.getAdmin();
                 Table table = this.connection.getTable(tableName);){
                ArrayList regionInfos = new ArrayList(admin.getTableRegions(selected.getTableName()));
                int numRegions = regionInfos.size();
                int average_rows = 1;
                int numRows = average_rows * numRegions;
                LOG.info((Object)("Adding " + numRows + " rows to table: " + selected));
                for (int i = 0; i < numRows; ++i) {
                    byte[] rowKey = Bytes.toBytes((String)("row-" + String.format("%010d", RandomUtils.nextInt((int)Integer.MAX_VALUE))));
                    HColumnDescriptor cfd = this.selectFamily(selected);
                    if (cfd == null) {
                        return;
                    }
                    byte[] family = cfd.getName();
                    byte[] qualifier = Bytes.toBytes((String)("col-" + RandomUtils.nextInt((int)Integer.MAX_VALUE) % 10));
                    byte[] value = Bytes.toBytes((String)("val-" + RandomStringUtils.randomAlphanumeric((int)10)));
                    Put put = new Put(rowKey);
                    put.addColumn(family, qualifier, value);
                    table.put(put);
                }
                HTableDescriptor freshTableDesc = admin.getTableDescriptor(tableName);
                Assert.assertTrue((String)("After insert, Table: " + tableName + " in not enabled"), (boolean)admin.isTableEnabled(tableName));
                IntegrationTestDDLMasterFailover.this.enabledTables.put(tableName, freshTableDesc);
                LOG.info((Object)("Added " + numRows + " rows to table: " + selected));
            }
        }
    }

    private class DeleteColumnFamilyAction
    extends ColumnAction {
        private DeleteColumnFamilyAction() {
        }

        @Override
        void perform() throws IOException {
            HTableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            HColumnDescriptor cfd = this.selectFamily(selected);
            if (selected == null || cfd == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                if (selected.getColumnFamilies().length < 2) {
                    LOG.info((Object)("No enough column families to delete in table " + selected.getTableName()));
                    return;
                }
                TableName tableName = selected.getTableName();
                LOG.info((Object)("Deleting column family: " + cfd + " from table: " + tableName));
                admin.deleteColumn(tableName, cfd.getName());
                HTableDescriptor freshTableDesc = admin.getTableDescriptor(tableName);
                Assert.assertFalse((String)("Column family: " + cfd + " was not added"), (boolean)freshTableDesc.hasFamily(cfd.getName()));
                Assert.assertTrue((String)("After delete column family, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                LOG.info((Object)("Deleted column family: " + cfd + " from table: " + tableName));
            }
        }
    }

    private class AlterFamilyEncodingAction
    extends ColumnAction {
        private AlterFamilyEncodingAction() {
        }

        @Override
        void perform() throws IOException {
            HTableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            if (selected == null) {
                return;
            }
            HColumnDescriptor columnDesc = this.selectFamily(selected);
            if (columnDesc == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                TableName tableName = selected.getTableName();
                int[] possibleIds = new int[]{0, 2, 3, 4, 6};
                short id = (short)possibleIds[RandomUtils.nextInt((int)possibleIds.length)];
                LOG.info((Object)("Altering encoding of column family: " + columnDesc + " to: " + id + " in table: " + tableName));
                columnDesc.setDataBlockEncoding(DataBlockEncoding.getEncodingById((short)id));
                admin.modifyTable(tableName, selected);
                HTableDescriptor freshTableDesc = admin.getTableDescriptor(tableName);
                HColumnDescriptor freshColumnDesc = freshTableDesc.getFamily(columnDesc.getName());
                Assert.assertEquals((String)("Encoding of column family: " + columnDesc + " was not altered"), (long)freshColumnDesc.getDataBlockEncoding().getId(), (long)id);
                Assert.assertTrue((String)("After alter encoding of column family, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                LOG.info((Object)("Altered encoding of column family: " + freshColumnDesc + " to: " + id + " in table: " + tableName));
            }
        }
    }

    private class AlterFamilyVersionsAction
    extends ColumnAction {
        private AlterFamilyVersionsAction() {
        }

        @Override
        void perform() throws IOException {
            HTableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            if (selected == null) {
                return;
            }
            HColumnDescriptor columnDesc = this.selectFamily(selected);
            if (columnDesc == null) {
                return;
            }
            int versions = RandomUtils.nextInt((int)10) + 3;
            try (Admin admin = this.connection.getAdmin();){
                TableName tableName = selected.getTableName();
                LOG.info((Object)("Altering versions of column family: " + columnDesc + " to: " + versions + " in table: " + tableName));
                columnDesc.setMinVersions(versions);
                columnDesc.setMaxVersions(versions);
                admin.modifyTable(tableName, selected);
                HTableDescriptor freshTableDesc = admin.getTableDescriptor(tableName);
                HColumnDescriptor freshColumnDesc = freshTableDesc.getFamily(columnDesc.getName());
                Assert.assertEquals((String)("Column family: " + columnDesc + " was not altered"), (long)freshColumnDesc.getMaxVersions(), (long)versions);
                Assert.assertEquals((String)("Column family: " + freshColumnDesc + " was not altered"), (long)freshColumnDesc.getMinVersions(), (long)versions);
                Assert.assertTrue((String)("After alter versions of column family, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                LOG.info((Object)("Altered versions of column family: " + columnDesc + " to: " + versions + " in table: " + tableName));
            }
        }
    }

    private class AddColumnFamilyAction
    extends ColumnAction {
        private AddColumnFamilyAction() {
        }

        @Override
        void perform() throws IOException {
            HTableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            if (selected == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                HColumnDescriptor cfd = this.createFamilyDesc();
                if (selected.hasFamily(cfd.getName())) {
                    LOG.info((Object)(new String(cfd.getName()) + " already exists in table " + selected.getTableName()));
                    return;
                }
                TableName tableName = selected.getTableName();
                LOG.info((Object)("Adding column family: " + cfd + " to table: " + tableName));
                admin.addColumn(tableName, cfd);
                HTableDescriptor freshTableDesc = admin.getTableDescriptor(tableName);
                Assert.assertTrue((String)("Column family: " + cfd + " was not added"), (boolean)freshTableDesc.hasFamily(cfd.getName()));
                Assert.assertTrue((String)("After add column family, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                LOG.info((Object)("Added column family: " + cfd + " to table: " + tableName));
            }
        }

        private HColumnDescriptor createFamilyDesc() {
            String familyName = "cf-" + String.format("%010d", RandomUtils.nextInt((int)Integer.MAX_VALUE));
            HColumnDescriptor cfd = new HColumnDescriptor(familyName);
            return cfd;
        }
    }

    private abstract class ColumnAction
    extends TableAction {
        private ColumnAction() {
        }

        protected HColumnDescriptor selectFamily(HTableDescriptor htd) {
            if (htd == null) {
                return null;
            }
            HColumnDescriptor[] families = htd.getColumnFamilies();
            if (families.length == 0) {
                LOG.info((Object)("No column families in table: " + htd));
                return null;
            }
            HColumnDescriptor randomCfd = families[RandomUtils.nextInt((int)families.length)];
            return randomCfd;
        }
    }

    private class DeleteTableAction
    extends TableAction {
        private DeleteTableAction() {
        }

        @Override
        void perform() throws IOException {
            HTableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
            if (selected == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                TableName tableName = selected.getTableName();
                LOG.info((Object)("Deleting table :" + selected));
                admin.deleteTable(tableName);
                Assert.assertFalse((String)("Table: " + selected + " was not deleted"), (boolean)admin.tableExists(tableName));
                IntegrationTestDDLMasterFailover.this.deletedTables.put(tableName, selected);
                LOG.info((Object)("Deleted table :" + selected));
            }
        }
    }

    private class EnableTableAction
    extends TableAction {
        private EnableTableAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void perform() throws IOException {
            block7: {
                HTableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.disabledTables);
                if (selected == null) {
                    return;
                }
                try (Admin admin = this.connection.getAdmin();){
                    TableName tableName = selected.getTableName();
                    LOG.info((Object)("Enabling table :" + selected));
                    admin.enableTable(tableName);
                    Assert.assertTrue((String)("Table: " + selected + " was not enabled"), (boolean)admin.isTableEnabled(tableName));
                    HTableDescriptor freshTableDesc = admin.getTableDescriptor(tableName);
                    Assert.assertTrue((String)("After enable, Table: " + tableName + " in not enabled"), (boolean)admin.isTableEnabled(tableName));
                    IntegrationTestDDLMasterFailover.this.enabledTables.put(tableName, freshTableDesc);
                    LOG.info((Object)("Enabled table :" + freshTableDesc));
                }
            }
        }
    }

    private class DisableTableAction
    extends TableAction {
        private DisableTableAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void perform() throws IOException {
            block7: {
                HTableDescriptor selected = this.selectTable(IntegrationTestDDLMasterFailover.this.enabledTables);
                if (selected == null) {
                    return;
                }
                try (Admin admin = this.connection.getAdmin();){
                    TableName tableName = selected.getTableName();
                    LOG.info((Object)("Disabling table :" + selected));
                    admin.disableTable(tableName);
                    Assert.assertTrue((String)("Table: " + selected + " was not disabled"), (boolean)admin.isTableDisabled(tableName));
                    HTableDescriptor freshTableDesc = admin.getTableDescriptor(tableName);
                    Assert.assertTrue((String)("After disable, Table: " + tableName + " is not disabled"), (boolean)admin.isTableDisabled(tableName));
                    IntegrationTestDDLMasterFailover.this.disabledTables.put(tableName, freshTableDesc);
                    LOG.info((Object)("Disabled table :" + freshTableDesc));
                }
            }
        }
    }

    private class CreateTableAction
    extends TableAction {
        private CreateTableAction() {
        }

        @Override
        void perform() throws IOException {
            try (Admin admin = this.connection.getAdmin();){
                HTableDescriptor htd = this.createTableDesc();
                TableName tableName = htd.getTableName();
                if (admin.tableExists(tableName)) {
                    return;
                }
                String numRegionKey = String.format(IntegrationTestDDLMasterFailover.NUM_REGIONS_KEY, this.getClass().getSimpleName());
                IntegrationTestDDLMasterFailover.this.numRegions = IntegrationTestDDLMasterFailover.this.getConf().getInt(numRegionKey, 50);
                byte[] startKey = Bytes.toBytes((String)"row-0000000000");
                byte[] endKey = Bytes.toBytes((String)"row-2147483647");
                LOG.info((Object)("Creating table:" + htd));
                admin.createTable(htd, startKey, endKey, IntegrationTestDDLMasterFailover.this.numRegions);
                Assert.assertTrue((String)("Table: " + htd + " was not created"), (boolean)admin.tableExists(tableName));
                HTableDescriptor freshTableDesc = admin.getTableDescriptor(tableName);
                Assert.assertTrue((String)("After create, Table: " + tableName + " in not enabled"), (boolean)admin.isTableEnabled(tableName));
                IntegrationTestDDLMasterFailover.this.enabledTables.put(tableName, freshTableDesc);
                LOG.info((Object)("Created table:" + freshTableDesc));
            }
        }

        private HTableDescriptor createTableDesc() {
            String tableName = "ittable-" + String.format("%010d", RandomUtils.nextInt((int)Integer.MAX_VALUE));
            String familyName = "cf-" + Math.abs(RandomUtils.nextInt());
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
            htd.addFamily(new HColumnDescriptor(familyName));
            return htd;
        }
    }

    private abstract class TableAction
    extends MasterAction {
        private TableAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HTableDescriptor selectTable(ConcurrentHashMap<TableName, HTableDescriptor> tableMap) {
            ConcurrentHashMap<TableName, HTableDescriptor> concurrentHashMap = tableMap;
            synchronized (concurrentHashMap) {
                if (tableMap.isEmpty()) {
                    return null;
                }
                ArrayList tableList = new ArrayList(tableMap.keySet());
                TableName randomKey = (TableName)tableList.get(RandomUtils.nextInt((int)tableList.size()));
                HTableDescriptor randomHtd = tableMap.get(randomKey);
                tableMap.remove(randomKey);
                return randomHtd;
            }
        }
    }

    private class DeleteNamespaceAction
    extends NamespaceAction {
        private DeleteNamespaceAction() {
        }

        @Override
        void perform() throws IOException {
            block9: {
                NamespaceDescriptor selected = this.selectNamespace(IntegrationTestDDLMasterFailover.this.namespaceMap);
                if (selected == null) {
                    return;
                }
                try (Admin admin = this.connection.getAdmin();){
                    String namespaceName = selected.getName();
                    LOG.info((Object)("Deleting namespace :" + selected));
                    admin.deleteNamespace(namespaceName);
                    try {
                        if (admin.getNamespaceDescriptor(namespaceName) != null) {
                            Assert.assertTrue((String)("Namespace: " + selected + " was not deleted"), (boolean)false);
                            break block9;
                        }
                        LOG.info((Object)("Deleted namespace :" + selected));
                    }
                    catch (NamespaceNotFoundException nsnfe) {
                        LOG.info((Object)("Deleted namespace :" + selected));
                    }
                }
            }
        }
    }

    private class ModifyNamespaceAction
    extends NamespaceAction {
        private ModifyNamespaceAction() {
        }

        @Override
        void perform() throws IOException {
            NamespaceDescriptor selected = this.selectNamespace(IntegrationTestDDLMasterFailover.this.namespaceMap);
            if (selected == null) {
                return;
            }
            try (Admin admin = this.connection.getAdmin();){
                String nsValueNew;
                String namespaceName = selected.getName();
                LOG.info((Object)("Modifying namespace :" + selected));
                NamespaceDescriptor modifiedNsd = NamespaceDescriptor.create((String)namespaceName).build();
                do {
                    nsValueNew = String.format("%010d", RandomUtils.nextInt((int)Integer.MAX_VALUE));
                } while (selected.getConfigurationValue("hbase.namespace.testKey").equals(nsValueNew));
                modifiedNsd.setConfiguration("hbase.namespace.testKey", nsValueNew);
                admin.modifyNamespace(modifiedNsd);
                NamespaceDescriptor freshNamespaceDesc = admin.getNamespaceDescriptor(namespaceName);
                Assert.assertTrue((String)("Namespace: " + selected + " was not modified"), (boolean)freshNamespaceDesc.getConfigurationValue("hbase.namespace.testKey").equals(nsValueNew));
                Assert.assertTrue((String)("Namespace: " + namespaceName + " does not exist"), (admin.getNamespaceDescriptor(namespaceName) != null ? 1 : 0) != 0);
                IntegrationTestDDLMasterFailover.this.namespaceMap.put(namespaceName, freshNamespaceDesc);
                LOG.info((Object)("Modified namespace :" + freshNamespaceDesc));
            }
        }
    }

    private class CreateNamespaceAction
    extends NamespaceAction {
        private CreateNamespaceAction() {
        }

        @Override
        void perform() throws IOException {
            try (Admin admin = this.connection.getAdmin();){
                NamespaceDescriptor nsd;
                while (true) {
                    nsd = this.createNamespaceDesc();
                    try {
                        if (admin.getNamespaceDescriptor(nsd.getName()) == null) break;
                    }
                    catch (NamespaceNotFoundException nsnfe) {
                        // empty catch block
                        break;
                    }
                }
                LOG.info((Object)("Creating namespace:" + nsd));
                admin.createNamespace(nsd);
                NamespaceDescriptor freshNamespaceDesc = admin.getNamespaceDescriptor(nsd.getName());
                Assert.assertTrue((String)("Namespace: " + nsd + " was not created"), (freshNamespaceDesc != null ? 1 : 0) != 0);
                IntegrationTestDDLMasterFailover.this.namespaceMap.put(nsd.getName(), freshNamespaceDesc);
                LOG.info((Object)("Created namespace:" + freshNamespaceDesc));
            }
        }

        private NamespaceDescriptor createNamespaceDesc() {
            String namespaceName = "itnamespace" + String.format("%010d", RandomUtils.nextInt((int)Integer.MAX_VALUE));
            NamespaceDescriptor nsd = NamespaceDescriptor.create((String)namespaceName).build();
            nsd.setConfiguration("hbase.namespace.testKey", String.format("%010d", RandomUtils.nextInt((int)Integer.MAX_VALUE)));
            return nsd;
        }
    }

    private abstract class NamespaceAction
    extends MasterAction {
        final String nsTestConfigKey = "hbase.namespace.testKey";

        private NamespaceAction() {
            this.nsTestConfigKey = "hbase.namespace.testKey";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected NamespaceDescriptor selectNamespace(ConcurrentHashMap<String, NamespaceDescriptor> namespaceMap) {
            ConcurrentHashMap<String, NamespaceDescriptor> concurrentHashMap = namespaceMap;
            synchronized (concurrentHashMap) {
                if (namespaceMap.isEmpty()) {
                    return null;
                }
                ArrayList namespaceList = new ArrayList(namespaceMap.keySet());
                String randomKey = (String)namespaceList.get(RandomUtils.nextInt((int)namespaceList.size()));
                NamespaceDescriptor randomNsd = namespaceMap.get(randomKey);
                namespaceMap.remove(randomKey);
                return randomNsd;
            }
        }
    }

    private abstract class MasterAction {
        Connection connection;

        private MasterAction() {
            this.connection = IntegrationTestDDLMasterFailover.this.getConnection();
        }

        abstract void perform() throws IOException;
    }
}

