/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.zookeeper.AuthFailingZooKeeper;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfHealingRecoverableZooKeeper
extends RecoverableZooKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(SelfHealingRecoverableZooKeeper.class);
    private Watcher watcher;
    private int sessionTimeout;
    private String quorumServers;
    private final AtomicInteger counter;

    public SelfHealingRecoverableZooKeeper(String quorumServers, int sessionTimeout, Watcher watcher, int maxRetries, int retryIntervalMillis, int maxSleepTime, String identifier, int authFailedRetries, int authFailedPause, int numFailuresBeforeSuccess, int multiMaxSize) throws IOException {
        super(quorumServers, sessionTimeout, watcher, maxRetries, retryIntervalMillis, maxSleepTime, identifier, authFailedRetries, authFailedPause, multiMaxSize);
        this.quorumServers = quorumServers;
        this.sessionTimeout = sessionTimeout;
        this.watcher = watcher;
        this.counter = new AtomicInteger(numFailuresBeforeSuccess);
    }

    ZooKeeper createNewZooKeeper() throws KeeperException {
        try {
            int remaining = this.counter.getAndDecrement();
            AuthFailingZooKeeper zk = new AuthFailingZooKeeper(this.quorumServers, this.sessionTimeout, this.watcher);
            if (remaining > 0) {
                zk.triggerAuthFailed();
            }
            return zk;
        }
        catch (IOException ex) {
            LOG.warn("Unable to create ZooKeeper Connection", (Throwable)ex);
            throw new KeeperException.OperationTimeoutException();
        }
    }
}

