/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.hbase.zookeeper.AuthFailingZooKeeper;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFailingRecoverableZooKeeper
extends RecoverableZooKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFailingRecoverableZooKeeper.class);
    private Watcher watcher;
    private int sessionTimeout;
    private String quorumServers;

    public AuthFailingRecoverableZooKeeper(String quorumServers, int sessionTimeout, Watcher watcher, int maxRetries, int retryIntervalMillis, int maxSleepTime, String identifier, int authFailedRetries, int authFailedPause, int multiMaxSize) throws IOException {
        super(quorumServers, sessionTimeout, watcher, maxRetries, retryIntervalMillis, maxSleepTime, identifier, authFailedRetries, authFailedPause, multiMaxSize);
        this.quorumServers = quorumServers;
        this.sessionTimeout = sessionTimeout;
        this.watcher = watcher;
    }

    ZooKeeper createNewZooKeeper() throws KeeperException {
        try {
            return new AuthFailingZooKeeper(this.quorumServers, this.sessionTimeout, this.watcher);
        }
        catch (IOException ex) {
            LOG.warn("Unable to create ZooKeeper Connection", (Throwable)ex);
            throw new KeeperException.OperationTimeoutException();
        }
    }
}

