/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.reflect.TypeToken;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hadoop.hbase.util.JSONBean;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={MiscTests.class, SmallTests.class})
public class TestJSONBean {
    private MBeanServer getMockMBeanServer() throws Exception {
        MBeanServer mbeanServer = (MBeanServer)Mockito.mock(MBeanServer.class);
        HashSet<ObjectName> names = new HashSet<ObjectName>();
        names.add(new ObjectName("test1:type=test2"));
        Mockito.when(mbeanServer.queryNames((ObjectName)Mockito.any(ObjectName.class), (QueryExp)Mockito.any(QueryExp.class))).thenReturn(names);
        MBeanInfo mbeanInfo = (MBeanInfo)Mockito.mock(MBeanInfo.class);
        Mockito.when((Object)mbeanInfo.getClassName()).thenReturn((Object)"testClassName");
        String[] attributeNames = new String[]{"intAttr", "nanAttr", "infinityAttr", "strAttr", "boolAttr"};
        MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[attributeNames.length];
        for (int i = 0; i < attributeInfos.length; ++i) {
            attributeInfos[i] = new MBeanAttributeInfo(attributeNames[i], null, null, true, false, false);
        }
        Mockito.when((Object)mbeanInfo.getAttributes()).thenReturn((Object)attributeInfos);
        Mockito.when((Object)mbeanServer.getMBeanInfo((ObjectName)Mockito.any(ObjectName.class))).thenReturn((Object)mbeanInfo);
        Mockito.when((Object)mbeanServer.getAttribute((ObjectName)Mockito.any(ObjectName.class), (String)Matchers.eq((Object)"intAttr"))).thenReturn((Object)3);
        Mockito.when((Object)mbeanServer.getAttribute((ObjectName)Mockito.any(ObjectName.class), (String)Matchers.eq((Object)"nanAttr"))).thenReturn((Object)Double.NaN);
        Mockito.when((Object)mbeanServer.getAttribute((ObjectName)Mockito.any(ObjectName.class), (String)Matchers.eq((Object)"infinityAttr"))).thenReturn((Object)Double.POSITIVE_INFINITY);
        Mockito.when((Object)mbeanServer.getAttribute((ObjectName)Mockito.any(ObjectName.class), (String)Matchers.eq((Object)"strAttr"))).thenReturn((Object)"aString");
        Mockito.when((Object)mbeanServer.getAttribute((ObjectName)Mockito.any(ObjectName.class), (String)Matchers.eq((Object)"boolAttr"))).thenReturn((Object)true);
        return mbeanServer;
    }

    private String getExpectedJSON() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("{");
        pw.println("  \"beans\": [");
        pw.println("    {");
        pw.println("      \"name\": \"test1:type=test2\",");
        pw.println("      \"modelerType\": \"testClassName\",");
        pw.println("      \"intAttr\": 3,");
        pw.println("      \"nanAttr\": \"NaN\",");
        pw.println("      \"infinityAttr\": \"Infinity\",");
        pw.println("      \"strAttr\": \"aString\",");
        pw.println("      \"boolAttr\": true");
        pw.println("    }");
        pw.println("  ]");
        pw.print("}");
        return sw.toString();
    }

    @Test
    public void testJSONBeanValueTypes() throws Exception {
        JSONBean bean = new JSONBean();
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);
             JSONBean.Writer jsonWriter = bean.open(printWriter);){
            jsonWriter.write(this.getMockMBeanServer(), null, null, false);
        }
        Gson gson = GsonUtil.createGson().create();
        Type typeOfHashMap = new TypeToken<Map<String, Object>>(){}.getType();
        Map expectedJson = (Map)gson.fromJson(this.getExpectedJSON(), typeOfHashMap);
        Map actualJson = (Map)gson.fromJson(stringWriter.toString(), typeOfHashMap);
        Assert.assertEquals((Object)expectedJson, (Object)actualJson);
    }
}

