/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.TableCfWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReaderThread;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryFilterRetryableException;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={ReplicationTests.class, LargeTests.class})
public class TestWALEntryStream {
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration conf;
    private static FileSystem fs;
    private static MiniDFSCluster cluster;
    private static final TableName tableName;
    private static final byte[] family;
    private static final byte[] qualifier;
    private static final HRegionInfo info;
    private static final HTableDescriptor htd;
    private static NavigableMap<byte[], Integer> scopes;
    private final String fakeWalGroupId = "fake-wal-group-id";
    private WAL log;
    ReplicationSourceLogQueue logQueue;
    private PathWatcher pathWatcher;
    @Rule
    public TestName tn = new TestName();
    private final MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniDFSCluster(3);
        cluster = TEST_UTIL.getDFSCluster();
        fs = cluster.getFileSystem();
        scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        MetricsSource source = new MetricsSource("2");
        source.clear();
        this.logQueue = new ReplicationSourceLogQueue(conf, source);
        ArrayList<PathWatcher> listeners = new ArrayList<PathWatcher>();
        this.pathWatcher = new PathWatcher();
        listeners.add(this.pathWatcher);
        WALFactory wals = new WALFactory(conf, listeners, this.tn.getMethodName());
        this.log = wals.getWAL(info.getEncodedNameAsBytes(), info.getTable().getNamespace());
    }

    @After
    public void tearDown() throws Exception {
        this.log.close();
    }

    @Test
    public void testDifferentCounts() throws Exception {
        int[] NB_ROWS = new int[]{1500, 60000};
        int[] NB_KVS = new int[]{1, 100};
        Boolean[] BOOL_VALS = new Boolean[]{false, true};
        for (int nbRows : NB_ROWS) {
            for (int walEditKVs : NB_KVS) {
                Boolean[] arr$ = BOOL_VALS;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    boolean isCompressionEnabled = arr$[i$];
                    TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.wal.enablecompression", isCompressionEnabled);
                    this.mvcc.advanceTo(1L);
                    for (int i = 0; i < nbRows; ++i) {
                        this.appendToLogPlus(walEditKVs);
                    }
                    this.log.rollWriter();
                    try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, new MetricsSource("1"), "fake-wal-group-id");){
                        int i = 0;
                        for (WAL.Entry e : entryStream) {
                            Assert.assertNotNull((Object)e);
                            ++i;
                        }
                        Assert.assertEquals((long)nbRows, (long)i);
                        Assert.assertFalse((boolean)entryStream.hasNext());
                    }
                    this.log.close();
                    this.setUp();
                }
            }
        }
    }

    @Test
    public void testAppendsWithRolls() throws Exception {
        long oldPos;
        WAL.Entry entry;
        this.appendToLog();
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, new MetricsSource("1"), "fake-wal-group-id");){
            Assert.assertTrue((boolean)entryStream.hasNext());
            entry = entryStream.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertFalse((boolean)entryStream.hasNext());
            try {
                entry = entryStream.next();
                Assert.fail();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            oldPos = entryStream.getPosition();
        }
        this.appendToLog();
        entryStream = new WALEntryStream(this.logQueue, fs, conf, oldPos, new MetricsSource("1"), "fake-wal-group-id");
        var4_2 = null;
        try {
            entry = entryStream.next();
            Assert.assertNotEquals((long)oldPos, (long)entryStream.getPosition());
            Assert.assertNotNull((Object)entry);
            oldPos = entryStream.getPosition();
        }
        catch (Throwable x2) {
            var4_2 = x2;
            throw x2;
        }
        finally {
            if (entryStream != null) {
                if (var4_2 != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    entryStream.close();
                }
            }
        }
        this.appendToLog();
        this.log.rollWriter();
        this.appendToLog();
        entryStream = new WALEntryStream(this.logQueue, fs, conf, oldPos, new MetricsSource("1"), "fake-wal-group-id");
        var4_2 = null;
        try {
            entry = entryStream.next();
            Assert.assertNotEquals((long)oldPos, (long)entryStream.getPosition());
            Assert.assertNotNull((Object)entry);
            entry = entryStream.next();
            Assert.assertNotEquals((long)oldPos, (long)entryStream.getPosition());
            Assert.assertNotNull((Object)entry);
            Assert.assertFalse((boolean)entryStream.hasNext());
            oldPos = entryStream.getPosition();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (entryStream != null) {
                if (var4_2 != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    entryStream.close();
                }
            }
        }
    }

    @Test
    public void testLogrollWhileStreaming() throws Exception {
        this.appendToLog("1");
        this.appendToLog("2");
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, new MetricsSource("1"), "fake-wal-group-id");){
            Assert.assertEquals((Object)"1", (Object)this.getRow(entryStream.next()));
            this.appendToLog("3");
            this.log.rollWriter();
            this.appendToLog("4");
            Assert.assertEquals((Object)"2", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((long)2L, (long)this.getQueue().size());
            Assert.assertEquals((Object)"3", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((Object)"4", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((long)1L, (long)this.getQueue().size());
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
    }

    @Test
    public void testNewEntriesWhileStreaming() throws Exception {
        this.appendToLog("1");
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, 0L, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            this.appendToLog("2");
            this.appendToLog("3");
            Assert.assertFalse((boolean)entryStream.hasNext());
            entryStream.reset();
            Assert.assertEquals((Object)"2", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((Object)"3", (Object)this.getRow(entryStream.next()));
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
    }

    @Test
    public void testResumeStreamingFromPosition() throws Exception {
        long lastPosition = 0L;
        this.appendToLog("1");
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, 0L, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            this.appendToLog("2");
            this.appendToLog("3");
            lastPosition = entryStream.getPosition();
        }
        entryStream = new WALEntryStream(this.logQueue, fs, conf, lastPosition, new MetricsSource("1"), "fake-wal-group-id");
        var4_3 = null;
        try {
            Assert.assertEquals((Object)"2", (Object)this.getRow(entryStream.next()));
            Assert.assertEquals((Object)"3", (Object)this.getRow(entryStream.next()));
            Assert.assertFalse((boolean)entryStream.hasNext());
            Assert.assertEquals((long)1L, (long)this.getQueue().size());
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (entryStream != null) {
                if (var4_3 != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    entryStream.close();
                }
            }
        }
    }

    @Test
    public void testPosition() throws Exception {
        long lastPosition = 0L;
        this.appendEntriesToLog(3);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, lastPosition, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            lastPosition = entryStream.getPosition();
        }
        entryStream = new WALEntryStream(this.logQueue, fs, conf, lastPosition, new MetricsSource("1"), "fake-wal-group-id");
        var4_3 = null;
        try {
            Assert.assertNotNull((Object)entryStream.next());
            Assert.assertNotNull((Object)entryStream.next());
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (entryStream != null) {
                if (var4_3 != null) {
                    try {
                        entryStream.close();
                    }
                    catch (Throwable x2) {
                        var4_3.addSuppressed(x2);
                    }
                } else {
                    entryStream.close();
                }
            }
        }
    }

    @Test
    public void testEmptyStream() throws Exception {
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, 0L, new MetricsSource("1"), "fake-wal-group-id");){
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
    }

    @Test
    public void testReplicationSourceWALReaderThread() throws Exception {
        long position;
        this.appendEntriesToLog(3);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            entryStream.next();
            entryStream.next();
            position = entryStream.getPosition();
        }
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        ReplicationSourceWALReaderThread batcher = new ReplicationSourceWALReaderThread(mockSourceManager, this.getQueueInfo(), this.logQueue, 0L, fs, conf, this.getDummyFilter(), new MetricsSource("1"), source, "fake-wal-group-id");
        Path walPath = this.getQueue().peek();
        batcher.start();
        ReplicationSourceWALReaderThread.WALEntryBatch entryBatch = batcher.take();
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertEquals((long)3L, (long)entryBatch.getWalEntries().size());
        Assert.assertEquals((long)position, (long)entryBatch.getLastWalPosition());
        Assert.assertEquals((Object)walPath, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)3L, (long)entryBatch.getNbRowKeys());
        this.appendToLog("foo");
        entryBatch = batcher.take();
        Assert.assertEquals((long)1L, (long)entryBatch.getNbEntries());
        Assert.assertEquals((Object)this.getRow((WAL.Entry)entryBatch.getWalEntries().get(0)), (Object)"foo");
    }

    @Test
    public void testReplicationSourceWALReaderWithFailingFilter() throws Exception {
        long position;
        this.appendEntriesToLog(3);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            entryStream.next();
            entryStream.next();
            position = entryStream.getPosition();
        }
        int numFailuresInFilter = 5;
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        ReplicationSourceWALReaderThread batcher = new ReplicationSourceWALReaderThread(mockSourceManager, this.getQueueInfo(), this.logQueue, 0L, fs, conf, this.getIntermittentFailingFilter(numFailuresInFilter), new MetricsSource("1"), source, "fake-wal-group-id");
        Path walPath = this.getQueue().peek();
        batcher.start();
        ReplicationSourceWALReaderThread.WALEntryBatch entryBatch = batcher.take();
        Assert.assertEquals((long)numFailuresInFilter, (long)FailingWALEntryFilter.numFailures());
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertEquals((long)3L, (long)entryBatch.getWalEntries().size());
        Assert.assertEquals((long)position, (long)entryBatch.getLastWalPosition());
        Assert.assertEquals((Object)walPath, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)3L, (long)entryBatch.getNbRowKeys());
    }

    @Test
    public void testReplicationSourceWALReaderThreadRecoveredQueue() throws Exception {
        long position;
        this.appendEntriesToLog(3);
        this.log.rollWriter();
        this.appendEntriesToLog(2);
        ReplicationSourceLogQueue tempQueue = new ReplicationSourceLogQueue(conf, this.getMockMetrics());
        for (Path path : this.getQueue()) {
            tempQueue.enqueueLog(path, "fake-wal-group-id");
        }
        Throwable throwable = null;
        try (WALEntryStream entryStream = new WALEntryStream(tempQueue, fs, conf, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            entryStream.next();
            entryStream.next();
            entryStream.next();
            entryStream.next();
            position = entryStream.getPosition();
        }
        catch (Throwable x2) {
            Throwable throwable2 = x2;
            throw x2;
        }
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        ReplicationSource replicationSource = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)replicationSource.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        ReplicationSourceWALReaderThread reader = new ReplicationSourceWALReaderThread(mockSourceManager, this.getRecoveredQueueInfo(), this.logQueue, 0L, fs, conf, this.getDummyFilter(), new MetricsSource("1"), replicationSource, "fake-wal-group-id");
        Path walPath = this.getQueue().toArray(new Path[2])[1];
        reader.start();
        ReplicationSourceWALReaderThread.WALEntryBatch entryBatch = reader.take();
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertEquals((long)5L, (long)entryBatch.getWalEntries().size());
        Assert.assertEquals((long)position, (long)entryBatch.getLastWalPosition());
        Assert.assertEquals((Object)walPath, (Object)entryBatch.getLastWalPath());
        Assert.assertFalse((boolean)entryBatch.hasMoreEntries());
    }

    @Test
    public void testWALKeySerialization() throws Exception {
        HashMap<String, byte[]> attributes = new HashMap<String, byte[]>();
        attributes.put("foo", Bytes.toBytes((String)"foo-value"));
        attributes.put("bar", Bytes.toBytes((String)"bar-value"));
        WALKey key = new WALKey(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), 0L, 0L, this.mvcc, attributes);
        Assert.assertEquals(attributes, (Object)key.getExtendedAttributes());
        WALProtos.WALKey.Builder builder = key.getBuilder(null);
        WALProtos.WALKey serializedKey = builder.build();
        WALKey deserializedKey = new WALKey();
        deserializedKey.readFieldsFromPb(serializedKey, null);
        Assert.assertEquals((Object)key, (Object)deserializedKey);
        Assert.assertEquals(key.getExtendedAttributes().keySet(), deserializedKey.getExtendedAttributes().keySet());
        for (Map.Entry entry : deserializedKey.getExtendedAttributes().entrySet()) {
            Assert.assertArrayEquals((byte[])key.getExtendedAttribute((String)entry.getKey()), (byte[])((byte[])entry.getValue()));
        }
    }

    @Test
    public void testReplicationSourceWALReaderThreadWithFilter() throws Exception {
        byte[] notReplicatedCf = Bytes.toBytes((String)"notReplicated");
        HashMap<TableName, List<String>> tableCfs = new HashMap<TableName, List<String>>();
        tableCfs.put(tableName, Collections.singletonList(Bytes.toString((byte[])family)));
        ReplicationPeer peer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when((Object)peer.getTableCFs()).thenReturn(tableCfs);
        ChainWALEntryFilter filter = new ChainWALEntryFilter(new WALEntryFilter[]{new TableCfWALEntryFilter(peer)});
        this.appendToLogPlus(3, notReplicatedCf);
        this.appendToLogPlus(3, notReplicatedCf);
        this.appendToLogPlus(3, notReplicatedCf);
        this.appendEntriesToLog(2);
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        ReplicationSourceWALReaderThread reader = new ReplicationSourceWALReaderThread(mockSourceManager, this.getQueueInfo(), this.logQueue, 0L, fs, conf, (WALEntryFilter)filter, new MetricsSource("1"), source, "fake-wal-group-id");
        reader.start();
        ReplicationSourceWALReaderThread.WALEntryBatch entryBatch = reader.take();
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertFalse((boolean)entryBatch.isEmpty());
        List walEntries = entryBatch.getWalEntries();
        Assert.assertEquals((long)2L, (long)walEntries.size());
        for (WAL.Entry entry : walEntries) {
            ArrayList cells = entry.getEdit().getCells();
            Assert.assertTrue((cells.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)((Cell)cells.get(0)), (byte[])family));
        }
    }

    @Test
    public void testReplicationSourceWALReaderThreadWithFilterWhenLogRolled() throws Exception {
        byte[] notReplicatedCf = Bytes.toBytes((String)"notReplicated");
        HashMap<TableName, List<String>> tableCfs = new HashMap<TableName, List<String>>();
        tableCfs.put(tableName, Collections.singletonList(Bytes.toString((byte[])family)));
        ReplicationPeer peer = (ReplicationPeer)Mockito.mock(ReplicationPeer.class);
        Mockito.when((Object)peer.getTableCFs()).thenReturn(tableCfs);
        ChainWALEntryFilter filter = new ChainWALEntryFilter(new WALEntryFilter[]{new TableCfWALEntryFilter(peer)});
        this.appendToLogPlus(3, notReplicatedCf);
        Path firstWAL = this.getQueue().peek();
        final long eof = this.getPosition(firstWAL);
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        final ReplicationSourceWALReaderThread reader = new ReplicationSourceWALReaderThread(mockSourceManager, this.getQueueInfo(), this.logQueue, 0L, fs, conf, (WALEntryFilter)filter, new MetricsSource("1"), source, "fake-wal-group-id");
        reader.start();
        Waiter.waitFor((Configuration)conf, (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() {
                return reader.getLastReadPosition() >= eof;
            }
        });
        Assert.assertNull((Object)reader.poll(0L));
        this.log.rollWriter();
        ReplicationSourceWALReaderThread.WALEntryBatch entryBatch = reader.take();
        Path lastWAL = this.getQueue().peek();
        long positionToBeLogged = this.getPosition(lastWAL);
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertTrue((boolean)entryBatch.isEmpty());
        Assert.assertEquals((long)1L, (long)this.getQueue().size());
        Assert.assertNotEquals((Object)firstWAL, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((Object)lastWAL, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)positionToBeLogged, (long)entryBatch.getLastWalPosition());
    }

    private long getPosition(Path walPath) throws IOException {
        ReplicationSourceLogQueue tempQueue = new ReplicationSourceLogQueue(conf, this.getMockMetrics());
        String walPrefix = DefaultWALProvider.getWALPrefixFromWALName((String)walPath.getName());
        tempQueue.enqueueLog(walPath, walPrefix);
        WALEntryStream entryStream = new WALEntryStream(tempQueue, fs, conf, this.getMockMetrics(), walPrefix);
        entryStream.hasNext();
        return entryStream.getPosition();
    }

    private String getRow(WAL.Entry entry) {
        Cell cell = (Cell)entry.getEdit().getCells().get(0);
        return Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength());
    }

    private void appendToLog(String key) throws IOException {
        long txid = this.log.append(htd, info, new WALKey(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), this.mvcc), this.getWALEdit(key), true);
        this.log.sync(txid);
    }

    private void appendEntriesToLog(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.appendToLog();
        }
    }

    private void appendToLog() throws IOException {
        this.appendToLogPlus(1);
    }

    private void appendToLogPlus(int count) throws IOException {
        this.appendToLogPlus(count, family, qualifier);
    }

    private void appendToLogPlus(int count, byte[] cf) throws IOException {
        this.appendToLogPlus(count, cf, qualifier);
    }

    private void appendToLogPlus(int count, byte[] cf, byte[] cq) throws IOException {
        long txid = this.log.append(htd, info, new WALKey(info.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), this.mvcc), this.getWALEdits(count, cf, cq), true);
        this.log.sync(txid);
    }

    private WALEdit getWALEdits(int count, byte[] cf, byte[] cq) {
        WALEdit edit = new WALEdit();
        for (int i = 0; i < count; ++i) {
            edit.add((Cell)new KeyValue(Bytes.toBytes((long)System.currentTimeMillis()), cf, cq, System.currentTimeMillis(), cq));
        }
        return edit;
    }

    private WALEdit getWALEdit(String row) {
        WALEdit edit = new WALEdit();
        edit.add((Cell)new KeyValue(Bytes.toBytes((String)row), family, qualifier, System.currentTimeMillis(), qualifier));
        return edit;
    }

    private WALEntryFilter getIntermittentFailingFilter(int numFailuresInFilter) {
        return new FailingWALEntryFilter(numFailuresInFilter);
    }

    private WALEntryFilter getDummyFilter() {
        return new WALEntryFilter(){

            public WAL.Entry filter(WAL.Entry entry) {
                return entry;
            }
        };
    }

    private ReplicationQueueInfo getRecoveredQueueInfo() {
        return this.getQueueInfo("1-1");
    }

    private ReplicationQueueInfo getQueueInfo() {
        return this.getQueueInfo("1");
    }

    private ReplicationQueueInfo getQueueInfo(String znode) {
        return new ReplicationQueueInfo(znode);
    }

    @Test
    public void testReplicationSourceWALReaderDisabled() throws IOException, InterruptedException, ExecutionException {
        long position;
        for (int i = 0; i < 3; ++i) {
            this.appendToLog("key" + i);
        }
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, 0L, new MetricsSource("1"), "fake-wal-group-id");){
            entryStream.next();
            entryStream.next();
            entryStream.next();
            position = entryStream.getPosition();
        }
        Path walPath = this.getQueue().peek();
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.getSourceMetrics()).thenReturn((Object)new MetricsSource("1"));
        final AtomicBoolean enabled = new AtomicBoolean(false);
        Mockito.when((Object)source.isPeerEnabled()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                return enabled.get();
            }
        });
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        final ReplicationSourceWALReaderThread reader = new ReplicationSourceWALReaderThread(mockSourceManager, this.getQueueInfo(), this.logQueue, 0L, fs, conf, this.getDummyFilter(), new MetricsSource("1"), source, "fake-wal-group-id");
        reader.start();
        Future<ReplicationSourceWALReaderThread.WALEntryBatch> future = Executors.newSingleThreadExecutor().submit(new Callable<ReplicationSourceWALReaderThread.WALEntryBatch>(){

            @Override
            public ReplicationSourceWALReaderThread.WALEntryBatch call() throws Exception {
                return reader.take();
            }
        });
        ((ReplicationSource)Mockito.verify((Object)source, (VerificationMode)Mockito.timeout((long)30000L).atLeast(5))).isPeerEnabled();
        Assert.assertFalse((boolean)future.isDone());
        enabled.set(true);
        ReplicationSourceWALReaderThread.WALEntryBatch entryBatch = future.get();
        Assert.assertNotNull((Object)entryBatch);
        Assert.assertEquals((long)3L, (long)entryBatch.getWalEntries().size());
        Assert.assertEquals((long)position, (long)entryBatch.getLastWalPosition());
        Assert.assertEquals((Object)walPath, (Object)entryBatch.getLastWalPath());
        Assert.assertEquals((long)3L, (long)entryBatch.getNbRowKeys());
    }

    @Test
    public void testEOFExceptionForRecoveredQueue() throws Exception {
        Path emptyLog = new Path("emptyLog.1");
        FSDataOutputStream fsdos = fs.create(emptyLog);
        fsdos.close();
        Assert.assertEquals((long)0L, (long)fs.getFileStatus(emptyLog).getLen());
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        Mockito.when((Object)mockSourceManager.getOldSources()).thenReturn(new ArrayList<ReplicationSourceInterface>(Arrays.asList(source)));
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        conf.setInt("replication.source.maxretriesmultiplier", 1);
        conf.setBoolean("replication.source.eof.autorecovery", true);
        ReplicationSourceLogQueue localLogQueue = new ReplicationSourceLogQueue(conf, this.getMockMetrics());
        localLogQueue.enqueueLog(emptyLog, "fake-wal-group-id");
        ReplicationSourceWALReaderThread reader = new ReplicationSourceWALReaderThread(mockSourceManager, this.getRecoveredQueueInfo(), localLogQueue, 0L, fs, conf, this.getDummyFilter(), this.getMockMetrics(), source, "fake-wal-group-id");
        reader.run();
        Assert.assertEquals((long)0L, (long)localLogQueue.getQueueSize("fake-wal-group-id"));
    }

    @Test
    public void testEOFExceptionForRecoveredQueueWithMultipleLogs() throws Exception {
        ReplicationSourceLogQueue localLogQueue = new ReplicationSourceLogQueue(conf, this.getMockMetrics());
        Path emptyLog = new Path("log.2");
        FSDataOutputStream fsdos = fs.create(emptyLog);
        fsdos.close();
        Assert.assertEquals((long)0L, (long)fs.getFileStatus(emptyLog).getLen());
        localLogQueue.enqueueLog(emptyLog, "fake-wal-group-id");
        Path log1 = new Path("log.1");
        WALProvider.Writer writer1 = WALFactory.createWALWriter((FileSystem)fs, (Path)log1, (Configuration)TEST_UTIL.getConfiguration());
        this.appendEntries(writer1, 3);
        localLogQueue.enqueueLog(log1, "fake-wal-group-id");
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        Mockito.when((Object)mockSourceManager.getOldSources()).thenReturn(new ArrayList<ReplicationSourceInterface>(Arrays.asList(source)));
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        conf.setInt("replication.source.maxretriesmultiplier", 1);
        conf.setBoolean("replication.source.eof.autorecovery", true);
        ReplicationSourceWALReaderThread reader = new ReplicationSourceWALReaderThread(mockSourceManager, this.getRecoveredQueueInfo(), localLogQueue, 0L, fs, conf, this.getDummyFilter(), this.getMockMetrics(), source, "fake-wal-group-id");
        Assert.assertEquals((String)"Initial log queue size is not correct", (long)2L, (long)localLogQueue.getQueueSize("fake-wal-group-id"));
        reader.run();
        Assert.assertEquals((String)"Log queue should be empty", (long)0L, (long)localLogQueue.getQueueSize("fake-wal-group-id"));
    }

    private PriorityBlockingQueue<Path> getQueue() {
        return this.logQueue.getQueue("fake-wal-group-id");
    }

    private MetricsSource getMockMetrics() {
        MetricsSource source = (MetricsSource)Mockito.mock(MetricsSource.class);
        ((MetricsSource)Mockito.doNothing().when((Object)source)).incrSizeOfLogQueue();
        ((MetricsSource)Mockito.doNothing().when((Object)source)).decrSizeOfLogQueue();
        ((MetricsSource)Mockito.doNothing().when((Object)source)).setOldestWalAge((long)Mockito.anyInt());
        return source;
    }

    private void appendEntries(WALProvider.Writer writer, int numEntries) throws IOException {
        for (int i = 0; i < numEntries; ++i) {
            byte[] b = Bytes.toBytes((String)Integer.toString(i));
            KeyValue kv = new KeyValue(b, b, b);
            WALEdit edit = new WALEdit();
            edit.add((Cell)kv);
            WALKey key = new WALKey(b, TableName.valueOf((byte[])b), 0L, 0L, HConstants.DEFAULT_CLUSTER_ID);
            TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            scopes.put(b, 1);
            key.setScopes(scopes);
            writer.append(new WAL.Entry(key, edit));
            writer.sync(false);
        }
        writer.close();
    }

    @Test
    public void testSizeOfLogQueue() throws Exception {
        Assert.assertEquals((long)1L, (long)this.logQueue.getMetrics().getSizeOfLogQueue());
        this.appendToLog();
        this.log.rollWriter();
        Assert.assertEquals((long)2L, (long)this.logQueue.getMetrics().getSizeOfLogQueue());
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, this.logQueue.getMetrics(), "fake-wal-group-id");){
            Assert.assertTrue((boolean)entryStream.hasNext());
            WAL.Entry entry = entryStream.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertFalse((boolean)entryStream.hasNext());
        }
        Assert.assertEquals((long)1L, (long)this.logQueue.getMetrics().getSizeOfLogQueue());
    }

    @Test
    public void testCleanClosedWALs() throws Exception {
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, conf, this.logQueue.getMetrics(), "fake-wal-group-id");){
            Assert.assertEquals((long)0L, (long)this.logQueue.getMetrics().getUncleanlyClosedWALs());
            this.appendToLog();
            Assert.assertNotNull((Object)entryStream.next());
            this.log.rollWriter();
            this.appendToLog();
            Assert.assertNotNull((Object)entryStream.next());
            Assert.assertEquals((long)0L, (long)this.logQueue.getMetrics().getUncleanlyClosedWALs());
        }
    }

    @Test
    public void testEOFExceptionInOldWALsDirectory() throws Exception {
        Assert.assertEquals((long)1L, (long)this.logQueue.getQueueSize("fake-wal-group-id"));
        FSHLog fsLog = (FSHLog)this.log;
        Path emptyLogFile = fsLog.getCurrentFileName();
        this.log.rollWriter(true);
        Assert.assertEquals((long)2L, (long)this.logQueue.getQueueSize("fake-wal-group-id"));
        Configuration localConf = new Configuration(conf);
        localConf.setInt("replication.source.maxretriesmultiplier", 1);
        localConf.setBoolean("replication.source.eof.autorecovery", true);
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, fs, localConf, this.logQueue.getMetrics(), "fake-wal-group-id");){
            Path archivePath = entryStream.getArchivedLog(emptyLogFile);
            Assert.assertNotEquals((Object)emptyLogFile.toString(), (Object)archivePath.toString());
            Assert.assertTrue((boolean)fs.exists(archivePath));
            fs.truncate(archivePath, 0L);
            Assert.assertEquals((long)0L, (long)fs.getFileStatus(archivePath).getLen());
        }
        ReplicationSourceManager mockSourceManager = (ReplicationSourceManager)Mockito.mock(ReplicationSourceManager.class);
        ReplicationSource source = (ReplicationSource)Mockito.mock(ReplicationSource.class);
        Mockito.when((Object)source.isPeerEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockSourceManager.getTotalBufferUsed()).thenReturn((Object)new AtomicLong(0L));
        ReplicationSourceWALReaderThread readerThread = new ReplicationSourceWALReaderThread(mockSourceManager, this.getQueueInfo(), this.logQueue, 0L, fs, localConf, this.getDummyFilter(), this.logQueue.getMetrics(), source, "fake-wal-group-id");
        readerThread.start();
        Waiter.waitFor((Configuration)conf, (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() {
                return TestWALEntryStream.this.logQueue.getQueueSize("fake-wal-group-id") == 1;
            }
        });
    }

    static {
        tableName = TableName.valueOf((String)"tablename");
        family = Bytes.toBytes((String)"column");
        qualifier = Bytes.toBytes((String)"qualifier");
        info = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.LAST_ROW, false);
        htd = new HTableDescriptor(tableName);
    }

    class PathWatcher
    extends WALActionsListener.Base {
        Path currentPath;

        PathWatcher() {
        }

        public void preLogRoll(Path oldPath, Path newPath) {
            TestWALEntryStream.this.logQueue.enqueueLog(newPath, "fake-wal-group-id");
            this.currentPath = newPath;
        }
    }

    public static class FailingWALEntryFilter
    implements WALEntryFilter {
        private int numFailures = 0;
        private static int countFailures = 0;

        public FailingWALEntryFilter(int numFailuresInFilter) {
            this.numFailures = numFailuresInFilter;
        }

        public WAL.Entry filter(WAL.Entry entry) {
            if (countFailures == this.numFailures) {
                return entry;
            }
            ++countFailures;
            throw new WALEntryFilterRetryableException("failing filter");
        }

        public static int numFailures() {
            return countFailures;
        }
    }
}

